/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.ExecutionItem;
import com.sas.scheduler.api.servers.ip.engine.FileDependency;
import com.sas.scheduler.api.servers.ip.engine.FileStatusListener;
import com.sas.scheduler.api.servers.ip.engine.RunCondition;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileExistsDependency
extends FileDependency
implements FileStatusListener {
    private boolean mExists;
    private transient Boolean mPreviousExistsCheck;
    static final String XML_FileExistsDependency_Tag = "FileExistsDependency";
    private static final String XML_Exists_Tag = "Exists";

    public FileExistsDependency(String filePath, boolean exists, ClientLogger logger) {
        super(filePath, logger);
        this.mExists = exists;
        this.mPreviousExistsCheck = null;
    }

    public FileExistsDependency(ClientLogger logger) {
        super(logger);
        this.mExists = true;
        this.mPreviousExistsCheck = null;
    }

    @Override
    protected boolean isConditionSatisfied(boolean[] outputDataChanged) {
        Boolean oldExists = this.mPreviousExistsCheck;
        File f = new File(this.getFilePath());
        boolean exists = this.fileExists(f);
        this.mPreviousExistsCheck = exists;
        outputDataChanged[0] = oldExists == null ? true : oldExists.booleanValue() != this.mPreviousExistsCheck.booleanValue();
        return this.mExists == exists;
    }

    @Override
    public void serialize(Document doc, Node parent) {
        Element tag = doc.createElement(XML_FileExistsDependency_Tag);
        parent.appendChild(tag);
        this.injectXML(doc, tag);
    }

    @Override
    protected void injectXML(Document doc, Element tag) {
        super.injectXML(doc, tag);
        tag.setAttribute(XML_Exists_Tag, Boolean.toString(this.mExists));
    }

    @Override
    public RunCondition copy() {
        FileExistsDependency dep = new FileExistsDependency(this.getFilePath(), this.mExists, this.mLogger);
        dep.setTriggerRestriction(this.getTriggerRestriction());
        dep.copyFrom(this);
        return dep;
    }

    public boolean isExists() {
        return this.mExists;
    }

    public void setExists(boolean exists) {
        this.mExists = exists;
    }

    @Override
    public String toString() {
        StringBuffer printString = new StringBuffer();
        printString.append("Runs if file: " + this.getFilePath() + " ");
        if (this.mExists) {
            printString.append("exists.");
        } else {
            printString.append("does not exist.");
        }
        if (!this.getTriggerRestriction()) {
            printString.append(" Trigger valid whenever the condition is true.");
        } else {
            printString.append(" Trigger valid only when condition becomes true.");
        }
        return printString.toString();
    }

    public static RunCondition processExistsCondition(Node node, ClientLogger logger) {
        Node triggerRestrictionNode;
        FileExistsDependency dependency = new FileExistsDependency(logger);
        NamedNodeMap attributes = node.getAttributes();
        dependency.processAttributes(attributes);
        Node existsNode = attributes.getNamedItem(XML_Exists_Tag);
        if (existsNode != null) {
            dependency.setExists(Boolean.valueOf(existsNode.getNodeValue()));
        }
        if ((triggerRestrictionNode = attributes.getNamedItem("RestrictTrigger")) != null) {
            dependency.setTriggerRestriction(Boolean.valueOf(triggerRestrictionNode.getNodeValue()));
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String tagName = child.getNodeName();
            if (!tagName.equals("FilePath")) continue;
            String filePath = ExecutionItem.getCData(child);
            dependency.setFilePath(filePath);
        }
        return dependency;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FileExistsDependency)) {
            return false;
        }
        FileExistsDependency other = (FileExistsDependency)obj;
        if (other.mExists != this.mExists) {
            return false;
        }
        return super.equals(obj);
    }
}

