/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.ExecutionProviderBase;

public class ExecutionCallback {
    private ExecutionProviderBase mProviderBase;
    private String mRendevousID;
    private String mFlowInstanceID;
    private String mFlowID;

    public ExecutionCallback(ExecutionProviderBase provider, String flowID, String flowInstanceID, String rendevousID) {
        this.mRendevousID = rendevousID;
        this.mProviderBase = provider;
        this.mFlowInstanceID = flowInstanceID;
        this.mFlowID = flowID;
    }

    public void markKilled() {
        this.markCompleted(1, 0);
    }

    public void markDone() {
        this.markCompleted(4, 0);
    }

    public void markExited(int exitCode) {
        this.markCompleted(2, exitCode);
    }

    public void markFailedToRun() {
        this.markCompleted(128, 0);
    }

    private void markCompleted(int statusCode, int exitCode) {
        if (this.mProviderBase.isJobDirectClusteringServer()) {
            this.mProviderBase.getClusteringServer().markJobFinished(this.mRendevousID, statusCode, exitCode);
        } else {
            this.mProviderBase.getFlowManager().markJobFinished(this.mRendevousID, statusCode, exitCode);
        }
    }

    public String getRendevousID() {
        return this.mRendevousID;
    }

    public void updateJobStartInfo(long startTime, String rendererName, String jobQueue) {
        if (this.mProviderBase.isJobDirectClusteringServer()) {
            this.mProviderBase.getClusteringServer().updateJobStartInfo(this.mRendevousID, startTime, rendererName);
        } else {
            this.mProviderBase.getFlowManager().updateJobStartInfo(this.mRendevousID, startTime, rendererName, jobQueue);
        }
    }

    public String getFlowInstanceID() {
        return this.mFlowInstanceID;
    }

    public String getFlowID() {
        return this.mFlowID;
    }
}

