/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.servers.ip.engine.AbstractUserSession;
import com.sas.scheduler.api.servers.ip.engine.ExecutionContext;
import com.sas.scheduler.api.servers.ip.engine.FlowHistory;
import com.sas.scheduler.api.servers.ip.engine.FlowInstance;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.HistorySearchOptions;
import com.sas.scheduler.api.servers.ip.engine.JobRendererInfo;
import com.sas.scheduler.api.servers.ip.engine.MasterServer;
import com.sas.scheduler.api.servers.ip.engine.PredefinedCalendar;
import com.sas.scheduler.api.servers.ip.engine.RunningJob;
import com.sas.scheduler.api.servers.ip.engine.ScheduleIDInfo;
import com.sas.scheduler.api.servers.ip.engine.TopLevelFlow;
import com.sas.scheduler.api.servers.ip.engine.TopLevelFlowIDInfo;
import com.sas.scheduler.api.servers.ip.engine.UserInfo;
import com.sas.scheduler.model.SchedulerException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public abstract class ClusterSupport {
    public static final String OP_GetHistory = "GetFlowHistories";
    public static final String OP_GetHistory_Response = "GetFlowHistories_Response";
    public static final String OP_GetMasterServerConfig = "GetMasterServerConfig";
    public static final String OP_GetMasterServerConfig_Response = "GetMasterServerConfig_Response";
    public static final String OP_AddFlows = "AddFlows";
    public static final String OP_AddFlows_Response = "AddFlows_Response";
    public static final String OP_IsMasterServer = "IsMasterServer";
    public static final String OP_CreateSession = "CreateSession";
    public static final String OP_CreateSession_Response = "CreateSession_Response";
    public static final String OP_GetAcceptJobScore = "GetAcceptJobScore";
    public static final String OP_ExecuteJobOnWorker = "ExecuteJobOnWorker";
    public static final String OP_MarkJobFinished = "MarkJobFinished";
    public static final String OP_KillJob = "KillJob";
    public static final String OP_KillFlows = "KillFlows";
    public static final String OP_KillFlows_Response = "KillFlows_Response";
    public static final String OP_RunFlows = "RunFlows";
    public static final String OP_RunFlows_Response = "RunFlows_Response";
    public static final String OP_DeleteFlows = "DeleteFlows";
    public static final String OP_DeleteFlows_Response = "DeleteFlows_Response";
    public static final String OP_GetFlowDefinitions = "GetFlowDefinitions";
    public static final String OP_GetFlowDefinitions_Response = "GetFlowDefinitions_Response";
    public static final String OP_GetAllFlowIDs = "GetAllFlowIDs";
    public static final String OP_GetAllFlowIDs_Response = "GetAllFlowIDs_Response";
    public static final String OP_GetFlowByName = "GetFlowByName";
    public static final String OP_GetFlowByName_Response = "GetFlowByName_Response";
    public static final String OP_GetInstanceDefinitions = "GetInstanceDefinitions";
    public static final String OP_GetInstanceDefinitions_Response = "GetInstanceDefinitions_Response";
    public static final String OP_IsAdministrator = "IsAdministrator";
    public static final String OP_IsAdministrator_Response = "IsAdministrator_Response";
    public static final String OP_KillExecutionItem = "KillExecutionItem";
    public static final String OP_KillExecutionItem_Response = "KillExecutionItem_Response";
    public static final String OP_TriggerExecutionItem = "TriggerExecutionItem";
    public static final String OP_TriggerExecutionItem_Response = "TriggerExecutionItem_Response";
    public static final String OP_TerminateSession = "TerminateSession";
    public static final String OP_TerminateSession_Response = "TerminateSession_Response";
    public static final String OP_UpdateFlow = "UpdateFlow";
    public static final String OP_UpdateFlow_Response = "UpdateFlow_Response";
    public static final String OP_ReleaseFlows = "ReleaseFlows";
    public static final String OP_ReleaseFlows_Response = "ReleaseFlows_Response";
    public static final String OP_HoldFlows = "HoldFlows";
    public static final String OP_HoldFlows_Response = "HoldFlows_Response";
    public static final String OP_SearchHistory = "SearchHistory";
    public static final String OP_SearchHistory_Response = "SearchHistory_Response";
    public static final String OP_UpdateJobStart = "UpdateJobStart";
    public static final String OP_GetOutput = "GetOutputData";
    public static final String OP_GetError = "GetErrorData";
    public static final String OP_GetOutput_Response = "GetOutputData_Response";
    public static final String OP_GetError_Response = "GetErrorData_Response";
    public static final String OP_GetRendererSnapshots = "GetRendererSnapshots";
    public static final String OP_GetRendererSnapshots_Response = "GetRendererSnapshots_Response";
    public static final String OP_GetNextTriggerTimes = "GetNextTriggerTimes";
    public static final String OP_GetNextTriggerTimes_Response = "GetNextTriggerTimes_Response";
    public static final String OP_GetJobRoutingRules = "GetJobRoutingRules";
    public static final String OP_SetJobRoutingRules = "SetJobRoutingRules";
    protected FlowManager mManager = null;

    public FlowManager getManager() {
        return this.mManager;
    }

    protected void setManager(FlowManager manager) {
        this.mManager = manager;
    }

    public abstract ExecutionContext assignExecutionContext(RunningJob var1);

    public abstract void killJob(RunningJob var1, boolean var2);

    public String[] addFlows(String sessionID, TopLevelFlow[] newFlows) {
        try {
            MasterServer server = this.getMasterServer();
            return server.addFlows(sessionID, newFlows);
        }
        catch (Exception e) {
            this.getManager().getLogger().logMessage(Level.WARNING, e);
            return new String[newFlows.length];
        }
    }

    public String[] addPredefinedCalendars(String sessionID, PredefinedCalendar[] calendars) {
        try {
            MasterServer server = this.getMasterServer();
            return server.addPredefinedCalendars(sessionID, calendars);
        }
        catch (Exception e) {
            this.getManager().getLogger().logMessage(Level.WARNING, e);
            return new String[calendars.length];
        }
    }

    @Deprecated
    public AbstractUserSession createSession(String userID, String password) {
        return this.createSession(userID, password != null ? new SealedString(password) : null);
    }

    public AbstractUserSession createSession(String userID, SealedString password) {
        try {
            MasterServer server = this.getMasterServer();
            if (server == null) {
                this.getManager().getLogger().logMessage(Level.WARNING, "Unable to contact scheduler server.  Ensure that the server is running.  For DIP, ensure that the JGroups TTL setting (Server options) is high enough to allow communication.");
                return null;
            }
            return server.createSession(userID, password);
        }
        catch (Exception e) {
            if (this.getManager() != null) {
                this.getManager().getLogger().logMessage(Level.WARNING, e);
            } else {
                e.printStackTrace();
            }
            return null;
        }
    }

    public String[] deleteFlows(String sessionID, String[] flowIDs) {
        try {
            MasterServer server = this.getMasterServer();
            return server.deleteFlows(sessionID, flowIDs);
        }
        catch (Exception e) {
            this.getManager().getLogger().logMessage(Level.WARNING, e);
            return new String[0];
        }
    }

    public TopLevelFlowIDInfo[] getAllFlowIDs(String sessionID) {
        try {
            MasterServer server = this.getMasterServer();
            if (server == null) {
                throw new SchedulerException("No DIP schedule server available");
            }
            return server.getAllFlowIDs(sessionID);
        }
        catch (Exception e) {
            this.getManager().getLogger().logMessage(Level.WARNING, e);
            return new TopLevelFlowIDInfo[0];
        }
    }

    public PredefinedCalendar getCalendarForID(String calendarID) {
        try {
            MasterServer server = this.getMasterServer();
            return server.getCalendarForID(calendarID);
        }
        catch (Exception e) {
            this.getManager().getLogger().logMessage(Level.WARNING, e);
            return null;
        }
    }

    public TopLevelFlow[] getFlowDefinitions(String sessionID, String[] flowIDs) {
        try {
            MasterServer server = this.getMasterServer();
            return server.getFlowDefinitions(sessionID, flowIDs);
        }
        catch (Exception e) {
            this.getManager().getLogger().logMessage(Level.WARNING, e);
            return new TopLevelFlow[0];
        }
    }

    public FlowHistory[] getFlowHistories(String sessionID, String[] flowIDs, int countPerFlow) {
        try {
            MasterServer server = this.getMasterServer();
            return server.getFlowHistories(sessionID, flowIDs, countPerFlow);
        }
        catch (Exception e) {
            this.getManager().getLogger().logMessage(Level.WARNING, e);
            return new FlowHistory[0];
        }
    }

    public FlowHistory[] getFlowHistory(String sessionID, HistorySearchOptions options) {
        try {
            MasterServer server = this.getMasterServer();
            return server.getFlowHistory(sessionID, options);
        }
        catch (Exception e) {
            this.getManager().getLogger().logMessage(Level.WARNING, e);
            return new FlowHistory[0];
        }
    }

    public String getFlowID(String sessionID, String flowName) {
        try {
            MasterServer server = this.getMasterServer();
            return server.getFlowID(sessionID, flowName);
        }
        catch (Exception e) {
            this.getManager().getLogger().logMessage(Level.WARNING, e);
            return null;
        }
    }

    public FlowInstance[] getInstanceDefinitions(String sessionID, String[] instanceIDs) {
        try {
            MasterServer server = this.getMasterServer();
            return server.getInstanceDefinitions(sessionID, instanceIDs);
        }
        catch (Exception e) {
            this.getManager().getLogger().logMessage(Level.WARNING, e);
            return new FlowInstance[0];
        }
    }

    public ScheduleIDInfo[] getPredefinedCalendarIDInfos(String sessionID) {
        try {
            MasterServer server = this.getMasterServer();
            return server.getPredefinedCalendarIDInfos(sessionID);
        }
        catch (Exception e) {
            this.getManager().getLogger().logMessage(Level.WARNING, e);
            return new ScheduleIDInfo[0];
        }
    }

    public PredefinedCalendar[] getPredefinedCalendars(String sessionID, String[] calendarIDs) {
        try {
            MasterServer server = this.getMasterServer();
            return server.getPredefinedCalendars(sessionID, calendarIDs);
        }
        catch (Exception e) {
            this.getManager().getLogger().logMessage(Level.WARNING, e);
            return new PredefinedCalendar[0];
        }
    }

    public String[] holdFlows(String sessionID, String[] flowIDs) {
        try {
            MasterServer server = this.getMasterServer();
            return server.holdFlows(sessionID, flowIDs);
        }
        catch (Exception e) {
            this.getManager().getLogger().logMessage(Level.WARNING, e);
            return new String[0];
        }
    }

    public boolean isAdministrator(String sessionID) {
        try {
            MasterServer server = this.getMasterServer();
            return server.isAdministrator(sessionID);
        }
        catch (Exception e) {
            this.getManager().getLogger().logMessage(Level.WARNING, e);
            return false;
        }
    }

    public String[][] isPredefinedCalendarInUse(String sessionID, String scheduleID) {
        try {
            MasterServer server = this.getMasterServer();
            return server.isPredefinedCalendarInUse(sessionID, scheduleID);
        }
        catch (Exception e) {
            this.getManager().getLogger().logMessage(Level.WARNING, e);
            return new String[0][];
        }
    }

    public boolean killExecutionItem(String sessionID, String flowInstanceID, String subItemID, boolean force) {
        try {
            MasterServer server = this.getMasterServer();
            return server.killExecutionItem(sessionID, flowInstanceID, subItemID, force);
        }
        catch (Exception e) {
            this.getManager().getLogger().logMessage(Level.WARNING, e);
            return false;
        }
    }

    public String[] killFlowInstances(String sessionID, String[] instanceIDs, boolean force) {
        try {
            MasterServer server = this.getMasterServer();
            return server.killFlowInstances(sessionID, instanceIDs, force);
        }
        catch (Exception e) {
            this.getManager().getLogger().logMessage(Level.WARNING, e);
            return new String[0];
        }
    }

    public String[] releaseFlows(String sessionID, String[] flowIDs) {
        try {
            MasterServer server = this.getMasterServer();
            return server.releaseFlows(sessionID, flowIDs);
        }
        catch (Exception e) {
            this.getManager().getLogger().logMessage(Level.WARNING, e);
            return new String[0];
        }
    }

    public String[] runFlows(String sessionID, String[] flowIDs) {
        try {
            MasterServer server = this.getMasterServer();
            return server.runFlows(sessionID, flowIDs);
        }
        catch (Exception e) {
            this.getManager().getLogger().logMessage(Level.WARNING, e);
            return new String[0];
        }
    }

    public void shutDownServer(String sessionID) {
    }

    public boolean terminateSession(String sessionID) {
        try {
            MasterServer server = this.getMasterServer();
            return server.terminateSession(sessionID);
        }
        catch (Exception e) {
            this.getManager().getLogger().logMessage(Level.WARNING, e);
            return false;
        }
    }

    public boolean triggerExecutionItem(String sessionID, String flowInstanceID, String subItemID) {
        try {
            MasterServer server = this.getMasterServer();
            return server.triggerExecutionItem(sessionID, flowInstanceID, subItemID);
        }
        catch (Exception e) {
            this.getManager().getLogger().logMessage(Level.WARNING, e);
            return false;
        }
    }

    public boolean updateFlow(String sessionID, TopLevelFlow flow) {
        try {
            MasterServer server = this.getMasterServer();
            return server.updateFlow(sessionID, flow);
        }
        catch (Exception e) {
            this.getManager().getLogger().logMessage(Level.WARNING, e);
            return false;
        }
    }

    public boolean updatePredefinedCalendar(String sessionID, PredefinedCalendar newCalendarDef) {
        try {
            MasterServer server = this.getMasterServer();
            return server.updatePredefinedCalendar(sessionID, newCalendarDef);
        }
        catch (Exception e) {
            this.getManager().getLogger().logMessage(Level.WARNING, e);
            return false;
        }
    }

    public abstract boolean isMasterServer();

    public abstract MasterServer getMasterServer();

    public void markJobFinished(String rendevousID, int statusCode, int exitCode) {
        MasterServer server = this.getMasterServer();
        if (server != null) {
            server.markJobFinished(rendevousID, statusCode, exitCode);
        }
    }

    public void cleanup() {
        if (this.mManager == null) {
            return;
        }
        this.mManager.getLogger().logMessage(Level.FINE, "Cleaning up cluster connection");
        this.mManager = null;
    }

    public void persistSessionHook(UserInfo user, AbstractUserSession session) {
    }

    public void saveUsedTimes(String flowID, Map<String, Long> usedTimes) {
        this.mManager.getExecutionProvider().saveUsedTimes(flowID, usedTimes);
    }

    public Map<String, Map<String, Long>> getUsedTimes() {
        return this.mManager.getExecutionProvider().getUsedTimes();
    }

    public void saveUsedTimesImpl(String flowID, Map<String, Long> usedTimes) {
    }

    public Map<String, Map<String, Long>> getUsedTimesImpl() {
        return new HashMap<String, Map<String, Long>>();
    }

    public void updateJobStartInfo(String rendevousID, long startTime, String rendererName) {
        MasterServer server = this.getMasterServer();
        if (server != null) {
            server.updateJobStartInfo(rendevousID, startTime, rendererName);
        }
    }

    public int getErrorStreamData(String sessionID, String flowID, String instanceID, String uniqueSubitemID, long startPos, int maxCharacters, StringBuffer buffer) {
        MasterServer server = this.getMasterServer();
        if (server != null) {
            return server.getErrorStreamData(sessionID, flowID, instanceID, uniqueSubitemID, startPos, maxCharacters, buffer);
        }
        return -1;
    }

    public int getOutputStreamData(String sessionID, String flowID, String instanceID, String uniqueSubitemID, long startPos, int maxCharacters, StringBuffer buffer) {
        MasterServer server = this.getMasterServer();
        if (server != null) {
            return server.getOutputStreamData(sessionID, flowID, instanceID, uniqueSubitemID, startPos, maxCharacters, buffer);
        }
        return -1;
    }

    public String getJobRoutingRulesXML(String sessionID) {
        MasterServer server = this.getMasterServer();
        if (server != null) {
            return server.getJobRoutingRulesXML(sessionID);
        }
        return "";
    }

    public boolean setJobRoutingRulesXML(String sessionID, String xml) {
        MasterServer server = this.getMasterServer();
        if (server != null) {
            return server.setJobRoutingRulesXML(sessionID, xml);
        }
        return false;
    }

    public Collection<JobRendererInfo> getJobRendererSnapshots() {
        MasterServer server = this.getMasterServer();
        if (server != null) {
            return server.getJobRendererSnapshots();
        }
        return new ArrayList<JobRendererInfo>();
    }

    public List<Long> getNextTriggerTimes(List<String> flowIDs, Calendar overrideStartTime) {
        MasterServer server = this.getMasterServer();
        if (server != null) {
            return server.getNextTriggerTimes(flowIDs, overrideStartTime);
        }
        ArrayList<Long> result = new ArrayList<Long>();
        for (int i = 0; i < flowIDs.size(); ++i) {
            result.add(0L);
        }
        return result;
    }

    public boolean isEligibleMaster() {
        return true;
    }
}

