/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip;

import com.sas.scheduler.api.servers.ip.IPScheduler;
import com.sas.scheduler.api.servers.ip.engine.ExecutionItem;
import com.sas.scheduler.api.servers.ip.engine.RunCondition;
import com.sas.scheduler.api.servers.ip.engine.RunItemExitCodeDependency;
import com.sas.scheduler.api.servers.ip.engine.RunItemFinishedDependency;
import com.sas.scheduler.api.servers.ip.engine.RunItemStartedDependency;
import com.sas.scheduler.api.servers.ip.engine.RunItemStatusDependency;
import com.sas.scheduler.model.JobEventInfo;

public class IPJobEvent
extends JobEventInfo {
    private static final long serialVersionUID = 1L;
    private ExecutionItem mSchedulerJob = null;

    public IPJobEvent(ExecutionItem theJob, int nType, int nOperator, int nValue) {
        super(theJob.getName(), nType, nOperator, nValue);
        this.mSchedulerJob = theJob;
    }

    public RunCondition getEvent() {
        if (this.mSchedulerJob != null) {
            switch (this.typeDataBinding) {
                case 0: {
                    RunItemStatusDependency dep = new RunItemStatusDependency(IPScheduler.getLogger());
                    dep.setStatusMask(4);
                    dep.setExecutionItem(this.mSchedulerJob);
                    return dep;
                }
                case 1: {
                    RunItemFinishedDependency dep = new RunItemFinishedDependency(IPScheduler.getLogger());
                    dep.setExecutionItem(this.mSchedulerJob);
                    return dep;
                }
                case 2: {
                    RunItemStartedDependency dep = new RunItemStartedDependency(IPScheduler.getLogger());
                    dep.setExecutionItem(this.mSchedulerJob);
                    return dep;
                }
                case 3: {
                    RunItemExitCodeDependency dep = new RunItemExitCodeDependency(IPScheduler.getLogger());
                    dep.setExitCode(this.valueDataBinding);
                    dep.setComparisonCode(this.translateComparisonCode(this.operatorDataBinding));
                    dep.setExecutionItem(this.mSchedulerJob);
                    return dep;
                }
                case 4: {
                    RunItemStartedDependency dep = new RunItemStartedDependency(IPScheduler.getLogger());
                    dep.setExecutionItem(this.mSchedulerJob);
                    dep.setSecondsSinceStart(this.getValue() * 60);
                    return dep;
                }
                case 5: {
                    RunItemFinishedDependency dep = new RunItemFinishedDependency(IPScheduler.getLogger());
                    dep.setExecutionItem(this.mSchedulerJob);
                    dep.setExecutionLength(this.getValue() * 60, 14);
                    return dep;
                }
                case 6: {
                    RunItemStatusDependency dep = new RunItemStatusDependency(IPScheduler.getLogger());
                    dep.setStatusMask(32);
                    dep.setExecutionItem(this.mSchedulerJob);
                    return dep;
                }
                case 7: {
                    RunItemStatusDependency dep = new RunItemStatusDependency(IPScheduler.getLogger());
                    dep.setStatusMask(128);
                    dep.setExecutionItem(this.mSchedulerJob);
                    return dep;
                }
                case 8: {
                    RunItemStatusDependency dep = new RunItemStatusDependency(IPScheduler.getLogger());
                    dep.setStatusMask(32);
                    dep.setExecutionItem(this.mSchedulerJob);
                    return dep;
                }
            }
        }
        return null;
    }

    private int translateComparisonCode(int operator) {
        switch (operator) {
            case 21: {
                return 12;
            }
            case 23: {
                return 10;
            }
            case 24: {
                return 13;
            }
            case 25: {
                return 11;
            }
            case 26: {
                return 14;
            }
            case 22: {
                return 15;
            }
        }
        return 12;
    }
}

