/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip;

import com.sas.scheduler.api.servers.FlowHistory;
import java.util.Date;

public class IPFlowHistory
implements FlowHistory {
    private long m_instanceID;
    private String m_instanceName;
    private String m_flowName;
    private String m_schedulerFlowID;
    private int m_CompletionState;
    private int m_ReturnStatus;
    private Date m_startTime = null;
    private Date m_finishTime;
    private int m_errorCode;

    public IPFlowHistory(String flowName, com.sas.scheduler.api.servers.ip.engine.FlowHistory schedulerHistory) {
        if (schedulerHistory.getStartTime() != null) {
            this.m_startTime = schedulerHistory.getStartTime().getTime();
        }
        this.m_finishTime = null;
        if (schedulerHistory.getFinishTime() != null) {
            this.m_finishTime = schedulerHistory.getFinishTime().getTime();
        }
        this.m_ReturnStatus = (int)schedulerHistory.getExitCode();
        switch (schedulerHistory.getCompletionCode()) {
            case 4: {
                this.m_CompletionState = 0;
                break;
            }
            case 2: {
                this.m_CompletionState = 1;
                break;
            }
            case 8: {
                this.m_CompletionState = 3;
                break;
            }
            case 1: {
                this.m_CompletionState = 2;
                break;
            }
            default: {
                this.m_CompletionState = -1;
            }
        }
        this.m_instanceName = schedulerHistory.getID();
        this.m_schedulerFlowID = schedulerHistory.getFlowID();
        this.m_flowName = flowName;
        try {
            this.m_instanceID = Long.parseLong(schedulerHistory.getID());
        }
        catch (NumberFormatException e) {
            this.m_instanceID = -2L;
        }
        this.m_errorCode = 0;
    }

    public IPFlowHistory(String flowName, com.sas.scheduler.model.FlowHistory schedulerHistory) {
        if (schedulerHistory.getStartTimeDataBinding() != null) {
            this.m_startTime = schedulerHistory.getStartTimeDataBinding().getTime();
        }
        this.m_finishTime = null;
        if (schedulerHistory.getFinishTimeDataBinding() != null) {
            this.m_finishTime = schedulerHistory.getFinishTimeDataBinding().getTime();
        }
        this.m_ReturnStatus = schedulerHistory.getStatus();
        this.m_CompletionState = schedulerHistory.getState();
        this.m_instanceName = schedulerHistory.getInstanceNameDataBinding();
        this.m_schedulerFlowID = schedulerHistory.getFlowNameDataBinding();
        this.m_flowName = flowName;
        try {
            this.m_instanceID = Long.parseLong(schedulerHistory.getInstanceNameDataBinding());
        }
        catch (NumberFormatException e) {
            this.m_instanceID = -2L;
        }
        this.m_errorCode = schedulerHistory.getErrorCode();
    }

    @Override
    public long getID() {
        return this.m_instanceID;
    }

    @Override
    public Date getStartTime() {
        return this.m_startTime;
    }

    @Override
    public Date getFinishTime() {
        return this.m_finishTime;
    }

    @Override
    public int getState() {
        return this.m_CompletionState;
    }

    @Override
    public int getStatus() {
        return this.m_ReturnStatus;
    }

    @Override
    public String getInstanceName() {
        return this.m_instanceName;
    }

    @Override
    public String getFlowName() {
        return this.m_flowName;
    }

    @Override
    public String getSchedulerFlowName() {
        return this.m_schedulerFlowID;
    }

    @Override
    public int getErrorCode() {
        return this.m_errorCode;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("===========================================\n");
        buffer.append("History Record for: " + this.getFlowName() + "\n");
        buffer.append("Started: " + this.getStartTime() + " Finished: " + this.getFinishTime() + "\n");
        buffer.append("State: " + this.getState());
        buffer.append("Status: " + this.getStatus());
        buffer.append("\n");
        buffer.append("===========================================\n");
        return buffer.toString();
    }
}

