/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip;

import com.sas.scheduler.api.servers.ip.ExtraRunItemOptions;
import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.ExecutionItem;
import com.sas.scheduler.api.servers.ip.engine.JobResourceRequirements;
import com.sas.scheduler.api.servers.ip.engine.RetryCondition;
import com.sas.scheduler.model.SchedulerException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ExtraJobOptions
extends ExtraRunItemOptions {
    public static final String XML_ExtraJobOptions_Tag = "ExtraJobOptions";
    public static final String XML_MaxRetryCount_Attr = "maxRetries";
    public static final String XML_RetryConditions_Tag = "RetryConditions";
    private RetryCondition mRetryCondition = null;
    private int mRetryCount = 0;
    private JobResourceRequirements mResourceRequirements = new JobResourceRequirements();

    @Override
    public void serialize(Document doc, Node parent) {
        Element jobElement = doc.createElement(XML_ExtraJobOptions_Tag);
        parent.appendChild(jobElement);
        this.injectXML(doc, jobElement);
    }

    @Override
    protected void injectXML(Document doc, Element options) {
        super.injectXML(doc, options);
        options.setAttribute(XML_MaxRetryCount_Attr, Integer.toString(this.mRetryCount));
        if (this.mRetryCondition != null) {
            Element conditions = doc.createElement(XML_RetryConditions_Tag);
            options.appendChild(conditions);
            this.mRetryCondition.serialize(doc, conditions);
        }
        Element resourceTag = doc.createElement("JobResources");
        options.appendChild(resourceTag);
        CDATASection reqSection = doc.createCDATASection(this.mResourceRequirements.toSerializedForm());
        resourceTag.appendChild(reqSection);
    }

    public RetryCondition getRetryCondition() {
        return this.mRetryCondition;
    }

    public void setRetryCondition(RetryCondition retryCondition) {
        this.mRetryCondition = retryCondition;
    }

    public int getRetryCount() {
        return this.mRetryCount;
    }

    public void setRetryCount(int retryCount) {
        this.mRetryCount = retryCount;
    }

    public JobResourceRequirements getJobResourceRequirements() {
        return this.mResourceRequirements;
    }

    public void setJobResourceRequirements(JobResourceRequirements resourceRequirements) {
        if (resourceRequirements == null) {
            resourceRequirements = new JobResourceRequirements();
        }
        this.mResourceRequirements = resourceRequirements;
    }

    public static ExtraJobOptions createFromXML(BufferedReader xmlReader, ClientLogger logger) throws SchedulerException {
        InputSource source = new InputSource(xmlReader);
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(source);
            NodeList nl = doc.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (!node.getNodeName().equals(XML_ExtraJobOptions_Tag)) continue;
                ExtraJobOptions options = new ExtraJobOptions();
                ExtraJobOptions.processOptions(options, node, logger);
                return options;
            }
        }
        catch (SAXException doc) {
        }
        catch (IOException e) {
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)e);
            throw se;
        }
        catch (ParserConfigurationException e) {
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)e);
            throw se;
        }
        catch (FactoryConfigurationError e) {
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)e);
            throw se;
        }
        return null;
    }

    static void processOptions(ExtraJobOptions options, Node node, ClientLogger logger) {
        ExtraRunItemOptions.processRunItemOptionsTag(options, node, logger);
        NamedNodeMap attributes = node.getAttributes();
        Node countNode = attributes.getNamedItem(XML_MaxRetryCount_Attr);
        if (countNode != null) {
            try {
                options.setRetryCount(Integer.valueOf(countNode.getNodeValue()));
            }
            catch (Exception e) {
                logger.logMessage(Level.WARNING, e);
            }
        }
        NodeList children = node.getChildNodes();
        int listLength = children.getLength();
        for (int i = 0; i < listLength; ++i) {
            Node child = children.item(i);
            String tagName = child.getNodeName();
            if (tagName.equals(XML_RetryConditions_Tag)) {
                RetryCondition condition = RetryCondition.processXML(child, logger);
                options.setRetryCondition(condition);
                continue;
            }
            if (!tagName.equals("JobResources")) continue;
            String tagValue = ExecutionItem.getCData(child);
            JobResourceRequirements resourceRequirements = JobResourceRequirements.createFromSerializedForm(tagValue);
            options.setJobResourceRequirements(resourceRequirements);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ExtraJobOptions)) {
            return false;
        }
        ExtraJobOptions other = (ExtraJobOptions)obj;
        if (this.mRetryCount != other.mRetryCount) {
            return false;
        }
        if (this.mRetryCondition == null && other.mRetryCondition != null || this.mRetryCondition != null && other.mRetryCondition == null) {
            return false;
        }
        if (this.mRetryCondition != null && !this.mRetryCondition.equals(other.mRetryCondition)) {
            return false;
        }
        if (!this.mResourceRequirements.equals(other.mResourceRequirements)) {
            return false;
        }
        return super.equals(obj);
    }
}

