/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers;

import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.servers.Calendar;
import com.sas.scheduler.api.servers.FlowHistory;
import com.sas.scheduler.api.servers.SchedulerIMPL;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.PromptCallbackInterface;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import java.security.InvalidParameterException;
import java.util.Date;
import java.util.List;

public interface Scheduler {
    public static final int FLOW_SCHEDULED = 0;
    public static final int FLOW_UNABLE_TO_UPDATE = 1;
    public static final int FLOW_UNABLE_TO_SUBMIT = 2;
    public static final int SERVER_NOT_CONNECTED = 0;
    public static final int SERVER_CONNECTED = 1;
    public static final int USER_ABORTED = 2;
    public static final int SYSTEM_ABORTED = 3;
    public static final int SYSTEM_UNSUPPORTED = 4;
    public static final int FLOWSTATE_UNKNOWN = -1;
    public static final int FLOWSTATE_DONE = 0;
    public static final int FLOWSTATE_EXIT = 1;
    public static final int FLOWSTATE_KILLED = 2;
    public static final int FLOWSTATE_RUNNING = 3;
    public static final int FLOWSTATE_SUSPENDED = 4;
    public static final int FLOWSTATE_WAITING = 5;
    public static final int FLOWID_NOT_OWNER = -1;
    public static final int FLOWID_NOT_AVAILABLE = -2;
    public static final int JOBSTATE_UNKNOWN = -1;
    public static final int JOBSTATE_DONE = 0;
    public static final int JOBSTATE_EXIT = 1;
    public static final int JOBSTATE_INITIALIZING = 2;
    public static final int JOBSTATE_KILLED = 3;
    public static final int JOBSTATE_RUNNING = 4;
    public static final int JOBSTATE_SUSPENDED = 5;
    public static final int JOBSTATE_WAITING = 6;

    public boolean areDefaultsSet();

    public void setDefaultsSet(boolean var1);

    public String createFileConditionString(String var1, int var2, int var3, long var4) throws SchedulerException;

    public String getFileNameFromConditionString(String var1);

    public int getFileTypeFromConditionString(String var1);

    public int getFileOperatorFromConditionString(String var1);

    public long getFileValueFromConditionString(String var1);

    public Calendar getCalendar(String var1) throws SchedulerException;

    public Calendar getCalendar(IRecurrenceInfo var1) throws SchedulerException;

    public String getCalendarName(IRecurrenceInfo var1);

    public Calendar createCalendar(IRecurrenceInfo var1) throws SchedulerException;

    public Calendar createCalendar(String var1, String var2) throws SchedulerException;

    public List<Calendar> getCalendars() throws SchedulerException;

    public boolean removeCalendar(Calendar var1) throws SchedulerException;

    public boolean addCalendar(Calendar var1) throws SchedulerException;

    public String getCalAdminID();

    public String createConditionString(String var1, String var2, String var3, String var4, String var5);

    public String createConditionString(String var1, String var2, String var3, String var4, String var5, String var6);

    public String createConditionString(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

    public String getCalNameFromConditionString(String var1);

    public String getUserNameFromConditionString(String var1);

    public String getHourFromConditionString(String var1);

    public String getMinuteFromConditionString(String var1);

    public int[] getListFromHourMinuteStr(String var1);

    public String getDurationFromConditionString(String var1);

    public String getOccurrenceFromConditionString(String var1);

    public String getTimezoneFromConditionString(String var1);

    public String getName() throws SchedulerException;

    public String getProductName();

    public String getSoftwareVersion();

    public int getMajorVersion();

    public int getMinorVersion();

    public boolean checkVersion(SchedulerIMPL var1) throws SchedulerException;

    public boolean isValidFlowName(String var1);

    public String makeValidFlowname(String var1);

    public boolean isValidJobName(String var1);

    public String makeValidJobName(String var1);

    public String getInvalidChars(boolean var1);

    public char getSubstitutionChar();

    public int getMaxJobPriority();

    public String getClassId();

    public boolean scheduleFlow(FlowInfo var1) throws SchedulerException;

    public boolean scheduleFlowNow(FlowInfo var1) throws SchedulerException;

    public String runNowName(String var1);

    public int rescheduleFlow(FlowInfo var1) throws SchedulerException;

    public int rescheduleFlow(FlowInfo var1, boolean var2) throws SchedulerException;

    public boolean removeFlow(FlowInfo var1) throws SchedulerException;

    public boolean removeFlow(DeployedFlow var1) throws SchedulerException;

    public boolean removeFlow(String var1) throws SchedulerException;

    public long getFlowInstance(FlowInfo var1) throws SchedulerException;

    public boolean killFlowInstance(FlowHistory var1) throws SchedulerException;

    public boolean pauseFlowInstance(FlowHistory var1) throws SchedulerException;

    public boolean resumeFlowInstance(FlowHistory var1) throws SchedulerException;

    public int getMaxFlowHistoryCount() throws SchedulerException;

    public List<FlowHistory> getAllFlowHistory() throws SchedulerException;

    public FlowHistory getFlowHistory(DeployedFlow var1) throws SchedulerException;

    public FlowHistory getFlowHistory(FlowInfo var1) throws SchedulerException;

    public List<FlowHistory> getFlowHistoryList(String var1, int var2) throws SchedulerException;

    public List<FlowHistory> getFlowHistoryList(FlowInfo var1) throws SchedulerException;

    public List<FlowHistory> getFlowHistoryList(FlowInfo var1, int var2) throws SchedulerException;

    public List<FlowHistory> getFlowHistoryList(String var1, List<FlowInfo> var2, int var3) throws SchedulerException;

    public Date getFinishTime(long var1) throws SchedulerException;

    public Date getStartTime(long var1) throws SchedulerException;

    public int getState(long var1) throws SchedulerException;

    public int getStatus(long var1) throws SchedulerException;

    public String genFlowName(FlowInfo var1);

    public boolean connectToSchedulingServer(PromptCallbackInterface var1);

    public int makeConnection(PromptCallbackInterface var1) throws SchedulerException;

    @Deprecated
    public int makeConnection(String var1, String var2) throws SchedulerException;

    public int makeConnection(String var1, SealedString var2) throws SchedulerException;

    public boolean isConnected();

    public boolean closeConnection();

    public String getCurrentUserID();

    public boolean isFlowScheduled(String var1);

    public boolean isFlowScheduled(FlowInfo var1);

    public boolean verifyFlowScheduled(FlowInfo var1) throws SchedulerException;

    public String genResourceSyntax(String var1);

    public SchedulerServerInfo getServerComponent();

    public boolean doesRunNowLeaveDefinition() throws InvalidParameterException;

    public boolean isHistorySupported() throws InvalidParameterException;

    public boolean isDependenciesEnabled() throws InvalidParameterException;

    public boolean isConnectionNeededForTimeEvents();

    public boolean isConnectionNeededForAdvanceProperties();

    public boolean isJobDependenciesEnabled() throws InvalidParameterException;

    public boolean isTimeDependenciesEnabled() throws InvalidParameterException;

    public boolean isFileDependenciesEnabled() throws InvalidParameterException;

    public boolean areQueues();

    public List<String> getQueues();

    public String clearJobPropertyOnMatch(String var1, String var2, String var3, String var4);
}

