/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.oma;

import com.sas.metadata.remote.MdObjectStore;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.Calendar;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.model.AbstractEventInterface;
import com.sas.scheduler.model.AbstractRecurrence;
import com.sas.scheduler.model.GeneralUtilities;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.OpaqueRecurrence;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.TimeEventInfo;
import java.util.Locale;
import java.util.TimeZone;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TimeEvent
implements AbstractEventInterface {
    private static final String TimeEventTag = "PlatformIndependentTimeEventV1:";
    private static final String TimeEventDefinitionSeparator = "||";
    private static final String TimeEventRecurrence = "Recurrence:";
    private static final String TimeEventRunTime = "RunTime:";
    private static final String TimeEventCalendarID = "CalendarName:";
    private static final String TimeEventUserName = "User:";
    private Calendar m_associatedDays;
    private String m_calname;
    private String m_calowner;
    private IRecurrenceInfo m_recurrence;
    private String m_user;
    private String m_hours;
    private String m_minutes;
    private int m_duration;
    private int m_occur;
    private String m_timezone;
    private Scheduler m_scheduler;
    private String m_description;

    public TimeEvent() {
        this("", null, null, "0", "00", 1, -1, null);
    }

    public TimeEvent(Scheduler scheduler) {
        this("", scheduler, null, "0", "00", 1, -1, null);
    }

    public TimeEvent(String userName, String hours, String minutes, int duration) {
        this(userName, null, null, hours, minutes, duration, -1, null);
    }

    public TimeEvent(Scheduler scheduler, IRecurrenceInfo recurrence, String userName, String hours, String minutes, int duration) {
        this(userName, scheduler, recurrence, hours, minutes, duration, -1, null);
    }

    public TimeEvent(Scheduler scheduler, IRecurrenceInfo recurrence, String userName, String hours, String minutes, int duration, int occur) {
        this(userName, scheduler, recurrence, hours, minutes, duration, occur, null);
    }

    public TimeEvent(Scheduler scheduler, IRecurrenceInfo recurrence, String userName, String hours, String minutes, int duration, String timezoneId) {
        this(userName, scheduler, recurrence, hours, minutes, duration, -1, timezoneId);
    }

    public TimeEvent(TimeEventInfo info) {
        this(info, TimeEvent.getSchedulerFromInfo(info.getScheduler(), MetaUtilities.getDefaultStore()));
    }

    public TimeEvent(TimeEventInfo info, MdObjectStore store) {
        this(info, TimeEvent.getSchedulerFromInfo(info.getScheduler(), store));
    }

    private static Scheduler getSchedulerFromInfo(SchedulerServerInfo ssi, MdObjectStore store) {
        try {
            return MetaUtilities.getSchedulingServer(ssi, store);
        }
        catch (SchedulerException se) {
            return null;
        }
    }

    public TimeEvent(TimeEventInfo info, Scheduler scheduler) {
        this(info.getUser(), scheduler, info.getRecurrence(), info.getHours(), info.getMinutes(), info.getDuration(), info.getOccur(), info.getTimezoneId());
        this.setDescription(info.getDescription());
    }

    public TimeEvent(String userName, Scheduler scheduler, IRecurrenceInfo recurrence, String hours, String minutes, int duration, int occur, String timezoneId) {
        this.m_user = userName;
        this.m_scheduler = scheduler;
        this.m_recurrence = recurrence;
        this.m_hours = hours;
        this.m_minutes = minutes;
        this.m_duration = duration;
        this.m_occur = occur;
        this.m_timezone = timezoneId;
        if (this.m_scheduler != null && this.m_recurrence != null) {
            try {
                this.m_associatedDays = this.m_scheduler.getCalendar(this.m_recurrence);
            }
            catch (SchedulerException se) {
                this.m_associatedDays = null;
                String calname = this.m_scheduler.getCalendarName(this.m_recurrence);
                if (calname != null) {
                    int index = calname.indexOf("@");
                    this.m_calname = calname.substring(0, index);
                    this.m_calowner = calname.substring(index + 1);
                }
                se.printStackTrace();
            }
        } else {
            this.m_associatedDays = null;
        }
    }

    public TimeEventInfo getInfo() {
        TimeEventInfo info = null;
        info = this.m_associatedDays != null && this.m_associatedDays.getDays() != null ? new TimeEventInfo(this.m_associatedDays.getDays(), this.m_user, this.m_hours, this.m_minutes, this.m_duration, this.m_occur, this.m_timezone) : new TimeEventInfo(this.m_recurrence, this.m_user, this.m_hours, this.m_minutes, this.m_duration, this.m_occur, this.m_timezone);
        info.setDescription(this.m_description);
        return info;
    }

    public boolean isCalendarOkay() {
        if (this.m_associatedDays != null) {
            return this.m_associatedDays.getDays() != null;
        }
        return this.m_recurrence != null;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public boolean setSchedulerInstance(Scheduler scheduler) {
        try {
            if (this.m_scheduler == null || this.m_scheduler.getClassId().equals(scheduler.getClassId())) {
                this.m_scheduler = scheduler;
                return true;
            }
            return false;
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    public IRecurrenceInfo getRecurrence() {
        return this.m_recurrence;
    }

    public boolean setRecurrence(IRecurrenceInfo recurrence) throws SchedulerException {
        if (this.m_scheduler == null) {
            return false;
        }
        if (this.m_associatedDays == null) {
            this.m_associatedDays = this.m_scheduler.getCalendar(recurrence);
            if (this.m_associatedDays == null) {
                return false;
            }
        }
        this.m_associatedDays.setDays(recurrence);
        return true;
    }

    public int getDuration() {
        return this.m_duration;
    }

    public boolean setDuration(int duration) {
        this.m_duration = duration;
        return true;
    }

    public String getHours() {
        return this.m_hours;
    }

    public boolean setHours(String hourString) {
        this.m_hours = hourString;
        return true;
    }

    public String getMinutes() {
        return this.m_minutes;
    }

    public boolean setMinutes(String minuteString) {
        this.m_minutes = minuteString;
        return true;
    }

    public int getOccur() {
        return this.m_occur;
    }

    public boolean setOccur(int occur) {
        this.m_occur = occur;
        return true;
    }

    public String getTimezoneId() {
        return this.m_timezone;
    }

    public boolean setTimezoneId(String timezoneId) {
        if (this.validateTimezone(timezoneId)) {
            this.m_timezone = timezoneId;
            return true;
        }
        return false;
    }

    public String getUser() {
        return this.m_user;
    }

    public boolean setUser(String user) {
        this.m_user = user;
        return true;
    }

    public Calendar getCalendar() {
        if (this.m_associatedDays == null && this.m_scheduler != null && this.m_recurrence != null) {
            try {
                this.m_associatedDays = this.m_scheduler.getCalendar(this.m_recurrence);
                if (this.m_associatedDays != null) {
                    this.m_associatedDays.setDays(this.m_recurrence);
                }
            }
            catch (SchedulerException ex) {
                this.m_associatedDays = null;
            }
        }
        return this.m_associatedDays;
    }

    public String getCalendarName() {
        return this.m_associatedDays != null ? this.m_associatedDays.getName() : this.m_calname;
    }

    public boolean setCalendarName(String name) {
        if (this.m_associatedDays == null) {
            this.m_calname = name;
            return true;
        }
        return false;
    }

    public String getCalendarOwner() {
        return this.m_associatedDays != null ? this.m_associatedDays.getOwner() : this.m_calowner;
    }

    public boolean setCalendarOwner(String owner) {
        if (this.m_associatedDays == null) {
            this.m_calowner = owner;
            return true;
        }
        return false;
    }

    public boolean setCalendar(Calendar calendar) {
        this.m_associatedDays = calendar;
        return true;
    }

    public void initFromXML(String xml, Scheduler scheduler) throws SchedulerException {
        Document doc = GeneralUtilities.parseXML((String)xml);
        Node node = doc.getElementsByTagName("Event").item(0);
        this.initFromNode(node, scheduler);
    }

    public void initFromNode(Node node, Scheduler scheduler) throws SchedulerException {
        this.m_scheduler = scheduler;
        try {
            NamedNodeMap map = node.getAttributes();
            String type = map.getNamedItem("Type").getNodeValue();
            if (type.compareTo("Time") != 0) {
                SchedulerException se = new SchedulerException("Invalid Type");
                throw se;
            }
            NodeList cnodes = node.getChildNodes();
            int numCNodes = cnodes.getLength();
            for (int x = 0; x < numCNodes; ++x) {
                Node cnode = cnodes.item(x);
                String tagname = cnode.getNodeName();
                if (tagname.compareTo("time") == 0) {
                    int thirdColon;
                    int secondColon;
                    String timeString = cnode.getFirstChild().getNodeValue();
                    int firstColon = timeString.indexOf(58);
                    if (firstColon > 0) {
                        this.m_hours = timeString.substring(0, firstColon);
                    }
                    if ((secondColon = timeString.indexOf(58, firstColon + 1)) > 0) {
                        this.m_minutes = timeString.substring(firstColon + 1, secondColon);
                    }
                    if ((thirdColon = timeString.indexOf(58, secondColon + 1)) > 0) {
                        this.m_duration = Integer.parseInt(timeString.substring(secondColon + 1, thirdColon));
                        this.m_timezone = timeString.substring(thirdColon + 1);
                        continue;
                    }
                    int hash = timeString.indexOf(35);
                    int tick = timeString.indexOf(43);
                    if (hash > 0) {
                        this.m_duration = Integer.parseInt(timeString.substring(secondColon + 1, hash));
                        if (tick > 0) {
                            this.m_occur = Integer.parseInt(timeString.substring(hash + 1), tick);
                            this.m_timezone = timeString.substring(tick + 1);
                            continue;
                        }
                        this.m_occur = Integer.parseInt(timeString.substring(hash + 1));
                        this.m_timezone = null;
                        continue;
                    }
                    if (tick > 0) {
                        this.m_duration = Integer.parseInt(timeString.substring(secondColon + 1, tick));
                        this.m_occur = -1;
                        this.m_timezone = timeString.substring(tick + 1);
                        continue;
                    }
                    this.m_duration = Integer.parseInt(timeString.substring(secondColon + 1));
                    this.m_occur = -1;
                    this.m_timezone = null;
                    continue;
                }
                if (tagname.compareTo("schedule") != 0) continue;
                IRecurrenceInfo days = this.createFromNode(cnode);
                this.m_associatedDays = this.m_scheduler.createCalendar(days);
                this.m_user = this.m_associatedDays.getOwner();
            }
        }
        catch (NullPointerException npe) {
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)npe);
            throw se;
        }
        catch (RuntimeException rte) {
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)rte);
            throw se;
        }
    }

    public String generateXML() {
        String xmlString = null;
        if (this.m_associatedDays == null) {
            return null;
        }
        IRecurrenceInfo days = this.m_associatedDays.getDays();
        if (days == null) {
            String xml = this.m_associatedDays.getDefinition();
            if (xml == null) {
                xml = this.toString();
            }
            if ((days = this.createFromXML(xml)) == null) {
                return null;
            }
            xmlString = xml;
        } else {
            xmlString = days.toXML();
        }
        if (xmlString == null) {
            return null;
        }
        StringBuffer timeXML = new StringBuffer();
        String desc = this.getDescription();
        if (desc != null && desc.indexOf(">") > 0) {
            desc = "";
        }
        timeXML.append("<Event Type=\"Time\" Description=\"" + desc + "\">\n");
        timeXML.append(xmlString);
        String temp = "<time>" + this.m_hours + ":" + this.m_minutes + ":" + this.m_duration;
        if (this.m_occur != -1) {
            temp = temp + "#" + this.m_occur;
        }
        if (this.m_timezone != null) {
            temp = temp + "+" + this.m_timezone;
        }
        timeXML.append(temp + "</time>\n");
        timeXML.append("</Event>\n");
        return timeXML.toString();
    }

    public String generateDefinition() {
        if (this.m_associatedDays == null) {
            return "";
        }
        IRecurrenceInfo days = this.m_associatedDays.getDays();
        if (days == null) {
            days = this.m_recurrence;
        }
        if (days == null) {
            return "";
        }
        String xmlString = days.toXML();
        if (xmlString == null) {
            return "";
        }
        StringBuffer timeDefinition = new StringBuffer(TimeEventTag);
        timeDefinition.append(TimeEventUserName);
        timeDefinition.append(this.m_user);
        timeDefinition.append(TimeEventDefinitionSeparator);
        timeDefinition.append(TimeEventCalendarID);
        timeDefinition.append(this.m_associatedDays.getName());
        timeDefinition.append(TimeEventDefinitionSeparator);
        timeDefinition.append(TimeEventRecurrence);
        timeDefinition.append(xmlString);
        timeDefinition.append(TimeEventDefinitionSeparator);
        timeDefinition.append(TimeEventRunTime);
        timeDefinition.append(this.m_hours);
        timeDefinition.append(':');
        timeDefinition.append(this.m_minutes);
        timeDefinition.append(':');
        timeDefinition.append(this.m_duration);
        if (this.m_occur > 0) {
            timeDefinition.append('#');
            timeDefinition.append(this.m_occur);
        }
        if (this.m_timezone != null) {
            timeDefinition.append('+');
            timeDefinition.append(this.m_timezone);
        }
        timeDefinition.append(TimeEventDefinitionSeparator);
        return timeDefinition.toString();
    }

    public String generateCalendarDefinition() {
        if (this.m_associatedDays == null) {
            return "";
        }
        IRecurrenceInfo days = this.m_associatedDays.getDays();
        if (days == null) {
            return "";
        }
        String xmlString = null;
        xmlString = days instanceof OpaqueRecurrence ? ((OpaqueRecurrence)days).getData() : days.toXML();
        if (xmlString == null) {
            return "";
        }
        return xmlString;
    }

    public boolean validateFromDefinition(String content) throws SchedulerException {
        if (content == null) {
            return false;
        }
        boolean isTimeEvent = content.startsWith(TimeEventTag);
        if (!isTimeEvent) {
            return false;
        }
        String timeString = this.getDefinitionString(content, TimeEventRunTime);
        if (timeString == null) {
            return false;
        }
        String recurrenceXML = this.getDefinitionString(content, TimeEventRecurrence);
        if (recurrenceXML == null) {
            return false;
        }
        String calendarName = this.getDefinitionString(content, TimeEventCalendarID);
        if (calendarName == null) {
            return false;
        }
        IRecurrenceInfo recurrence = AbstractRecurrence.createFromXML((String)recurrenceXML);
        if (recurrence == null) {
            return false;
        }
        String hours = "";
        String minutes = "";
        String durationString = null;
        int duration = -1;
        String occurString = null;
        int occur = -1;
        String timezone = null;
        int firstColon = timeString.indexOf(58);
        if (firstColon < 0) {
            return false;
        }
        hours = timeString.substring(0, firstColon);
        int secondColon = timeString.indexOf(58, firstColon + 1);
        if (secondColon < 0) {
            return false;
        }
        minutes = timeString.substring(firstColon + 1, secondColon);
        int hash = timeString.indexOf(35, secondColon + 1);
        int plus = timeString.indexOf(43, secondColon + 1);
        if (hash > 0) {
            durationString = timeString.substring(secondColon + 1, hash);
            if (plus > 0) {
                occurString = timeString.substring(hash + 1, plus);
                timezone = timeString.substring(plus + 1);
            } else {
                occurString = timeString.substring(hash + 1);
            }
        } else if (plus > 0) {
            durationString = timeString.substring(secondColon + 1, plus);
            timezone = timeString.substring(plus + 1);
        } else {
            durationString = timeString.substring(secondColon + 1);
        }
        try {
            duration = Integer.parseInt(durationString);
        }
        catch (RuntimeException e) {
            return false;
        }
        if (occurString != null) {
            try {
                occur = Integer.parseInt(occurString);
            }
            catch (RuntimeException e) {
                return false;
            }
        }
        return this.validateHours(hours) && this.validateMinutes(minutes) && this.validateDuration(duration) && this.validateOccur(occur) && this.validateTimezone(timezone);
    }

    public boolean initFromDefinition(Scheduler scheduler, String content) throws SchedulerException {
        boolean isTimeEvent;
        if (scheduler == null || content == null) {
            return false;
        }
        if (content.startsWith("\"") || content.startsWith("'")) {
            content = content.substring(1, content.length() - 1);
        }
        if (!(isTimeEvent = content.startsWith(TimeEventTag))) {
            return false;
        }
        String nameString = this.getDefinitionString(content, TimeEventUserName);
        String timeString = this.getDefinitionString(content, TimeEventRunTime);
        if (timeString == null) {
            return false;
        }
        String recurrenceXML = this.getDefinitionString(content, TimeEventRecurrence);
        if (recurrenceXML == null) {
            return false;
        }
        String calendarName = this.getDefinitionString(content, TimeEventCalendarID);
        if (calendarName == null) {
            return false;
        }
        String temp = recurrenceXML.replaceAll("&&", "&amp;&amp;");
        IRecurrenceInfo recurrence = AbstractRecurrence.createFromXML((String)temp);
        if (recurrence == null) {
            return false;
        }
        String hours = "";
        String minutes = "";
        int duration = -1;
        int occur = -1;
        String timezone = null;
        int firstColon = timeString.indexOf(58);
        if (firstColon < 0) {
            return false;
        }
        hours = MetaUtilities.replaceString(timeString.substring(0, firstColon), ";", ",");
        int secondColon = timeString.indexOf(58, firstColon + 1);
        if (secondColon < 0) {
            return false;
        }
        minutes = MetaUtilities.replaceString(timeString.substring(firstColon + 1, secondColon), ";", ",");
        String durationString = null;
        String occurString = null;
        int hash = timeString.indexOf(35, secondColon + 1);
        int plus = timeString.indexOf(43, secondColon + 1);
        if (hash > 0) {
            durationString = timeString.substring(secondColon + 1, hash);
            if (plus > 0) {
                occurString = timeString.substring(hash + 1, plus);
                timezone = timeString.substring(plus + 1);
            } else {
                occurString = timeString.substring(hash + 1);
            }
        } else if (plus > 0) {
            durationString = timeString.substring(secondColon + 1, plus);
            timezone = timeString.substring(plus + 1);
        } else {
            durationString = timeString.substring(secondColon + 1);
        }
        try {
            duration = Integer.parseInt(durationString);
        }
        catch (RuntimeException e) {
            return false;
        }
        if (occurString != null) {
            try {
                occur = Integer.parseInt(occurString);
            }
            catch (RuntimeException e) {
                return false;
            }
        }
        if (!(this.validateHours(hours) && this.validateMinutes(minutes) && this.validateDuration(duration) && this.validateOccur(occur) && this.validateTimezone(timezone))) {
            return false;
        }
        try {
            Calendar calendar;
            this.m_associatedDays = calendar = scheduler.getCalendar(recurrence);
        }
        catch (SchedulerException se) {
            if (MetaUtilities.isDebug()) {
                se.printStackTrace();
            }
            this.m_associatedDays = null;
        }
        this.m_recurrence = recurrence;
        this.m_hours = hours;
        this.m_minutes = minutes;
        this.m_duration = duration;
        this.m_occur = occur;
        this.m_timezone = timezone;
        this.m_scheduler = scheduler;
        if (nameString != null) {
            this.m_user = nameString;
        }
        return true;
    }

    public boolean initFromCondition(Scheduler scheduler, String conditionString) throws SchedulerException {
        if (scheduler == null) {
            return false;
        }
        String calendarName = scheduler.getCalNameFromConditionString(conditionString);
        String durationString = scheduler.getDurationFromConditionString(conditionString);
        String hours = scheduler.getHourFromConditionString(conditionString);
        String minutes = scheduler.getMinuteFromConditionString(conditionString);
        String userName = scheduler.getUserNameFromConditionString(conditionString);
        String occur = scheduler.getOccurrenceFromConditionString(conditionString);
        String timezone = scheduler.getTimezoneFromConditionString(conditionString);
        if (calendarName == null || durationString == null || hours == null || minutes == null || userName == null) {
            return false;
        }
        Calendar calendar = scheduler.getCalendar(calendarName + '@' + userName);
        if (calendar == null) {
            return false;
        }
        this.m_associatedDays = calendar;
        this.m_scheduler = scheduler;
        this.m_description = conditionString;
        this.m_hours = hours;
        this.m_minutes = minutes;
        this.m_user = userName;
        this.m_timezone = timezone;
        try {
            this.m_duration = Integer.parseInt(durationString);
        }
        catch (NumberFormatException ex) {
            this.m_duration = 1;
        }
        try {
            this.m_occur = Integer.parseInt(occur);
        }
        catch (NumberFormatException ex) {
            this.m_occur = -1;
        }
        return true;
    }

    public String toString() {
        return this.toString(Locale.getDefault());
    }

    public String toString(Locale locale) {
        IRecurrenceInfo rinfo = null;
        if (this.m_associatedDays != null) {
            rinfo = this.m_associatedDays.getDays();
        }
        return TimeEventInfo.toStringShortDesc((IRecurrenceInfo)rinfo, (String)this.m_hours, (String)this.m_minutes, (String)String.valueOf(this.m_duration), (String)this.m_timezone, (Locale)locale);
    }

    private String getDefinitionString(String definition, String type) {
        int start = definition.indexOf(type, 0);
        if (start < 0) {
            return null;
        }
        int end = definition.indexOf(TimeEventDefinitionSeparator, start);
        if (end < 0) {
            return null;
        }
        String result = definition.substring(start + type.length(), end).trim();
        return result;
    }

    private boolean validateDuration(int duration) {
        return duration >= 1;
    }

    private boolean validateOccur(int occur) {
        return occur == -1 || occur >= 1;
    }

    private boolean validateTimezone(String id) {
        if (id == null) {
            return true;
        }
        if (id.length() > 0) {
            String[] timezones = TimeZone.getAvailableIDs();
            int length = timezones.length;
            for (int i = 0; i < length; ++i) {
                if (id.compareTo(timezones[i]) != 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean validateMinutes(String minutes) {
        return minutes.length() > 0;
    }

    private boolean validateHours(String hours) {
        return hours.length() > 0;
    }

    private IRecurrenceInfo createFromNode(Node node) {
        try {
            return AbstractRecurrence.createFromNode((Node)node);
        }
        catch (SchedulerException schedulerException) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    private IRecurrenceInfo createFromXML(String xmlString) {
        try {
            return AbstractRecurrence.createFromXML((String)xmlString);
        }
        catch (SchedulerException schedulerException) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    public String generateXML(boolean exportFormat) {
        return this.generateXML();
    }

    public boolean setDescription(String sDescription) {
        this.m_description = sDescription;
        return true;
    }

    public String getDescription() {
        return this.m_description;
    }
}

