/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.oma;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.api.servers.os.OSScheduler;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerResultSet;
import com.sas.scheduler.visuals.swing.TriggeringEventPanel;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.security.acl.NotOwnerException;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;

public class SubmitFlow {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(SubmitFlow.class);
    protected boolean m_success;
    protected DeployedFlow m_flow;
    protected Scheduler m_scheduler;
    protected boolean m_flowModified;
    protected boolean m_errorOnDelete;
    protected TriggeringEventPanel m_triggerEventPanel = null;
    private boolean m_bReturnCode;
    private String m_reason;
    private String m_warning;

    public SubmitFlow(DeployedFlow flowMetadata) {
        this(flowMetadata, false, false);
    }

    public SubmitFlow(DeployedFlow flowMetadata, boolean flowModified) {
        this(flowMetadata, flowModified, false);
    }

    public SubmitFlow(DeployedFlow flowMetadata, boolean flowModified, boolean errorOnDelete) {
        this.m_flow = flowMetadata;
        this.m_scheduler = this.m_flow.getSchedulingServer();
        this.m_flowModified = flowModified;
        this.m_errorOnDelete = errorOnDelete;
    }

    public boolean isFlowSubmitted() throws MdException, RemoteException {
        return this.m_flow.isFlowSubmitted();
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    @Deprecated
    public boolean batchSubmit(String user, String pass) throws SchedulerException {
        return this.batchSubmit(user, pass != null ? new SealedString(pass) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean batchSubmit(String user, SealedString pass) throws SchedulerException {
        boolean rc = false;
        if (this.m_scheduler != null) {
            this.m_scheduler.closeConnection();
        }
        try {
            this.m_scheduler = this.m_flow.getSchedulingServer();
            if (this.m_scheduler != null && this.m_scheduler.makeConnection(user, pass) == 1) {
                ScheduleFlow submitter = new ScheduleFlow(this.m_flow, true);
                submitter.run();
                rc = this.m_bReturnCode;
            } else {
                rc = false;
            }
        }
        catch (RuntimeException ex) {
            rc = false;
        }
        finally {
            if (this.m_scheduler instanceof OSScheduler) {
                this.m_scheduler.closeConnection();
            }
        }
        return rc;
    }

    @Deprecated
    public Date getFinishTime(String user, String password) throws NotOwnerException, SchedulerException {
        return this.getFinishTime(user, password != null ? new SealedString(password) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getFinishTime(String user, SealedString password) throws NotOwnerException, SchedulerException {
        Date rc = null;
        try {
            if (this.m_scheduler != null) {
                this.m_scheduler.closeConnection();
            }
            if (this.m_scheduler != null && this.m_scheduler.makeConnection(user, password) != 1) {
                long flowid = this.m_flow.getScheduleID();
                if (flowid == -2L) {
                    flowid = this.m_scheduler.getFlowInstance(this.m_flow.getInfo());
                }
                if (flowid == -1L) {
                    NotOwnerException ex = new NotOwnerException();
                    throw ex;
                }
                if (flowid == -2L) {
                    rc = null;
                } else {
                    this.m_flow.setScheduleID(flowid);
                    rc = this.m_scheduler.getFinishTime(flowid);
                }
            } else {
                rc = null;
            }
        }
        finally {
            if (this.m_scheduler instanceof OSScheduler) {
                this.m_scheduler.closeConnection();
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getStartTime(String user, String password) throws NotOwnerException, SchedulerException {
        Date rc = null;
        try {
            if (this.m_scheduler != null) {
                this.m_scheduler.closeConnection();
            }
            this.m_scheduler = this.m_flow.getSchedulingServer();
            if (this.m_scheduler != null && this.m_scheduler.makeConnection(user, password != null ? new SealedString(password) : null) != 1) {
                long flowid = this.m_flow.getScheduleID();
                if (flowid == -2L) {
                    flowid = this.m_scheduler.getFlowInstance(this.m_flow.getInfo());
                }
                if (flowid == -1L) {
                    NotOwnerException ex = new NotOwnerException();
                    throw ex;
                }
                if (flowid == -2L) {
                    rc = null;
                } else {
                    this.m_flow.setScheduleID(flowid);
                    rc = this.m_scheduler.getStartTime(flowid);
                }
            } else {
                rc = null;
            }
        }
        catch (RuntimeException ex) {
            rc = null;
        }
        finally {
            if (this.m_scheduler instanceof OSScheduler) {
                this.m_scheduler.closeConnection();
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState(String user, String password) throws NotOwnerException, SchedulerException {
        int rc = -1;
        try {
            if (this.m_scheduler != null) {
                this.m_scheduler.closeConnection();
            }
            this.m_scheduler = this.m_flow.getSchedulingServer();
            if (this.m_scheduler != null && this.m_scheduler.makeConnection(user, password != null ? new SealedString(password) : null) != 1) {
                long flowid = this.m_flow.getScheduleID();
                if (flowid == -2L) {
                    flowid = this.m_scheduler.getFlowInstance(this.m_flow.getInfo());
                }
                if (flowid == -1L) {
                    NotOwnerException ex = new NotOwnerException();
                    throw ex;
                }
                if (flowid == -2L) {
                    rc = -1;
                } else {
                    this.m_flow.setScheduleID(flowid);
                    rc = this.m_scheduler.getState(flowid);
                }
            } else {
                rc = -1;
            }
        }
        catch (RuntimeException ex) {
            rc = -1;
        }
        finally {
            if (this.m_scheduler instanceof OSScheduler) {
                this.m_scheduler.closeConnection();
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus(String user, String password) throws NotOwnerException, SchedulerException {
        int rc = -1;
        try {
            if (this.m_scheduler != null) {
                this.m_scheduler.closeConnection();
            }
            this.m_scheduler = this.m_flow.getSchedulingServer();
            if (this.m_scheduler != null && this.m_scheduler.makeConnection(user, password != null ? new SealedString(password) : null) != 1) {
                long flowid = this.m_flow.getScheduleID();
                if (flowid == -2L) {
                    flowid = this.m_scheduler.getFlowInstance(this.m_flow.getInfo());
                }
                if (flowid == -1L) {
                    NotOwnerException ex = new NotOwnerException();
                    throw ex;
                }
                if (flowid == -2L) {
                    int n = -1;
                    return n;
                }
                this.m_flow.setScheduleID(flowid);
                rc = this.m_scheduler.getStatus(flowid);
            } else {
                rc = -1;
            }
        }
        catch (RuntimeException ex) {
            rc = -1;
        }
        finally {
            if (this.m_scheduler instanceof OSScheduler) {
                this.m_scheduler.closeConnection();
            }
        }
        return rc;
    }

    public static List<FlowInfo> getSubmittedFlowInfos(List<FlowInfo> notscheduled, MdObjectStore store, String repos) throws RemoteException, SchedulerException {
        String reposID = repos.substring(9);
        List<FlowInfo> list = null;
        try {
            list = MetaUtilities.getSubmittedFlowInfos(notscheduled, store, "A0000001." + reposID);
        }
        catch (MdException ex) {
            list = null;
        }
        catch (RemoteException ex) {
            list = null;
        }
        return list;
    }

    public static List<FlowInfo> getSubmittedFlowInfos(MdObjectStore store, String repos) throws RemoteException, SchedulerException {
        String reposID = repos.substring(9);
        List<FlowInfo> list = null;
        try {
            list = MetaUtilities.getSubmittedFlowInfos(store, "A0000001." + reposID);
        }
        catch (MdException ex) {
            list = null;
        }
        catch (RemoteException ex) {
            list = null;
        }
        return list;
    }

    public static List<?> getSubmittedFlows(List<DeployedFlow> notscheduled, MdObjectStore store, String repos) throws RemoteException {
        String reposID = repos.substring(9);
        List<DeployedFlow> list = null;
        try {
            list = MetaUtilities.getSubmittedFlows(notscheduled, store, "A0000001." + reposID);
        }
        catch (MdException ex) {
            list = null;
        }
        catch (RemoteException ex) {
            list = null;
        }
        return list;
    }

    public static List<?> getSubmittedFlows(MdObjectStore store, String repos) throws RemoteException {
        String reposID = repos.substring(9);
        List<DeployedFlow> list = null;
        try {
            list = MetaUtilities.getSubmittedFlows(store, "A0000001." + reposID);
        }
        catch (MdException ex) {
            list = null;
        }
        catch (RemoteException ex) {
            list = null;
        }
        return list;
    }

    public static SchedulerResultSet ScheduleFlow(FlowInfo info, Scheduler scheduler, boolean removeAndSubmit) {
        return SubmitFlow.ScheduleFlow(info, scheduler, removeAndSubmit, false);
    }

    public static SchedulerResultSet ScheduleFlow(FlowInfo info, Scheduler scheduler, boolean removeAndSubmit, boolean errorOnDelete) {
        String warning;
        String reason;
        block24: {
            reason = null;
            warning = null;
            try {
                String triggerType;
                warning = SubmitFlow.checkDependencies(scheduler, info, warning);
                String string = triggerType = info != null ? info.getTriggerType() : "";
                if (triggerType.compareTo("RunNow") == 0) {
                    if (!scheduler.scheduleFlowNow(info)) {
                        reason = m_bundle.getString("SubmitFlow.SchedulerNotAvailable.txt");
                    }
                    break block24;
                }
                if (removeAndSubmit && scheduler.isFlowScheduled(info)) {
                    try {
                        switch (scheduler.rescheduleFlow(info, errorOnDelete)) {
                            case 1: {
                                warning = m_bundle.getString("SubmitFlow.UnableToRemovePreviousFromScheduler.txt");
                                break;
                            }
                            case 0: {
                                break;
                            }
                            case 2: {
                                reason = m_bundle.getString("SubmitFlow.SchedulerNotAvailable.txt");
                            }
                        }
                    }
                    catch (UnsupportedOperationException ex) {
                        warning = ex.getLocalizedMessage();
                    }
                    break block24;
                }
                try {
                    if (!scheduler.scheduleFlow(info)) {
                        reason = m_bundle.getString("SubmitFlow.SchedulerNotAvailable.txt");
                    }
                }
                catch (UnsupportedOperationException ex) {
                    warning = ex.getLocalizedMessage();
                }
            }
            catch (InvalidParameterException ex) {
                reason = ex.getLocalizedMessage();
            }
            catch (SchedulerException ex) {
                reason = ex.getLocalizedMessage();
                if (reason == null && ex.getCause() != null) {
                    reason = ex.getCause().getLocalizedMessage();
                }
            }
            catch (UnsupportedOperationException ex) {
                reason = ex.getLocalizedMessage();
            }
            catch (NullPointerException ex) {
                reason = ex.toString();
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                }
            }
            catch (RuntimeException ex) {
                reason = ex.getLocalizedMessage();
                if (reason != null && reason.length() != 0) break block24;
                reason = ex.toString();
            }
        }
        if (warning != null && reason != null) {
            return new SchedulerResultSet(0, reason + "\n" + warning, (DisplayInfo)info);
        }
        if (warning != null) {
            return new SchedulerResultSet(2, warning, (DisplayInfo)info);
        }
        if (reason != null) {
            return new SchedulerResultSet(0, reason, (DisplayInfo)info);
        }
        String confirmation = MetaUtilities.messageString(m_bundle.getString("SubmitFlow.Confirmation.msg.fmt"), info != null ? info.getName() : "", scheduler.getServerComponent().getName());
        return new SchedulerResultSet(1, confirmation, (DisplayInfo)info);
    }

    protected boolean isFlowEmpty() {
        return SubmitFlow.isFlowEmpty(this.m_flow);
    }

    protected static boolean isFlowEmpty(DeployedFlow flow) {
        boolean bNoJobs = true;
        List<Object> jobs = flow.getJobs();
        if (jobs.size() > 0) {
            bNoJobs = false;
        }
        return bNoJobs;
    }

    protected String getReason() {
        if (this.m_warning != null && this.m_reason != null) {
            return this.m_reason + "\n" + this.m_warning;
        }
        if (this.m_warning != null) {
            return this.m_warning;
        }
        if (this.m_reason != null) {
            return this.m_reason;
        }
        return null;
    }

    public boolean getReturnCode() {
        return this.m_bReturnCode;
    }

    protected static String checkDependencies(Scheduler scheduler, FlowInfo flow, String message) {
        String returnString = message;
        if (flow.getJobs().size() > 1) {
            int numDepends = 0;
            for (Object obj : flow.getJobs()) {
                numDepends += flow.getEvents((DisplayInfo)obj).size();
            }
            if (numDepends == 0 && scheduler.isDependenciesEnabled()) {
                returnString = message == null ? m_bundle.getString("SubmitFlow.NoJobDependenciesWarning.txt") : message + "\n" + m_bundle.getString("SubmitFlow.NoJobDependenciesWarning.txt");
            }
        }
        return returnString;
    }

    protected class ScheduleFlowNow
    implements Runnable {
        private FlowInfo m_myflow;

        public ScheduleFlowNow(FlowInfo flow) {
            this.m_myflow = flow;
        }

        public ScheduleFlowNow(DeployedFlow flow) throws SchedulerException {
            this.m_myflow = flow.getInfo();
        }

        @Override
        public void run() {
            block7: {
                SubmitFlow.this.m_reason = null;
                SubmitFlow.this.m_warning = null;
                SubmitFlow.this.m_bReturnCode = true;
                try {
                    SubmitFlow.this.m_reason = SubmitFlow.checkDependencies(SubmitFlow.this.m_scheduler, this.m_myflow, SubmitFlow.this.m_reason);
                    SubmitFlow.this.m_bReturnCode = true;
                    SubmitFlow.this.m_bReturnCode = SubmitFlow.this.m_scheduler.scheduleFlowNow(this.m_myflow);
                    if (!SubmitFlow.this.m_bReturnCode) {
                        SubmitFlow.this.m_reason = m_bundle.getString("SubmitFlow.SchedulerNotAvailable.txt");
                    }
                }
                catch (InvalidParameterException ex) {
                    SubmitFlow.this.m_bReturnCode = false;
                    SubmitFlow.this.m_reason = ex.getLocalizedMessage();
                }
                catch (SchedulerException ex) {
                    SubmitFlow.this.m_bReturnCode = false;
                    SubmitFlow.this.m_reason = ex.getLocalizedMessage();
                }
                catch (UnsupportedOperationException ex) {
                    SubmitFlow.this.m_bReturnCode = true;
                    SubmitFlow.this.m_reason = ex.getLocalizedMessage();
                }
                catch (NullPointerException ex) {
                    SubmitFlow.this.m_bReturnCode = false;
                    SubmitFlow.this.m_reason = ex.toString();
                }
                catch (RuntimeException ex) {
                    SubmitFlow.this.m_bReturnCode = false;
                    SubmitFlow.this.m_reason = ex.getLocalizedMessage();
                    if (SubmitFlow.this.m_reason != null && SubmitFlow.this.m_reason.length() != 0) break block7;
                    SubmitFlow.this.m_reason = ex.toString();
                }
            }
        }
    }

    protected class ScheduleFlow
    implements Runnable {
        private DeployedFlow m_dflow;
        private FlowInfo m_myflow;
        private boolean m_removeAndSubmit;

        public ScheduleFlow(MdObjectStore store, String repos, FlowInfo flow, boolean removeAndSubmit) throws IllegalArgumentException, RemoteException, SchedulerException {
            this.m_myflow = flow;
            this.m_removeAndSubmit = removeAndSubmit;
        }

        public ScheduleFlow(DeployedFlow flow, boolean removeAndSubmit) throws SchedulerException {
            this.m_dflow = flow;
            this.m_myflow = flow.getInfo();
            this.m_removeAndSubmit = removeAndSubmit;
        }

        @Override
        public void run() {
            block17: {
                SubmitFlow.this.m_reason = null;
                SubmitFlow.this.m_warning = null;
                SubmitFlow.this.m_bReturnCode = true;
                try {
                    SubmitFlow.this.m_reason = SubmitFlow.checkDependencies(SubmitFlow.this.m_scheduler, this.m_myflow, SubmitFlow.this.m_reason);
                    if (this.m_removeAndSubmit && SubmitFlow.this.m_scheduler.isFlowScheduled(this.m_myflow)) {
                        SubmitFlow.this.m_bReturnCode = true;
                        try {
                            switch (SubmitFlow.this.m_scheduler.rescheduleFlow(this.m_myflow, SubmitFlow.this.m_errorOnDelete)) {
                                case 1: {
                                    SubmitFlow.this.m_warning = m_bundle.getString("SubmitFlow.UnableToRemovePreviousFromScheduler.txt");
                                    break;
                                }
                                case 0: {
                                    this.m_dflow.setFlowSubmitted(true);
                                    this.m_dflow.commitChangesWithNoValidation();
                                    break;
                                }
                                case 2: {
                                    SubmitFlow.this.m_bReturnCode = false;
                                    SubmitFlow.this.m_reason = m_bundle.getString("SubmitFlow.SchedulerNotAvailable.txt");
                                }
                            }
                        }
                        catch (UnsupportedOperationException ex) {
                            SubmitFlow.this.m_warning = ex.getLocalizedMessage();
                        }
                    } else {
                        SubmitFlow.this.m_bReturnCode = SubmitFlow.this.m_scheduler.scheduleFlow(this.m_myflow);
                        if (SubmitFlow.this.m_bReturnCode) {
                            this.m_dflow.setFlowSubmitted(true);
                            this.m_dflow.commitChangesWithNoValidation();
                        } else {
                            SubmitFlow.this.m_reason = m_bundle.getString("SubmitFlow.SchedulerNotAvailable.txt");
                        }
                    }
                }
                catch (InvalidParameterException ex) {
                    SubmitFlow.this.m_bReturnCode = false;
                    SubmitFlow.this.m_reason = ex.getLocalizedMessage();
                }
                catch (SchedulerException ex) {
                    SubmitFlow.this.m_bReturnCode = false;
                    SubmitFlow.this.m_reason = ex.getLocalizedMessage();
                }
                catch (UnsupportedOperationException ex) {
                    SubmitFlow.this.m_bReturnCode = true;
                    SubmitFlow.this.m_reason = ex.getLocalizedMessage();
                }
                catch (NullPointerException ex) {
                    SubmitFlow.this.m_bReturnCode = false;
                    SubmitFlow.this.m_reason = ex.toString();
                }
                catch (RuntimeException ex) {
                    SubmitFlow.this.m_bReturnCode = false;
                    SubmitFlow.this.m_reason = ex.getLocalizedMessage();
                    if (SubmitFlow.this.m_reason != null && SubmitFlow.this.m_reason.length() != 0) break block17;
                    SubmitFlow.this.m_reason = ex.toString();
                }
            }
        }

        public String getReason() {
            if (SubmitFlow.this.m_warning != null && SubmitFlow.this.m_reason != null) {
                return SubmitFlow.this.m_reason + "\n" + SubmitFlow.this.m_warning;
            }
            if (SubmitFlow.this.m_warning != null) {
                return SubmitFlow.this.m_warning;
            }
            if (SubmitFlow.this.m_reason != null) {
                return SubmitFlow.this.m_reason;
            }
            return null;
        }

        public boolean getReturnCode() {
            return SubmitFlow.this.m_bReturnCode;
        }
    }
}

