/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.oma;

import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.scheduler.api.oma.FolderNode;
import com.sas.scheduler.api.oma.RepositoryNode;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class FolderTree
extends JTree {
    private static final long serialVersionUID = 1L;
    private DefaultMutableTreeNode m_rootNode;

    public FolderTree(IOMI connection, MdObjectStore store, List<?> repositoryList) throws RemoteException {
        super(new DefaultTreeModel(new DefaultMutableTreeNode("FOLDERROOT")));
        this.setShowsRootHandles(true);
        this.addTreeExpansionListener(new myTreeExpansionListener());
        this.addTreeSelectionListener(new myTreeSelectionListener());
        this.getSelectionModel().setSelectionMode(1);
        this.setRootVisible(false);
        this.setScrollsOnExpand(true);
        this.m_rootNode = (DefaultMutableTreeNode)this.getModel().getRoot();
        if (repositoryList == null || repositoryList.isEmpty()) {
            try {
                MdFactory factory = store.getFactory();
                repositoryList = factory.getOMIUtil().getRepositories();
            }
            catch (MdException mde) {
                repositoryList = new ArrayList();
            }
            catch (RemoteException re) {
                repositoryList = new ArrayList();
            }
        }
        Iterator<?> iter = repositoryList.iterator();
        while (iter.hasNext()) {
            try {
                Root meta = (Root)iter.next();
                RepositoryNode reposNode = new RepositoryNode((CMetadata)meta, store);
                reposNode.addChildren();
                this.m_rootNode.add(reposNode);
            }
            catch (MdException meta) {
            }
            catch (RemoteException meta) {}
        }
        int count = this.m_rootNode.getChildCount();
        for (int x = 0; x < count; ++x) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_rootNode.getChildAt(x);
            FolderTree.addChildren(node);
            this.expandPath(new TreePath(node.getPath()));
        }
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.m_rootNode;
    }

    private static void addChildren(DefaultMutableTreeNode node) {
        if (node instanceof FolderNode) {
            FolderNode fnode = (FolderNode)node;
            try {
                fnode.addChildren();
                for (int x = 0; x < fnode.getChildCount(); ++x) {
                    DefaultMutableTreeNode cnode = (DefaultMutableTreeNode)fnode.getChildAt(x);
                    FolderTree.addChildren(cnode);
                }
            }
            catch (RemoteException re) {
                return;
            }
            catch (MdException mde) {
                return;
            }
        } else if (node instanceof RepositoryNode) {
            RepositoryNode rnode = (RepositoryNode)node;
            for (int x = 0; x < rnode.getChildCount(); ++x) {
                DefaultMutableTreeNode cnode = (DefaultMutableTreeNode)rnode.getChildAt(x);
                FolderTree.addChildren(cnode);
            }
        }
    }

    private class myTreeSelectionListener
    implements TreeSelectionListener {
        private myTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent arg0) {
            TreePath[] spaths = FolderTree.this.getSelectionPaths();
            TreePath[] tpaths = null;
            if (spaths != null) {
                int index = 0;
                int num = spaths.length;
                tpaths = new TreePath[num];
                for (int i = 0; i < num; ++i) {
                    TreePath path = spaths[i];
                    Object obj = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                    if (!(obj instanceof Tree)) continue;
                    tpaths[index++] = path;
                }
            } else {
                tpaths = new TreePath[]{};
            }
            FolderTree.this.setSelectionPaths(tpaths);
        }
    }

    private class myTreeExpansionListener
    implements TreeExpansionListener {
        private myTreeExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            FolderNode folder;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
            if (node instanceof FolderNode && !(folder = (FolderNode)node).hasExpanded()) {
                try {
                    DefaultMutableTreeNode child;
                    folder.addChildren();
                    folder.setHasExpanded(true);
                    if (folder.getChildCount() > 0 && (child = (DefaultMutableTreeNode)folder.getFirstChild()) != null) {
                        TreePath tp = new TreePath(child.getPath());
                        FolderTree.this.expandPath(tp);
                    }
                }
                catch (RemoteException remoteException) {
                }
                catch (MdException mdException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent arg0) {
        }
    }
}

