/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.oma;

import com.sas.metadata.remote.JFJob;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.oma.GroupingEvent;
import com.sas.scheduler.api.oma.JobEvent;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.model.JobDefinitionInfo;
import java.rmi.RemoteException;

public class ExportJobDefinition
extends JobDefinitionInfo {
    private JFJob m_jfjob;
    private String m_location;
    private String m_host;
    private String m_blankJobId = null;
    public static final String ID_Prefix = "Id=\"";
    public static final String ID_Blank = "XXXXXXXX";

    public ExportJobDefinition(JFJob job, int type, String command, String username, String host) throws RemoteException {
        this(job, type, command, null, username, host);
    }

    public ExportJobDefinition(JFJob job, int type, String command, String location, String username, String host) throws RemoteException {
        super(JobEvent.getName(job), type, command, username);
        this.m_jfjob = job;
        this.m_location = location;
        this.m_host = host;
    }

    public void blankJobIds(String flowId) {
        this.m_blankJobId = flowId != null ? "XXXXXXXX." + flowId : null;
    }

    public static boolean isIdBlanked(String id) {
        int index = id.indexOf(ID_Blank);
        return index >= 0;
    }

    public static String getFlowIdFromBlankedJobId(String blankedJobId) {
        int index = blankedJobId.indexOf(ID_Blank);
        if (index >= 0) {
            String id = blankedJobId.substring(index + ID_Blank.length());
            if (id.startsWith(".")) {
                return id.substring(1);
            }
            return id;
        }
        return null;
    }

    public String generateXML() {
        if (this.m_name == null) {
            return "";
        }
        if (this.m_command == null) {
            return "";
        }
        StringBuffer jobXML = new StringBuffer();
        String jobName = this.m_name;
        String jobId = null;
        String desc = MetaUtilities.replaceString(DeployedJob.getDescription(this.m_jfjob), "\"", "'");
        int start = jobName.indexOf("{");
        if (start > -1) {
            jobId = jobName.substring(start + 1, jobName.indexOf("}"));
            jobName = jobName.substring(0, start);
        }
        if (jobId != null) {
            if (this.m_blankJobId != null) {
                jobXML.append("<JobDef Name=\"" + jobName + "\" " + ID_Prefix + this.m_blankJobId + "\" Type=\"" + this.m_type + "\" Location=\"" + this.m_location + "\" Description=\"" + desc + "\" Created=\"" + DeployedJob.getDateCreated(this.m_jfjob, false) + "\" Modified=\"" + DeployedJob.getDateModified(this.m_jfjob, false) + "\">\n");
            } else {
                jobXML.append("<JobDef Name=\"" + jobName + "\" " + ID_Prefix + jobId + "\" Type=\"" + this.m_type + "\" Location=\"" + this.m_location + "\" Description=\"" + desc + "\" Created=\"" + DeployedJob.getDateCreated(this.m_jfjob, false) + "\" Modified=\"" + DeployedJob.getDateModified(this.m_jfjob, false) + "\">\n");
            }
        } else {
            jobXML.append("<JobDef Name=\"" + this.m_name + "\" Type=\"" + this.m_type + "\" Location=\"" + this.m_location + "\" Description=\"" + desc + "\" Created=\"" + DeployedJob.getDateCreated(this.m_jfjob, false) + "\" Modified=\"" + DeployedJob.getDateModified(this.m_jfjob, false) + "\">\n");
        }
        jobXML.append("<JobCmdLine  Value=\"" + this.m_command + "\"/>\n");
        if (this.m_host != null) {
            jobXML.append("<Host  Value=\"" + this.m_host + "\"/>\n");
        }
        if (this.m_username != null) {
            jobXML.append("<UserName  Value=\"" + this.m_username + "\"/>\n");
        }
        jobXML.append("</JobDef>\n");
        return jobXML.toString();
    }

    public String generateDependenciesXML() {
        String desc;
        if (this.m_dependency == null) {
            return null;
        }
        if (this.m_name == null) {
            return null;
        }
        if (this.m_type == null) {
            return null;
        }
        StringBuffer depXML = new StringBuffer();
        String jobName = this.m_name;
        int start = jobName.indexOf("{");
        if (start > -1) {
            jobName = jobName.substring(0, start);
        }
        if ((desc = this.m_dependency.getDescription()) == null || desc.contains("<")) {
            desc = "";
        }
        depXML.append("<Dependencies  Name=\"" + this.m_dependency.toString() + "\" Type = \"" + this.m_type + "\" Reference=\"" + jobName + "\" Description=\"" + desc + "\">\n");
        if (this.m_dependency instanceof GroupingEvent) {
            depXML.append(this.m_dependency.generateXML(true));
        } else {
            depXML.append("<Events CombinationType=\"OR\">\n");
            depXML.append(this.m_dependency.generateXML(true));
            depXML.append("</Events>\n");
        }
        depXML.append("</Dependencies>\n");
        return depXML.toString();
    }
}

