/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.oma;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServerComponent;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.util.UpgradeInterface;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.ResourceBundle;

public class DeployedJobSmartObject
extends Metadata
implements LocalizableProperties,
UpgradeInterface {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(DeployedJobSmartObject.class);
    private static final long serialVersionUID = 1L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(1, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(2, 0);
    private JFJob m_jfjob;

    public DeployedJobSmartObject() throws RemoteException {
        super(DeployedJobSmartObject.class);
    }

    public DeployedJobSmartObject(Object o) throws RemoteException {
        super(o, DeployedJobSmartObject.class);
        if (!(o instanceof JFJob)) {
            throw new IllegalArgumentException(MetaUtilities.messageString(m_bundle.getString("DeployedJobSmartObject.badctorobject.msg.fmt"), o.getClass().getName()));
        }
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
        this.m_jfjob = (JFJob)o;
    }

    public String getType() throws RemoteException {
        return "DeployedJob";
    }

    public Date getCreateDate() throws ServiceException, RemoteException {
        Date d = DeployedJob.getDateCreated(this.m_jfjob);
        if (d == null) {
            d = super.getCreateDate();
        }
        return d;
    }

    public Date getModifyDate() throws ServiceException, RemoteException {
        Date d = DeployedJob.getDateModified(this.m_jfjob);
        if (d == null) {
            d = super.getModifyDate();
        }
        return d;
    }

    public String getName() throws RemoteException {
        return DeployedJob.getName(this.m_jfjob);
    }

    public PropertyList getLocalizableProperties() {
        return this.getDefaultLocalizableProperties();
    }

    public void setLocalizableProperties(PropertyMap map) {
        this.setDefaultLocalizableProperties(map);
    }

    public void upgradeFromPreviousVersion() throws ServiceException, RemoteException {
        try {
            FolderInterface targetFolder;
            Job job;
            ServerComponent sc = CommandUtilities.getServerComponentForJob(this.m_jfjob);
            if (sc != null) {
                Property property = null;
                AssociationList properties = this.m_jfjob.getProperties();
                int propsize = properties.size();
                for (int j = 0; j < propsize; ++j) {
                    property = (Property)properties.get(j);
                    if (!property.getPropertyName().equalsIgnoreCase("LSfqid")) continue;
                    property.delete();
                    break;
                }
            }
            if ((job = DeployedJob.getJobObject(this.m_jfjob)) != null) {
                MetaUtilities.fixOldJobObject(job);
            }
            if ((targetFolder = this.getParent()) == null || FolderUtil.isDIStudioUngroupedFolder((FolderInterface)targetFolder)) {
                targetFolder = FolderUtil.makeSharedDataFolder((MetadataInterface)this);
            }
            this.validateNameAndFolder(targetFolder);
            this.m_jfjob.setUsageVersion("2000000.0");
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public boolean isUserWritten() {
        try {
            Job job = DeployedJob.getJobObject(this.m_jfjob);
            return MetaUtilities.isUserWritten(job);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }
}

