/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.tree;

import com.sas.services.user.UserContextInterface;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsActionContext;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.tree.FoldersTreeModel;
import com.sas.workspace.models.tree.ITreeModel;
import com.sas.workspace.models.tree.ITreeNode;
import com.sas.workspace.visuals.tree.AbstractBaseTree;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreePath;

public class FoldersTree
extends AbstractBaseTree {
    private static final WAdminResource bundle = WAdminResource.getBundle(FoldersTree.class);
    public static final String FOLDERS_TREE_CONTEXT = "FoldersTree";

    public FoldersTree(UserContextInterface userContext) {
        this(new FoldersTreeModel(userContext));
    }

    public FoldersTree(ITreeModel model) {
        super(model);
        this.setName(bundle.getString("FoldersTree.Name.txt"));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setIconDecorationsSupported(true);
        this.expandRoot();
        this.setLeadSelectionPath(this.getPathForRow(0));
    }

    @Override
    protected WsActionContextInterface createActionContext() {
        return new WsActionContext(FOLDERS_TREE_CONTEXT, this);
    }

    @Override
    public void selectObjects(SimpleObject[] aSimpleObjects) {
        ArrayList<TreePath> lPaths = new ArrayList<TreePath>(aSimpleObjects.length);
        for (int i = 0; i < aSimpleObjects.length; ++i) {
            String sFQID = aSimpleObjects[i].getID();
            ITreeModel model = (ITreeModel)this.getModel();
            List lNodes = model.findNodes(sFQID);
            if (lNodes.isEmpty() && model instanceof FoldersTreeModel) {
                ((FoldersTreeModel)model).addParentNodes(aSimpleObjects[i]);
                lNodes = model.findNodes(sFQID);
            }
            for (int j = 0; j < lNodes.size(); ++j) {
                lPaths.add(this.getPathFor((ITreeNode)lNodes.get(j)));
            }
        }
        this.setSelectionPaths(lPaths.toArray(new TreePath[lPaths.size()]));
        this.scrollPathToVisible(this.getLeadSelectionPath());
    }
}

