/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.tree;

import com.sas.workspace.models.tree.CategoryTreeNode;
import com.sas.workspace.models.tree.ITreeModel;
import com.sas.workspace.models.tree.ITreeNode;
import com.sas.workspace.visuals.tree.AbstractBaseTree;
import com.sas.workspace.visuals.tree.CategoryTreeUI;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;

public abstract class AbstractCategoryTree
extends AbstractBaseTree {
    private static final String UICLASSID = "CategoryTreeUI";
    private boolean m_bShowCategoryIcons = false;

    public AbstractCategoryTree() {
    }

    public AbstractCategoryTree(ITreeModel model) {
        super(model);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
    }

    @Override
    public String getUIClassID() {
        if (UIManager.get(UICLASSID) == null) {
            UIManager.put(UICLASSID, CategoryTreeUI.class.getName());
        }
        return UICLASSID;
    }

    public boolean getShowCategoryIcons() {
        return this.m_bShowCategoryIcons;
    }

    public void setShowCategoryIcons(boolean bShowCategoryIcons) {
        this.m_bShowCategoryIcons = bShowCategoryIcons;
    }

    @Override
    protected TreeCellRenderer createTreeCellRenderer() {
        return new cCategoryTreeCellRenderer();
    }

    @Override
    protected TreeCellEditor createTreeCellEditor(TreeCellRenderer renderer) {
        return super.createTreeCellEditor(renderer);
    }

    protected class cCategoryTreeCellRenderer
    extends DefaultTreeCellRenderer {
        protected cCategoryTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean bHasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, bHasFocus);
            this.setText(((ITreeNode)value).getName());
            Icon icon = null;
            if (value instanceof CategoryTreeNode) {
                this.setFont(this.getFont().deriveFont(1));
                if (((AbstractCategoryTree)tree).getShowCategoryIcons()) {
                    icon = ((ITreeNode)value).getIcon();
                }
            } else {
                this.setFont(this.getFont().deriveFont(0));
                icon = ((ITreeNode)value).getIcon();
            }
            this.setIcon(icon);
            this.setDisabledIcon(icon);
            return this;
        }
    }
}

