/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.pfd;

import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDScrollView;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.WsFileChooser;
import com.sas.workspace.visuals.pfd.WsPFDModel;
import com.sas.workspace.visuals.pfd.WsPFDPanel;
import com.sas.workspace.visuals.pfd.WsPFDPrimitive;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;

public class WsPFDPropertyTab
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(WsPFDPropertyTab.class);
    private static final String IMAGE_FILENAME_SUFFIX = ".png";
    public static final double ZOOM_MIN = 0.1;
    public static final double ZOOM_MAX = 5.0;
    public static final double ZOOM_INCREMENT = 0.1;
    public static final String LAYOUT_RIGHT = "Right";
    public static final String LAYOUT_LEFT = "Left";
    public static final String LAYOUT_UP = "Up";
    public static final String LAYOUT_DOWN = "Down";
    protected static final int APPDEFAULT_LAYOUT_RIGHT = 0;
    protected static final int APPDEFAULT_LAYOUT_DOWN = 1;
    protected static final int APPDEFAULT_LAYOUT_LEFT = 2;
    protected static final int APPDEFAULT_LAYOUT_UP = 3;
    private static final int APPDEFAULT_ZOOM_TO_FIT = -1;
    private static final String DEFAULT_ZOOM_KEY = "pfd.zoom.custompercent";
    private static final String DEFAULT_ZOOM_INDEX_KEY = "PFDFrame.DefaultZoomIndex";
    private static final String DEFAULT_LAYOUT_KEY = "PFDFrame.LayoutDirection";
    private static final String DEFAULT_BACKGROUND_KEY = "pfd.color.Background";
    private static final int DEFAULT_LAYOUT = 0;
    private static final int DEFAULT_ZOOM = 100;
    private WsPFDModel m_mdl;
    private WsPFDPanel m_pfd;
    private PFDScrollView m_scr;
    private JMenuItem[] m_aCommonPopupMenuItems;
    private boolean m_bZoomActionsAvailable;
    private boolean m_bLayoutActionsAvailable;
    private boolean m_bPrintActionsAvailable;
    private String m_sPrintJobTitle;
    private String m_sGIFFileName;
    private String m_sGIFDefaultDirectoryKey;
    private boolean m_bUpdateDefaultLayout;
    private boolean m_bUpdateDefaultZoom;
    private Point m_pClickedPoint;
    private String m_sDefaultLayoutKey;
    private String m_sDefaultZoomKey;
    private boolean m_bZoomToFitPending;
    private WsAbstractAction m_actZoom;
    private WsAbstractAction m_actZoomOut;
    private WsAbstractAction m_actZoomIn;
    private WsAbstractAction m_actZoomCustom;
    private WsAbstractAction m_actZoomToFit;
    private WsAbstractAction m_actZoom25;
    private WsAbstractAction m_actZoom50;
    private WsAbstractAction m_actZoom75;
    private WsAbstractAction m_actZoom100;
    private WsAbstractAction m_actZoom200;
    private WsAbstractAction m_actLayout;
    private WsAbstractToggleAction m_actLayoutLeft;
    private WsAbstractToggleAction m_actLayoutRight;
    private WsAbstractToggleAction m_actLayoutUp;
    private WsAbstractToggleAction m_actLayoutDown;
    private WsAbstractAction m_actPrint;
    private WsAbstractAction m_actPageSetup;
    private WsAbstractAction m_actSaveToImage;
    private WsAbstractAction m_actSaveToImageCurrent;
    private PropertyChangeListener m_lsnrAppDefaults;

    public WsPFDPropertyTab() {
        this.initialize();
    }

    @Override
    protected void initialize() {
        this.initializeAttributes();
        this.m_mdl = this.createPFDModel();
        this.initializeActionsAvailable();
        this.m_pClickedPoint = new Point();
        this.createComponents();
        this.layoutComponents();
        this.createActions();
        this.installDefaults();
    }

    private void initializeActionsAvailable() {
        this.setZoomActionsAvailable(true);
        this.setLayoutActionsAvailable(true);
        this.setPrintActionsAvailable(true);
    }

    private void initializeAttributes() {
        this.m_sPrintJobTitle = bundle.getString("WsPFDPropertyTab.Untitled.txt");
        this.m_sGIFFileName = bundle.getString("WsPFDPropertyTab.Untitled.txt");
        this.m_sGIFDefaultDirectoryKey = "PFDPanel.SaveToGif.DefaultDirectory";
        this.m_bUpdateDefaultLayout = true;
        this.m_bUpdateDefaultZoom = false;
    }

    protected void installDefaults() {
        this.m_sDefaultZoomKey = this.getDefaultZoomKey();
        this.m_sDefaultLayoutKey = this.getDefaultLayoutKey();
        if (this.m_sDefaultLayoutKey != null) {
            this.installDefaultLayout();
        }
        if (this.m_sDefaultZoomKey != null) {
            this.installDefaultZoom();
        }
        this.m_lsnrAppDefaults = this.createAppDefaultsListener();
        Workspace.getWorkspace().getAppDefaultsFile().addPropertyChangeListener(this.m_lsnrAppDefaults);
    }

    private void installDefaultLayout() {
        String sLayout;
        int eLayout = Workspace.getWorkspace().getAppDefaultsFile().getPropertyInt(this.m_sDefaultLayoutKey, this.getInitialDefaultLayout());
        switch (eLayout) {
            default: {
                sLayout = LAYOUT_RIGHT;
                break;
            }
            case 1: {
                sLayout = LAYOUT_DOWN;
                break;
            }
            case 2: {
                sLayout = LAYOUT_LEFT;
                break;
            }
            case 3: {
                sLayout = LAYOUT_UP;
            }
        }
        this.setLayoutDirectionImpl(sLayout);
    }

    private void installDefaultZoom() {
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        int zoom = 0;
        if (this.m_sDefaultZoomKey.equals(DEFAULT_ZOOM_KEY)) {
            int eZoom = appDefaults.getPropertyInt(DEFAULT_ZOOM_INDEX_KEY, 1);
            switch (eZoom) {
                case 0: {
                    zoom = 200;
                    break;
                }
                case 1: {
                    zoom = 100;
                    break;
                }
                case 2: {
                    zoom = 75;
                    break;
                }
                case 3: {
                    zoom = 50;
                    break;
                }
                case 4: {
                    zoom = 25;
                    break;
                }
                case 5: {
                    zoom = -1;
                    break;
                }
                case 6: {
                    zoom = 0;
                }
            }
        }
        if (zoom == 0) {
            zoom = appDefaults.getPropertyInt(this.m_sDefaultZoomKey, this.getInitialDefaultZoom());
        }
        if (zoom == -1) {
            this.m_bZoomToFitPending = true;
        } else {
            this.zoomImpl((double)zoom / 100.0);
        }
    }

    protected void zoomToFitIfPending() {
        if (this.m_bZoomToFitPending) {
            this.zoomImpl(this.m_pfd.getFitScale());
            this.m_bZoomToFitPending = false;
        }
    }

    protected PropertyChangeListener createAppDefaultsListener() {
        return new AppDefaultsListener();
    }

    protected String getDefaultZoomKey() {
        return DEFAULT_ZOOM_KEY;
    }

    protected String getDefaultLayoutKey() {
        return DEFAULT_LAYOUT_KEY;
    }

    protected String getDefaultBackgroundKey() {
        return DEFAULT_BACKGROUND_KEY;
    }

    protected int getInitialDefaultZoom() {
        return 100;
    }

    protected int getInitialDefaultLayout() {
        return 0;
    }

    protected void createComponents() {
        this.m_pfd = this.createPFDComponent();
        this.m_scr = this.createScrollComponent();
    }

    protected WsPFDPanel createPFDComponent() {
        WsPFDPanel pfd = new WsPFDPanel();
        pfd.setModel(this.m_mdl);
        pfd.setPopupMenuRequestListener(this.createDefaultPopupMenuRequestListener());
        return pfd;
    }

    protected WsPFDModel createPFDModel() {
        return new WsPFDModel();
    }

    protected WsPopupMenuRequestListener createDefaultPopupMenuRequestListener() {
        return new PopupMenuRequestListener();
    }

    protected WsPFDPanel getPFDComponent() {
        return this.m_pfd;
    }

    protected WsPFDModel getPFDModel() {
        return this.m_mdl;
    }

    protected PFDScrollView getScrollComponent() {
        return this.m_scr;
    }

    protected PFDScrollView createScrollComponent() {
        PFDScrollView scr = new PFDScrollView((PFDView)this.m_pfd);
        LookAndFeel.installBorder((JComponent)scr, "ScrollPane.border");
        return scr;
    }

    protected Point getSavedClickedPoint() {
        return this.m_pClickedPoint;
    }

    protected void setSavedClickedPoint(Point clickedPoint) {
        this.m_pClickedPoint = clickedPoint;
    }

    protected void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_scr);
    }

    protected void createActions() {
        this.createZoomActions();
        this.createLayoutActions();
        this.createPrintActions();
    }

    @Override
    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.setZoomActionsActive(bActive && this.isZoomActionsAvailable());
        this.setLayoutActionsActive(bActive && this.isLayoutActionsAvailable());
        this.setPrintActionsActive(bActive && this.isPrintActionsAvailable());
        this.m_pfd.setActive(bActive);
    }

    @Override
    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_pfd.setEditable(bEditable);
        this.updateActions();
    }

    protected void updateActions() {
        this.updateZoomActions();
        this.updateLayoutActions();
    }

    @Override
    public void saveSettingsAndCleanUp() {
        Workspace.getWorkspace().getAppDefaultsFile().removePropertyChangeListener(this.m_lsnrAppDefaults);
        this.m_pfd.dispose();
    }

    public void setCommonPopupMenuItems(JMenuItem[] aMenuItems) {
        this.m_aCommonPopupMenuItems = aMenuItems;
    }

    public JMenuItem[] getCommonPopupMenuItems() {
        return this.m_aCommonPopupMenuItems;
    }

    public void setZoomActionsAvailable(boolean bAvailable) {
        this.m_bZoomActionsAvailable = bAvailable;
    }

    public boolean isZoomActionsAvailable() {
        return this.m_bZoomActionsAvailable;
    }

    public void setLayoutActionsAvailable(boolean bAvailable) {
        this.m_bLayoutActionsAvailable = bAvailable;
    }

    public boolean isLayoutActionsAvailable() {
        return this.m_bLayoutActionsAvailable;
    }

    public void setPrintActionsAvailable(boolean bAvailable) {
        this.m_bPrintActionsAvailable = bAvailable;
    }

    public boolean isPrintActionsAvailable() {
        return this.m_bPrintActionsAvailable;
    }

    public void setPrintJobTitle(String sTitle) {
        this.m_sPrintJobTitle = sTitle;
    }

    public String getPrintJobTitle() {
        return this.m_sPrintJobTitle;
    }

    public void setGIFFileName(String sFileName) {
        this.m_sGIFFileName = sFileName;
    }

    public String getGIFFileName() {
        return this.m_sGIFFileName;
    }

    public void setGIFDefaultDirectoryKey(String sKey) {
        this.m_sGIFDefaultDirectoryKey = sKey;
    }

    public String getGIFDefaultDirectoryKey() {
        return this.m_sGIFDefaultDirectoryKey;
    }

    public void setUpdateDefaultZoom(boolean bUpdate) {
        this.m_bUpdateDefaultZoom = bUpdate;
    }

    public boolean isUpdateDefaultZoom() {
        return this.m_bUpdateDefaultZoom;
    }

    public void setUpdateDefaultLayout(boolean bUpdate) {
        this.m_bUpdateDefaultLayout = bUpdate;
    }

    public boolean isUpdateDefaultLayout() {
        return this.m_bUpdateDefaultLayout;
    }

    protected void showPopupMenu(Point ptLocation) {
        PFDPrimitive[] aSelectedPrimitives = this.m_pfd.getSelectedPrimitives();
        JPopupMenu menuPopup = aSelectedPrimitives.length == 0 ? this.createCanvasPopupMenu() : (aSelectedPrimitives.length == 1 ? this.createPrimitivePopupMenu(aSelectedPrimitives[0]) : this.createPrimitivesPopupMenu(aSelectedPrimitives));
        if (menuPopup != null && menuPopup.getComponentCount() > 0) {
            menuPopup.show((Component)((Object)this.m_pfd), ptLocation.x, ptLocation.y);
        }
    }

    protected JPopupMenu createPrimitivePopupMenu(PFDPrimitive prim) {
        JPopupMenu menuPopup = new JPopupMenu();
        if (prim instanceof WsPFDPrimitive) {
            ((WsPFDPrimitive)prim).addPopupMenuItems(menuPopup);
        }
        this.addCommonPopupMenuItems(menuPopup);
        return menuPopup;
    }

    protected JPopupMenu createPrimitivesPopupMenu(PFDPrimitive[] aPrimitives) {
        JPopupMenu menuPopup = new JPopupMenu();
        this.addCommonPopupMenuItems(menuPopup);
        return menuPopup;
    }

    protected JPopupMenu createCanvasPopupMenu() {
        JPopupMenu menuPopup = new JPopupMenu();
        this.addCanvasPopupMenuItems(menuPopup);
        this.addCommonPopupMenuItems(menuPopup);
        return menuPopup;
    }

    protected void addCanvasPopupMenuItems(JPopupMenu menuPopup) {
        if (this.isZoomActionsAvailable()) {
            menuPopup.add(this.createZoomMenu());
        }
        if (this.isLayoutActionsAvailable()) {
            menuPopup.add(this.createLayoutMenu());
        }
        if (this.isPrintActionsAvailable()) {
            menuPopup.add(this.m_actPrint);
        }
    }

    protected JMenu createZoomMenu() {
        JMenu menu = new JMenu(this.m_actZoom);
        menu.add(this.m_actZoomOut);
        menu.add(this.m_actZoomIn);
        menu.add(this.m_actZoomCustom);
        menu.add(this.m_actZoomToFit);
        menu.add(this.m_actZoom25);
        menu.add(this.m_actZoom50);
        menu.add(this.m_actZoom75);
        menu.add(this.m_actZoom100);
        menu.add(this.m_actZoom200);
        return menu;
    }

    protected JMenu createLayoutMenu() {
        JMenu menu = new JMenu(this.m_actLayout);
        menu.add(WsUIUtilities.createCheckBoxMenuItem(this.m_actLayoutRight));
        menu.add(WsUIUtilities.createCheckBoxMenuItem(this.m_actLayoutDown));
        menu.add(WsUIUtilities.createCheckBoxMenuItem(this.m_actLayoutLeft));
        menu.add(WsUIUtilities.createCheckBoxMenuItem(this.m_actLayoutUp));
        return menu;
    }

    protected void addCommonPopupMenuItems(JPopupMenu menuPopup) {
        if (this.m_aCommonPopupMenuItems == null || this.m_aCommonPopupMenuItems.length == 0) {
            return;
        }
        if (menuPopup.getComponentCount() > 0) {
            menuPopup.addSeparator();
        }
        for (int iMenuItem = 0; iMenuItem < this.m_aCommonPopupMenuItems.length; ++iMenuItem) {
            menuPopup.add(this.m_aCommonPopupMenuItems[iMenuItem]);
        }
    }

    public void zoomIn() {
        this.zoom(this.m_pfd.getScale() + 0.1);
    }

    public void zoomOut() {
        this.zoom(this.m_pfd.getScale() - 0.1);
    }

    public void zoomToFit() {
        this.zoomImpl(this.m_pfd.getFitScale());
        if (this.m_bUpdateDefaultZoom) {
            Workspace.getWorkspace().getAppDefaultsFile().setPropertyInt(this.m_sDefaultZoomKey, -1);
        }
    }

    public void zoom(double scale) {
        this.zoomImpl(scale);
        if (this.m_bUpdateDefaultZoom) {
            Workspace.getWorkspace().getAppDefaultsFile().setPropertyInt(this.m_sDefaultZoomKey, (int)(scale * 100.0));
        }
    }

    private void zoomImpl(double scale) {
        scale = Math.min(scale, 5.0);
        scale = Math.max(scale, 0.1);
        this.m_pfd.setScale(scale);
        this.updateZoomActions();
        this.m_pfd.revalidate();
    }

    protected void showCustomZoomDialog() {
        CustomZoomPanel pnl = new CustomZoomPanel();
        pnl.setZoomFactor((int)(this.m_pfd.getScale() * 100.0 + 0.5));
        String sTitle = bundle.getString("WsPFDPropertyTab.CustomZoomDialog.Title.txt");
        WAStandardDialog dlg = new WAStandardDialog(Workspace.getWorkspace(), sTitle, true);
        dlg.setHelpButtonVisible(false);
        dlg.setMainPanel(pnl);
        dlg.show();
        if (dlg.getReturnValue() == 1) {
            try {
                this.zoom((double)pnl.getZoomFactor() / 100.0);
            }
            catch (WAIntTextField.IllegalIntegerException ex) {
                MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
            }
        }
    }

    protected void createZoomActions() {
        this.m_actZoom = this.createZoomAction();
        this.m_actZoomOut = this.createZoomOutAction();
        this.m_actZoomIn = this.createZoomInAction();
        this.m_actZoomCustom = this.createZoomCustomAction();
        this.m_actZoomToFit = this.createZoomToFitAction();
        this.m_actZoom25 = this.createZoom25Action();
        this.m_actZoom50 = this.createZoom50Action();
        this.m_actZoom75 = this.createZoom75Action();
        this.m_actZoom100 = this.createZoom100Action();
        this.m_actZoom200 = this.createZoom200Action();
    }

    protected void setZoomActionsActive(boolean bActive) {
        this.m_actZoom.setActive(bActive);
        this.m_actZoomOut.setActive(bActive);
        this.m_actZoomIn.setActive(bActive);
        this.m_actZoomCustom.setActive(bActive);
        this.m_actZoomToFit.setActive(bActive);
        this.m_actZoom25.setActive(bActive);
        this.m_actZoom50.setActive(bActive);
        this.m_actZoom75.setActive(bActive);
        this.m_actZoom100.setActive(bActive);
        this.m_actZoom200.setActive(bActive);
    }

    protected void updateZoomActions() {
        double scale = this.m_pfd.getScale();
        this.m_actZoomIn.setEnabled(scale < 5.0);
        this.m_actZoomOut.setEnabled(scale > 0.1);
    }

    protected WsAbstractAction createZoomAction() {
        return new ZoomAction();
    }

    protected WsAbstractAction createZoomOutAction() {
        return new ZoomOutAction();
    }

    protected WsAbstractAction createZoomInAction() {
        return new ZoomInAction();
    }

    protected WsAbstractAction createZoomCustomAction() {
        return new ZoomCustomAction();
    }

    protected WsAbstractAction createZoomToFitAction() {
        return new ZoomToFitAction();
    }

    protected WsAbstractAction createZoom25Action() {
        return new Zoom25Action();
    }

    protected WsAbstractAction createZoom50Action() {
        return new Zoom50Action();
    }

    protected WsAbstractAction createZoom75Action() {
        return new Zoom75Action();
    }

    protected WsAbstractAction createZoom100Action() {
        return new Zoom100Action();
    }

    protected WsAbstractAction createZoom200Action() {
        return new Zoom200Action();
    }

    public void setLayoutDirection(String eLayoutDirection) {
        this.setLayoutDirectionImpl(eLayoutDirection);
        if (this.m_bUpdateDefaultLayout) {
            int eDefaultLayoutDirection = eLayoutDirection == LAYOUT_UP ? 3 : (eLayoutDirection == LAYOUT_DOWN ? 1 : (eLayoutDirection == LAYOUT_LEFT ? 2 : 0));
            Workspace.getWorkspace().getAppDefaultsFile().setPropertyInt(this.m_sDefaultLayoutKey, eDefaultLayoutDirection);
        }
    }

    public String getLayoutDirection() {
        return this.m_pfd.getLayoutDirection();
    }

    private void setLayoutDirectionImpl(String eLayoutDirection) {
        this.m_pfd.setLayoutDirection(eLayoutDirection);
        if (eLayoutDirection == LAYOUT_UP) {
            this.m_actLayoutUp.setSelected(true);
        } else if (eLayoutDirection == LAYOUT_DOWN) {
            this.m_actLayoutDown.setSelected(true);
        } else if (eLayoutDirection == LAYOUT_LEFT) {
            this.m_actLayoutLeft.setSelected(true);
        } else if (eLayoutDirection == LAYOUT_RIGHT) {
            this.m_actLayoutRight.setSelected(true);
        }
    }

    protected void createLayoutActions() {
        this.m_actLayout = this.createLayoutAction();
        this.m_actLayoutLeft = this.createLayoutLeftAction();
        this.m_actLayoutRight = this.createLayoutRightAction();
        this.m_actLayoutUp = this.createLayoutUpAction();
        this.m_actLayoutDown = this.createLayoutDownAction();
    }

    protected void setLayoutActionsActive(boolean bActive) {
        this.m_actLayout.setActive(bActive);
        this.m_actLayoutLeft.setActive(bActive);
        this.m_actLayoutRight.setActive(bActive);
        this.m_actLayoutUp.setActive(bActive);
        this.m_actLayoutDown.setActive(bActive);
    }

    protected void updateLayoutActions() {
    }

    protected WsAbstractAction createLayoutAction() {
        return new LayoutAction();
    }

    protected WsAbstractToggleAction createLayoutLeftAction() {
        return new LayoutLeftAction();
    }

    protected WsAbstractToggleAction createLayoutRightAction() {
        return new LayoutRightAction();
    }

    protected WsAbstractToggleAction createLayoutUpAction() {
        return new LayoutUpAction();
    }

    protected WsAbstractToggleAction createLayoutDownAction() {
        return new LayoutDownAction();
    }

    public void print() {
        this.m_pfd.setPrintMode(0);
        PrinterJob printJob = PrinterJob.getPrinterJob();
        if (!Workspace.getWorkspace().isPrinterConnected(printJob)) {
            return;
        }
        printJob.setJobName(this.m_sPrintJobTitle);
        printJob.setPrintable((Printable)((Object)this.m_pfd), this.m_pfd.getPageFormat());
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (PrinterException ex) {
                String sTitle = bundle.getString("WsPFDPropertyTab.PrintError.Title.txt");
                MessageUtil.displayMessage(ex.getLocalizedMessage(), sTitle, 0);
            }
        }
        this.repaint();
    }

    public void pageSetup() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        if (!Workspace.getWorkspace().isPrinterConnected(printJob)) {
            return;
        }
        this.m_pfd.setPageFormat(printJob.pageDialog(this.m_pfd.getPageFormat()));
    }

    public void saveToGIF() {
        throw new UnsupportedOperationException("save to gif is no longer supported; call saveToImage() instead");
    }

    public void saveToImageCurrent() {
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        String sDefaultPath = appDefaults.getPropertyString(this.m_sGIFDefaultDirectoryKey, "");
        WsFileChooser dlg = new WsFileChooser(sDefaultPath);
        dlg.setFileSelectionMode(0);
        dlg.setMultiSelectionEnabled(false);
        dlg.setDialogTitle(bundle.getString("WsPFDPropertyTab.SaveToImageDialog.Title.txt"));
        String sFileName = this.m_sGIFFileName;
        if (!sFileName.endsWith(IMAGE_FILENAME_SUFFIX)) {
            sFileName = sFileName + IMAGE_FILENAME_SUFFIX;
        }
        dlg.setSelectedFile(new File(sFileName));
        if (dlg.showSaveDialog(Workspace.getWorkspace()) == 0) {
            File file = dlg.getSelectedFile();
            this.m_pfd.saveToPng(file);
            appDefaults.setPropertyString(this.m_sGIFDefaultDirectoryKey, dlg.getCurrentDirectory().getPath());
            this.m_sGIFFileName = file.getName();
        }
    }

    public void saveToImage() {
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        String sDefaultPath = appDefaults.getPropertyString(this.m_sGIFDefaultDirectoryKey, "");
        WsFileChooser dlg = new WsFileChooser(sDefaultPath);
        dlg.setFileSelectionMode(0);
        dlg.setMultiSelectionEnabled(false);
        dlg.setDialogTitle(bundle.getString("WsPFDPropertyTab.SaveToImageDialog.Title.txt"));
        String sFileName = this.m_sGIFFileName;
        if (!sFileName.endsWith(IMAGE_FILENAME_SUFFIX)) {
            sFileName = sFileName + IMAGE_FILENAME_SUFFIX;
        }
        dlg.setSelectedFile(new File(sFileName));
        if (dlg.showSaveDialog(Workspace.getWorkspace()) == 0) {
            File file = dlg.getSelectedFile();
            this.m_pfd.saveModelToPng(file);
            appDefaults.setPropertyString(this.m_sGIFDefaultDirectoryKey, dlg.getCurrentDirectory().getPath());
            this.m_sGIFFileName = file.getName();
        }
    }

    protected void createPrintActions() {
        this.m_actPrint = this.createPrintAction();
        this.m_actPageSetup = this.createPageSetupAction();
        this.m_actSaveToImage = this.createSaveToImageAction();
        this.m_actSaveToImageCurrent = this.createSaveToImageCurrentPageAction();
    }

    protected void setPrintActionsActive(boolean bActive) {
        this.m_actPrint.setActive(bActive);
        this.m_actPageSetup.setActive(bActive);
        this.m_actSaveToImage.setActive(bActive);
        this.m_actSaveToImageCurrent.setActive(bActive);
    }

    protected void updatePrintActions() {
    }

    protected WsAbstractAction createPrintAction() {
        return new PrintAction();
    }

    protected WsAbstractAction createPageSetupAction() {
        return new PageSetupAction();
    }

    protected WsAbstractAction createSaveToImageAction() {
        return new SaveToImageAction();
    }

    protected WsAbstractAction createSaveToImageCurrentPageAction() {
        return new SaveToImageCurrentPageAction();
    }

    protected static class CustomZoomPanel
    extends WAPanel {
        private static final long serialVersionUID = 1L;
        private JLabel m_lblCurrent;
        private JLabel m_lblCustom;
        private JLabel m_lblCurrentValue;
        private WAIntTextField m_txtCustomValue;

        public CustomZoomPanel() {
            this.initialize();
        }

        @Override
        protected void initialize() {
            this.m_txtCustomValue = new WAIntTextField();
            this.m_txtCustomValue.setColumns(6);
            this.m_txtCustomValue.setValue(100);
            this.m_lblCurrent = new JLabel(bundle.getString("WsPFDPropertyTab.CustomZoomPanel.CurrentZoomLabel.txt"));
            this.m_lblCustom = WsUIUtilities.createLabelForComponent(this.m_txtCustomValue, bundle, "WsPFDPropertyTab.CustomZoomPanel.CustomZoomLabel");
            this.m_lblCurrentValue = new JLabel("100%");
            this.m_lblCurrentValue.setHorizontalTextPosition(4);
            this.setLayout(new GridBagLayout());
            this.add((Component)this.m_lblCurrent, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.add((Component)this.m_lblCustom, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
            this.add((Component)this.m_lblCurrentValue, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)this.m_txtCustomValue, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        }

        public void setZoomFactor(int zoom) {
            this.m_lblCurrentValue.setText(zoom + "%");
            this.m_txtCustomValue.setValue(100);
        }

        public int getZoomFactor() throws WAIntTextField.IllegalIntegerException {
            return this.m_txtCustomValue.getValue2();
        }

        @Override
        public boolean validateData() {
            try {
                this.m_txtCustomValue.getValue2();
                return true;
            }
            catch (WAIntTextField.IllegalIntegerException ex) {
                MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
                this.m_txtCustomValue.requestFocusInWindow();
                return false;
            }
        }
    }

    protected class AppDefaultsListener
    implements PropertyChangeListener {
        protected AppDefaultsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            String sProperty = ev.getPropertyName();
            if (sProperty == null) {
                return;
            }
            if (WsPFDPropertyTab.this.m_bUpdateDefaultLayout && sProperty.equals(WsPFDPropertyTab.this.m_sDefaultLayoutKey)) {
                WsPFDPropertyTab.this.installDefaultLayout();
            } else if (WsPFDPropertyTab.this.m_bUpdateDefaultZoom) {
                if (sProperty.equals(WsPFDPropertyTab.this.m_sDefaultZoomKey)) {
                    WsPFDPropertyTab.this.zoomImpl((double)((Integer)ev.getNewValue()).intValue() / 100.0);
                } else if (WsPFDPropertyTab.DEFAULT_ZOOM_KEY.equals(WsPFDPropertyTab.this.m_sDefaultZoomKey) && sProperty.equals(WsPFDPropertyTab.DEFAULT_ZOOM_INDEX_KEY)) {
                    WsPFDPropertyTab.this.installDefaultZoom();
                    WsPFDPropertyTab.this.zoomToFitIfPending();
                }
            }
        }
    }

    protected class PopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected PopupMenuRequestListener() {
        }

        @Override
        public void popupMenuRequested(MouseEvent ev) {
            WsPFDPropertyTab.this.showPopupMenu(ev.getPoint());
        }
    }

    protected class SaveToImageCurrentPageAction
    extends WsAbstractAction {
        public SaveToImageCurrentPageAction() {
            super(bundle, "WsPFDPropertyTab.Action.SaveToImageCurrent", 256);
            this.setMenuSupportId("Common:SaveCurrentImage");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsPFDPropertyTab.this.saveToImageCurrent();
        }
    }

    protected class SaveToImageAction
    extends WsAbstractAction {
        public SaveToImageAction() {
            super(bundle, "WsPFDPropertyTab.Action.SaveToImage", 256);
            this.setMenuSupportId("printtogif");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsPFDPropertyTab.this.saveToImage();
        }
    }

    protected class PageSetupAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public PageSetupAction() {
            super(bundle, "WsPFDPropertyTab.Action.PageSetup", 256);
            this.setMenuSupportId("pagesetup");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsPFDPropertyTab.this.pageSetup();
        }
    }

    protected class PrintAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public PrintAction() {
            super(bundle, "WsPFDPropertyTab.Action.Print", 258);
            this.setMenuSupportId("print");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsPFDPropertyTab.this.print();
        }
    }

    protected class LayoutDownAction
    extends WsAbstractToggleAction {
        private static final long serialVersionUID = 1L;

        public LayoutDownAction() {
            super(bundle, "WsPFDPropertyTab.Action.LayoutDown", 256);
            this.setMenuSupportId("layoutdown");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsPFDPropertyTab.this.setLayoutDirection(WsPFDPropertyTab.LAYOUT_DOWN);
        }
    }

    protected class LayoutUpAction
    extends WsAbstractToggleAction {
        private static final long serialVersionUID = 1L;

        public LayoutUpAction() {
            super(bundle, "WsPFDPropertyTab.Action.LayoutUp", 256);
            this.setMenuSupportId("layoutup");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsPFDPropertyTab.this.setLayoutDirection(WsPFDPropertyTab.LAYOUT_UP);
        }
    }

    protected class LayoutRightAction
    extends WsAbstractToggleAction {
        private static final long serialVersionUID = 1L;

        public LayoutRightAction() {
            super(bundle, "WsPFDPropertyTab.Action.LayoutRight", 256);
            this.setMenuSupportId("layoutright");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsPFDPropertyTab.this.setLayoutDirection(WsPFDPropertyTab.LAYOUT_RIGHT);
        }
    }

    protected class LayoutLeftAction
    extends WsAbstractToggleAction {
        private static final long serialVersionUID = 1L;

        public LayoutLeftAction() {
            super(bundle, "WsPFDPropertyTab.Action.LayoutLeft", 256);
            this.setMenuSupportId("layoutleft");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsPFDPropertyTab.this.setLayoutDirection(WsPFDPropertyTab.LAYOUT_LEFT);
        }
    }

    protected class LayoutAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public LayoutAction() {
            super(bundle, "WsPFDPropertyTab.Action.Layout", 257);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    protected class Zoom200Action
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public Zoom200Action() {
            super(bundle, "WsPFDPropertyTab.Action.Zoom200", 257);
            this.setMenuSupportId("zoom200");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsPFDPropertyTab.this.zoom(2.0);
        }
    }

    protected class Zoom100Action
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public Zoom100Action() {
            super(bundle, "WsPFDPropertyTab.Action.Zoom100", 257);
            this.setMenuSupportId("zoom100");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsPFDPropertyTab.this.zoom(1.0);
        }
    }

    protected class Zoom75Action
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public Zoom75Action() {
            super(bundle, "WsPFDPropertyTab.Action.Zoom75", 257);
            this.setMenuSupportId("zoom75");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsPFDPropertyTab.this.zoom(0.75);
        }
    }

    protected class Zoom50Action
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public Zoom50Action() {
            super(bundle, "WsPFDPropertyTab.Action.Zoom50", 257);
            this.setMenuSupportId("zoom50");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsPFDPropertyTab.this.zoom(0.5);
        }
    }

    protected class Zoom25Action
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public Zoom25Action() {
            super(bundle, "WsPFDPropertyTab.Action.Zoom25", 257);
            this.setMenuSupportId("zoom25");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsPFDPropertyTab.this.zoom(0.25);
        }
    }

    protected class ZoomToFitAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public ZoomToFitAction() {
            super(bundle, "WsPFDPropertyTab.Action.ZoomToFit", 257);
            this.setMenuSupportId("zoomtofit");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsPFDPropertyTab.this.zoomToFit();
        }
    }

    protected class ZoomCustomAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public ZoomCustomAction() {
            super(bundle, "WsPFDPropertyTab.Action.ZoomCustom", 257);
            this.setMenuSupportId("zoomcustom");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsPFDPropertyTab.this.showCustomZoomDialog();
        }
    }

    protected class ZoomInAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public ZoomInAction() {
            super(bundle, "WsPFDPropertyTab.Action.ZoomIn", 258);
            this.setMenuSupportId("zoomin");
            this.setHidable(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsPFDPropertyTab.this.zoomIn();
        }
    }

    protected class ZoomOutAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public ZoomOutAction() {
            super(bundle, "WsPFDPropertyTab.Action.ZoomOut", 258);
            this.setMenuSupportId("zoomout");
            this.setHidable(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsPFDPropertyTab.this.zoomOut();
        }
    }

    protected class ZoomAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public ZoomAction() {
            super(bundle, "WsPFDPropertyTab.Action.Zoom", 257);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

