/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.pfd;

import com.sas.graphics.components.pfd.PFDModel;
import com.sas.graphics.components.pfd.PFDModelEvent;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.util.layout.LayeredLayoutStrategy;
import com.sas.graphics.interfaces.LayoutStrategyInterface;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.visuals.pfd.WsPFDDefaultSelectionModel;
import com.sas.workspace.visuals.pfd.WsPFDModel;
import com.sas.workspace.visuals.pfd.WsPFDPrimitive;
import com.sas.workspace.visuals.pfd.WsPFDSelectionModel;
import java.awt.Dimension;
import java.awt.Point;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class WsPFDPanel
extends PFDView {
    private static final long serialVersionUID = 1L;
    private static final String uiClassID = "WsPFDPanelUI";
    public static final String LAYOUT_LEFT = "Left";
    public static final String LAYOUT_RIGHT = "Right";
    public static final String LAYOUT_DOWN = "Down";
    public static final String LAYOUT_UP = "Up";
    private String m_eLayoutDirection;
    private WsPopupMenuRequestListener m_lsnrPopupMenuRequest;
    private Action m_actDefault;
    private Action m_actDelete;
    private boolean m_bPopupMenuEnabled;
    private boolean m_bActive;
    private PFDPrimitive m_primActive;
    private boolean m_bEditable;
    private WsPFDModel m_mdlPFD;
    private WsPFDSelectionModel m_mdlSelection;

    public WsPFDPanel() {
        this(null);
    }

    public WsPFDPanel(WsPFDModel mdl) {
        super.setKeyboardEnabled(false);
        super.setPopupMenuEnabled(false);
        this.setModel(mdl == null ? this.createDefaultModel() : mdl);
        this.setPopupMenuEnabled(true);
        this.setPFDLayout(this.createDefaultLayoutStrategy(LAYOUT_DOWN));
        this.setLayoutDirection(LAYOUT_DOWN);
        this.setSelectionModel(this.createDefaultSelectionModel());
        this.setEditable(true);
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void updateUI() {
        if (!UIManager.getDefaults().containsKey(uiClassID)) {
            UIManager.put(uiClassID, "com.sas.workspace.visuals.pfd.WsPFDPanelUI");
        }
        this.setUI(UIManager.getUI((JComponent)((Object)this)));
    }

    protected WsPFDModel createDefaultModel() {
        return new WsPFDModel();
    }

    protected LayoutStrategyInterface createDefaultLayoutStrategy(String eLayoutDirection) {
        Dimension dimReferenceNode = this.m_mdlPFD.getReferenceNodeSize();
        LayeredLayoutStrategy lls = new LayeredLayoutStrategy();
        lls.setReferenceNodeSize(dimReferenceNode.width, dimReferenceNode.height);
        lls.setBetweenLayerSpace(10);
        lls.setWithinLayerSpace(10);
        lls.setNodePositionHonored(true);
        lls.setFlowDirection(eLayoutDirection);
        return lls;
    }

    protected WsPFDSelectionModel createDefaultSelectionModel() {
        return new WsPFDDefaultSelectionModel(this);
    }

    public void setModel(PFDModel mdl) {
        super.setModel(mdl);
        this.m_mdlPFD = mdl instanceof WsPFDModel ? (WsPFDModel)mdl : null;
    }

    public void modelChanged(PFDModelEvent ev) {
        if (ev.getType() == 1000) {
            this.setActivePrimitive(null);
            this.removeAllPrimitivesFromSelection();
            this.updateLayout();
        } else {
            super.modelChanged(ev);
        }
    }

    public void setPFDModel(WsPFDModel mdl) {
        this.setModel(mdl);
    }

    public WsPFDModel getPFDModel() {
        return this.m_mdlPFD;
    }

    public void setSelectionModel(WsPFDSelectionModel mdlSelection) {
        if (this.m_mdlSelection == mdlSelection) {
            return;
        }
        WsPFDSelectionModel mdlOldSelection = this.m_mdlSelection;
        if (this.m_mdlSelection != null) {
            this.m_mdlSelection.dispose();
        }
        this.m_mdlSelection = mdlSelection;
        this.firePropertyChange("SelectionModel", mdlOldSelection, mdlSelection);
    }

    public WsPFDSelectionModel getSelectionModel() {
        return this.m_mdlSelection;
    }

    public void setLayoutDirection(String eLayoutDirection) {
        if (this.m_eLayoutDirection == eLayoutDirection) {
            return;
        }
        if (eLayoutDirection != LAYOUT_UP && eLayoutDirection != LAYOUT_DOWN && eLayoutDirection != LAYOUT_RIGHT && eLayoutDirection != LAYOUT_LEFT) {
            throw new IllegalArgumentException("Illegal layout direction: " + eLayoutDirection);
        }
        this.m_eLayoutDirection = eLayoutDirection;
        LayeredLayoutStrategy lls = (LayeredLayoutStrategy)this.getPFDLayout();
        lls.setFlowDirection(eLayoutDirection);
        this.getModel().setFlowDirection(eLayoutDirection);
        this.updateLayout();
    }

    public String getLayoutDirection() {
        return this.m_eLayoutDirection;
    }

    public void updateLayout() {
        LayeredLayoutStrategy lls = (LayeredLayoutStrategy)this.getPFDLayout();
        Dimension dimReferenceNode = this.m_mdlPFD.getReferenceNodeSize();
        lls.setReferenceNodeSize(dimReferenceNode.width, dimReferenceNode.height);
        this.doPFDLayout(true);
    }

    public void setPopupMenuEnabled(boolean bEnabled) {
        this.m_bPopupMenuEnabled = bEnabled;
    }

    public boolean isPopupMenuEnabled() {
        return this.m_bPopupMenuEnabled;
    }

    public void setKeyboardEnabled(boolean bEnabled) {
        throw new UnsupportedOperationException("Keyboard should never be disabled");
    }

    public boolean isKeyboardEnabled() {
        return true;
    }

    public void setPopupMenuRequestListener(WsPopupMenuRequestListener lsnr) {
        this.m_lsnrPopupMenuRequest = lsnr;
    }

    public WsPopupMenuRequestListener getPopupMenuRequestListener() {
        return this.m_lsnrPopupMenuRequest;
    }

    public void setDefaultAction(Action actDefault) {
        this.m_actDefault = actDefault;
    }

    public Action getDefaultAction() {
        return this.m_actDefault;
    }

    public void setDeleteAction(Action actDelete) {
        this.m_actDelete = actDelete;
    }

    public Action getDeleteAction() {
        return this.m_actDelete;
    }

    public void setActive(boolean bActive) {
        if (this.m_bActive == bActive) {
            return;
        }
        this.m_bActive = bActive;
        if (this.m_primActive instanceof WsPFDPrimitive) {
            ((WsPFDPrimitive)this.m_primActive).setActive(this.m_bActive);
        }
    }

    public boolean isActive() {
        return this.m_bActive;
    }

    public void setActivePrimitive(PFDPrimitive primActive) {
        if (this.m_primActive instanceof WsPFDPrimitive) {
            ((WsPFDPrimitive)this.m_primActive).setActive(false);
        }
        this.m_primActive = primActive;
        if (this.m_primActive instanceof WsPFDPrimitive) {
            ((WsPFDPrimitive)this.m_primActive).setActive(this.m_bActive);
        }
    }

    public PFDPrimitive getActivePrimitive() {
        return this.m_primActive;
    }

    public void setEditable(boolean bEditable) {
        if (this.m_bEditable == bEditable) {
            return;
        }
        this.m_bEditable = bEditable;
        this.m_mdlPFD.setEditable(bEditable);
    }

    public boolean isEditable() {
        return this.m_bEditable;
    }

    public void addPrimitiveToSelection(PFDPrimitive prim) {
        this.m_mdlSelection.addPrimitive(prim);
    }

    public void removePrimitiveFromSelection(PFDPrimitive prim) {
        this.m_mdlSelection.removePrimitive(prim);
    }

    public void addPrimitivesToSelection(PFDPrimitive[] aPrimitives) {
        this.m_mdlSelection.addPrimitives(aPrimitives);
    }

    public void removePrimitivesFromSelection(PFDPrimitive[] aPrimitives) {
        this.m_mdlSelection.removePrimitives(aPrimitives);
    }

    public void removeAllPrimitivesFromSelection() {
        this.m_mdlSelection.removeAllPrimitives();
    }

    public int getSelectedPrimitivesCount() {
        return this.m_mdlSelection.getSelectionCount();
    }

    public void setPrimarySelectedPrimitive(PFDPrimitive prim) {
        this.m_mdlSelection.setPrimaryPrimitive(prim);
    }

    public PFDPrimitive getPrimarySelectedPrimitive() {
        return this.m_mdlSelection.getPrimaryPrimitive();
    }

    public boolean isPrimitiveSelected(PFDPrimitive prim) {
        return this.m_mdlSelection.isPrimitiveSelected(prim);
    }

    public boolean isDropValid(WsPFDPrimitive prim, Point ptEvent, List lObjects) {
        Point ptPrimitive = prim.getLocation();
        Point ptPrimitiveEvent = new Point(ptEvent.x - ptPrimitive.x, ptEvent.y - ptPrimitive.y);
        return prim.isDropValid(ptPrimitiveEvent, lObjects);
    }

    public boolean isDropValid(Point ptEvent, List lObjects) {
        return this.m_mdlPFD.isDropValid(ptEvent, lObjects);
    }

    public boolean drop(WsPFDPrimitive prim, Point ptEvent, List lObjects) {
        Point ptPrimitive = prim.getLocation();
        Point ptPrimitiveEvent = new Point(ptEvent.x - ptPrimitive.x, ptEvent.y - ptPrimitive.y);
        return prim.drop(ptPrimitiveEvent, lObjects);
    }

    protected boolean drop(Point ptEvent, List lObjects) {
        return this.m_mdlPFD.drop(ptEvent, lObjects);
    }
}

