/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.expression;

import com.sas.workspace.WAdminResource;
import com.sas.workspace.visuals.expression.Category;
import com.sas.workspace.visuals.expression.Function;
import com.sas.workspace.visuals.expression.FunctionsModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class FunctionsTreeModel
extends DefaultTreeModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(FunctionsTreeModel.class);

    public FunctionsTreeModel(FunctionsModel mdlFunctions) {
        this(mdlFunctions, true);
    }

    public FunctionsTreeModel(FunctionsModel mdlFunctions, boolean bAddAll) {
        super(new DefaultMutableTreeNode("ROOT"));
        this.initialize(mdlFunctions, bAddAll);
    }

    private void initialize(FunctionsModel mdlFunctions, boolean bAddAll) {
        DefaultMutableTreeNode nodeRoot = (DefaultMutableTreeNode)this.getRoot();
        Category[] aCategories = mdlFunctions.getCategories();
        for (int iCategory = 0; iCategory < aCategories.length; ++iCategory) {
            CategoryNode nodeCategory = new CategoryNode(aCategories[iCategory]);
            nodeRoot.add(nodeCategory);
            Function[] aFunctions = aCategories[iCategory].getFunctions();
            for (int iFunction = 0; iFunction < aFunctions.length; ++iFunction) {
                FunctionNode nodeFunction = new FunctionNode(aFunctions[iFunction]);
                nodeCategory.add(nodeFunction);
            }
        }
        if (!bAddAll) {
            return;
        }
        CategoryNode nodeAll = new CategoryNode(bundle.getString("FunctionsTreeModel.AllFunctions.txt"));
        nodeRoot.insert(nodeAll, 0);
        Function[] aFunctions = mdlFunctions.getAllFunctions();
        for (int iFunction = 0; iFunction < aFunctions.length; ++iFunction) {
            FunctionNode nodeFunction = new FunctionNode(aFunctions[iFunction]);
            nodeAll.add(nodeFunction);
        }
    }

    public Function getFunctionForPath(TreePath path) {
        Object last = path.getLastPathComponent();
        return last instanceof FunctionNode ? ((FunctionNode)last).getFunction() : null;
    }

    private static class FunctionNode
    extends DefaultMutableTreeNode {
        private Function m_function;

        public FunctionNode(Function function) {
            super(function.getDisplayName());
            this.m_function = function;
        }

        public Function getFunction() {
            return this.m_function;
        }
    }

    private static class CategoryNode
    extends DefaultMutableTreeNode {
        private Category m_category;

        public CategoryNode(String sDisplayName) {
            super(sDisplayName);
        }

        public CategoryNode(Category category) {
            super(category.getDisplayName());
            this.m_category = category;
        }

        public Category getCategory() {
            return this.m_category;
        }
    }
}

