/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.expression;

import com.sas.expressions.visuals.CustomTabInterface;
import com.sas.expressions.visuals.ExpressionBuilderInterface;
import com.sas.swing.visuals.FlatSplitPane;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.visuals.expression.AbstractFunctionsModel;
import com.sas.workspace.visuals.expression.BaseFunction;
import com.sas.workspace.visuals.expression.Category;
import com.sas.workspace.visuals.expression.ExpressionPanel;
import com.sas.workspace.visuals.expression.Function;
import com.sas.workspace.visuals.expression.FunctionsModel;
import com.sas.workspace.visuals.expression.FunctionsModelsUtilities;
import com.sas.workspace.visuals.expression.FunctionsTreeModel;
import com.sas.workspace.visuals.expression.PropertiesFunctionsModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class FunctionsTab
extends JPanel
implements CustomTabInterface {
    private static final WAdminResource bundle = WAdminResource.getBundle(FunctionsTab.class);
    private static final String DIVIDER_LOCATION_KEY = ".DividerLocation";
    private static final String TERADATA_HELP_FILE = "TeradataHelp.pdf";
    private static final String USER_DEFINED_HELP_FILE = "UserDefinedHelp";
    private static Icon FOLDER_ICON = bundle.getIcon("FunctionsTab.Folder.image");
    private static Icon FUNCTION_ICON = bundle.getIcon("FunctionsTab.Function.image");
    private FunctionsModel m_mdlFunctions;
    private FunctionsTreeModel m_mdlTree;
    private JTree m_treeFunctions;
    private JTextPane m_txtHelp;
    private JScrollPane m_scrHelp;
    private JSplitPane m_splt;
    private ExpressionPanel m_pnlExpression;
    private static String s_sHelpPath;
    private static String s_sPDFOpenCommand;
    private Function m_selectedFunction;

    public FunctionsTab() {
        this((FunctionsModel)null);
    }

    public FunctionsTab(FunctionsModel mdlFunctions) {
        this.m_mdlFunctions = mdlFunctions;
        if (this.m_mdlFunctions == null) {
            this.m_mdlFunctions = this.createDefaultFunctionsModel();
        }
        this.initialize();
    }

    private FunctionsModel createDefaultFunctionsModel() {
        long start = System.currentTimeMillis();
        PropertiesFunctionsModel mdl = new PropertiesFunctionsModel();
        mdl.load(new WAdminResource(ExpressionPanel.class, "Functions"), "SQL.");
        FunctionsModelsUtilities.getHelpFilesForAllFunctions((FunctionsModel)mdl, this.getHelpPath());
        Function[] allInitialFunctions = mdl.getAllFunctions();
        this.addAllTeradataFunctions(mdl);
        this.addExtraFunctions(mdl);
        this.addAllSQLFunctions(mdl, allInitialFunctions);
        this.addUserDefinedFunctions(mdl);
        long end = System.currentTimeMillis();
        Workspace.getDefaultLogger().debug("load model:" + (double)(end - start) / 1000.0);
        return mdl;
    }

    private void addAllTeradataFunctions(AbstractFunctionsModel mdlTarget) {
        String sTeradataFunctionsPath = System.getProperty("ExpressionPanelTeradataFunctionsPath");
        InputStream strmTeradataFunctions = null;
        try {
            strmTeradataFunctions = sTeradataFunctionsPath != null ? new FileInputStream(sTeradataFunctionsPath) : FunctionsTab.class.getResourceAsStream("TeradataFunctions.xml");
        }
        catch (FileNotFoundException ex) {
            Workspace.getDefaultLogger().warn((Object)"Error opening expression panel Teradata functions: ", ex);
        }
        AbstractFunctionsModel mdlTeradata = this.createModel(strmTeradataFunctions);
        if (mdlTeradata == null) {
            return;
        }
        this.addPushdownFunctions(mdlTeradata, mdlTarget);
        this.addTeradataFunctions(mdlTeradata, mdlTarget);
    }

    private void addAllSQLFunctions(AbstractFunctionsModel mdlTarget, Function[] allInitialFunctions) {
        InputStream strmSQLFunctions = FunctionsTab.class.getResourceAsStream("SQL_Functions.xml");
        AbstractFunctionsModel mdlSQL = this.createModel(strmSQLFunctions);
        if (mdlSQL == null) {
            return;
        }
        this.addSQLFunctions(mdlSQL, mdlTarget, allInitialFunctions);
    }

    private void addSQLFunctions(AbstractFunctionsModel mdlSource, AbstractFunctionsModel mdlTarget, Function[] allInitialFunctions) {
        Category[] sourceCategories = mdlSource.getCategories();
        for (int iCategory = 0; iCategory < sourceCategories.length; ++iCategory) {
            Category thisCategory = sourceCategories[iCategory];
            Category categoryTarget = mdlTarget.acquireCategory(thisCategory.getName(), thisCategory.getName());
            Function[] functions = thisCategory.getFunctions();
            for (int iFunction = 0; iFunction < functions.length; ++iFunction) {
                BaseFunction functionNew = null;
                Function thisFunction = functions[iFunction];
                if (thisFunction.getInsertString().length() == 0) {
                    Function pdFunction;
                    String sName = thisFunction.getName();
                    if ("AVG".equalsIgnoreCase(sName)) {
                        sName = "AVG(argument)";
                    } else if ("COUNT".equalsIgnoreCase(sName)) {
                        sName = "COUNT(argument)";
                    } else if ("SUBSTR".equalsIgnoreCase(sName)) {
                        sName = "SUBSTR \"Extract\"";
                    } else if ("ACOS".equalsIgnoreCase(sName)) {
                        sName = "ARCOS";
                    } else if ("ASIN".equalsIgnoreCase(sName)) {
                        sName = "ARSIN";
                    }
                    String extraDescription = "";
                    String thisDescription = thisFunction.getDescription();
                    if (thisDescription.length() != 0) {
                        extraDescription = "<br/><br/>" + thisDescription;
                    }
                    if ((pdFunction = this.findFunction(allInitialFunctions, sName)) == null) {
                        Workspace.getDefaultLogger().debug("No existing function found for " + thisFunction.getName());
                    } else {
                        functionNew = new BaseFunction(categoryTarget, pdFunction.getName(), thisFunction.getName() + " *", pdFunction.getDescription() + extraDescription, pdFunction.getToolTip(), pdFunction.getInsertString(), pdFunction.getHelpFileName());
                        if (!thisFunction.getName().equalsIgnoreCase(thisFunction.getDisplayName())) {
                            BaseFunction secondFunc = null;
                            secondFunc = new BaseFunction(categoryTarget, thisFunction.getDisplayName(), thisFunction.getDisplayName() + " *", pdFunction.getDescription() + extraDescription, pdFunction.getToolTip(), pdFunction.getInsertString(), pdFunction.getHelpFileName());
                            categoryTarget.addFunction(secondFunc);
                        }
                    }
                } else {
                    functionNew = new BaseFunction(categoryTarget, thisFunction.getName(), thisFunction.getDisplayName(), thisFunction.getDescription(), thisFunction.getToolTip(), thisFunction.getInsertString(), null, thisFunction.getHelpPageRange());
                }
                if (functionNew == null) continue;
                categoryTarget.addFunction(functionNew);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractFunctionsModel createModel(InputStream inStream) {
        PropertiesFunctionsModel mdlFunctions = new PropertiesFunctionsModel();
        try {
            mdlFunctions.loadXML(inStream);
            PropertiesFunctionsModel propertiesFunctionsModel = mdlFunctions;
            return propertiesFunctionsModel;
        }
        catch (IOException ex) {
            Workspace.getDefaultLogger().warn((Object)"Error reading expression panel Teradata functions: ", ex);
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException ex) {
                Workspace.getDefaultLogger().error(ex);
            }
        }
        return null;
    }

    private void addTeradataFunctions(AbstractFunctionsModel mdlTeradata, AbstractFunctionsModel mdlTarget) {
        Category categoryTeradata = mdlTeradata.findCategory("Teradata");
        if (categoryTeradata == null) {
            return;
        }
        Function[] aTeradataFunctions = categoryTeradata.getFunctions();
        if (aTeradataFunctions.length == 0) {
            return;
        }
        Category categoryTarget = mdlTarget.acquireCategory("Teradata", "Teradata");
        for (int iFunction = 0; iFunction < aTeradataFunctions.length; ++iFunction) {
            String description = aTeradataFunctions[iFunction].getDescription();
            if (description == null || description.length() == 0) {
                description = aTeradataFunctions[iFunction].getInsertString();
            }
            BaseFunction functionNew = new BaseFunction(categoryTarget, aTeradataFunctions[iFunction].getName(), aTeradataFunctions[iFunction].getName(), description, aTeradataFunctions[iFunction].getToolTip(), aTeradataFunctions[iFunction].getInsertString(), TERADATA_HELP_FILE, aTeradataFunctions[iFunction].getHelpPageRange());
            categoryTarget.addFunction(functionNew);
        }
    }

    private void addPushdownFunctions(AbstractFunctionsModel mdlTeradata, AbstractFunctionsModel mdlTarget) {
        Category categoryTeradata = mdlTeradata.findCategory("Pushdown");
        if (categoryTeradata == null) {
            return;
        }
        Function[] aPushdownFunctions = categoryTeradata.getFunctions();
        if (aPushdownFunctions.length == 0) {
            return;
        }
        Category categoryTarget = mdlTarget.acquireCategory("Teradata", "Teradata");
        Function[] aAllFunctions = mdlTarget.getAllFunctions();
        for (int iFunction = 0; iFunction < aPushdownFunctions.length; ++iFunction) {
            String sName = aPushdownFunctions[iFunction].getName();
            if ("AVG".equalsIgnoreCase(sName)) {
                sName = "AVG(argument)";
            } else if ("COUNT".equalsIgnoreCase(sName)) {
                sName = "COUNT(argument)";
            } else if ("SUBSTR".equalsIgnoreCase(sName)) {
                sName = "SUBSTR \"Extract\"";
            } else if ("ACOS".equalsIgnoreCase(sName)) {
                sName = "ARCOS";
            } else if ("ASIN".equalsIgnoreCase(sName)) {
                sName = "ARSIN";
            }
            Function function = this.findFunction(aAllFunctions, sName);
            if (function == null) {
                Workspace.getDefaultLogger().debug("No existing function found for " + aPushdownFunctions[iFunction].getName());
                continue;
            }
            BaseFunction functionNew = new BaseFunction(categoryTarget, function.getName(), aPushdownFunctions[iFunction].getName() + " *", function.getDescription(), function.getToolTip(), function.getInsertString(), function.getHelpFileName());
            categoryTarget.addFunction(functionNew);
        }
    }

    private Function findFunction(Function[] aFunctions, String sDisplayName) {
        for (int iFunction = 0; iFunction < aFunctions.length; ++iFunction) {
            if (!aFunctions[iFunction].getDisplayName().equals(sDisplayName)) continue;
            return aFunctions[iFunction];
        }
        return null;
    }

    private void addExtraFunctions(AbstractFunctionsModel mdl) {
        String sExtraFunctions = System.getProperty("ExpressionPanelAdditionalFunctionsPath");
        if (sExtraFunctions != null) {
            try {
                this.loadFunctionsFromPathOrFile(mdl, sExtraFunctions);
            }
            catch (FileNotFoundException ex) {
                Workspace.getDefaultLogger().warn("Invalid path specified for additional expression panel functions: " + ex.getLocalizedMessage());
            }
        }
    }

    private void loadFunctionsFromPathOrFile(AbstractFunctionsModel mdl, String sExtraFunctions) throws FileNotFoundException {
        File f = new File(sExtraFunctions);
        if (f.isFile()) {
            this.loadFunctionsFromFile(mdl, sExtraFunctions, "Error reading additional expression panel functions:");
        } else if (f.isDirectory()) {
            String[] contents = f.list(new FileExtensionFilter(".xml"));
            for (int i = 0; i < contents.length; ++i) {
                this.loadFunctionsFromFile(mdl, sExtraFunctions + "\\" + contents[i], "Error reading additional expression panel functions:");
            }
        }
    }

    private void loadFunctionsFromFile(AbstractFunctionsModel mdl, String sExtraFunctions, String errorMessage) throws FileNotFoundException {
        FileInputStream strmExtra = new FileInputStream(sExtraFunctions);
        try {
            mdl.loadXML(strmExtra);
        }
        catch (IOException ex) {
            Workspace.getDefaultLogger().warn(errorMessage + ex.getLocalizedMessage());
        }
    }

    private void addUserDefinedFunctions(AbstractFunctionsModel mdl) {
        String sUDFunctionsFileName = System.getProperty("UserDefinedFunctionsPath");
        if (sUDFunctionsFileName == null) {
            sUDFunctionsFileName = Workspace.getAppDataFilePath("UserDefinedFunctions.xml");
        }
        if (sUDFunctionsFileName != null) {
            try {
                this.loadFunctionsFromPathOrFile(mdl, sUDFunctionsFileName);
            }
            catch (FileNotFoundException ex) {
                Workspace.getDefaultLogger().warn("Invalid path specified for additional expression panel functions: " + ex.getLocalizedMessage());
            }
        }
    }

    private void initialize() {
        this.m_mdlTree = new FunctionsTreeModel(this.m_mdlFunctions);
        this.m_treeFunctions = new JTree(this.m_mdlTree);
        this.m_treeFunctions.setScrollsOnExpand(true);
        this.m_treeFunctions.setRootVisible(false);
        this.m_treeFunctions.setShowsRootHandles(false);
        this.m_treeFunctions.getSelectionModel().addTreeSelectionListener(new FunctionSelectionListener());
        this.m_treeFunctions.getSelectionModel().setSelectionMode(1);
        this.m_treeFunctions.addMouseListener(new FunctionsTreeMouseListener());
        this.m_treeFunctions.setCellRenderer(new FunctionTreeCellRenderer());
        JScrollPane scrFunctions = new JScrollPane(this.m_treeFunctions);
        Border brdrInner = scrFunctions.getBorder();
        Border brdrOuter = BorderFactory.createEmptyBorder(0, 0, 0, 5);
        scrFunctions.setBorder(BorderFactory.createCompoundBorder(brdrOuter, brdrInner));
        this.m_txtHelp = new JTextPane();
        this.m_txtHelp.setEditable(false);
        this.m_txtHelp.setEditorKit(new HTMLEditorKit());
        this.m_txtHelp.addHyperlinkListener(new HelpHyperlinkListener());
        this.m_scrHelp = new JScrollPane(this.m_txtHelp);
        brdrInner = this.m_scrHelp.getBorder();
        brdrOuter = BorderFactory.createEmptyBorder(0, 6, 0, 0);
        this.m_scrHelp.setBorder(BorderFactory.createCompoundBorder(brdrOuter, brdrInner));
        FlatSplitPane spltTemp = new FlatSplitPane(1);
        this.m_splt = spltTemp.getSplitter();
        this.m_splt.setContinuousLayout(true);
        this.m_splt.setLeftComponent(scrFunctions);
        this.m_splt.setRightComponent(this.m_scrHelp);
        this.m_splt.setDividerSize(3);
        this.m_splt.setResizeWeight(0.5);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_splt, "Center");
        scrFunctions.setPreferredSize(new Dimension(67, scrFunctions.getPreferredSize().height));
        this.m_scrHelp.setPreferredSize(new Dimension(123, this.m_scrHelp.getPreferredSize().height));
    }

    private void setSelectedFunction(Function function) {
        if (function == this.m_selectedFunction) {
            return;
        }
        this.m_selectedFunction = function;
        this.m_pnlExpression.insertExpressionTextChanged();
        if (this.m_selectedFunction != null) {
            this.showHelpFor(this.m_selectedFunction);
        }
    }

    private Function getSelectedFunction() {
        return this.m_selectedFunction;
    }

    public JSplitPane getSplitPane() {
        return this.m_splt;
    }

    public void restoreSettings(String settingsKeyPrefix, WorkspaceFile appDefaults) {
        this.m_splt.setDividerLocation(appDefaults.getPropertyInt(settingsKeyPrefix + DIVIDER_LOCATION_KEY, -1));
    }

    public void saveSettings(String settingsKeyPrefix, WorkspaceFile appDefaults) {
        appDefaults.setPropertyInt(settingsKeyPrefix + DIVIDER_LOCATION_KEY, this.m_splt.getDividerLocation());
    }

    public boolean isInsertButtonEnabled() {
        return this.getSelectedFunction() != null;
    }

    public void setExpressionBuilder(ExpressionBuilderInterface component) {
        this.m_pnlExpression = (ExpressionPanel)component;
    }

    public String getInsertText() {
        this.insertFunction(this.getSelectedFunction());
        return "";
    }

    public void insertTextChanged() {
    }

    private void insertFunction(Function function) {
        if (function == null) {
            return;
        }
        String sInsert = function.getInsertString();
        int iInsert = this.m_pnlExpression.getInsertPosition();
        int iArgumentStart = sInsert.indexOf(60);
        int iArgumentEnd = iArgumentStart > 0 ? sInsert.indexOf(62, iArgumentStart) : -1;
        this.m_pnlExpression.insertExpressionText(sInsert);
        if (iArgumentStart > 0 && iArgumentEnd > iArgumentStart) {
            SwingUtilities.invokeLater(new SelectExpressionTextRunnable(iInsert + iArgumentStart, iInsert + iArgumentEnd + 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showHelpFor(Function function) {
        this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
        try {
            String sHelpFileName = function.getHelpFileName();
            if (sHelpFileName == null) {
                this.generateHelpFor(function);
            } else if (USER_DEFINED_HELP_FILE.equals(sHelpFileName)) {
                this.generateHelpFor(function);
            } else if (TERADATA_HELP_FILE.equals(sHelpFileName)) {
                this.generateHelpFor(function);
            } else {
                URL urlHelp = sHelpFileName.startsWith("#") ? new File(this.getHelpPath() + sHelpFileName.substring(1)).toURL() : new File(sHelpFileName).toURL();
                Workspace.getDefaultLogger().debug(urlHelp);
                this.m_txtHelp.setPage(urlHelp);
            }
        }
        catch (MalformedURLException ex) {
            Workspace.getDefaultLogger().error((Object)"", ex);
            this.generateHelpFor(function);
        }
        catch (IOException ex) {
            Workspace.getDefaultLogger().error((Object)"", ex);
            this.generateHelpFor(function);
        }
        finally {
            this.getTopLevelAncestor().setCursor(Cursor.getDefaultCursor());
        }
    }

    private String getHelpPath() {
        if (s_sHelpPath != null) {
            return s_sHelpPath;
        }
        String sFileSeparator = System.getProperty("file.separator");
        StringBuffer sbPath = new StringBuffer(256);
        String sOptionPath = System.getProperty("ExpressionPanelHelpPath");
        if (sOptionPath == null) {
            sbPath.append(System.getProperty("user.dir"));
            sbPath.append(sFileSeparator);
            sbPath.append("html");
            sbPath.append(sFileSeparator);
            sbPath.append("ExpressionPanelHelp");
        } else {
            sbPath.append(sOptionPath);
        }
        sbPath.append(sFileSeparator);
        int lPath = sbPath.length();
        sbPath.append(Locale.getDefault().getLanguage());
        if (!new File(sbPath.toString()).isDirectory()) {
            Workspace.getDefaultLogger().warn("Help directory for " + Locale.getDefault().getDisplayLanguage() + " not found: " + sbPath.toString());
            sbPath.replace(lPath, sbPath.length(), "en");
            if (!new File(sbPath.toString()).isDirectory()) {
                Workspace.getDefaultLogger().warn("Help directory for English not found: " + sbPath.toString());
            }
        }
        sbPath.append(sFileSeparator);
        s_sHelpPath = sbPath.toString();
        return s_sHelpPath;
    }

    private void generateHelpFor(Function function) {
        StringBuffer sbHelp = new StringBuffer();
        sbHelp.append("<html>");
        sbHelp.append("<head>");
        sbHelp.append("<meta http-equiv=\"Content-Type\" content=\"text/html\">");
        sbHelp.append(bundle.getString("FunctionsTab.GeneratedHelp.Style.lcl"));
        sbHelp.append("<title>");
        sbHelp.append(function.getDisplayName());
        sbHelp.append("</title>");
        sbHelp.append("</head>");
        sbHelp.append("<body>");
        sbHelp.append("<h1 style='margin-top:0in;margin-right:0in;margin-bottom:3.0pt;margin-left:0in;page-break-after:avoid;tab-stops:.25in .5in .75in'>");
        sbHelp.append("<b><span style='mso-bidi-font-family:Arial;mso-font-kerning:16.0pt'>");
        sbHelp.append(function.getDisplayName());
        sbHelp.append("<o:p></o:p></span></b></h1>");
        sbHelp.append("<p class=MsoNormal style='tab-stops:.25in .5in .75in'><span style='mso-bidi-font-family:Arial'>");
        sbHelp.append(function.getDescription());
        sbHelp.append("<o:p></o:p></span></p>");
        sbHelp.append("<h2 style='margin-top:12.0pt;margin-right:0in;margin-bottom:3.0pt;margin-left:");
        sbHelp.append(".25in;page-break-after:avoid;tab-stops:.25in .5in .75in'><b><span");
        sbHelp.append("style='mso-bidi-font-family:Arial'>").append(bundle.getString("FunctionsTab.GeneratedHelp.Category.txt")).append("<o:p></o:p></span></b></h2>");
        sbHelp.append("<p class=MsoNormal style='margin-top:0in;margin-right:0in;margin-bottom:6.0pt;");
        sbHelp.append("   margin-left:.25in;tab-stops:.25in .5in .75in'><span style='mso-bidi-font-family:");
        sbHelp.append("   Arial'>");
        sbHelp.append(function.getCategory().getDisplayName());
        sbHelp.append("<o:p></o:p></span></p>");
        sbHelp.append("<h2 style='margin-top:12.0pt;margin-right:0in;margin-bottom:3.0pt;margin-left:");
        sbHelp.append(".25in;page-break-after:avoid;tab-stops:.25in .5in .75in'><b><span");
        sbHelp.append("style='mso-bidi-font-family:Arial'>").append(bundle.getString("FunctionsTab.GeneratedHelp.Syntax.txt")).append("<o:p></o:p></span></b></h2>");
        sbHelp.append("<p class=MsoNormal style='margin-top:0in;margin-right:0in;margin-bottom:6.0pt;");
        sbHelp.append("   margin-left:.25in;tab-stops:.25in .5in .75in'><span style='mso-bidi-font-family:");
        sbHelp.append("   Arial'>");
        String sInsert = function.getInsertString();
        if ("Aggregate".equals(function.getCategoryName())) {
            sInsert = function.getToolTip();
        }
        block7: for (int iInsert = 0; iInsert < sInsert.length(); ++iInsert) {
            char c = sInsert.charAt(iInsert);
            switch (c) {
                case '<': {
                    sbHelp.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sbHelp.append("&gt;");
                    continue block7;
                }
                default: {
                    sbHelp.append(c);
                }
            }
        }
        sbHelp.append("   <o:p></o:p></span></p>");
        if ("Teradata".equals(function.getCategoryName()) && ((BaseFunction)function).getHelpPageRange() != null) {
            String s = bundle.formatString("FunctionsTab.GeneratedHelp.SeeIn.fmt.txt", function.getDisplayName(), bundle.getString("FunctionsTab.GeneratedHelp.Document.lcl"), new Integer(((BaseFunction)function).getHelpPageRange()[0]));
            sbHelp.append(s);
        }
        sbHelp.append("</body>");
        sbHelp.append("</html>");
        StringReader strm = new StringReader(sbHelp.toString());
        try {
            this.m_txtHelp.setText("");
            this.m_txtHelp.setContentType("text/html");
            this.m_txtHelp.getDocument().putProperty("stream", null);
            this.m_txtHelp.getEditorKit().read(strm, this.m_txtHelp.getDocument(), 0);
            this.m_txtHelp.setCaretPosition(0);
        }
        catch (IOException ex) {
            Workspace.getDefaultLogger().error((Object)"", ex);
        }
        catch (BadLocationException ex) {
            Workspace.getDefaultLogger().error((Object)"", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private String getPDFOpenCommand() {
        if (s_sPDFOpenCommand != null) {
            return s_sPDFOpenCommand.length() != 0 ? s_sPDFOpenCommand : null;
        }
        s_sPDFOpenCommand = "";
        String sTempDir = System.getProperty("java.io.tmpdir");
        String sPDFOpenWithListFileName = sTempDir + "PDFOpenWithList.txt";
        String sCommand = "regedit /e " + sPDFOpenWithListFileName + " HKEY_CLASSES_ROOT\\.pdf\\OpenWithList";
        Workspace.getDefaultLogger().debug("Get PDF Open With List Command: " + sCommand);
        try {
            Process p = Runtime.getRuntime().exec(sCommand);
            p.waitFor();
            StringBuffer sb = this.readFile(sPDFOpenWithListFileName);
            try {
                int iPDFOpenCommandEnd;
                int iPDFOpenCommandStart;
                String sPDFOpenCommandFileName;
                block20: {
                    String string;
                    String sOpenCommandKey;
                    block19: {
                        String sOpenApplicationKey = "[HKEY_CLASSES_ROOT\\.pdf\\OpenWithList\\";
                        int iOpenApplicationStart = sb.indexOf(sOpenApplicationKey);
                        if (iOpenApplicationStart < 0) {
                            String string2 = null;
                            return string2;
                        }
                        int iOpenApplicationEnd = sb.indexOf("]", iOpenApplicationStart);
                        if (iOpenApplicationEnd < 0) {
                            String string3 = null;
                            return string3;
                        }
                        String sOpenApplication = sb.substring(iOpenApplicationStart + sOpenApplicationKey.length(), iOpenApplicationEnd);
                        Workspace.getDefaultLogger().debug("PDF Open Application Name: " + sOpenApplication);
                        sOpenCommandKey = "HKEY_CLASSES_ROOT\\Applications\\" + sOpenApplication + "\\shell\\Read\\command";
                        sPDFOpenCommandFileName = sTempDir + "PDFOpenWithExecutable.txt";
                        sCommand = "regedit /e " + sPDFOpenCommandFileName + " " + sOpenCommandKey;
                        Workspace.getDefaultLogger().debug("Get PDF Open Command Command: " + sCommand);
                        p = Runtime.getRuntime().exec(sCommand);
                        p.waitFor();
                        sb = this.readFile(sPDFOpenCommandFileName);
                        iPDFOpenCommandStart = sb.indexOf(sOpenCommandKey);
                        if (iPDFOpenCommandStart >= 0) break block19;
                        String string4 = null;
                        new File(sPDFOpenCommandFileName).delete();
                        return string4;
                    }
                    try {
                        int iDoubleBackSlash = sb.indexOf("\\\\", iPDFOpenCommandStart += sOpenCommandKey.length() + "]\n@=\"\\".length());
                        while (iDoubleBackSlash > 1) {
                            sb.replace(iDoubleBackSlash, iDoubleBackSlash + 2, "\\");
                            iDoubleBackSlash = sb.indexOf("\\\\", iDoubleBackSlash + 1);
                        }
                        iPDFOpenCommandEnd = sb.indexOf("\\\"", iPDFOpenCommandStart);
                        if (iPDFOpenCommandEnd >= 0) break block20;
                        string = null;
                        new File(sPDFOpenCommandFileName).delete();
                    }
                    catch (Throwable throwable) {
                        new File(sPDFOpenCommandFileName).delete();
                        throw throwable;
                    }
                    return string;
                }
                String string = s_sPDFOpenCommand = sb.substring(iPDFOpenCommandStart, iPDFOpenCommandEnd) + "\"";
                new File(sPDFOpenCommandFileName).delete();
                return string;
            }
            finally {
                new File(sPDFOpenWithListFileName).delete();
            }
        }
        catch (IOException ex) {
            Workspace.getDefaultLogger().warn(ex);
        }
        catch (InterruptedException ex) {
            Workspace.getDefaultLogger().warn(ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer readFile(String sFileName) throws IOException {
        FileInputStream strm = new FileInputStream(sFileName);
        InputStreamReader rdr0 = new InputStreamReader((InputStream)strm, "Unicode");
        try (BufferedReader rdr = new BufferedReader(rdr0);){
            StringBuffer sb = new StringBuffer(8192);
            String s = rdr.readLine();
            while (s != null) {
                sb.append(s).append('\n');
                s = rdr.readLine();
            }
            StringBuffer stringBuffer = sb;
            return stringBuffer;
        }
    }

    public class FileExtensionFilter
    implements FilenameFilter {
        private String ext = "*";

        public FileExtensionFilter(String ext) {
            this.ext = ext;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(this.ext);
        }
    }

    private class SelectExpressionTextRunnable
    implements Runnable {
        private int m_iStart;
        private int m_iEnd;

        public SelectExpressionTextRunnable(int iStart, int iEnd) {
            this.m_iStart = iStart;
            this.m_iEnd = iEnd;
        }

        @Override
        public void run() {
            FunctionsTab.this.m_pnlExpression.selectExpressionText(this.m_iStart, this.m_iEnd);
        }
    }

    private class HelpHyperlinkListener
    implements HyperlinkListener {
        private HelpHyperlinkListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent ev) {
            if (ev.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                URL url = ev.getURL();
                String sDescription = ev.getDescription();
                if (sDescription.startsWith("Teradata#")) {
                    String sPDFOpenCommand;
                    String sOptions = sDescription.substring(9) + "&pagemode=none&toolbar=0&navpanes=0&zoom=100";
                    String sTeradataHelpPath = System.getProperty("ExpressionPanelTeradataHelpPath");
                    if (sTeradataHelpPath == null) {
                        sTeradataHelpPath = FunctionsTab.this.getHelpPath() + FunctionsTab.TERADATA_HELP_FILE;
                    }
                    String sCommand = (sPDFOpenCommand = FunctionsTab.this.getPDFOpenCommand()) != null ? sPDFOpenCommand + " /A \"" + sOptions + "\" \"" + sTeradataHelpPath + "\"" : "explorer.exe \"file://" + sTeradataHelpPath + "#" + sOptions + "\"";
                    Workspace.getDefaultLogger().debug("Command to show Teradata help: " + sCommand);
                    try {
                        Runtime.getRuntime().exec(sCommand);
                    }
                    catch (IOException ex) {
                        Workspace.getDefaultLogger().error(ex.getLocalizedMessage());
                    }
                } else if (url.toString().startsWith("http:")) {
                    try {
                        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url.toString());
                    }
                    catch (IOException ex) {
                        Workspace.getDefaultLogger().error(ex.getLocalizedMessage());
                    }
                } else {
                    try {
                        FunctionsTab.this.m_txtHelp.setPage(url);
                    }
                    catch (IOException ex) {
                        Workspace.getDefaultLogger().error((Object)"", ex);
                        FunctionsTab.this.m_txtHelp.setText("<b>Help not found: </b> " + ev.getURL());
                    }
                }
            }
        }
    }

    private class FunctionsTreeMouseListener
    extends MouseAdapter {
        private FunctionsTreeMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            Function function;
            TreePath path;
            if (ev.getClickCount() == 2 && ev.getButton() == 1 && (path = FunctionsTab.this.m_treeFunctions.getPathForLocation(ev.getX(), ev.getY())) != null && FunctionsTab.this.m_treeFunctions.isPathSelected(path) && (function = FunctionsTab.this.m_mdlTree.getFunctionForPath(path)) != null) {
                FunctionsTab.this.insertFunction(function);
            }
        }
    }

    private class FunctionSelectionListener
    implements TreeSelectionListener {
        private FunctionSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent ev) {
            FunctionsTab.this.setSelectedFunction(FunctionsTab.this.m_mdlTree.getFunctionForPath(ev.getPath()));
        }
    }

    private static class FunctionTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private FunctionTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object node, boolean bSelected, boolean bExpanded, boolean bLeaf, int iRow, boolean bHasFocus) {
            JLabel lbl = (JLabel)super.getTreeCellRendererComponent(tree, node, bSelected, bExpanded, bLeaf, iRow, bHasFocus);
            lbl.setIcon(bLeaf ? FUNCTION_ICON : FOLDER_ICON);
            return lbl;
        }
    }
}

