/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.expression;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.expression.BaseFunction;
import com.sas.workspace.visuals.expression.Category;
import com.sas.workspace.visuals.expression.Function;
import com.sas.workspace.visuals.expression.FunctionsModel;
import com.sas.workspace.visuals.expression.FunctionsTab;
import com.sas.workspace.visuals.expression.PropertiesFunctionsModel;
import com.sas.workspace.visuals.expression.ServerPropertiesFunctionsModel;
import com.sas.workspace.visuals.expression.XMLFunctionsModel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class FunctionsModelsUtilities {
    private static final String BLANKS = "                                        ";
    private static final String PAD = "   ";
    private static final String LRDICT_HELP_DIR = "lrdict.hlp";
    private static final String NLSREF_HELP_DIR = "nlsref.hlp";
    private static final String DQCLREF_HELP_DIR = "dqclref.hlp";
    private static final String COMMON_HELP_DIR = "common.hlp";
    private static final String IMAGES_DIR = "/images";
    private static final String STYLESHEET_DIR = "/ss";
    private static final String[] s_aLanguages = new String[]{"en"};
    private static final String[] s_aHelpDirectories = new String[]{"common.hlp", "lrdict.hlp", "nlsref.hlp", "dqclref.hlp"};
    private static final String[] s_aHelpImageDirectories = new String[]{"common.hlp/images", "lrdict.hlp/images", "nlsref.hlp/images", "dqclref.hlp/images"};
    private static final String[] s_aHelpStyleSheetDirectories = new String[]{"common.hlp/ss"};
    private static final String TOP_NAVIGATION = "<!-- top navigation -->";
    private static final String START_INDEX = "<!-- startindex -->";
    private static final String BOTTOM_NAVIGATION = "<!-- bottom navigation -->";
    private static final String COPYRIGHT = "<p class=\"copyright\">";
    private static final String ANCHOR_START = "<a href=\"";
    private static final String ANCHOR_START2 = "<A href=\"";
    private static final String ANCHOR_HREF_END = "\"";
    private static final String ANCHOR_START_END = ">";
    private static final String ANCHOR_END = "</a>";
    private static final String ANCHOR_END2 = "</A>";
    private static final String LOCAL_HELP_IMAGES = "./images/";
    private static final String IMAGE_START = "<img";
    private static final String IMAGE_END = ">";
    private static final String IMAGE_SOURCE_START = "src=\"";
    private static final String IMAGE_SOURCE_END = "\"";
    private static final String START_BOLD_UNDERLINE = "<b><u>";
    private static final String END_BOLD_UNDERLINE = "</b></u>";
    private static List lHelpFilesProcessed;
    private static List lHelpFilesToProcess;
    private static List lImageFiles;

    private FunctionsModelsUtilities() {
    }

    public static void main(String[] aArguments) {
        if (aArguments.length == 0) {
            System.out.println("No operation specified");
            return;
        }
        if ("ConvertTo421".equalsIgnoreCase(aArguments[0])) {
            if (aArguments.length != 4) {
                System.out.println("ConvertTo421 requires exactly three arguments: target XML file name, source help directory, target help directory");
                return;
            }
            FunctionsModelsUtilities.convertTo421(aArguments[1], aArguments[2], aArguments[3]);
        } else if ("CleanHelp".equalsIgnoreCase(aArguments[0])) {
            if (aArguments.length != 3) {
                System.out.println("CleanHelp requires exactly two arguments: source help file name and the target help file name");
                return;
            }
            lHelpFilesToProcess = new ArrayList();
            lHelpFilesProcessed = new ArrayList();
            lImageFiles = new ArrayList();
            FunctionsModelsUtilities.cleanHelp(aArguments[1], aArguments[2]);
            for (int iHelpFile = 0; iHelpFile < lHelpFilesToProcess.size(); ++iHelpFile) {
                System.out.println("help files=" + lHelpFilesToProcess.get(iHelpFile));
            }
            for (int iImageFile = 0; iImageFile < lImageFiles.size(); ++iImageFile) {
                System.out.println("image files=" + lImageFiles.get(iImageFile));
            }
        } else if ("Print".equalsIgnoreCase(aArguments[0])) {
            if (aArguments.length != 2) {
                System.out.println("Print requires one argument: [DIS][EG][IMS]");
                return;
            }
            FunctionsModel mdl = FunctionsModelsUtilities.loadModel(aArguments[1]);
            if (mdl == null) {
                System.out.println("Unrecognized DIS Model.  Should be DIS, EG, or IMS.  Was " + aArguments[1]);
                return;
            }
            System.out.println("----------" + aArguments[1] + "----------");
            FunctionsModelsUtilities.printModel(System.out, mdl);
        } else {
            System.out.println("Command not recognized: " + aArguments[0]);
        }
    }

    private static FunctionsModel loadModel(String sModelType) {
        if ("DIS".equalsIgnoreCase(sModelType)) {
            PropertiesFunctionsModel mdlDIS = new PropertiesFunctionsModel();
            mdlDIS.load(new WAdminResource(FunctionsTab.class, "Functions"), "SQL.");
            return mdlDIS;
        }
        if ("EG".equalsIgnoreCase(sModelType)) {
            XMLFunctionsModel mdlEG = new XMLFunctionsModel();
            try {
                mdlEG.load(FunctionsTab.class.getResource("SASEXPFUNC.xml").getPath());
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return mdlEG;
        }
        if ("IMS".equalsIgnoreCase(sModelType)) {
            ServerProperties[] aServerProperties = FunctionsModelsUtilities.loadServerProperties();
            ServerProperties sp = FunctionsModelsUtilities.findServerProperties(aServerProperties, "saswks91");
            ServerPropertiesFunctionsModel mdlIMS = new ServerPropertiesFunctionsModel();
            mdlIMS.load(sp);
            return mdlIMS;
        }
        return null;
    }

    private static boolean assertDirectory(String sDirectory) {
        boolean rc = new File(sDirectory).isDirectory();
        if (!rc) {
            System.out.println("Missing source directory: " + sDirectory);
        }
        return rc;
    }

    private static boolean createDirectory(String sDirectory) {
        File dir = new File(sDirectory);
        if (dir.isDirectory()) {
            return true;
        }
        return dir.mkdir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void convertTo421(String sTargetXMLFileName, String sSourceHelpDirectory, String sTargetHelpDirectory) {
        int iHelpStyleSheetDirectory;
        int iHelpImageDirectory;
        int iHelpDirectory;
        String sLanguageDirectory;
        int iLanguage;
        boolean bPunt = !FunctionsModelsUtilities.assertDirectory(sSourceHelpDirectory);
        for (iLanguage = 0; iLanguage < s_aLanguages.length; ++iLanguage) {
            sLanguageDirectory = sSourceHelpDirectory + "/" + s_aLanguages[iLanguage];
            bPunt |= !FunctionsModelsUtilities.assertDirectory(sLanguageDirectory);
            sLanguageDirectory = sLanguageDirectory + "/";
            for (iHelpDirectory = 0; iHelpDirectory < s_aHelpDirectories.length; ++iHelpDirectory) {
                bPunt |= !FunctionsModelsUtilities.assertDirectory(sLanguageDirectory + s_aHelpDirectories[iHelpDirectory]);
            }
            for (iHelpImageDirectory = 0; iHelpImageDirectory < s_aHelpImageDirectories.length; ++iHelpImageDirectory) {
                bPunt |= !FunctionsModelsUtilities.assertDirectory(sLanguageDirectory + s_aHelpImageDirectories[iHelpImageDirectory]);
            }
            for (iHelpStyleSheetDirectory = 0; iHelpStyleSheetDirectory < s_aHelpStyleSheetDirectories.length; ++iHelpStyleSheetDirectory) {
                bPunt |= !FunctionsModelsUtilities.assertDirectory(sLanguageDirectory + s_aHelpStyleSheetDirectories[iHelpStyleSheetDirectory]);
            }
        }
        if (bPunt) {
            System.out.println("Incorrect source help directory structure: " + sSourceHelpDirectory);
            return;
        }
        bPunt = !FunctionsModelsUtilities.createDirectory(sTargetHelpDirectory);
        for (iLanguage = 0; iLanguage < s_aLanguages.length; ++iLanguage) {
            sLanguageDirectory = sTargetHelpDirectory + "\\" + s_aLanguages[iLanguage];
            bPunt |= !FunctionsModelsUtilities.createDirectory(sLanguageDirectory);
            sLanguageDirectory = sLanguageDirectory + "/";
            for (iHelpDirectory = 0; iHelpDirectory < s_aHelpDirectories.length; ++iHelpDirectory) {
                bPunt |= !FunctionsModelsUtilities.createDirectory(sLanguageDirectory + s_aHelpDirectories[iHelpDirectory]);
            }
            for (iHelpImageDirectory = 0; iHelpImageDirectory < s_aHelpImageDirectories.length; ++iHelpImageDirectory) {
                bPunt |= !FunctionsModelsUtilities.createDirectory(sLanguageDirectory + s_aHelpImageDirectories[iHelpImageDirectory]);
            }
            for (iHelpStyleSheetDirectory = 0; iHelpStyleSheetDirectory < s_aHelpStyleSheetDirectories.length; ++iHelpStyleSheetDirectory) {
                bPunt |= !FunctionsModelsUtilities.createDirectory(sLanguageDirectory + s_aHelpStyleSheetDirectories[iHelpStyleSheetDirectory]);
            }
        }
        if (bPunt) {
            System.out.println("Unable to create target help directory structure: " + sTargetHelpDirectory);
            return;
        }
        PropertiesFunctionsModel mdl = new PropertiesFunctionsModel();
        mdl.load(new WAdminResource(FunctionsModelsUtilities.class, "Functions"), "SQL.");
        try {
            for (int iLanguage2 = 0; iLanguage2 < s_aLanguages.length; ++iLanguage2) {
                String sSourceLanguageDirectory = sSourceHelpDirectory + "/" + s_aLanguages[iLanguage2] + "/";
                String sTargetLanguageDirectory = sTargetHelpDirectory + "/" + s_aLanguages[iLanguage2] + "/";
                for (int iHelpDirectory2 = 1; iHelpDirectory2 < s_aHelpDirectories.length; ++iHelpDirectory2) {
                    String sSourceHelpIndexesFileName = sSourceLanguageDirectory + s_aHelpDirectories[iHelpDirectory2] + "/index.xml";
                    String sTargetHelpIndexesFileName = sTargetLanguageDirectory + s_aHelpDirectories[iHelpDirectory2] + "/index.xml";
                    FunctionsModelsUtilities.copyFile(sSourceHelpIndexesFileName, sTargetHelpIndexesFileName);
                }
                FunctionsModelsUtilities.getHelpFilesForAllFunctions((FunctionsModel)mdl, sSourceLanguageDirectory);
                FunctionsModelsUtilities.printFunctionsWithNoHelp(mdl);
                try (FileOutputStream strmOutput = new FileOutputStream(sTargetXMLFileName);){
                    mdl.saveXML(strmOutput);
                }
                for (int iHelpStyleSheetDirectory2 = 0; iHelpStyleSheetDirectory2 < s_aHelpStyleSheetDirectories.length; ++iHelpStyleSheetDirectory2) {
                    String sSourceHelpStyleSheetFileName = sSourceLanguageDirectory + s_aHelpStyleSheetDirectories[iHelpStyleSheetDirectory2] + "/style.css";
                    String sTargetHelpStyleSheetFileName = sTargetLanguageDirectory + s_aHelpStyleSheetDirectories[iHelpStyleSheetDirectory2] + "/style.css";
                    FunctionsModelsUtilities.copyFile(sSourceHelpStyleSheetFileName, sTargetHelpStyleSheetFileName);
                }
                lHelpFilesToProcess = new ArrayList();
                lHelpFilesProcessed = new ArrayList();
                lImageFiles = new ArrayList();
                Function[] aFunctions = mdl.getAllFunctions();
                for (int iFunction = 0; iFunction < aFunctions.length; ++iFunction) {
                    String sHelpFileName = aFunctions[iFunction].getHelpFileName();
                    if (sHelpFileName == null || lHelpFilesToProcess.contains(sHelpFileName)) continue;
                    lHelpFilesToProcess.add(sHelpFileName.substring(1));
                }
                System.out.println();
                System.out.println("Cleaning Help Files");
                System.out.println("-------------------");
                while (!lHelpFilesToProcess.isEmpty()) {
                    String sHelpFileName = (String)lHelpFilesToProcess.remove(0);
                    lHelpFilesProcessed.add(sHelpFileName);
                    String sSourceHelpPath = sSourceLanguageDirectory + sHelpFileName;
                    String sTargetHelpPath = sTargetLanguageDirectory + sHelpFileName;
                    System.out.println(sSourceHelpPath + ": --------------------------------------------------");
                    FunctionsModelsUtilities.cleanHelp(sSourceHelpPath, sTargetHelpPath);
                }
                System.out.println();
                System.out.println("Copying Image Files");
                System.out.println("-------------------");
                for (int iImageFile = 0; iImageFile < lImageFiles.size(); ++iImageFile) {
                    String sImageFile = (String)lImageFiles.get(iImageFile);
                    String sSourceImagePath = sSourceLanguageDirectory + sImageFile;
                    String sTargetImagePath = sTargetLanguageDirectory + sImageFile;
                    try {
                        System.out.println("Copying " + sSourceImagePath + " to " + sTargetImagePath);
                        FunctionsModelsUtilities.copyFile(sSourceImagePath, sTargetImagePath);
                        continue;
                    }
                    catch (IOException ex) {
                        System.out.println(ex.getLocalizedMessage());
                    }
                }
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void printModel(PrintStream strmOut, FunctionsModel mdl) {
        Category[] aCategories = mdl.getCategories();
        for (int iCategory = 0; iCategory < aCategories.length; ++iCategory) {
            strmOut.println(aCategories[iCategory].getDisplayName());
            Function[] aFunctions = aCategories[iCategory].getFunctions();
            for (int iFunction = 0; iFunction < aFunctions.length; ++iFunction) {
                strmOut.println(PAD + aFunctions[iFunction].getDisplayName());
            }
        }
    }

    static void cleanHelp(String sSourceHelpFileName, String sTargetHelpFileName) {
        try {
            StringBuffer sb = FunctionsModelsUtilities.readFile(sSourceHelpFileName);
            int iTopNavigation = sb.indexOf(TOP_NAVIGATION);
            int iStartIndex = sb.indexOf(START_INDEX);
            if (iTopNavigation > 1 && iStartIndex > iTopNavigation) {
                sb.delete(iTopNavigation, iStartIndex);
            } else {
                System.out.println(sSourceHelpFileName + ": Error: Unable to remove top navigation");
            }
            int iBottomNavigation = sb.indexOf(BOTTOM_NAVIGATION);
            int iCopyright = sb.indexOf(COPYRIGHT, iBottomNavigation);
            if (iBottomNavigation > 1 && iCopyright > iBottomNavigation) {
                sb.delete(iBottomNavigation, iCopyright);
            } else {
                System.out.println(sSourceHelpFileName + ": Error: Unable to remove bottom navigation");
            }
            FunctionsModelsUtilities.processAnchors(sb, sSourceHelpFileName);
            FunctionsModelsUtilities.processImages(sb, sSourceHelpFileName);
            FunctionsModelsUtilities.writeFile(sTargetHelpFileName, sb);
        }
        catch (FileNotFoundException ex) {
            System.err.println(ex.getLocalizedMessage());
        }
        catch (IOException ex) {
            System.err.println(ex.getLocalizedMessage());
        }
    }

    private static void processAnchors(StringBuffer sb, String sHelpFileName) {
        int iAnchorStart = sb.indexOf(ANCHOR_START);
        while (iAnchorStart > 0) {
            FunctionsModelsUtilities.processAnchor(sb, iAnchorStart, sHelpFileName);
            iAnchorStart = sb.indexOf(ANCHOR_START, iAnchorStart + 1);
        }
        iAnchorStart = sb.indexOf(ANCHOR_START2);
        while (iAnchorStart > 0) {
            FunctionsModelsUtilities.processAnchor(sb, iAnchorStart, sHelpFileName);
            iAnchorStart = sb.indexOf(ANCHOR_START, iAnchorStart + 1);
        }
    }

    private static void processAnchor(StringBuffer sb, int iAnchorStart, String sHelpFileName) {
        String sParentDirectory = new File(new File(sHelpFileName).getParent()).getName() + "/";
        int iAnchorHrefEnd = sb.indexOf("\"", iAnchorStart + ANCHOR_START.length());
        if (iAnchorHrefEnd > iAnchorStart) {
            String sAnchorHref = sb.substring(iAnchorStart + ANCHOR_START.length(), iAnchorHrefEnd);
            if (sAnchorHref.startsWith("#") || sAnchorHref.startsWith(new File(sHelpFileName).getName() + "#")) {
                System.out.println(sHelpFileName + ": Anchor in file:" + sAnchorHref);
            } else if (sAnchorHref.indexOf(47) < 0 && sAnchorHref.indexOf(92) < 0) {
                if (sAnchorHref.startsWith("#")) {
                    System.out.println(sHelpFileName + ": Local file    :" + sAnchorHref);
                } else if (sAnchorHref.startsWith(new File(sHelpFileName).getName() + "#")) {
                    System.out.println(sHelpFileName + ": Local file    :" + sAnchorHref);
                }
                String sReferencedFile = sParentDirectory + sAnchorHref;
                int iPound = sReferencedFile.indexOf(35);
                if (iPound > 1) {
                    sReferencedFile = sReferencedFile.substring(0, iPound);
                }
                if (!lHelpFilesProcessed.contains(sReferencedFile) && !lHelpFilesToProcess.contains(sReferencedFile)) {
                    lHelpFilesToProcess.add(sReferencedFile);
                    System.out.println(sHelpFileName + ": Anchor added  :" + sAnchorHref);
                } else {
                    System.out.println(sHelpFileName + ": Anchor in list:" + sAnchorHref);
                }
            } else if (sAnchorHref.startsWith("http:") || sAnchorHref.startsWith("file:")) {
                System.out.println(sHelpFileName + ": External ref  :" + sAnchorHref);
            } else {
                boolean bFound = false;
                for (int iHelpDirectory = 0; iHelpDirectory < s_aHelpDirectories.length && !bFound; ++iHelpDirectory) {
                    bFound = sAnchorHref.startsWith("../" + s_aHelpDirectories[iHelpDirectory] + "/");
                }
                if (bFound) {
                    String sReferencedFile = sAnchorHref.substring(3);
                    int iPound = sReferencedFile.indexOf(35);
                    if (iPound > 1) {
                        sReferencedFile = sReferencedFile.substring(0, iPound);
                    }
                    if (!lHelpFilesProcessed.contains(sReferencedFile) && !lHelpFilesToProcess.contains(sReferencedFile)) {
                        lHelpFilesToProcess.add(sReferencedFile);
                        System.out.println(sHelpFileName + ": Anchor added  :" + sAnchorHref);
                    } else {
                        System.out.println(sHelpFileName + ": Anchor in list:" + sAnchorHref);
                    }
                } else {
                    int iAnchorStartEnd = sb.indexOf(">", iAnchorStart);
                    if (iAnchorStart < iAnchorStartEnd) {
                        int iAnchorEnd = sb.indexOf(ANCHOR_END, iAnchorStartEnd);
                        if (iAnchorEnd < 0) {
                            iAnchorEnd = sb.indexOf(ANCHOR_END2, iAnchorStart);
                        }
                        if (iAnchorStartEnd < iAnchorEnd) {
                            sb.replace(iAnchorStart, iAnchorStartEnd + 1, START_BOLD_UNDERLINE);
                            sb.replace(iAnchorEnd -= iAnchorStartEnd + 1 - iAnchorStart - START_BOLD_UNDERLINE.length(), iAnchorEnd + ANCHOR_END.length(), END_BOLD_UNDERLINE);
                            System.out.println(sHelpFileName + ": Anchor removed:" + sAnchorHref);
                        } else {
                            System.out.println(sHelpFileName + ": Error: Attempt to remove anchor failed.");
                        }
                    } else {
                        System.out.println(sHelpFileName + ": Error: Attempt to remove anchor failed.");
                    }
                }
            }
        } else {
            System.out.println(sHelpFileName + ": Error: Unable to find end of anchor href");
        }
    }

    private static void processImages(StringBuffer sb, String sHelpFileName) {
        String sParentDirectory = new File(new File(sHelpFileName).getParent()).getName();
        int iImageStart = sb.indexOf(IMAGE_START);
        while (iImageStart > 0) {
            int iImageEnd = sb.indexOf(">", iImageStart);
            if (iImageEnd > iImageStart) {
                String sImage = sb.substring(iImageStart, iImageEnd);
                int iImageSourceStart = sImage.indexOf(IMAGE_SOURCE_START);
                if (iImageSourceStart > 0) {
                    int iImageSourceEnd = sImage.indexOf("\"", iImageSourceStart + IMAGE_SOURCE_START.length());
                    if (iImageSourceEnd > iImageSourceStart) {
                        String sImageSource = sImage.substring(iImageSourceStart + IMAGE_SOURCE_START.length(), iImageSourceEnd);
                        if (sImageSource.startsWith(LOCAL_HELP_IMAGES)) {
                            String sReferencedImage = sParentDirectory + IMAGES_DIR + sImageSource.substring(LOCAL_HELP_IMAGES.length() - 1);
                            if (!lImageFiles.contains(sReferencedImage)) {
                                lImageFiles.add(sReferencedImage);
                                System.out.println(sHelpFileName + ": Image added   :" + sImageSource);
                            } else {
                                System.out.println(sHelpFileName + ": Image in list :" + sImageSource);
                            }
                        } else {
                            boolean bFound = false;
                            for (int iHelpDirectory = 0; iHelpDirectory < s_aHelpImageDirectories.length && !bFound; ++iHelpDirectory) {
                                bFound = sImageSource.startsWith("../" + s_aHelpImageDirectories[iHelpDirectory] + "/");
                            }
                            if (bFound) {
                                String sReferencedImage = sImageSource.substring(3);
                                if (!lImageFiles.contains(sReferencedImage)) {
                                    lImageFiles.add(sReferencedImage);
                                    System.out.println(sHelpFileName + ": Image added   :" + sImageSource);
                                } else {
                                    System.out.println(sHelpFileName + ": Image in list :" + sImageSource);
                                }
                            } else {
                                System.out.println(sHelpFileName + ": Warn: Image not in one of the help directories:" + sImageSource);
                            }
                        }
                    } else {
                        System.out.println(sHelpFileName + ": Error: No end to image source");
                    }
                } else {
                    System.out.println(sHelpFileName + ": Error: No image source");
                }
            } else {
                System.out.println(sHelpFileName + ": Error: No end to image");
            }
            iImageStart = sb.indexOf(IMAGE_START, iImageStart + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadAndCompareModels(PrintStream strmOut) {
        PropertiesFunctionsModel mdlDIS = new PropertiesFunctionsModel();
        mdlDIS.load(new WAdminResource(FunctionsTab.class, "Functions"), "SQL.");
        XMLFunctionsModel mdlEG = new XMLFunctionsModel();
        try {
            mdlEG.load(FunctionsTab.class.getResource("SASEXPFUNC.xml").getPath());
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace(strmOut);
        }
        catch (IOException ex) {
            ex.printStackTrace(strmOut);
        }
        strmOut.println("------------------------------------------------------------");
        ServerProperties[] aSPs = FunctionsModelsUtilities.loadServerProperties();
        if (aSPs != null) {
            ServerPropertiesFunctionsModel[] aSPModels = new ServerPropertiesFunctionsModel[aSPs.length];
            for (int iSP = 0; iSP < aSPs.length; ++iSP) {
                aSPModels[iSP] = new ServerPropertiesFunctionsModel();
                aSPModels[iSP].load(aSPs[iSP]);
            }
        }
        try (FileOutputStream strm = new FileOutputStream("\\\\D16434\\Public\\Data\\Functions.xml");){
            mdlDIS.saveXML(strm);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            PropertiesFunctionsModel mdlNew = new PropertiesFunctionsModel();
            try (FileInputStream strm = new FileInputStream("\\\\D16434\\Public\\Data\\Functions.xml");){
                mdlNew.loadXML(strm);
            }
            strmOut.println("saved to loaded -------------------------------------");
            FunctionsModelsUtilities.compareModels(strmOut, mdlDIS, mdlNew);
            System.out.println(mdlNew.equals(mdlDIS));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void compareModels(PrintStream strmOut, FunctionsModel mdlOne, FunctionsModel mdlTwo) {
        Function[] aFunctions;
        Category[] aOne = mdlOne.getCategories();
        Category[] aTwo = mdlTwo.getCategories();
        int iOne = 0;
        int iTwo = 0;
        while (iOne < aOne.length && iTwo < aTwo.length) {
            int iFunction;
            Function[] aFunctions2;
            Category one = aOne[iOne];
            Category two = aTwo[iTwo];
            String sOne = one.getDisplayName().trim();
            String sTwo = two.getDisplayName().trim();
            if (sOne.equals("External File") && sTwo.equals("External Files") || sOne.equals("Trigonometric and Hyperbolic") && sTwo.equals("Trigonometric") || sOne.equals("Probability and Density") && sTwo.equals("Probability")) {
                strmOut.println(sOne + BLANKS.substring(Math.min(sOne.length(), BLANKS.length())) + sTwo);
                FunctionsModelsUtilities.compareFunctions(strmOut, one.getFunctions(), two.getFunctions());
                ++iOne;
                ++iTwo;
                continue;
            }
            if (sOne.equals(sTwo)) {
                strmOut.println(sOne + BLANKS.substring(Math.min(sOne.length(), BLANKS.length())) + sTwo);
                FunctionsModelsUtilities.compareFunctions(strmOut, one.getFunctions(), two.getFunctions());
                ++iOne;
                ++iTwo;
                continue;
            }
            if (sOne.equals("All Functions") || sOne.equals("Formats") || sOne.equals("Informats")) {
                ++iOne;
                continue;
            }
            if (sOne.compareTo(sTwo) < 0) {
                strmOut.println(sOne);
                aFunctions2 = one.getFunctions();
                for (iFunction = 0; iFunction < aFunctions2.length; ++iFunction) {
                    strmOut.println(PAD + aFunctions2[iFunction].getDisplayName());
                }
                ++iOne;
                continue;
            }
            strmOut.println(BLANKS + sTwo);
            aFunctions2 = two.getFunctions();
            for (iFunction = 0; iFunction < aFunctions2.length; ++iFunction) {
                strmOut.println("                                           " + aFunctions2[iFunction].getDisplayName());
            }
            ++iTwo;
        }
        while (iOne < aOne.length) {
            strmOut.println(BLANKS + aOne[iOne].getDisplayName().trim());
            aFunctions = aOne[iOne].getFunctions();
            for (int iFunction = 0; iFunction < aFunctions.length; ++iFunction) {
                strmOut.println(PAD + aFunctions[iFunction].getDisplayName());
            }
            ++iOne;
        }
        while (iTwo < aTwo.length) {
            strmOut.println(BLANKS + aTwo[iTwo].getDisplayName().trim());
            aFunctions = aTwo[iTwo].getFunctions();
            for (int iFunction = 0; iFunction < aFunctions.length; ++iFunction) {
                strmOut.println("                                           " + aFunctions[iFunction].getDisplayName());
            }
            ++iTwo;
        }
    }

    private static void compareFunctions(PrintStream strmOut, Function[] aOne, Function[] aTwo) {
        String sOne;
        int iOne = 0;
        int iTwo = 0;
        while (iOne < aOne.length && iTwo < aTwo.length) {
            sOne = aOne[iOne].toString().trim();
            String sTwo = aTwo[iTwo].toString().trim();
            int one = sOne.indexOf(40);
            int two = sTwo.indexOf(40);
            if (one > 0) {
                sOne = sOne.substring(0, one).trim();
            }
            if (two > 0) {
                sTwo = sTwo.substring(0, two).trim();
            }
            if (sOne.equals(sTwo)) {
                strmOut.println(PAD + sOne + BLANKS.substring(Math.min(sOne.length(), BLANKS.length())) + sTwo);
                ++iOne;
                ++iTwo;
                continue;
            }
            if (sOne.compareTo(sTwo) < 0) {
                strmOut.println(PAD + sOne);
                ++iOne;
                continue;
            }
            strmOut.println("                                           " + sTwo);
            ++iTwo;
        }
        while (iOne < aOne.length) {
            sOne = aOne[iOne].toString();
            strmOut.println(PAD + sOne);
            ++iOne;
        }
        while (iTwo < aTwo.length) {
            String sTwo = aTwo[iTwo].toString();
            strmOut.println("                                           " + sTwo);
            ++iTwo;
        }
    }

    private static ServerProperties[] loadServerProperties() {
        InputStream strm = ServerProperties.class.getResourceAsStream("IQServerProperties.xml");
        try {
            List lSPs = ServerProperties.readServerProperties((InputStream)strm);
            ArrayList<ServerProperties> lWorkspaceSPs = new ArrayList<ServerProperties>();
            for (int iSP = 0; iSP < lSPs.size(); ++iSP) {
                ServerProperties sp = (ServerProperties)lSPs.get(iSP);
                if (!sp.getID().startsWith("saswks")) continue;
                lWorkspaceSPs.add(sp);
            }
            return lWorkspaceSPs.toArray(new ServerProperties[lWorkspaceSPs.size()]);
        }
        catch (MetadataException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static ServerProperties findServerProperties(ServerProperties[] aServerProperties, String sID) {
        if (sID == null) {
            return null;
        }
        for (int iSP = 0; iSP < aServerProperties.length; ++iSP) {
            if (!sID.equals(aServerProperties[iSP].getID())) continue;
            return aServerProperties[iSP];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List loadHelpIndexesFile(String sHelpIndexFileName) throws IOException {
        String sParentDirectory = new File(new File(sHelpIndexFileName).getParent()).getName();
        try (FileInputStream strmHelp = new FileInputStream(sHelpIndexFileName);){
            List list = FunctionsModelsUtilities.loadHelpIndexesFile(strmHelp, sParentDirectory);
            return list;
        }
    }

    private static List loadHelpIndexesFile(InputStream strm, String sParentDirectory) throws IOException {
        sParentDirectory = sParentDirectory + "/";
        ArrayList<HelpIndexItem> lIndexItems = new ArrayList<HelpIndexItem>();
        Document doc = FunctionsModelsUtilities.loadXMLDocument(strm);
        Element eleIndex = doc.getDocumentElement();
        NodeList lEntries = eleIndex.getElementsByTagName("indexEntry");
        for (int iEntry = 0; iEntry < lEntries.getLength(); ++iEntry) {
            Element eleEntry = (Element)lEntries.item(iEntry);
            NodeList lTargets = eleEntry.getElementsByTagName("indexTarget");
            for (int iTarget = 0; iTarget < lTargets.getLength(); ++iTarget) {
                Element eleIndexTarget = (Element)lTargets.item(iTarget);
                Element eleTitle = (Element)eleIndexTarget.getElementsByTagName("title").item(0);
                Element eleTarget = (Element)eleIndexTarget.getElementsByTagName("target").item(0);
                if (eleIndexTarget.getElementsByTagName("target").getLength() > 1) {
                    Workspace.getDefaultLogger().debug(eleTitle.getNodeValue() + " has " + eleIndexTarget.getElementsByTagName("target").getLength() + " targets");
                }
                HelpIndexItem item = new HelpIndexItem();
                item.title = eleTitle.getTextContent();
                item.file = sParentDirectory + eleTarget.getAttribute("file");
                lIndexItems.add(item);
            }
        }
        return lIndexItems;
    }

    public static void getHelpFilesForAllFunctions(FunctionsModel mdl, String sHelpPath) {
        try {
            ArrayList lHelpItems = new ArrayList();
            for (int iHelpDirectory = 1; iHelpDirectory < s_aHelpDirectories.length; ++iHelpDirectory) {
                String sHelpIndexesFileName = sHelpPath + s_aHelpDirectories[iHelpDirectory] + "/index.xml";
                lHelpItems.addAll(FunctionsModelsUtilities.loadHelpIndexesFile(sHelpIndexesFileName));
            }
            HelpIndexItem[] aHelpItems = lHelpItems.toArray(new HelpIndexItem[lHelpItems.size()]);
            FunctionsModelsUtilities.getHelpFilesForAllFunctions(mdl, aHelpItems);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void getHelpFilesForAllFunctions(FunctionsModel mdl, HelpIndexItem[] aHelpIndexes) {
        Category[] aCategories = mdl.getCategories();
        for (int iCategory = 0; iCategory < aCategories.length; ++iCategory) {
            Function[] aFunctions = aCategories[iCategory].getFunctions();
            for (int iFunction = 0; iFunction < aFunctions.length; ++iFunction) {
                String sHelpFile = FunctionsModelsUtilities.getHelpFileFor(aFunctions[iFunction], aHelpIndexes);
                if (sHelpFile == null) continue;
                ((BaseFunction)aFunctions[iFunction]).setHelpFileName("#" + sHelpFile);
            }
        }
    }

    private static String getHelpFileFor(Function f, HelpIndexItem[] aHelpIndexes) {
        int iItem;
        String sTitle;
        if ("Informats".equals(f.getCategoryName())) {
            sTitle = f.getDisplayName() + " Informat";
        } else if ("Formats".equals(f.getCategoryName())) {
            sTitle = f.getDisplayName() + " Format";
        } else {
            if ("Aggregate".equals(f.getCategoryName())) {
                return null;
            }
            sTitle = f.getDisplayName() + " Function";
        }
        for (iItem = 0; iItem < aHelpIndexes.length; ++iItem) {
            if (!aHelpIndexes[iItem].title.equals(sTitle)) continue;
            return aHelpIndexes[iItem].file;
        }
        if (sTitle.startsWith("YYMMDD")) {
            return "lrdict.hlp/a000589916.htm";
        }
        if (sTitle.startsWith("YYMM")) {
            return "lrdict.hlp/a002231336.htm";
        }
        if (sTitle.startsWith("YYQR")) {
            return "lrdict.hlp/a002231415.htm";
        }
        if (sTitle.startsWith("YYQ")) {
            return "lrdict.hlp/a002231398.htm";
        }
        if (sTitle.startsWith("MMYY")) {
            return "lrdict.hlp/a002231365.htm";
        }
        if (sTitle.startsWith("MMDDYY")) {
            return "lrdict.hlp/a000590662.htm";
        }
        if (sTitle.startsWith("DDMMYY")) {
            return "lrdict.hlp/a000590662.htm";
        }
        if (sTitle.startsWith("PCTL")) {
            return "lrdict.hlp/a002186127.htm";
        }
        if (sTitle.startsWith("SYS") && f.getInsertString().indexOf(38) == 0) {
            sTitle = f.getDisplayName() + " Automatic Macro Variable";
            for (iItem = 0; iItem < aHelpIndexes.length; ++iItem) {
                if (!aHelpIndexes[iItem].title.equals(sTitle)) continue;
                return aHelpIndexes[iItem].file;
            }
        }
        return null;
    }

    private static void printFunctionsWithHelp(FunctionsModel mdl) {
        Function[] aFunctions = mdl.getAllFunctions();
        for (int iFunction = 0; iFunction < aFunctions.length; ++iFunction) {
            String sHelpFileName = aFunctions[iFunction].getHelpFileName();
            if (sHelpFileName == null) continue;
            System.out.println(aFunctions[iFunction].getDisplayName() + " = " + sHelpFileName);
        }
    }

    private static void printFunctionsWithNoHelp(FunctionsModel mdl) {
        System.out.println("----- Functions With No Help -----");
        Function[] aFunctions = mdl.getAllFunctions();
        for (int iFunction = 0; iFunction < aFunctions.length; ++iFunction) {
            String sHelpFileName = aFunctions[iFunction].getHelpFileName();
            if (sHelpFileName != null) continue;
            System.out.println(aFunctions[iFunction].getDisplayName() + ": " + aFunctions[iFunction].getDescription());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuffer readFile(String sFileName) throws IOException {
        try (BufferedReader rdr = new BufferedReader(new FileReader(sFileName));){
            StringBuffer sb = new StringBuffer(8192);
            String s = rdr.readLine();
            while (s != null) {
                sb.append(s).append('\n');
                s = rdr.readLine();
            }
            StringBuffer stringBuffer = sb;
            return stringBuffer;
        }
    }

    private static void writeFile(String sFileName, StringBuffer sb) throws IOException {
        try (BufferedWriter wtr = new BufferedWriter(new FileWriter(sFileName));){
            wtr.write(sb.toString());
            wtr.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(String sSourceFileName, String sTargetFileName) throws IOException {
        try (FileInputStream strmIn = new FileInputStream(sSourceFileName);
             FileOutputStream strmOut = new FileOutputStream(sTargetFileName);){
            byte[] buffer = new byte[8192];
            int nRead = ((InputStream)strmIn).read(buffer);
            while (nRead > -1) {
                ((OutputStream)strmOut).write(buffer, 0, nRead);
                nRead = ((InputStream)strmIn).read(buffer);
            }
        }
    }

    private static Document loadXMLDocument(InputStream strmXML) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(strmXML);
        }
        catch (ParserConfigurationException ex) {
            IOException exception = new IOException(ex.getLocalizedMessage());
            exception.initCause(ex);
            throw exception;
        }
        catch (SAXException ex) {
            IOException exception = new IOException(ex.getLocalizedMessage());
            exception.initCause(ex);
            throw exception;
        }
    }

    private static class HelpIndexItem {
        String title;
        String file;

        private HelpIndexItem() {
        }
    }
}

