/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.expression;

import com.sas.iquery.metadata.serverprop.FunctionSignature;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.expression.Category;
import com.sas.workspace.visuals.expression.Function;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BaseFunction
implements Function,
Comparable {
    private Category m_category;
    private String m_sCategory;
    private String m_sName;
    private String m_sDisplayName;
    private String m_sHelpFileName;
    private String m_sDescription;
    private String m_sToolTip;
    private String m_sInsert;
    private String m_sFormat;
    private String[] m_aArguments;
    private int[] m_aPageRange;
    private static final String NAME = "Name";
    private static final String DISPLAYNAME = "DisplayName";
    private static final String DESCRIPTION = "Description";
    private static final String INSERT = "Insert";
    private static final String TOOLTIP = "ToolTip";
    private static final String HELPFILENAME = "HelpFileName";
    private static final String HELPFIRSTPAGE = "HelpFirstPage";
    private static final String HELPLASTPAGE = "HelpLastPage";

    public BaseFunction() {
    }

    public BaseFunction(WAdminResource aBundle, String sKeyPrefix) {
        String sArgument;
        this.m_sName = aBundle.getString(sKeyPrefix + ".DisplayName.txt");
        this.m_sDescription = aBundle.getRawString(sKeyPrefix + ".Description.txt");
        this.m_sFormat = aBundle.getString(sKeyPrefix + ".fmt.notrans");
        this.m_sToolTip = aBundle.getRawString(sKeyPrefix + ".ToolTip.txt");
        if (this.m_sToolTip == null) {
            this.m_sToolTip = aBundle.getRawString(sKeyPrefix + ".Tooltip.txt");
        }
        this.m_sCategory = aBundle.getRawString(sKeyPrefix + ".Category.notrans");
        if (this.m_sCategory == null) {
            this.m_sCategory = aBundle.getRawString(sKeyPrefix + ".Category");
        }
        this.m_sDisplayName = this.m_sName;
        this.hackDisplayName();
        String sTypePrefix = sKeyPrefix.substring(0, sKeyPrefix.indexOf(46));
        ArrayList<String> lArguments = new ArrayList<String>();
        int iArgument = 0;
        while ((sArgument = aBundle.getRawString(sKeyPrefix + ".arg." + iArgument + ".type.notrans")) != null) {
            String sArgumentDisplayName = aBundle.getString(sTypePrefix + ".Function.ArgumentType." + sArgument + ".DisplayName.txt");
            lArguments.add(sArgumentDisplayName);
            ++iArgument;
        }
        this.m_aArguments = lArguments.toArray(new String[lArguments.size()]);
    }

    public BaseFunction(Category category, String sName, String sDisplayName) {
        this.m_category = category;
        this.m_sCategory = category.getName();
        this.m_sName = sName;
        this.m_sDisplayName = sDisplayName;
        this.m_sInsert = sDisplayName;
        this.hackDisplayName();
    }

    public BaseFunction(Category category, String sName, String sDisplayName, String sDescription, String sToolTip, String sInsertString, String sHelpFileName) {
        this.m_category = category;
        this.m_sCategory = category.getName();
        this.m_sName = sName;
        this.m_sDisplayName = sDisplayName;
        this.m_sDescription = sDescription;
        this.m_sToolTip = sToolTip;
        this.m_sInsert = sInsertString;
        this.m_sHelpFileName = sHelpFileName;
    }

    public BaseFunction(Category category, String sName, String sDisplayName, String sDescription, String sToolTip, String sInsertString, String sHelpFileName, int[] aHelpPageRange) {
        this.m_category = category;
        this.m_sCategory = category.getName();
        this.m_sName = sName;
        this.m_sDisplayName = sDisplayName;
        this.m_sDescription = sDescription;
        this.m_sToolTip = sToolTip;
        this.m_sInsert = sInsertString;
        this.m_sHelpFileName = sHelpFileName;
        this.m_aPageRange = aHelpPageRange;
    }

    public BaseFunction(Category category, com.sas.iquery.metadata.serverprop.Function function, FunctionSignature signature) {
        this.m_category = category;
        this.m_sCategory = category.getName();
        this.m_sName = function.getID();
        this.m_sDisplayName = function.getLabel();
        this.m_sDescription = function.getDescription();
        this.m_sToolTip = function.getToolTip();
        this.m_sFormat = signature.getDefaultSyntaxTemplate();
        List lParameters = signature.getParameters();
        this.m_aArguments = new String[lParameters.size()];
        for (int iArgument = 0; iArgument < this.m_aArguments.length; ++iArgument) {
            this.m_aArguments[iArgument] = lParameters.get(iArgument).toString();
        }
        this.hackDisplayName();
    }

    private void hackDisplayName() {
        int iParenthesis = this.m_sDisplayName.indexOf(40);
        if (!(iParenthesis <= 0 || "Aggregate".equals(this.m_sCategory) || "Counting Aggregation".equals(this.m_sCategory) || "Non-counting Aggregation".equals(this.m_sCategory))) {
            this.m_sDisplayName = this.m_sDisplayName.substring(0, iParenthesis).trim();
        }
    }

    @Override
    public void setCategory(Category category) {
        this.m_category = category;
        this.m_sCategory = category.getName();
    }

    @Override
    public Category getCategory() {
        return this.m_category;
    }

    @Override
    public String getCategoryName() {
        return this.m_sCategory;
    }

    @Override
    public String getName() {
        return this.m_sName;
    }

    @Override
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Override
    public String getDescription() {
        return this.m_sDescription;
    }

    @Override
    public String getToolTip() {
        return this.m_sToolTip;
    }

    @Override
    public String getInsertString() {
        if (this.m_sInsert == null) {
            this.m_sInsert = this.m_sFormat != null ? MessageFormat.format(this.m_sFormat, this.m_aArguments) : this.m_sDisplayName;
        }
        return this.m_sInsert;
    }

    @Override
    public String getHelpFileName() {
        return this.m_sHelpFileName;
    }

    public void setHelpFileName(String sHelpFileName) {
        this.m_sHelpFileName = sHelpFileName;
    }

    @Override
    public int[] getHelpPageRange() {
        return this.m_aPageRange;
    }

    public int compareTo(Object object) {
        if (object instanceof Function) {
            return this.m_sDisplayName.compareToIgnoreCase(((Function)object).getDisplayName());
        }
        return this.m_sDisplayName.compareToIgnoreCase(object.toString());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof BaseFunction) {
            Function function = (Function)object;
            return this.m_sName.equals(function.getName()) && this.m_sDisplayName.equals(function.getDisplayName()) && this.m_sDescription.equals(function.getDescription()) && this.m_sToolTip.equals(function.getToolTip()) && this.getInsertString().equals(function.getInsertString()) && this.m_category.getDisplayName().equals(function.getCategory().getDisplayName());
        }
        return false;
    }

    public int hashcode() {
        return super.hashCode();
    }

    public String toString() {
        return this.m_sDisplayName;
    }

    @Override
    public Element saveToXML(Document document) {
        Element eleFunction = document.createElement("Function");
        eleFunction.setNodeValue("Function");
        eleFunction.setAttribute(NAME, this.getName());
        eleFunction.setAttribute(DISPLAYNAME, this.getDisplayName());
        eleFunction.setAttribute(DESCRIPTION, this.getDescription());
        eleFunction.setAttribute(INSERT, this.getInsertString());
        eleFunction.setAttribute(TOOLTIP, this.getToolTip());
        eleFunction.setAttribute(HELPFILENAME, this.getHelpFileName());
        if (this.m_aPageRange != null) {
            eleFunction.setAttribute(HELPFIRSTPAGE, Integer.toString(this.m_aPageRange[0]));
            eleFunction.setAttribute(HELPLASTPAGE, Integer.toString(this.m_aPageRange[1]));
        }
        return eleFunction;
    }

    @Override
    public void loadFromXML(Element eleFunction) {
        block8: {
            this.m_sName = eleFunction.getAttribute(NAME);
            this.m_sDisplayName = eleFunction.getAttribute(DISPLAYNAME);
            this.m_sDescription = eleFunction.getAttribute(DESCRIPTION);
            this.m_sInsert = eleFunction.getAttribute(INSERT);
            this.m_sToolTip = eleFunction.getAttribute(TOOLTIP);
            this.m_sHelpFileName = eleFunction.getAttribute(HELPFILENAME);
            if (this.m_sDisplayName.length() == 0) {
                this.m_sDisplayName = this.m_sName;
            }
            if (this.m_sHelpFileName.length() == 0) {
                this.m_sHelpFileName = null;
            }
            String sFirstPage = eleFunction.getAttribute(HELPFIRSTPAGE);
            String sLastPage = eleFunction.getAttribute(HELPLASTPAGE);
            if (sFirstPage.length() > 0 && sLastPage.length() > 0) {
                try {
                    int iFirstPage = Integer.parseInt(sFirstPage);
                    try {
                        int iLastPage = Integer.parseInt(sLastPage);
                        if (iFirstPage > iLastPage) {
                            Workspace.getDefaultLogger().warn("First help page (" + iFirstPage + ") must be less than or equal to last help page (" + iLastPage + ")");
                            break block8;
                        }
                        this.m_aPageRange = new int[]{iFirstPage, iLastPage};
                    }
                    catch (NumberFormatException ex) {
                        Workspace.getDefaultLogger().warn("Last page is not an integer value: " + sFirstPage);
                    }
                }
                catch (NumberFormatException ex) {
                    Workspace.getDefaultLogger().warn("First page is not an integer value: " + sFirstPage);
                }
            }
        }
    }
}

