/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.expression;

import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.expression.Category;
import com.sas.workspace.visuals.expression.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BaseCategory
implements Category,
Comparable {
    private List m_lFunctions;
    private Function[] m_aFunctions;
    private String m_sDisplayName;
    private String m_sName;

    public BaseCategory(String sName, String sDisplayName) {
        this.m_sName = sName;
        this.m_sDisplayName = sDisplayName;
        this.m_lFunctions = new ArrayList();
    }

    @Override
    public void addFunction(Function function) {
        if (this.checkForDuplicate(function)) {
            return;
        }
        this.m_lFunctions.add(function);
        this.m_aFunctions = null;
    }

    private boolean checkForDuplicate(Function function) {
        for (int iFunction = 0; iFunction < this.m_lFunctions.size(); ++iFunction) {
            Function function0 = (Function)this.m_lFunctions.get(iFunction);
            if (!function.getDisplayName().equals(function0.getDisplayName()) || !function.getName().equals(function0.getName()) || !function.getInsertString().equals(function0.getInsertString())) continue;
            Workspace.getDefaultLogger().debug("Duplicate:" + function0.getDisplayName() + ": " + function0.getName() + ":" + function0.getInsertString() + "equal to" + function.getDisplayName() + ": " + function.getName() + ":" + function.getInsertString());
            return true;
        }
        return false;
    }

    @Override
    public void clearAllFunctions() {
        this.m_lFunctions.clear();
    }

    @Override
    public Function[] getFunctions() {
        if (this.m_aFunctions == null) {
            this.m_aFunctions = this.m_lFunctions.toArray(new Function[this.m_lFunctions.size()]);
            Arrays.sort(this.m_aFunctions);
        }
        return this.m_aFunctions;
    }

    @Override
    public String getName() {
        return this.m_sName;
    }

    @Override
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    public int compareTo(Object object) {
        if (object instanceof Category) {
            return this.m_sDisplayName.compareToIgnoreCase(((Category)object).getDisplayName());
        }
        return this.m_sDisplayName.compareToIgnoreCase(object.toString());
    }

    public boolean equals(Object object) {
        if (object instanceof Category) {
            Function[] aFunctions2;
            Category category = (Category)object;
            if (!this.m_sDisplayName.equals(category.getDisplayName()) || !this.m_sName.equals(category.getName())) {
                return false;
            }
            Function[] aFunctions1 = this.getFunctions();
            if (aFunctions1.length != (aFunctions2 = category.getFunctions()).length) {
                return false;
            }
            for (int iFunction = 0; iFunction < aFunctions1.length; ++iFunction) {
                if (aFunctions1[iFunction].equals(aFunctions2[iFunction])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashcode() {
        return super.hashCode();
    }
}

