/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.dualselector;

import com.sas.beans.Util;
import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.swing.visuals.dualselector.BaseDualSelector;
import com.sas.swing.visuals.dualselector.JListDualSelectorAdapter;
import com.sas.workspace.WsSelectionChangedEvent;
import com.sas.workspace.WsSelectionChangedListener;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.visuals.dualselector.JPanelDualSelectorAdapter;
import com.sas.workspace.visuals.dualselector.SelectorPanel;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PanelListSelector
extends BaseDualSelector
implements WsSelectionChangedListener,
ListSelectionListener {
    private boolean clearSelection;
    private transient ListModel targetListModel;
    protected JPanel m_sourceJPanel;
    protected SelectorPanel m_sourceSelectorPanel;
    protected JList m_targetJList;

    public PanelListSelector(JPanel panel) {
        if (!(panel instanceof SelectorPanel)) {
            throw new IllegalArgumentException("The JPanel must implement the SelectorPanel interface.");
        }
        this.setDesignTime(Util.isDesignTime());
        this.targetMaximumCount = -1;
        this.dragAndDropEnabled = true;
        this.sourceAdapter = new JPanelDualSelectorAdapter(panel, (JComponent)((Object)this));
        this.targetAdapter = new JListDualSelectorAdapter((JComponent)((Object)this));
        this.m_sourceJPanel = panel;
        this.m_sourceSelectorPanel = (SelectorPanel)((Object)panel);
        this.m_targetJList = (JList)this.targetAdapter.getComponent();
        this.initializeBaseDualSelector();
        this.m_sourceJPanel.addMouseListener(this.sourceMouseListener);
        this.m_targetJList.addMouseListener(this.targetMouseListener);
        if (this.getTargetModel() == null) {
            this.setTargetModel(new DefaultListModel());
        }
        this.initialized = true;
        this.ensureButtonsEnabled();
        this.addListeners();
        this.updateUI();
    }

    protected void addListeners() {
        super.addListeners();
        this.m_sourceSelectorPanel.removeSelectionChangedListener(this);
        this.m_sourceSelectorPanel.addSelectionChangedListener(this);
        this.m_targetJList.removeListSelectionListener(this);
        this.m_targetJList.addListSelectionListener(this);
    }

    public ListCellRenderer getTargetCellRenderer() {
        return this.m_targetJList.getCellRenderer();
    }

    public void setTargetCellRenderer(ListCellRenderer newValue) {
        ListCellRenderer oldValue = this.m_targetJList.getCellRenderer();
        if (newValue == oldValue) {
            return;
        }
        this.m_targetJList.setCellRenderer(newValue);
        this.firePropertyChange("targetListCellRenderer", oldValue, newValue);
    }

    public ListModel getTargetModel() {
        return this.targetListModel;
    }

    public void setTargetModel(ListModel listModel) throws IllegalArgumentException {
        ListModel oldModel;
        if (listModel instanceof DefaultListModel || listModel instanceof CollectionToListModelAdapter) {
            oldModel = this.targetListModel;
            if (listModel != null) {
                this.targetListModel = listModel;
            }
            if (this.m_targetJList != null) {
                this.m_targetJList.setModel(this.targetListModel);
            } else {
                this.targetListModel = new DefaultListModel();
                if (this.m_targetJList != null) {
                    this.m_targetJList.setModel(this.targetListModel);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.firePropertyChange("targetListModel", oldModel, this.targetListModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectionChanged(WsSelectionChangedEvent ev) {
        WsSelectionProvider source = (WsSelectionProvider)ev.getSource();
        Object[] aObjects = source.getSelectedObjects();
        this.direction = aObjects == null || aObjects.length <= 0;
        if (aObjects != null && aObjects.length > 0) {
            if (this.alternatingMultipleButtonStyle) {
                this.alternatingMultipleButton.setIcon(this.getAlternatingButtonIcon("alternatingMultipleButton", false));
            }
            if (this.alternatingSingleButtonStyle) {
                this.alternatingSingleButton.setIcon(this.getAlternatingButtonIcon("alternatingSingleButton", false));
            }
            this.ensureButtonsEnabled();
            this.clearSelection = true;
            try {
                this.m_targetJList.getSelectionModel().clearSelection();
                this.direction = false;
            }
            finally {
                this.clearSelection = false;
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent ie) {
        this.direction = ie.getFirstIndex() >= 0;
        Object source = ie.getSource();
        if (!this.clearSelection && ie.getFirstIndex() >= 0 && source == this.m_targetJList) {
            if (this.alternatingMultipleButtonStyle) {
                this.alternatingMultipleButton.setIcon(this.getAlternatingButtonIcon("alternatingMultipleButton", true));
            }
            if (this.alternatingSingleButtonStyle) {
                this.alternatingSingleButton.setIcon(this.getAlternatingButtonIcon("alternatingSingleButton", true));
            }
            this.ensureButtonsEnabled();
            this.clearSelection = true;
            try {
                this.m_sourceSelectorPanel.clearSelection();
                this.direction = true;
            }
            finally {
                this.clearSelection = false;
            }
        }
    }
}

