/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.TextStore;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATable;
import com.sas.workspace.WATableModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.TableCellEditorManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellEditor;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WsEngineSpecificPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected cLibraryOptionsTableModel m_libraryModel;
    protected WATable m_optionsTable;
    protected JPanel m_optionsPanel;
    protected TitledBorder titledBorder2;
    protected JLabel standoptlabel;
    private static WAdminResource bundle = WAdminResource.getBundle(WsEngineSpecificPanel.class);

    protected void _initialize() {
        this.standoptlabel = new JLabel(bundle.getString("Label.standoption.txt"));
        this.standoptlabel.setDisplayedMnemonic(bundle.getString("Label.standoptions.mnem").charAt(0));
        this.m_optionsPanel = new JPanel(new BorderLayout());
        this.m_optionsPanel.setPreferredSize(new Dimension(200, 100));
        this.m_libraryModel = new cLibraryOptionsTableModel();
        this.m_libraryModel.setupModel();
        this.m_optionsTable = new WATable((WATableModel)this.m_libraryModel, false);
        this.m_optionsTable.setToolTipColumn(2);
        TableCellEditorManager locem = new TableCellEditorManager(this.m_optionsTable);
        ArrayList cellChoices = null;
        Vector comboItems = null;
        for (int i = 0; i < this.m_optionsTable.getRowCount(); ++i) {
            cellChoices = this.m_libraryModel.getCellChoices(i);
            comboItems = new Vector();
            for (int j = 0; j < cellChoices.size(); ++j) {
                comboItems.add(cellChoices.get(j));
            }
            if (comboItems.size() <= 1) continue;
            locem.setEditorAt(i, new DefaultCellEditor(new JComboBox(comboItems)));
        }
        this.m_optionsTable.getColumn(this.m_optionsTable.getColumnName(1)).setCellEditor(locem);
        this.m_optionsPanel.add((Component)new JScrollPane(this.m_optionsTable), "Center");
        this.m_optionsPanel.setToolTipText(bundle.getString("standoptionsToolTip.txt"));
    }

    public ArrayList getDialogOptions() {
        ArrayList options = new ArrayList();
        for (int i = 0; i < this.m_libraryModel.getRowCount(); ++i) {
            if (this.m_libraryModel.getValueAt(i, 2) == null) continue;
            try {
                Property propertyObject = (Property)this.m_libraryModel.getValueAt(i, 2);
                if (propertyObject.getDefaultValueState() != 1) continue;
                ArrayList<String> option = new ArrayList<String>(3);
                option.add(propertyObject.getName());
                option.add(propertyObject.getPropertyName());
                option.add(propertyObject.getDefaultValue());
                options.add(option);
                continue;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
        }
        return options;
    }

    @Override
    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        if (saveToModel) {
            TableCellEditor editor = this.m_optionsTable.getCellEditor();
            if (editor != null) {
                editor.stopCellEditing();
            }
            for (int i = 0; i < this.m_libraryModel.getRowCount(); ++i) {
                if (this.m_libraryModel.getValueAt(i, 2) == null) continue;
                Property propertyObject = (Property)this.m_libraryModel.getValueAt(i, 3);
                String value = (String)this.m_libraryModel.getValueAt(i, 1);
                if (value == null || propertyObject.getDefaultValue().equals(value)) continue;
                propertyObject.setDefaultValue(value);
            }
        }
        return true;
    }

    class cLibraryOptionsTableModel
    extends WATableModel {
        private static final long serialVersionUID = 1L;
        protected ArrayList m_cellChoices = new ArrayList();
        protected boolean[] m_columnIsEditable = new boolean[]{false, true, false};
        protected boolean[] m_columnIsChoice = new boolean[]{false, false, false};
        protected CMetadata currentMetadata = null;

        public cLibraryOptionsTableModel() {
            this.columnNames.add(bundle.getString("LibraryOptionsTableModel.Name.txt"));
            this.columnNames.add(bundle.getString("LibraryOptionsTableModel.Value.txt"));
            this.columnNames.add(bundle.getString("LibraryOptionsTableModel.Desc.txt"));
        }

        public void setCurrentMetadata(CMetadata cm) {
            this.currentMetadata = cm;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setupModel() {
            MdObjectStore m_store = null;
            try {
                m_store = Workspace.getMdFactory().createObjectStore();
                CMetadata repos = null;
                List repositories = Workspace.getMdFactory().getOMIUtil().getRepositories();
                for (int j = 0; j < repositories.size(); ++j) {
                    repos = (CMetadata)repositories.get(j);
                    String sOptions = "<XMLSELECT Search=\"*[@MetadataType='SASLibrary'][PrototypeProperties/AttributeProperty[@PropertyName='Engine' and @DefaultValue='ORACLE']]\"/><TEMPLATES><Prototype Id=\"\" Name=\"\"><Properties/></Prototype><Property Id=\"\" Name=\"\" Desc=\"\" PropertyName=\"\" IsRequired=\"\" IsVisible=\"\" IsUpdateable=\"\" DefaultValue=\"\"><OwningType/></Property><PropertyType Id=\"\" SQLType=\"\"><StoredConfiguration/></PropertyType><TextStore Id=\"\" TextType=\"\" StoredText=\"\"/><DeployedComponent Id=\"\"/></TEMPLATES>";
                    List properties = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)m_store, repos.getFQID(), "Prototype", 396, sOptions);
                    if (properties.size() == 0) continue;
                    for (int k = 0; k < properties.size(); ++k) {
                        Prototype prototype = (Prototype)properties.get(k);
                        AssociationList options = prototype.getProperties();
                        for (int i = 0; i < options.size(); ++i) {
                            if (!(options.elementAt(i) instanceof Property)) continue;
                            ArrayList<String> rowData = new ArrayList<String>();
                            ArrayList<String> choices = new ArrayList<String>();
                            Property option = (Property)options.elementAt(i);
                            PropertyType owningType = option.getOwningType();
                            TextStore storedConfig = (TextStore)owningType.getStoredConfiguration();
                            String storedText = null;
                            Document doc = null;
                            NodeList secondLevelList = null;
                            NodeList thirdLevelList = null;
                            Node docNode = null;
                            NamedNodeMap attributeMap = null;
                            if (storedConfig != null) {
                                storedText = storedConfig.getStoredText();
                            }
                            if (storedText != null && (doc = Workspace.getMdFactory().getOMIUtil().parseXML(storedText)).hasChildNodes()) {
                                secondLevelList = doc.getFirstChild().getChildNodes();
                                for (int m = 0; m < secondLevelList.getLength(); ++m) {
                                    docNode = secondLevelList.item(m);
                                    if (!docNode.getNodeName().equalsIgnoreCase("Enumeration")) continue;
                                    thirdLevelList = docNode.getChildNodes();
                                    for (int n = 0; n < thirdLevelList.getLength(); ++n) {
                                        docNode = thirdLevelList.item(n);
                                        if (!docNode.hasAttributes() || (docNode = (attributeMap = docNode.getAttributes()).getNamedItem("name")) == null) continue;
                                        choices.add(docNode.getNodeValue());
                                    }
                                }
                            }
                            rowData.add(option.getName());
                            rowData.add(option.getDefaultValue());
                            rowData.add(option.getDesc());
                            rowData.add((String)option);
                            this.data.add(rowData);
                            this.m_cellChoices.add(choices);
                        }
                    }
                }
                if (this.data.size() > 0) {
                    this.fireTableRowsInserted(0, this.data.size() - 1);
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage(e, "Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException(re);
            }
            finally {
                try {
                    m_store.dispose();
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException(ex);
                }
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return this.m_columnIsEditable[col];
        }

        @Override
        public String getColumnName(int col) {
            return (String)this.columnNames.get(col);
        }

        public String getRowName(int row) {
            return String.valueOf(row + 1);
        }

        public Object getRowValue(int row) {
            return String.valueOf(row + 1);
        }

        public ArrayList getCellChoices(int row) {
            return (ArrayList)this.m_cellChoices.get(row);
        }
    }
}

