/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTabGroup;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WorkspaceOMAView;
import com.sas.workspace.WsAbstractIconFactory;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.visuals.AppServerPanel;
import com.sas.workspace.visuals.WsEditorPropertyTab;
import com.sas.workspace.visuals.WsLogPropertyTab;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import javax.swing.Icon;

public class WsEditorOMAView
extends WorkspaceOMAView {
    private static WAdminResource bundle = WAdminResource.getBundle(WsEditorOMAView.class);
    private static final String SHOW_CODE_KEY = "com.sas.wadmin.visuals.WAPFDEditorOMAView.ShowEditor";
    private static final String SHOW_LOG_KEY = "com.sas.wadmin.visuals.WAPFDEditorOMAView.ShowLog";
    private static final String SHOW_OUTPUT_KEY = "com.sas.wadmin.visuals.WAPFDEditorOMAView.ShowOutput";
    private static int g_nEditorInstances;
    protected boolean m_bEditorPresent;
    protected boolean m_bLogPresent;
    protected boolean m_bOutputPresent;
    protected boolean m_bListeningForDefaultAppServerChanges;
    protected String m_sHostname;
    protected String m_sFileName;
    protected String m_sStatus;
    private String m_sOldAppServerStatus;
    protected WsEditorPropertyTab m_tabEditor;
    protected WsLogPropertyTab m_tabLog;
    protected WsLogPropertyTab m_tabOutput;
    protected PropertyChangeListener m_lsnrAppDefaults;

    public WsEditorOMAView() {
        WorkspaceFile fileAppDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        this.m_bEditorPresent = true;
        this.m_bLogPresent = fileAppDefaults.getPropertyBoolean(SHOW_LOG_KEY, this.isLogShownByDefault());
        this.m_bOutputPresent = fileAppDefaults.getPropertyBoolean(SHOW_OUTPUT_KEY, this.isOutputShownByDefault());
        this.m_sHostname = Workspace.getAppServerName();
        this.m_lsnrAppDefaults = this.createAppDefaultsListener();
        this.m_bListeningForDefaultAppServerChanges = true;
        fileAppDefaults.addPropertyChangeListener(this.m_lsnrAppDefaults);
        Workspace.getWorkspace().getWorkspaceFile().addPropertyChangeListener(this.m_lsnrAppDefaults);
    }

    @Override
    public WAPropertyTabGroup createView() {
        super.createView();
        this.createTabs();
        return this.createTabGroup();
    }

    @Override
    public void dispose() {
        WorkspaceFile fileAppDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        fileAppDefaults.removePropertyChangeListener(this.m_lsnrAppDefaults);
        Workspace.getWorkspace().getWorkspaceFile().removePropertyChangeListener(this.m_lsnrAppDefaults);
        this.m_lsnrAppDefaults = null;
        if (!this.m_bEditorPresent) {
            this.m_tabEditor.saveSettingsAndCleanUp();
        }
        if (!this.m_bLogPresent) {
            this.m_tabLog.saveSettingsAndCleanUp();
        }
        if (!this.m_bOutputPresent) {
            this.m_tabOutput.saveSettingsAndCleanUp();
        }
        this.m_tabEditor = null;
        this.m_tabLog = null;
        this.m_tabOutput = null;
        super.dispose();
    }

    @Override
    protected String getFrameTitle() {
        String title = this.m_sFileName.length() > 0 ? bundle.formatString("WsEditorOMAView.Frame.title.fmt", this.m_sHostname, this.m_sFileName) : bundle.formatString("WsEditorOMAView.Frame.NoFilename.title.fmt", this.m_sHostname);
        if (this.m_sStatus != null && this.m_sStatus.length() > 0) {
            title = title + ": " + this.m_sStatus;
        }
        return title;
    }

    @Override
    protected Icon getFrameIcon() {
        return WsAbstractIconFactory.getInstance().getIconForAction("Common:CodeEditor");
    }

    protected String createEditorFileName() {
        if (++g_nEditorInstances == 1) {
            return bundle.getString("Common.Untitled.txt");
        }
        return bundle.formatString("Common.Untitled.fmt", new Integer(g_nEditorInstances));
    }

    protected void createTabs() {
        this.m_tabEditor = this.createEditorPropertyTab();
        this.m_tabLog = this.createLogPropertyTab();
        this.m_tabOutput = this.createOutputPropertyTab();
        this.m_tabEditor.setLogTab(this.m_tabLog);
        this.m_tabEditor.setOutputTab(this.m_tabOutput);
    }

    protected WAPropertyTabGroup createTabGroup() {
        WAPropertyTabGroup tabs = new WAPropertyTabGroup();
        if (this.m_bEditorPresent) {
            tabs.addTab(this.m_tabEditor.getName(), this.m_tabEditor);
        }
        if (this.m_bLogPresent) {
            tabs.addTab(this.m_tabLog.getName(), this.m_tabLog);
        }
        if (this.m_bOutputPresent) {
            tabs.addTab(this.m_tabOutput.getName(), this.m_tabOutput);
        }
        return tabs;
    }

    protected WsEditorPropertyTab createEditorPropertyTab() {
        WsEditorPropertyTab tab = new WsEditorPropertyTab();
        this.m_sFileName = this.createEditorFileName();
        tab.setTemporaryFileName(this.m_sFileName);
        tab.addPropertyChangeListener("FileNameProperty", this.createFileNameChangeListener());
        tab.setOwningView(this);
        return tab;
    }

    protected WsLogPropertyTab createLogPropertyTab() {
        WsLogPropertyTab tab = new WsLogPropertyTab(1);
        tab.setName(bundle.getString("WsEditorOMAView.LogTab.title.txt"));
        tab.setOwningView(this);
        return tab;
    }

    protected WsLogPropertyTab createOutputPropertyTab() {
        WsLogPropertyTab tab = new WsLogPropertyTab(2);
        tab.setName(bundle.getString("WsEditorOMAView.OutputTab.title.txt"));
        tab.setOwningView(this);
        return tab;
    }

    public void showEditorTab() {
        this.setEditorTabPresent(true);
        this.getPropertyFrame().showTab(this.m_tabEditor);
    }

    public void setEditorTabPresent(boolean bPresent) {
        if (bPresent != this.m_bEditorPresent) {
            this.m_bEditorPresent = bPresent;
            if (this.m_bEditorPresent) {
                this.getPropertyFrame().addTab(this.m_tabEditor.getName(), this.m_tabEditor);
            } else {
                this.getPropertyFrame().removeTab(this.m_tabEditor);
            }
        }
    }

    public boolean isEditorTabPresent() {
        return this.m_bEditorPresent;
    }

    public void showLogTab() {
        this.setLogTabPresent(true);
        this.getPropertyFrame().showTab(this.m_tabLog);
    }

    public void setLogTabPresent(boolean bPresent) {
        if (bPresent != this.m_bLogPresent) {
            this.m_bLogPresent = bPresent;
            if (this.m_bLogPresent) {
                this.getPropertyFrame().addTab(this.m_tabLog.getName(), this.m_tabLog);
            } else {
                this.getPropertyFrame().removeTab(this.m_tabLog);
            }
        }
    }

    public boolean isLogTabPresent() {
        return this.m_bLogPresent;
    }

    public void showOutputTab() {
        this.setOutputTabPresent(true);
        this.getPropertyFrame().showTab(this.m_tabOutput);
    }

    public void setOutputTabPresent(boolean bPresent) {
        if (bPresent != this.m_bOutputPresent) {
            this.m_bOutputPresent = bPresent;
            if (this.m_bOutputPresent) {
                this.getPropertyFrame().addTab(this.m_tabOutput.getName(), this.m_tabOutput);
            } else {
                this.getPropertyFrame().removeTab(this.m_tabOutput);
            }
        }
    }

    public boolean isOutputTabPresent() {
        return this.m_bOutputPresent;
    }

    public WsEditorPropertyTab getEditorTab() {
        return this.m_tabEditor;
    }

    protected void setLastAppServerStatus(String lastStatus) {
        this.m_sOldAppServerStatus = lastStatus;
    }

    public String getLastAppServerStatus() {
        return this.m_sOldAppServerStatus;
    }

    protected String getDefaultsPrefix() {
        return this.getClass().getName();
    }

    public boolean isEditorShownByDefault() {
        return true;
    }

    protected boolean isLogShownByDefault() {
        return true;
    }

    protected boolean isOutputShownByDefault() {
        return true;
    }

    public void setListenForDefaultAppServerChanges(boolean bListen) {
        this.m_bListeningForDefaultAppServerChanges = bListen;
    }

    public boolean isListeningForDefaultAppServerChanges() {
        return this.m_bListeningForDefaultAppServerChanges;
    }

    public void updateTitleWithDefaultAppServerChanges() throws MdException, RemoteException {
        String sHostname = WsAppServer.getDefaultAppServerName();
        if (sHostname != null && !sHostname.equals(AppServerPanel.DefaultServerId)) {
            this.m_sHostname = sHostname;
            this.setLastAppServerStatus(this.m_sStatus);
            this.m_sStatus = "";
            if (sHostname.length() > 0) {
                String title = this.getFrameTitle();
                this.getFrame().setTitle(title);
            }
        }
    }

    public void updateTitleWithStatusChanges(String sNewStatus, String sFileName, String sHostName) {
        this.setLastAppServerStatus(this.m_sStatus);
        this.m_sStatus = sNewStatus;
        this.m_sHostname = sHostName;
        this.m_sFileName = sFileName;
        String title = sFileName.length() > 0 ? bundle.formatString("WsEditorOMAView.Frame.title.fmt", sHostName, sFileName) : bundle.formatString("WsEditorOMAView.Frame.NoFilename.title.fmt", sHostName);
        if (this.m_sStatus != null && this.m_sStatus.length() > 0) {
            title = title + ": " + this.m_sStatus;
        }
        this.getFrame().setTitle(title);
    }

    public void updateTitleWithStatusChanges(String sNewStatus, String sHostName) {
        this.setLastAppServerStatus(this.m_sStatus);
        this.m_sStatus = sNewStatus;
        this.m_sHostname = sHostName;
        String title = bundle.formatString("WsEditorOMAView.Frame.NoFilename.title.fmt", sHostName);
        if (this.m_sStatus != null && this.m_sStatus.length() > 0) {
            title = title + ": " + this.m_sStatus;
        }
        this.getFrame().setTitle(title);
    }

    protected PropertyChangeListener createAppDefaultsListener() {
        return new cAppDefaultsListener();
    }

    protected PropertyChangeListener createFileNameChangeListener() {
        return new cFileNameChangeListener();
    }

    protected class cFileNameChangeListener
    implements PropertyChangeListener {
        protected cFileNameChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("FileNameProperty")) {
                WsEditorOMAView.this.m_sFileName = (String)e.getNewValue();
                WsEditorOMAView.this.getFrame().setTitle(WsEditorOMAView.this.getFrameTitle());
            }
        }
    }

    protected class cAppDefaultsListener
    implements PropertyChangeListener {
        protected cAppDefaultsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            WsEditorOMAView.this.setEditorTabPresent(true);
            if (e.getPropertyName().equals(WsEditorOMAView.SHOW_LOG_KEY)) {
                WsEditorOMAView.this.setLogTabPresent((Boolean)e.getNewValue());
            }
            if (e.getPropertyName().equals(WsEditorOMAView.SHOW_OUTPUT_KEY)) {
                WsEditorOMAView.this.setOutputTabPresent((Boolean)e.getNewValue());
            }
            if (WsEditorOMAView.this.m_bListeningForDefaultAppServerChanges && e.getPropertyName().equals(AppServerPanel.DefaultServerId)) {
                try {
                    String sHostname = WsAppServer.getDefaultAppServerName();
                    if (sHostname != null && !sHostname.equals(AppServerPanel.DefaultServerId)) {
                        WsEditorOMAView.this.m_sHostname = sHostname;
                        WsEditorOMAView.this.setLastAppServerStatus(WsEditorOMAView.this.m_sStatus);
                        WsEditorOMAView.this.m_sStatus = "";
                        if (((String)e.getNewValue()).length() > 0) {
                            String title = WsEditorOMAView.this.getFrameTitle();
                            WsEditorOMAView.this.getFrame().setTitle(title);
                        }
                    }
                }
                catch (MdException me) {
                    MessageUtil.displayMetadataExceptionMessage(me, "Accessing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException(re);
                }
            }
        }
    }
}

