/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.editor.CodeEditor;
import com.sas.editor.CodeEditorPane;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractIconFactory;
import com.sas.workspace.WsExternalDataPropertyTabInterface;
import com.sas.workspace.visuals.WsEditorOMAView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;

public abstract class WsAbstractEditorPropertyTab
extends WAPropertyTab
implements WsExternalDataPropertyTabInterface {
    private static final WAdminResource bundle = WAdminResource.getBundle(WsAbstractEditorPropertyTab.class);
    public static final String FILE_NAME_PROPERTY = "FileNameProperty";
    public static final int CODE = 0;
    public static final int LOG = 1;
    public static final int OUTPUT = 2;
    protected String m_sFileName;
    protected boolean m_bRealFileName;
    protected WsEditorOMAView m_view;
    protected CodeEditor m_cmpEditor;
    protected CodeEditorPane m_txtEditor;
    protected WsAbstractAction m_actOpen;
    protected WsAbstractAction m_actSave;
    protected WsAbstractAction m_actSaveAs;
    protected WsAbstractAction m_actPrint;
    protected WsAbstractAction m_actPageSetup;
    protected WsAbstractAction m_actUndo;
    protected WsAbstractAction m_actRedo;
    protected WsAbstractAction m_actCut;
    protected WsAbstractAction m_actCopy;
    protected WsAbstractAction m_actPaste;
    protected WsAbstractAction m_actSelectAll;
    protected WsAbstractAction m_actClear;
    protected WsAbstractAction m_actFindReplace;
    protected WsAbstractAction m_actPopupMenu;
    protected int m_eType;

    public WsAbstractEditorPropertyTab(int eType) {
        this.m_eType = eType;
        String sNameKey = eType == 0 ? "WsAbstractEditorPropertyTab.Name.Code.txt" : (eType == 1 ? "WsAbstractEditorPropertyTab.Name.Log.txt" : "WsAbstractEditorPropertyTab.Name.Output.txt");
        this.setName(bundle.getString(sNameKey));
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public boolean validateData() {
        return true;
    }

    @Override
    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.setStorePopulated(true);
    }

    @Override
    public void moveDataToView() throws MdException, RemoteException {
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this.m_cmpEditor != null ? this.m_cmpEditor.getEditorPane() : null;
    }

    @Override
    public String getContentsName() {
        return this.getName();
    }

    @Override
    public boolean getSaveContentsDefault() {
        return true;
    }

    @Override
    public boolean saveExternalData() {
        return this.save();
    }

    public void setFileName(String sFileName) {
        String sOldFileName = this.m_sFileName;
        this.m_sFileName = sFileName;
        this.m_bRealFileName = true;
        this.firePropertyChange(FILE_NAME_PROPERTY, sOldFileName, this.m_sFileName);
    }

    public void setTemporaryFileName(String sFileName) {
        String sOldFileName = this.m_sFileName;
        this.m_sFileName = sFileName;
        this.m_bRealFileName = false;
        this.firePropertyChange(FILE_NAME_PROPERTY, sOldFileName, this.m_sFileName);
    }

    public String getFileName() {
        return this.m_sFileName;
    }

    public void setOwningView(WsEditorOMAView view) {
        this.m_view = view;
    }

    public WsEditorOMAView getOwningView() {
        return this.m_view;
    }

    public CodeEditorPane getEditorPane() {
        return this.m_txtEditor;
    }

    public boolean open() {
        int savePrompt;
        if (this.hasDataChanged() && (savePrompt = this.promptedSave()) != 0 && savePrompt != 1) {
            return false;
        }
        try {
            boolean brc = this.m_cmpEditor.dlgOpen((JFrame)Workspace.getWorkspace());
            if (brc) {
                this.setFileName(this.m_txtEditor.getCodeEditorDocument().getFilename());
                this.setDataChanged(false);
            }
            return brc;
        }
        catch (IOException e) {
            MessageUtil.displayMessage(e.getLocalizedMessage(), this.getName(), 0);
            return false;
        }
    }

    public int promptedSave() {
        int status = MessageUtil.displayMessage(bundle.getString("WsAbstractEditorPropertyTab.SaveChanges.txt"), bundle.getString("WsAbstractEditorPropertyTab.SaveChanges.title.txt"), 1, 1);
        if (status == 0) {
            this.save();
        }
        return status;
    }

    @Override
    public boolean save() {
        if (this.m_bRealFileName) {
            try {
                boolean brc = this.m_cmpEditor.save((JFrame)Workspace.getWorkspace());
                this.setDataChanged(false);
                this.updateActions();
                return brc;
            }
            catch (IOException e) {
                MessageUtil.displayMessage(e.getLocalizedMessage(), this.getName(), 0);
                return false;
            }
        }
        return this.saveAs();
    }

    public boolean saveAs() {
        try {
            boolean brc = this.m_cmpEditor.dlgSaveAs((JFrame)Workspace.getWorkspace());
            if (brc) {
                this.setFileName(this.m_txtEditor.getCodeEditorDocument().getFilename());
                this.setDataChanged(false);
            }
            return brc;
        }
        catch (IOException e) {
            MessageUtil.displayMessage(e.getLocalizedMessage(), this.getName(), 0);
            return false;
        }
    }

    public void clear() {
        this.m_txtEditor.getCodeEditorDocument().doClearAll();
    }

    public void setText(String sText) {
        this.m_txtEditor.setText(sText);
    }

    public String getText() {
        return this.m_txtEditor.getText();
    }

    public String getSelectedText() {
        return this.m_txtEditor.getSelectedText();
    }

    public boolean isTextSelected() {
        String selectedText = this.getSelectedText();
        return selectedText != null && selectedText.length() > 0;
    }

    public void scrollToTop() {
        this.m_txtEditor.setCaretPosition(0);
    }

    @Override
    protected void initialize() {
        this.m_cmpEditor = this.createEditor();
        this.m_txtEditor = this.m_cmpEditor.getEditorPane();
        this.m_cmpEditor.enablePromptForUnsavedData(false);
        this.m_txtEditor.addCaretListener(this.createCaretListener());
        this.createActions();
        this.updateActions();
        this.addActionsToKeymap();
    }

    @Override
    protected void layoutWidgets() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_cmpEditor);
        this.setPreferredSize(new Dimension(400, 200));
    }

    protected abstract CodeEditor createEditor();

    protected CaretListener createCaretListener() {
        return new cCaretListener();
    }

    protected abstract void createActions();

    protected abstract void updateActions();

    protected void addActionsToKeymap() {
        this.m_txtEditor.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(121, 1), this.m_actPopupMenu);
        this.m_txtEditor.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(112, 0));
    }

    protected void removeActionsFromKeymap() {
        this.m_txtEditor.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(121, 1));
    }

    protected WsAbstractAction createOpenAction() {
        return new cOpenAction();
    }

    protected WsAbstractAction createSaveAction() {
        return new cSaveAction();
    }

    protected WsAbstractAction createSaveAsAction() {
        return new cSaveAsAction();
    }

    protected WsAbstractAction createPageSetupAction() {
        return new cPageSetupAction();
    }

    protected WsAbstractAction createPrintAction() {
        return new cPrintAction();
    }

    protected WsAbstractAction createUndoAction() {
        return new cUndoAction();
    }

    protected WsAbstractAction createRedoAction() {
        return new cRedoAction();
    }

    protected WsAbstractAction createCutAction() {
        return new cCutAction();
    }

    protected WsAbstractAction createCopyAction() {
        return new cCopyAction();
    }

    protected WsAbstractAction createPasteAction() {
        return new cPasteAction();
    }

    protected WsAbstractAction createSelectAllAction() {
        return new cSelectAllAction();
    }

    protected WsAbstractAction createClearAction() {
        return new cClearAction();
    }

    protected WsAbstractAction createFindReplaceAction() {
        return new cFindReplaceAction();
    }

    protected WsAbstractAction createPopupMenuAction() {
        return new cPopupMenuAction();
    }

    @Override
    public boolean noSaveSaysDontWrite() {
        return false;
    }

    protected class cPopupMenuAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        protected cPopupMenuAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Rectangle rectCaret;
            try {
                int pos = WsAbstractEditorPropertyTab.this.m_txtEditor.getCaretPosition();
                rectCaret = WsAbstractEditorPropertyTab.this.m_txtEditor.modelToView(pos);
            }
            catch (BadLocationException ex) {
                rectCaret = new Rectangle(0, 0, 0, 0);
            }
            JPopupMenu menuPopup = WsAbstractEditorPropertyTab.this.m_txtEditor.getPopupMenu();
            menuPopup.show((Component)WsAbstractEditorPropertyTab.this.m_txtEditor, rectCaret.x, rectCaret.y);
        }
    }

    protected class cFindReplaceAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cFindReplaceAction() {
            this.setMenuSupportId("findreplace");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsAbstractEditorPropertyTab.this.m_txtEditor.dlgFind();
        }
    }

    protected class cClearAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;
        Action m_actEditorClear;

        public cClearAction() {
            this.setHidable(true);
            this.setMenuSupportId("clear");
            this.m_actEditorClear = WsAbstractEditorPropertyTab.this.m_txtEditor.getActionMap().get("clear-all");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_actEditorClear.actionPerformed(e);
        }
    }

    protected class cSelectAllAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cSelectAllAction() {
            this.setMenuSupportId("selectall");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsAbstractEditorPropertyTab.this.m_txtEditor.selectAll();
        }
    }

    protected class cPasteAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cPasteAction() {
            super(bundle, "WsAbstractEditorPropertyTab.Paste", 16);
            this.setMenuSupportId("paste");
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Paste"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsAbstractEditorPropertyTab.this.m_txtEditor.paste();
        }
    }

    protected class cCopyAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cCopyAction() {
            super(bundle, "WsAbstractEditorPropertyTab.Copy", 16);
            this.setMenuSupportId("copy");
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Copy"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsAbstractEditorPropertyTab.this.m_txtEditor.copy();
        }
    }

    protected class cCutAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cCutAction() {
            super(bundle, "WsAbstractEditorPropertyTab.Cut", 16);
            this.setMenuSupportId("cut");
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Cut"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsAbstractEditorPropertyTab.this.m_txtEditor.cut();
        }
    }

    protected class cRedoAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;
        Action m_actEditorRedo;

        public cRedoAction() {
            this.setMenuSupportId("redo");
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Redo"));
            this.m_actEditorRedo = WsAbstractEditorPropertyTab.this.m_txtEditor.getActionMap().get("redo");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_actEditorRedo.actionPerformed(e);
        }
    }

    protected class cUndoAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;
        Action m_actEditorUndo;

        public cUndoAction() {
            this.setMenuSupportId("undo");
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Undo"));
            this.m_actEditorUndo = WsAbstractEditorPropertyTab.this.m_txtEditor.getActionMap().get("undo");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_actEditorUndo.actionPerformed(e);
        }
    }

    protected class cPrintAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cPrintAction() {
            this.setMenuSupportId("print");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsAbstractEditorPropertyTab.this.m_cmpEditor.printDlg();
        }
    }

    protected class cPageSetupAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cPageSetupAction() {
            this.setMenuSupportId("pagesetup");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsAbstractEditorPropertyTab.this.m_cmpEditor.pageSetupDlg();
        }
    }

    protected class cSaveAsAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cSaveAsAction() {
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:SaveAs"));
            this.setMenuSupportId("saveas");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsAbstractEditorPropertyTab.this.saveAs();
        }
    }

    protected class cSaveAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cSaveAction() {
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Save"));
            this.setMenuSupportId("save");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsAbstractEditorPropertyTab.this.save();
        }
    }

    protected class cOpenAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cOpenAction() {
            super(bundle, "WsAbstractEditorPropertyTab.Open", 16);
            this.setMenuSupportId("open");
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Open"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsAbstractEditorPropertyTab.this.open();
        }
    }

    protected class cCaretListener
    implements CaretListener {
        protected cCaretListener() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            WsAbstractEditorPropertyTab.this.updateActions();
        }
    }
}

