/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WorkspaceTreeModel;
import com.sas.workspace.WsTreeNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class RepositoryPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected WorkspaceTree m_treeBrowse;
    protected JLabel m_jGroupLabel;
    protected boolean m_fBorder = false;
    protected Tree m_parentTree = null;
    protected CMetadata m_parentRepository;
    private static WAdminResource bundle = WAdminResource.getBundle(RepositoryPanel.class);

    public RepositoryPanel(boolean fBorder, WorkspaceTree treeBrowse) {
        this.m_fBorder = fBorder;
        this.m_treeBrowse = treeBrowse != null ? treeBrowse : Workspace.getWorkspace().getBrowseTree();
        this.initialize();
        this.layoutWidgets();
    }

    public RepositoryPanel(boolean fBorder) {
        this.m_fBorder = fBorder;
        this.m_treeBrowse = Workspace.getWorkspace().getBrowseTree();
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    protected void initialize() {
        this.m_jGroupLabel = new JLabel();
        if (this.m_fBorder) {
            TitledBorder titledBorder1 = new TitledBorder(bundle.getString("RepositoryPanel.Groupbox.txt"));
            this.setBorder(titledBorder1);
        }
    }

    @Override
    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        JLabel tempLabel = new JLabel(bundle.getString("RepositoryPanel.GroupParent.txt"));
        JScrollPane treeScrollPane = new JScrollPane(this.m_treeBrowse, 22, 30);
        treeScrollPane.setBorder(BorderFactory.createBevelBorder(1));
        treeScrollPane.setToolTipText(bundle.getString("RepositoryPanel.GroupParent.Tooltip.txt"));
        treeScrollPane.setPreferredSize(new Dimension(200, 150));
        tempLabel.setDisplayedMnemonic(bundle.getString("RepositoryPanel.GroupParent.mnem").charAt(0));
        tempLabel.setLabelFor(treeScrollPane);
        this.add((Component)tempLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)treeScrollPane, new GridBagConstraints(0, 1, 3, 2, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    @Override
    public boolean validateData() {
        return true;
    }

    @Override
    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
        if (!bSaveToModel) {
            TreePath path;
            WsTreeNode node;
            WsTreeNode node2;
            this.m_treeBrowse.initialize();
            this.m_treeBrowse.setListenForChanges(false);
            String strDefaultName = Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("LastSelectedTreeNameRepositoryPanel");
            String strDefaultID = Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("LastSelectedTreeIDRepositoryPanel");
            boolean fFound = false;
            if (strDefaultName.length() > 0 && (node2 = ((WorkspaceTreeModel)this.m_treeBrowse.getModel()).getNodebyNameAndFQID(strDefaultName, strDefaultID)) != null) {
                fFound = true;
                TreePath path2 = new TreePath(node2.getPath());
                this.m_treeBrowse.expandPath(path2);
                this.m_treeBrowse.setSelectionPath(path2);
            }
            String defaultTreeRole = (String)myParent.getWizardData("DEFAULTTREEROLE");
            if (!fFound && defaultTreeRole != null && (node = ((WorkspaceTreeModel)this.m_treeBrowse.getModel()).getTreeNodebyRole(defaultTreeRole)) != null) {
                fFound = true;
                path = new TreePath(node.getPath());
                this.m_treeBrowse.expandPath(path);
                this.m_treeBrowse.setSelectionPath(path);
            }
            if (!fFound && (node = ((WorkspaceTreeModel)this.m_treeBrowse.getModel()).getFirstRepository()) != null) {
                fFound = true;
                path = new TreePath(node.getPath());
                this.m_treeBrowse.expandPath(path);
                this.m_treeBrowse.setSelectionPath(path);
            }
        } else {
            CMetadata metaObject = this.m_treeBrowse.getSelectedNode().getMetadata();
            boolean fGroupSelected = true;
            this.m_parentTree = null;
            if (metaObject.getFQID().indexOf("A0000001") > -1) {
                this.m_parentRepository = metaObject;
                fGroupSelected = false;
            }
            if (fGroupSelected) {
                TreeNode[] nodeArray = this.m_treeBrowse.getSelectedNode().getPath();
                for (int i = 0; i < nodeArray.length; ++i) {
                    WsTreeNode tempnode = (WsTreeNode)nodeArray[i];
                    if (tempnode.getMetadata() == null || tempnode.getMetadata().getFQID().indexOf("A0000001") <= -1) continue;
                    this.m_parentRepository = tempnode.getMetadata();
                    break;
                }
                String nodeName = this.m_treeBrowse.getSelectedNode().getMetadata().getName();
                String nodeID = this.m_treeBrowse.getSelectedNode().getMetadata().getFQID();
                Workspace.getWorkspace().getAppDefaultsFile().setPropertyString("LastSelectedTreeNameRepositoryPanel", nodeName);
                Workspace.getWorkspace().getAppDefaultsFile().setPropertyString("LastSelectedTreeIDRepositoryPanel", nodeID);
                this.m_parentTree = null;
                try {
                    MdObjectStore store = (MdObjectStore)myParent.getWizardData("OBJECTSTORE");
                    this.m_parentTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, "", "Tree", metaObject.getFQID());
                    Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_parentTree, null, null, "", 8);
                }
                catch (MdException e) {
                    MessageUtil.displayMetadataExceptionMessage(e, "Reading");
                    return false;
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException(re);
                }
            }
        }
        return true;
    }

    public CMetadata getSelectedRepository() {
        return this.m_parentRepository;
    }

    public CMetadata getSelectedGroup() {
        return this.m_parentTree;
    }
}

