/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WARootPane;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsButtonsLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class MetadataMIMBCheckBoxDialog
extends WAStandardDialog {
    private static final long serialVersionUID = 1L;
    public static final String ShowProperty = "MIMB.ShowWarning";
    protected JButton m_btnOK;
    private static WAdminResource m_bundle = new WAdminResource(MetadataMIMBCheckBoxDialog.class);

    public MetadataMIMBCheckBoxDialog(JFrame frmOwner) {
        super(Workspace.getWorkspace(), m_bundle.getString("MetadataCommon.NoClassDef.Title.txt"), true);
        this.setResizable(true);
    }

    public void doShow(boolean bIgnoreSetting) {
        WorkspaceFile AppDefs;
        if (!bIgnoreSetting && !(AppDefs = Workspace.getWorkspace().getAppDefaultsFile()).getPropertyBoolean(ShowProperty, true)) {
            return;
        }
        this.setMainPanel(new cMainPanel());
        if (SwingUtilities.isEventDispatchThread()) {
            this.show();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MetadataMIMBCheckBoxDialog.this.show();
                }
            });
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
    }

    @Override
    protected void updateButtonsPanel() {
        this.removeKeyListeners(this.m_pnlButtons, this.m_KeyHandler);
        this.m_pnlButtons.removeAll();
        this.m_pnlButtons.setLayout(new WsButtonsLayout());
        this.m_pnlButtons.add(this.m_btnOk);
        ((WARootPane)this.getRootPane()).setRealDefaultButton(this.m_btnOk);
        this.addKeyListeners(this.m_pnlButtons, this.m_KeyHandler);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
    }

    protected class cMainPanel
    extends WAPanel {
        private static final long serialVersionUID = 1L;
        protected JCheckBox m_ckbDisable;
        protected WATextArea m_txtMsg1;
        protected WATextArea m_txtMsg2;

        public cMainPanel() {
            this.initialize();
            this.layoutWidgets();
        }

        @Override
        protected void initialize() {
            this.m_ckbDisable = new JCheckBox(m_bundle.getString("MetadataWarningDialog.Disable.txt"));
            this.m_txtMsg1 = new WATextArea(4, 56);
            this.m_txtMsg2 = new WATextArea(5, 56);
            this.m_ckbDisable.setMnemonic(m_bundle.getString("MetadataWarningDialog.CheckBox.mnem").charAt(0));
            this.m_txtMsg1.setBehavior(1);
            this.m_txtMsg1.setLineWrap(true);
            this.m_txtMsg1.setWrapStyleWord(true);
            this.m_txtMsg1.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.m_txtMsg2.setBehavior(1);
            this.m_txtMsg2.setLineWrap(true);
            this.m_txtMsg2.setWrapStyleWord(true);
            this.m_txtMsg2.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }

        @Override
        protected void layoutWidgets() {
            this.setLayout(new GridBagLayout());
            this.add((Component)this.m_txtMsg1, new GridBagConstraints(1, 1, 1, 1, 0.5, 1.0, 11, 1, new Insets(5, 5, 0, 0), 0, 0));
            this.add((Component)this.m_txtMsg2, new GridBagConstraints(1, 2, 1, 1, 0.5, 1.0, 11, 1, new Insets(5, 5, 0, 0), 0, 0));
            this.add((Component)this.m_ckbDisable, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        }

        @Override
        public boolean validateData() {
            return true;
        }

        @Override
        public boolean doDataExchange(boolean bExchangeToModel) throws MdException, RemoteException {
            WorkspaceFile AppDefs = Workspace.getWorkspace().getAppDefaultsFile();
            if (bExchangeToModel) {
                AppDefs.setPropertyBoolean(MetadataMIMBCheckBoxDialog.ShowProperty, !this.m_ckbDisable.isSelected());
            } else {
                String sMsg1 = m_bundle.getString("MetadataCommon.MINotFound.txt");
                String sMsg2 = m_bundle.getString("MetadataCommon.MINotFound2.txt");
                this.m_txtMsg1.setText(sMsg1);
                this.m_txtMsg2.setText(sMsg2);
                MetadataMIMBCheckBoxDialog.this.m_btnHelp.setEnabled(false);
            }
            return true;
        }
    }
}

