/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.services.security.RemoteCallbackHandler;
import com.sas.services.security.RemoteNameCallbackInterface;
import com.sas.services.security.RemotePasswordCallbackInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.visuals.LogonView;
import java.awt.Dialog;
import java.awt.Window;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.swing.JFrame;

public class LoginCallbackHandler
implements RemoteCallbackHandler {
    private String m_strHostName = null;
    static WAdminResource m_bundle = new WAdminResource(LoginCallbackHandler.class);

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException, RemoteException {
        RemoteNameCallbackInterface rnCallback = null;
        RemotePasswordCallbackInterface rpCallback = null;
        for (int cbIndex = 0; cbIndex < callbacks.length; ++cbIndex) {
            Callback callback = callbacks[cbIndex];
            if (callback instanceof RemoteNameCallbackInterface) {
                rnCallback = (RemoteNameCallbackInterface)callback;
                continue;
            }
            if (callback instanceof RemotePasswordCallbackInterface) {
                rpCallback = (RemotePasswordCallbackInterface)callback;
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unrecognized Callback!");
        }
        String strPrompt = m_bundle.getString("LoginCallbackHandler.LogOn.txt");
        if (this.m_strHostName != null && this.m_strHostName.length() > 0) {
            strPrompt = m_bundle.formatString("LoginCallbackHandler.LogOn.fmt.txt", this.m_strHostName);
        } else if (rnCallback != null && rnCallback.getPrompt() != null && rnCallback.getPrompt().length() > 0) {
            strPrompt = rnCallback.getPrompt();
        } else if (rpCallback != null && rpCallback.getPrompt() != null && rpCallback.getPrompt().length() > 0) {
            strPrompt = rpCallback.getPrompt();
        }
        Window parent = MessageUtil.getMainWindow();
        LogonView panel = new LogonView();
        WAStandardDialog dialog = null;
        if (parent instanceof JFrame) {
            dialog = new LoginDialog((JFrame)parent, panel);
        }
        if (parent instanceof Dialog) {
            dialog = new LoginDialog((Dialog)parent, panel);
        }
        dialog.setModal(true);
        dialog.setTitle(strPrompt);
        if (rnCallback != null && rnCallback.getPrompt() != null && rnCallback.getPrompt().length() > 0) {
            ((LoginDialog)dialog).setUserNamePrompt(rnCallback.getPrompt());
        }
        if (rpCallback != null && rpCallback.getPrompt() != null && rpCallback.getPrompt().length() > 0) {
            ((LoginDialog)dialog).setPasswordPrompt(rpCallback.getPrompt());
        }
        dialog.show();
        if (dialog.getReturnValue() == 1) {
            String strUserName = panel.getUserName();
            String strPassword = panel.getPassword();
            if (rnCallback != null && rpCallback != null) {
                rnCallback.setName(strUserName);
                rpCallback.setPassword(strPassword.toCharArray());
            }
        } else {
            throw new IOException(m_bundle.getString("LoginCallbackHandler.NoCredentials.txt"));
        }
    }

    public void setHostName(String name) {
        this.m_strHostName = name;
    }

    private class LoginDialog
    extends WAStandardDialog {
        private String m_strUserNamePrompt;
        private String m_strPasswordPrompt;
        private LogonView m_pnlView;
        private static final long serialVersionUID = 4483879654724372745L;

        public LoginDialog(JFrame parent, LogonView panel) {
            super(parent);
            this.m_strUserNamePrompt = null;
            this.m_strPasswordPrompt = null;
            this.m_pnlView = null;
            this.initialize(panel);
        }

        public LoginDialog(Dialog parent, LogonView panel) {
            super(parent);
            this.m_strUserNamePrompt = null;
            this.m_strPasswordPrompt = null;
            this.m_pnlView = null;
            this.initialize(panel);
        }

        protected void initialize(LogonView panel) {
            this.setHelpProduct("shared");
            this.setHelpTopic("newlogin");
            this.setMainPanel(panel);
            this.m_pnlView = panel;
        }

        @Override
        public void dispose() {
            String strUserName = this.m_pnlView.getUserName();
            String strPassword = this.m_pnlView.getPassword();
            if (this.getReturnValue() == 1) {
                if (strUserName.trim().length() == 0) {
                    String strMessage = m_bundle.getString("LoginDialog.UsernameRequired.txt");
                    if (this.m_strUserNamePrompt != null) {
                        strMessage = m_bundle.formatString("Common.IsRequired.fmt.txt", this.m_strUserNamePrompt);
                    }
                    MessageUtil.displayMessage(strMessage, 0);
                    return;
                }
                if (strPassword.trim().length() == 0) {
                    String strMessage = m_bundle.getString("LoginDialog.PasswordRequired.txt");
                    if (this.m_strPasswordPrompt != null) {
                        strMessage = m_bundle.formatString("Common.IsRequired.fmt.txt", this.m_strPasswordPrompt);
                    }
                    MessageUtil.displayMessage(strMessage, 0);
                    return;
                }
            }
            super.dispose();
        }

        public void setUserNamePrompt(String prompt) {
            this.m_strUserNamePrompt = prompt;
        }

        public void setPasswordPrompt(String prompt) {
            this.m_strPasswordPrompt = prompt;
        }
    }
}

