/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;

public class LegalNoticeDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton m_okButton;
    private JScrollPane m_textScrollPane;
    private String m_copyright;
    private String m_thirdPartyInfo;
    private static WAdminResource bundle = WAdminResource.getBundle(LegalNoticeDialog.class);
    private static String m_lineSeparator = "\r\n\n";

    public LegalNoticeDialog(JDialog parent, String copyright, String thirdPartyInfo) {
        super((Dialog)parent, true);
        this.setTitle(bundle.getString("Common.LegalNotices.txt"));
        this.setResizable(false);
        this.setSize(400, 300);
        this.m_copyright = copyright;
        this.m_thirdPartyInfo = thirdPartyInfo;
        this._initialize();
        this._layoutWidgets();
        this.setLocationRelativeTo(parent);
    }

    protected void _initialize() {
        this.m_okButton = new JButton(bundle.getString("Common.OK.txt"));
        this.m_okButton.setPreferredSize(new Dimension(80, 24));
        this.m_okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LegalNoticeDialog.this.dispose();
            }
        });
        String legalText = this.m_copyright.concat(m_lineSeparator);
        legalText = legalText.concat(bundle.getString("LegalNotices.GeneralProtection.txt"));
        legalText = legalText.concat(m_lineSeparator);
        legalText = legalText.concat(bundle.getString("LegalNotices.GovtRestrictedRights.Title.txt"));
        legalText = legalText.concat("\n");
        legalText = legalText.concat(bundle.getString("LegalNotices.GovtRestrictedRights.Desc.txt"));
        if (this.m_thirdPartyInfo != null) {
            legalText = legalText.concat(m_lineSeparator);
            legalText = legalText.concat(this.m_thirdPartyInfo);
        }
        WATextArea textArea = new WATextArea();
        textArea.setBehavior(1);
        textArea.setText(legalText);
        textArea.setSize(350, 280);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setCaretPosition(0);
        this.m_textScrollPane = new JScrollPane(textArea, 22, 31);
    }

    protected void _layoutWidgets() {
        GridBagLayout gbl = new GridBagLayout();
        Container cp = this.getContentPane();
        cp.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(12, 12, 0, 12);
        gbl.setConstraints(this.m_textScrollPane, gbc);
        cp.add(this.m_textScrollPane);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 10;
        gbc.insets = new Insets(12, 12, 12, 12);
        gbl.setConstraints(this.m_okButton, gbc);
        cp.add(this.m_okButton);
    }
}

