/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.expressions.visuals.DataSourceNodeInterface;
import com.sas.expressions.visuals.DataSourceTreeInterface;
import com.sas.expressions.visuals.DataValuesInterface;
import com.sas.expressions.visuals.DistinctValuesInterface;
import com.sas.expressions.visuals.ExpressionBuilderPanel;
import com.sas.expressions.visuals.FormattedValuesInterface;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.RowSelector;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.TransformationStep;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.ExpressionParser;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.visuals.expression.ExpressionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class ExpressionBuilderTab
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(ExpressionBuilderTab.class);
    protected ExpressionBuilderPanel m_builder;
    protected AbstractTransformation m_Metadata;
    protected String m_sExpression;
    protected ArrayList m_Cols;
    protected ArrayList m_Tables;
    protected boolean m_useSQLSyntax = false;
    protected boolean m_bUseMetadata = true;
    protected boolean m_bTokenizeExpression = false;
    protected boolean m_bUseQuotes = false;
    protected boolean m_bAllowAutoGen;
    protected String m_columnGroupNodeName;

    public ExpressionBuilderTab(CMetadata inMetadata) {
        this.m_Metadata = (AbstractTransformation)inMetadata;
        this.initialize();
        this.layoutWidgets();
    }

    public ExpressionBuilderTab(CMetadata inMetadata, boolean useSQLSyntax) {
        this.m_Metadata = (AbstractTransformation)inMetadata;
        this.setUseSQLSyntax(useSQLSyntax);
        this.initialize();
        this.layoutWidgets();
    }

    public ExpressionBuilderTab(CMetadata inMetadata, boolean useSQLSyntax, boolean bUseMetadata, boolean bTokenizeExpression) {
        this.m_Metadata = (AbstractTransformation)inMetadata;
        this.setUseSQLSyntax(useSQLSyntax);
        this.m_bUseMetadata = bUseMetadata;
        this.m_bTokenizeExpression = bTokenizeExpression;
        this.initialize();
        this.layoutWidgets();
    }

    public ExpressionBuilderTab(ArrayList cols, ArrayList tables, boolean useSQLSyntax) {
        this.m_Metadata = null;
        this.m_Cols = cols;
        this.m_Tables = tables;
        boolean useQuotes = false;
        if (tables != null) {
            for (int i = 0; i < tables.size(); ++i) {
                DataTable table = (DataTable)tables.get(i);
                try {
                    if (!DBMSNamesPropertyHandler.needQuotes(table)) continue;
                    useQuotes = true;
                    continue;
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage(exc, "Accessing");
                    continue;
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException(re);
                }
            }
        }
        this.setUseQuotes(useQuotes);
        this.setUseSQLSyntax(useSQLSyntax);
        this.initialize();
        this.layoutWidgets();
    }

    public ExpressionBuilderTab(ArrayList cols) {
        this.m_Metadata = null;
        this.m_Cols = cols;
        this.initialize();
        this.layoutWidgets();
    }

    public ExpressionBuilderTab(ArrayList cols, boolean useSQLSyntax) {
        this.m_Metadata = null;
        this.m_Cols = cols;
        this.setUseSQLSyntax(useSQLSyntax);
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public boolean validateData() {
        String returnval = this.m_builder.validateLineLengths(false);
        if (returnval != null) {
            MessageUtil.displayMessage(returnval, 0);
            return false;
        }
        return true;
    }

    public void setShowValidationBtn(boolean isShwoValidationBtn) {
        this.m_builder.setValidationButtonVisible(isShwoValidationBtn);
    }

    @Override
    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        String oldExpression = this.m_sExpression;
        this.m_sExpression = this.m_builder.getExpressionText();
        TextStore src = null;
        if (this.m_Metadata instanceof TransformationStep) {
            TransformationStep ts = (TransformationStep)this.m_Metadata;
            AssociationList lMaps = ts.getTransformations();
            RowSelector rowsel = null;
            ClassifierMap map = null;
            if (lMaps.size() > 0) {
                map = (ClassifierMap)lMaps.get(0);
                rowsel = map.getAssociatedRowSelector();
            }
            if (saveToModel) {
                if (this.m_bUseMetadata && this.m_sExpression.compareTo(oldExpression) != 0) {
                    if (rowsel == null) {
                        String reposID = Workspace.getWorkspace().getDefaultRepository().getFQID().substring(9);
                        rowsel = (RowSelector)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_Metadata.getObjectStore(), null, "Where Clause", "RowSelector", reposID);
                        map.getAssociatedRowSelectors().add((Object)rowsel);
                        src = (TextStore)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_Metadata.getObjectStore(), null, "Where Source", "TextStore", reposID);
                        rowsel.getSourceCodes().flushAll();
                        rowsel.getSourceCodes().add((Object)src);
                    } else {
                        src = (TextStore)rowsel.getSourceCode();
                    }
                    if (this.m_bTokenizeExpression & !map.getClassifierSources().isEmpty()) {
                        DataTable tblSource = (DataTable)map.getClassifierSources().get(0);
                        boolean bCaseSensitive = this.useQuotes();
                        this.m_sExpression = ExpressionParser.tokenizeString(this.m_sExpression, (List)tblSource.getColumns(), (AbstractTransformation)map, this.useQuotes(), bCaseSensitive);
                    }
                    src.setStoredText(this.m_sExpression);
                }
            } else {
                this.setListeningForChanges(false);
                if (this.m_bUseMetadata) {
                    if (!map.getClassifierSources().isEmpty()) {
                        DataTable tblSource = (DataTable)map.getClassifierSources().get(0);
                        this.setUseQuotes(DBMSNamesPropertyHandler.needQuotes(tblSource));
                    }
                    if (rowsel != null) {
                        this.m_sExpression = ((TextStore)rowsel.getSourceCode()).getStoredText();
                        if (this.m_bTokenizeExpression) {
                            this.m_sExpression = ExpressionParser.detokenizeString(this.m_sExpression, (AbstractTransformation)map, this.useQuotes());
                        }
                        this.m_builder.setExpressionText(this.m_sExpression);
                    }
                }
                this.m_builder.setDataSourceTreeModel((TreeModel)new MyDataSourceTree(this.m_Metadata));
                this.setListeningForChanges(true);
            }
        } else if (this.m_Metadata instanceof FeatureMap) {
            FeatureMap fm = (FeatureMap)this.m_Metadata;
            src = (TextStore)fm.getSourceCode();
            if (saveToModel) {
                if (src == null) {
                    String reposID = Workspace.getWorkspace().getDefaultRepository().getFQID().substring(9);
                    src = (TextStore)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_Metadata.getObjectStore(), null, "FeatureMap Source", "TextStore", reposID);
                    src.setStoredText(this.m_sExpression);
                    fm.getSourceCodes().flushAll();
                    fm.getSourceCodes().add((Object)src);
                } else {
                    src.setStoredText(this.m_sExpression);
                }
            } else {
                this.m_builder.setDataSourceTreeModel((TreeModel)new MyDataSourceTree(this.m_Metadata));
                if (src != null) {
                    this.m_sExpression = src.getStoredText();
                    this.m_builder.setExpressionText(this.m_sExpression);
                }
            }
        } else if (this.m_Metadata == null && !saveToModel) {
            if (this.m_Tables == null) {
                this.m_builder.setDataSourceTreeModel((TreeModel)new MyDataSourceTree(this.m_Cols));
            } else {
                this.m_builder.setDataSourceTreeModel((TreeModel)new MyDataSourceTree(this.m_Cols, this.m_Tables));
            }
        }
        return true;
    }

    @Override
    protected void initialize() {
        this.m_builder = this.createExpressionPanel();
        this.m_builder.setMaximumLineLength(255);
        this.listenForDataChangesTo((JTextComponent)this.m_builder.getExpressionTextPane());
        this.setHelpTopic("about");
        this.setHelpProduct("expbuild");
        this.m_columnGroupNodeName = bundle.getString("ExpressionBuilderTab.MappedColumnsNode.txt");
    }

    protected ExpressionBuilderPanel createExpressionPanel() {
        return new ExpressionPanel();
    }

    @Override
    protected void layoutWidgets() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_builder, "Center");
    }

    @Override
    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_builder.setReadOnly(false);
    }

    @Override
    public void saveSettingsAndCleanUp() {
        this.m_builder.dispose();
        super.saveSettingsAndCleanUp();
    }

    public boolean useSQLSyntax() {
        return this.m_useSQLSyntax;
    }

    public void setUseSQLSyntax(boolean useSQLSyntax) {
        this.m_useSQLSyntax = useSQLSyntax;
    }

    public void setColumnGroupNodeName(String name) {
        this.m_columnGroupNodeName = name;
    }

    public boolean useQuotes() {
        return this.m_bUseQuotes;
    }

    public void setUseQuotes(boolean bUseQuotes) {
        this.m_bUseQuotes = bUseQuotes;
    }

    public void setExpression(String sExpression) {
        this.m_builder.setExpressionText(sExpression);
    }

    public String getExpression() {
        return this.m_builder.getExpressionText();
    }

    protected String quoteName(String sName) {
        if (this.useQuotes()) {
            return "'" + sName + "'n";
        }
        return sName;
    }

    class MyDataSourceTree
    extends DefaultTreeModel
    implements DataSourceTreeInterface {
        private static final long serialVersionUID = 1L;

        MyDataSourceTree(AbstractTransformation obj) {
            super(new DefaultMutableTreeNode());
            TreeNode initRoot = this.buildRootNode((CMetadata)obj);
            this.setRoot(initRoot);
        }

        MyDataSourceTree(ArrayList cols) {
            super(new DefaultMutableTreeNode());
            TreeNode initRoot = this.buildRootNode(cols);
            this.setRoot(initRoot);
        }

        MyDataSourceTree(ArrayList cols, ArrayList tbls) {
            super(new DefaultMutableTreeNode());
            TreeNode initRoot = this.buildRootNode(cols, tbls);
            this.setRoot(initRoot);
        }

        protected TreeNode buildRootNode(ArrayList cols) {
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
            for (int i = 0; i < cols.size(); ++i) {
                Column col = (Column)cols.get(i);
                ColumnNode colNode = new ColumnNode(col);
                rootNode.add(colNode);
            }
            return rootNode;
        }

        protected TreeNode buildRootNode(ArrayList cols, ArrayList tbls) {
            int i;
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
            DefaultMutableTreeNode mappedNode = new DefaultMutableTreeNode(ExpressionBuilderTab.this.m_columnGroupNodeName);
            for (i = 0; i < cols.size(); ++i) {
                Column col = (Column)cols.get(i);
                ColumnNode colNode = new ColumnNode(col, ExpressionBuilderTab.this.useSQLSyntax());
                mappedNode.add(colNode);
            }
            if (cols.size() > 0) {
                rootNode.add(mappedNode);
            }
            for (i = 0; i < tbls.size(); ++i) {
                DataTable tbl = (DataTable)tbls.get(i);
                TableNode tblNode = new TableNode(tbl);
                rootNode.add(tblNode);
                try {
                    AssociationList columns = tbl.getColumns();
                    for (int iCol = 0; iCol < columns.size(); ++iCol) {
                        Column col = (Column)columns.get(iCol);
                        ColumnNode colNode = new ColumnNode(col);
                        tblNode.add(colNode);
                    }
                    continue;
                }
                catch (MdException e) {
                    MessageUtil.displayMetadataExceptionMessage(e, "Reading");
                    break;
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException(re);
                }
            }
            return rootNode;
        }

        protected TreeNode buildRootNode(CMetadata metadata) {
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
            try {
                if (metadata instanceof TransformationStep) {
                    TransformationStep ts = (TransformationStep)metadata;
                    Vector<Object> tabs = new Vector<Object>();
                    AssociationList maps = ts.getTransformations();
                    ClassifierMap map = (ClassifierMap)maps.get(0);
                    AssociationList inputs = map.getClassifierSources();
                    for (int j = 0; j < inputs.size(); ++j) {
                        if (!(inputs.get(j) instanceof DataTable)) continue;
                        tabs.add(inputs.get(j));
                    }
                    for (int i = 0; i < tabs.size(); ++i) {
                        DataTable tab = (DataTable)tabs.get(i);
                        AssociationList cols = tab.getColumns();
                        TableNode tabNode = new TableNode(tab);
                        rootNode.add(tabNode);
                        for (int j = 0; j < cols.size(); ++j) {
                            Column col = (Column)cols.get(j);
                            ColumnNode colNode = new ColumnNode(col);
                            tabNode.add(colNode);
                        }
                    }
                    tabs = null;
                } else if (metadata instanceof FeatureMap) {
                    FeatureMap fm = (FeatureMap)metadata;
                    AssociationList cols = fm.getFeatureSources();
                    for (int i = 0; i < cols.size(); ++i) {
                        Column col = (Column)cols.get(i);
                        ColumnNode colNode = new ColumnNode(col);
                        rootNode.add(colNode);
                    }
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage(e, "Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException(re);
            }
            return rootNode;
        }

        public TreeCellRenderer getJTreeCellRenderer(JTree tree) {
            return new SourceNodeRenderer();
        }

        class ColumnNode
        extends DefaultMutableTreeNode
        implements DataSourceNodeInterface {
            private static final long serialVersionUID = 1L;
            private String m_name;
            private String m_displayName;
            private String m_description;
            private String m_insertName;
            private Column m_column;

            ColumnNode(String name, String displayName, String desc, String insertName) {
                super(displayName);
                this.m_name = name;
                this.m_displayName = displayName;
                this.m_description = desc;
                this.m_insertName = insertName;
            }

            ColumnNode(Column col, boolean bUseInsertNameForDisplay) {
                this(col);
                if (bUseInsertNameForDisplay) {
                    this.m_displayName = this.m_insertName;
                    this.setUserObject(this.m_insertName);
                }
            }

            ColumnNode(Column col) {
                this.m_column = col;
                try {
                    String name;
                    this.setUserObject(col.getName());
                    this.m_name = col.getName();
                    this.m_displayName = col.getName();
                    this.m_description = col.getDesc();
                    if (ExpressionBuilderTab.this.useSQLSyntax()) {
                        DataTable tbl = col.getTable();
                        name = tbl instanceof PhysicalTable ? ((PhysicalTable)tbl).getSASTableName() : tbl.getName();
                        if ((name = ExpressionBuilderTab.this.quoteName(name)).trim().length() > 0) {
                            name = name + ".";
                        }
                    } else {
                        name = "";
                    }
                    this.m_insertName = name + ExpressionBuilderTab.this.quoteName(col.getSASColumnName()) + " ";
                }
                catch (MdException name) {
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException(re);
                }
            }

            public String getName() {
                return this.m_name;
            }

            public String getDisplayName() {
                return this.m_displayName;
            }

            public String getDescription() {
                return this.m_description;
            }

            public String getInsertName() {
                return this.m_insertName;
            }

            public Column getColumn() {
                return this.m_column;
            }

            public String getToolTip() {
                return this.m_description;
            }

            public DataValuesInterface getDataValuesInterface() {
                return null;
            }

            public DistinctValuesInterface getDistinctValuesInterface() {
                return null;
            }

            public FormattedValuesInterface getFormattedValuesInterface() {
                return null;
            }
        }

        protected class TableNode
        extends DefaultMutableTreeNode
        implements DataSourceNodeInterface {
            private static final long serialVersionUID = 1L;
            private DataTable m_table;
            private String m_name;
            private String m_displayName;
            private String m_description;
            private String m_insertName;

            TableNode(DataTable tbl, String name, String displayName, String desc, String insertName) {
                super(displayName);
                this.m_table = tbl;
                this.m_name = name;
                this.m_displayName = displayName;
                this.m_description = desc;
                this.m_insertName = insertName;
            }

            TableNode(DataTable tbl) {
                String name = "";
                try {
                    name = tbl instanceof PhysicalTable ? ((PhysicalTable)tbl).getSASTableName() : tbl.getName();
                    this.m_description = tbl.getDesc();
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException(re);
                }
                this.m_table = tbl;
                this.m_name = name;
                this.m_displayName = name;
                this.m_insertName = null;
                this.setUserObject(name);
            }

            public DataTable getTable() {
                return this.m_table;
            }

            public String getName() {
                return this.m_name;
            }

            public String getDisplayName() {
                return this.m_displayName;
            }

            public String getDescription() {
                return this.m_description;
            }

            public String getToolTip() {
                return this.m_description;
            }

            public String getInsertName() {
                return this.m_insertName;
            }

            public DataValuesInterface getDataValuesInterface() {
                return null;
            }

            public DistinctValuesInterface getDistinctValuesInterface() {
                return null;
            }

            public FormattedValuesInterface getFormattedValuesInterface() {
                return null;
            }
        }

        protected class SourceNodeRenderer
        extends DefaultTreeCellRenderer {
            private static final long serialVersionUID = 1L;

            public SourceNodeRenderer() {
                this.setLeafIcon(WorkspaceTree.getDefaultLeafIcon());
                this.setOpenIcon(WorkspaceTree.getOpenedFolderIcon());
                this.setClosedIcon(WorkspaceTree.getClosedFolderIcon());
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object node, boolean bSelected, boolean bExpanded, boolean bLeaf, int iRow, boolean bHasFocus) {
                JLabel lbl = (JLabel)super.getTreeCellRendererComponent(tree, node, bSelected, bExpanded, bLeaf, iRow, bHasFocus);
                Icon icon = null;
                if (node instanceof TableNode) {
                    icon = WAdminResource.getCMTypeIcon((CMetadata)((TableNode)node).getTable(), false);
                } else if (node instanceof ColumnNode) {
                    Column col = ((ColumnNode)node).getColumn();
                    icon = WsColumnMetadataUtil.getColumnTypeIcon(col);
                }
                if (icon != null) {
                    lbl.setIcon(icon);
                }
                return lbl;
            }
        }
    }
}

