/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.JCheckBox;

public class DBMSNamesPropertiesPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(DBMSNamesPropertiesPanel.class);
    protected Root m_oMetadata;
    protected JCheckBox m_ckbCase;
    protected JCheckBox m_ckbSpecChar;
    protected JCheckBox m_ckbFormatsInformats;
    protected String Case = null;
    protected String SpecChar = null;
    protected boolean m_isSASTable;
    protected boolean m_Global;
    protected boolean m_ShowFormatsInformatsCheckbox;
    protected boolean m_CreateFormatsInformats;
    protected WsAbstractAction m_actCase;
    protected WsAbstractAction m_actSpecChar;
    protected WsAbstractAction m_actFormatsInformats;

    public DBMSNamesPropertiesPanel() {
        this(null, false, false, true);
    }

    public DBMSNamesPropertiesPanel(Root Meta) {
        this(Meta, false, false);
    }

    public DBMSNamesPropertiesPanel(Root Meta, boolean bisSASTable) {
        this(Meta, bisSASTable, false);
    }

    public DBMSNamesPropertiesPanel(Root Meta, boolean bisSASTable, boolean bGlobal) {
        this(Meta, bisSASTable, bGlobal, false);
    }

    public DBMSNamesPropertiesPanel(Root Meta, boolean bisSASTable, boolean bGlobal, boolean bShowFormatsInformatsCheckbox) {
        this.m_oMetadata = Meta;
        this.m_isSASTable = bisSASTable;
        this.m_Global = bGlobal;
        this.m_ShowFormatsInformatsCheckbox = bShowFormatsInformatsCheckbox;
        this.initialize();
        this.layoutWidgets();
        this.setHelpTopic("DBMSNamesProperties_panel");
    }

    @Override
    public boolean validateData() {
        this.Case = this.m_ckbCase.isSelected() ? "Y" : "N";
        if (this.m_ckbSpecChar.isSelected()) {
            this.SpecChar = "Y";
            this.Case = "Y";
        } else {
            this.SpecChar = "N";
        }
        if (this.m_ShowFormatsInformatsCheckbox) {
            this.m_CreateFormatsInformats = this.m_ckbFormatsInformats.isSelected();
        }
        return true;
    }

    @Override
    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (bSaveToModel) {
            this.moveDataToStore();
        } else {
            if (!this.m_isSASTable) {
                this.populateStore();
            }
            this.setListeningForChanges(false);
            this.moveDataToView();
            this.setListeningForChanges(true);
        }
        return true;
    }

    @Override
    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        if (this.m_oMetadata != null) {
            this.Case = DBMSNamesPropertyHandler.getCasePropertyValue(this.m_oMetadata);
            if (this.Case == "") {
                this.Case = DBMSNamesPropertyHandler.getGlobalCaseValue();
            }
            this.SpecChar = DBMSNamesPropertyHandler.getSpecCharPropertyValue(this.m_oMetadata);
            if (this.SpecChar == "") {
                this.SpecChar = DBMSNamesPropertyHandler.getGlobalSpecCharValue();
            }
        } else {
            this.Case = DBMSNamesPropertyHandler.getGlobalCaseValue();
            Container toplevelobject = this.getTopLevelAncestor();
            this.SpecChar = DBMSNamesPropertyHandler.getGlobalSpecCharValue();
            if (toplevelobject instanceof WAWizardDialog) {
                WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
                if (myParent != null && myParent.getWizardData("ENGINETYPE") != null && ((String)myParent.getWizardData("ENGINETYPE")).equalsIgnoreCase("SASIOIME")) {
                    this.SpecChar = "Y";
                } else if (myParent != null && myParent.getWizardData("ENGINETYPE") != null && (((String)myParent.getWizardData("ENGINETYPE")).equalsIgnoreCase("POSTGRES") || ((String)myParent.getWizardData("ENGINETYPE")).equalsIgnoreCase("SASIORST"))) {
                    this.Case = "Y";
                    this.SpecChar = "Y";
                } else if (myParent != null && myParent.getWizardData("ENGINETYPE") != null && ((String)myParent.getWizardData("ENGINETYPE")).equalsIgnoreCase("SASIOPI")) {
                    this.Case = "Y";
                } else {
                    this.SpecChar = DBMSNamesPropertyHandler.getGlobalSpecCharValue();
                }
            }
        }
        this.setStorePopulated(true);
    }

    @Override
    public void moveDataToView() {
        if (!this.m_isSASTable) {
            boolean bSpecChar = this.SpecChar.equals("Y");
            this.m_ckbSpecChar.setSelected(bSpecChar);
            if (bSpecChar) {
                this.m_ckbCase.setSelected(true);
                this.m_actCase.setEnabled(false);
            } else {
                this.setEditable(true);
                this.m_ckbCase.setSelected(this.Case.equals("Y"));
            }
        } else {
            this.m_ckbSpecChar.setSelected(false);
            this.m_ckbCase.setSelected(false);
            this.setEditable(false);
        }
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        if (this.m_isSASTable) {
            this.Case = "N";
            this.SpecChar = "N";
        } else {
            this.Case = this.m_ckbCase.isSelected() ? "Y" : "N";
            String string = this.SpecChar = this.m_ckbSpecChar.isSelected() ? "Y" : "N";
        }
        if (this.m_oMetadata != null) {
            DBMSNamesPropertyHandler.createDBMSNamesPropertySet(this.m_oMetadata, this.Case, this.SpecChar);
        }
        if (this.m_Global) {
            this.setGlobal();
        }
        this.setDataChanged(false);
    }

    @Override
    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_actSpecChar.setEnabled(bEditable);
        if (bEditable) {
            if (!this.m_ckbSpecChar.isSelected()) {
                this.m_actCase.setEnabled(bEditable);
            }
        } else {
            this.m_actCase.setEnabled(bEditable);
        }
    }

    public void setGlobal() {
        if (this.m_ckbSpecChar.isSelected()) {
            DBMSNamesPropertyHandler.setGlobalSpecCharValue("Y");
            DBMSNamesPropertyHandler.setGlobalCaseValue("Y");
        } else {
            DBMSNamesPropertyHandler.setGlobalSpecCharValue("N");
            if (this.m_ckbCase.isSelected()) {
                DBMSNamesPropertyHandler.setGlobalCaseValue("Y");
            } else {
                DBMSNamesPropertyHandler.setGlobalCaseValue("N");
            }
        }
    }

    public void setSASTable(boolean bisSASTable) {
        this.m_isSASTable = bisSASTable;
    }

    public String getCaseValue() {
        return this.Case == null ? "N" : this.Case;
    }

    public String getSpecCharValue() {
        return this.SpecChar == null ? "N" : this.SpecChar;
    }

    public boolean getFormatsInformatsValue() {
        return this.m_CreateFormatsInformats;
    }

    public void setPanelVisible(boolean bVisible) {
        this.m_ckbSpecChar.setVisible(bVisible);
        this.m_ckbCase.setVisible(bVisible);
    }

    public void setPanelClear(boolean bClear) {
        this.m_ckbSpecChar.setSelected(false);
        this.m_ckbCase.setSelected(false);
    }

    @Override
    protected void initialize() {
        this.createActions();
        this.m_ckbCase = new JCheckBox(this.m_actCase);
        this.m_ckbSpecChar = new JCheckBox(this.m_actSpecChar);
        if (this.m_ShowFormatsInformatsCheckbox) {
            this.m_ckbFormatsInformats = new JCheckBox(this.m_actFormatsInformats);
            this.m_ckbFormatsInformats.setSelected(true);
        }
        this.listenForDataChangesTo(this.m_ckbCase);
        this.listenForDataChangesTo(this.m_ckbSpecChar);
    }

    protected void createActions() {
        this.m_actCase = this.createCaseAction();
        this.m_actSpecChar = this.createSpecCharAction();
        if (this.m_ShowFormatsInformatsCheckbox) {
            this.m_actFormatsInformats = this.createFormatsInformatsAction();
        }
    }

    protected WsAbstractAction createCaseAction() {
        return new cCaseAction();
    }

    protected WsAbstractAction createSpecCharAction() {
        return new cSpecCharAction();
    }

    protected WsAbstractAction createFormatsInformatsAction() {
        return new cFormatsInformatsAction();
    }

    @Override
    protected void layoutWidgets() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_ckbCase, "North");
        this.add((Component)this.m_ckbSpecChar, "South");
        if (this.m_ShowFormatsInformatsCheckbox) {
            this.add((Component)this.m_ckbSpecChar, "Center");
            this.add((Component)this.m_ckbFormatsInformats, "South");
        }
    }

    public void onNext() {
        try {
            this.populateStore();
            this.moveDataToView();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage(e, "Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
    }

    public void setMetadataObject(Root metadata) {
        this.m_oMetadata = metadata;
    }

    public void setCase(boolean isCaseSensitive) {
        this.m_ckbCase.setSelected(isCaseSensitive);
    }

    protected class cFormatsInformatsAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cFormatsInformatsAction() {
            super(bundle, "DBMSNamesProperties.CreateFormatsInformats", 0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    protected class cSpecCharAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cSpecCharAction() {
            super(bundle, "DBMSNamesProperties.SpecChar", false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DBMSNamesPropertiesPanel.this.m_ckbSpecChar.isSelected()) {
                DBMSNamesPropertiesPanel.this.m_ckbCase.setSelected(true);
                DBMSNamesPropertiesPanel.this.m_actCase.setEnabled(false);
            } else {
                DBMSNamesPropertiesPanel.this.m_actCase.setEnabled(true);
            }
        }
    }

    protected class cCaseAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cCaseAction() {
            super(bundle, "DBMSNamesProperties.Case", false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

