/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.editor.LogListHolder;
import com.sas.metadata.remote.CMetadata;
import com.sas.workspace.AppServer;
import com.sas.workspace.AppServerCodeErrorException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WALoginDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;

public class CodeSubmitter {
    public static final String DEFAULT_SERVER_ID = "AppServer.Default";
    private static WAdminResource bundle = WAdminResource.getBundle(CodeSubmitter.class);
    protected AppServer m_AppServer;
    protected cCodeSubmitter m_submitter = this.createCodeSubmitter();
    protected int m_status;
    protected String m_sExceptionMessage;
    protected String m_sSASCode;
    protected LogListHolder m_hldrLog;
    protected LogListHolder m_hldrOutput;
    protected String m_execDesc;
    protected String m_execTitle;
    protected boolean m_searchLogForError = false;
    protected StringBuffer m_logText;
    private static final String ERRORSTRING = "ERROR:";

    public CodeSubmitter() {
    }

    public CodeSubmitter(boolean searchLogForError) {
        this();
        this.m_searchLogForError = searchLogForError;
    }

    public CodeSubmitter(String execTitle, String execDesc) {
        this();
        this.m_execDesc = execDesc;
        this.m_execTitle = execTitle;
    }

    public CodeSubmitter(String execTitle, String execDesc, boolean searchLogForError) {
        this(execTitle, execDesc);
        this.m_searchLogForError = searchLogForError;
    }

    public void dispose() {
        if (this.m_AppServer != null) {
            this.m_AppServer.dropConnection();
            this.m_AppServer.termAppServer();
            this.m_AppServer = null;
        }
    }

    public int getStatus() {
        return this.m_status;
    }

    public String getMessage() {
        return this.m_sExceptionMessage;
    }

    public LogListHolder getLogText() {
        return this.m_hldrLog;
    }

    public StringBuffer getLogStringText() {
        return this.m_logText;
    }

    public LogListHolder getOutputText() {
        return this.m_hldrOutput;
    }

    public boolean submitCode(StringBuffer codeToSubmit, CMetadata metaObject, boolean genMacroOptions) {
        return this.submitCode(codeToSubmit, metaObject, genMacroOptions, true);
    }

    public boolean submitCode(StringBuffer codeToSubmit, CMetadata metaObject, boolean genMacroOptions, boolean displayAppServerMessages) {
        boolean fStatus = true;
        if (codeToSubmit == null || codeToSubmit.length() == 0) {
            MessageUtil.displayMessage(bundle.getString("CodeSubmitter.NothingToSubmit.txt"));
            return true;
        }
        if (this.m_AppServer == null) {
            this.m_AppServer = Workspace.getWorkspace().makeAppServer(false);
        }
        if (this.m_AppServer == null) {
            MessageUtil.displayMessage(bundle.getString("CodeSubmitter.AppServerNotFound.txt"));
            return true;
        }
        try {
            StringBuffer buffer = new StringBuffer();
            if (genMacroOptions) {
                WorkspaceFile wsFile = Workspace.getWorkspace().getWorkspaceFile();
                SASCodeGeneration sasCode = new SASCodeGeneration();
                if ("".equals(wsFile.getPropertyString("userid", "").trim()) || "".equals(wsFile.getPropertyString("password", "").trim())) {
                    WALoginDialog waLoginDlg = new WALoginDialog(Workspace.getWorkspace(), bundle.getString("CodeSubmitter.MetadataDialog.Title.txt"), false);
                    waLoginDlg.show();
                    String metaUser = waLoginDlg.getUsername();
                    String metaPassword = Workspace.getMdFactory().getUtil().decrypt(waLoginDlg.getPassword());
                    waLoginDlg.dispose();
                    buffer.append(sasCode.getMetadataMacrosAndOptions(metaObject, this.m_AppServer.getServerContext(), true, metaUser, metaPassword));
                } else {
                    buffer.append(sasCode.getMetadataMacrosAndOptions(metaObject, this.m_AppServer.getServerContext(), true));
                }
            }
            buffer.append(codeToSubmit);
            fStatus = this.submitCodeToAppServer(buffer.toString(), displayAppServerMessages);
        }
        catch (Exception e) {
            MessageUtil.displayMessage(e.getLocalizedMessage(), 0);
            Workspace.getDefaultLogger().error((Object)"", e);
        }
        return fStatus;
    }

    protected boolean submitCodeToAppServer(String sSASCode, boolean displayMessages) {
        StringBuffer logText;
        Workspace work = Workspace.getWorkspace();
        Workspace.getDefaultLogger().debug("----- Submitting -----");
        Workspace.getDefaultLogger().debug(sSASCode);
        Workspace.getDefaultLogger().debug("----------------------");
        this.m_submitter.setCodeToSubmit(sSASCode);
        work.setStatusText(bundle.getString("CodeSubmitter.Exec.Wait.txt"));
        OpRequestUI op = new OpRequestUI(work, this.m_execDesc == null ? bundle.getString("CodeSubmitter.Exec.Desc.txt") : this.m_execDesc, this.m_execTitle == null ? bundle.getString("CodeSubmitter.Exec.Title.txt") : this.m_execTitle);
        op.setDelayBeforeProgressCancelDialog(0);
        op.setProgressShownOnStatusBar(false);
        op.execute(this.m_submitter);
        boolean appserverCodeErr = false;
        if (this.m_submitter.getStatus() != 0) {
            appserverCodeErr = true;
        } else if (this.m_searchLogForError && (logText = this.m_submitter.getLogStringText()) != null && logText.indexOf(ERRORSTRING) > -1) {
            appserverCodeErr = true;
        }
        if (appserverCodeErr) {
            String sError = bundle.getString("CodeSubmitter.Msg.SubFail.txt") + " " + this.m_submitter.getMessage();
            Workspace.getDefaultLogger().error(sError);
            if (displayMessages) {
                work.setStatusText(sError);
                work.getMessagesWindow().addMessage(sError);
                MessageUtil.displayMessage(sError, 0);
            }
            return false;
        }
        work.clearStatusText();
        return true;
    }

    public void setAppServer(AppServer appServer) {
        this.m_AppServer = appServer;
    }

    protected void refreshAppServer() {
        WorkspaceFile wsf;
        String sAppServerID;
        if (this.m_AppServer != null) {
            this.m_AppServer.dropConnection();
            this.m_AppServer.termAppServer();
            this.m_AppServer = null;
        }
        if ((sAppServerID = (wsf = Workspace.getWorkspace().getWorkspaceFile()).getPropertyString(DEFAULT_SERVER_ID)) != null && sAppServerID.length() > 0) {
            this.m_AppServer = Workspace.getWorkspace().makeAppServer(false);
        }
    }

    protected cCodeSubmitter createCodeSubmitter() {
        return new cCodeSubmitter();
    }

    protected class cCodeSubmitter
    implements Runnable {
        private int m_intStatus;
        private String m_strExceptionMessage;
        private String m_strSASCode;
        private LogListHolder m_llisthldrLog;
        private LogListHolder m_llisthldrOutput;
        private StringBuffer m_strlogText;

        public void setCodeToSubmit(String sascode) {
            this.m_strSASCode = sascode;
        }

        public int getStatus() {
            return this.m_intStatus;
        }

        public String getMessage() {
            return this.m_strExceptionMessage != null ? this.m_strExceptionMessage : CodeSubmitter.this.m_AppServer.getStatusMsg();
        }

        public LogListHolder getLogText() {
            return this.m_llisthldrLog;
        }

        public StringBuffer getLogStringText() {
            return this.m_strlogText;
        }

        public LogListHolder getOutputText() {
            return this.m_llisthldrOutput;
        }

        @Override
        public void run() {
            try {
                CodeSubmitter.this.m_AppServer.submitSrc(this.m_strSASCode);
                this.m_intStatus = CodeSubmitter.this.m_AppServer.waitForCompletion();
                this.m_strlogText = CodeSubmitter.this.m_AppServer.getLog();
            }
            catch (AppServerCodeErrorException ex) {
                this.m_strExceptionMessage = ex.getMessage();
                this.m_intStatus = CodeSubmitter.this.m_AppServer.getStatus();
                CodeSubmitter.this.m_AppServer.resetStatus();
                Workspace.getDefaultLogger().error((Object)"", ex);
            }
            catch (Exception e) {
                this.m_strExceptionMessage = e.getMessage();
                this.m_intStatus = CodeSubmitter.this.m_AppServer.getStatus();
                Workspace.getDefaultLogger().error((Object)"", e);
            }
            this.m_llisthldrLog = new LogListHolder(CodeSubmitter.this.m_AppServer.getLogLinesHolder(), CodeSubmitter.this.m_AppServer.getLogCCHolder(), CodeSubmitter.this.m_AppServer.getLogTypeHolder());
            this.m_llisthldrOutput = new LogListHolder(CodeSubmitter.this.m_AppServer.getListLinesHolder(), CodeSubmitter.this.m_AppServer.getListCCHolder(), CodeSubmitter.this.m_AppServer.getListTypeHolder());
            CodeSubmitter.this.m_hldrLog = this.m_llisthldrLog;
            CodeSubmitter.this.m_hldrOutput = this.m_llisthldrOutput;
            CodeSubmitter.this.m_sExceptionMessage = this.m_strExceptionMessage;
            CodeSubmitter.this.m_status = this.m_intStatus;
            CodeSubmitter.this.m_logText = this.m_strlogText;
        }
    }
}

