/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.models.tree.inventory;

import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleBrowseObjectImpl;
import com.sas.workspace.models.tree.inventory.AbstractElement;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class TableElement
extends AbstractElement {
    private boolean m_bShowColumns;

    public TableElement(boolean bShowColumns) {
        this.m_bShowColumns = bShowColumns;
    }

    @Override
    public boolean areChildrenAllowed(SimpleObject simpleObject) {
        return this.m_bShowColumns;
    }

    @Override
    public SimpleBrowseObject[] getChildrenOf(SimpleObject simpleObject) {
        if (!this.m_bShowColumns) {
            return new SimpleBrowseObject[0];
        }
        ArrayList<SimpleBrowseObjectImpl> lSimpleColumns = new ArrayList<SimpleBrowseObjectImpl>();
        try {
            Filter filter = new Filter();
            filter.setOMRTemplate("<Templates><DataTable><Columns/></DataTable></Templates>");
            filter.setOMRFlags(16);
            String sKey = simpleObject.getID() + "/" + simpleObject.getMetadataType();
            BrowseMetadataInterface table = this.m_server.browseFetch(sKey, (FilterInterface)filter);
            List lColumns = (List)table.get("Columns");
            if (lColumns != null && !lColumns.isEmpty()) {
                for (int i = 0; i < lColumns.size(); ++i) {
                    BrowseMetadataInterface column = (BrowseMetadataInterface)lColumns.get(i);
                    lSimpleColumns.add(new SimpleBrowseObjectImpl(column));
                }
            }
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return lSimpleColumns.toArray(new SimpleBrowseObject[lSimpleColumns.size()]);
    }

    @Override
    public SimpleBrowseObject[] getParentsOf(SimpleObject simpleObject) {
        ArrayList<SimpleBrowseObjectImpl> lSimpleParents = new ArrayList<SimpleBrowseObjectImpl>();
        try {
            Filter filter = new Filter();
            filter.setOMRTemplate("<Templates><DataTable><SourceTransformations/><TablePackage/><TargetTransformations/></DataTable><DatabaseSchema><UsedByPackages/></DatabaseSchema></Templates>");
            filter.setOMRFlags(16);
            String sKey = simpleObject.getID() + "/" + simpleObject.getMetadataType();
            BrowseMetadataInterface table = this.m_server.browseFetch(sKey, (FilterInterface)filter);
            List lLibraries = null;
            List lTablePackages = (List)table.get("TablePackage");
            if (lTablePackages != null && lTablePackages.size() > 0) {
                BrowseMetadataInterface tablePackage = (BrowseMetadataInterface)lTablePackages.get(0);
                lLibraries = "DatabaseSchema".equals(tablePackage.getNativeType()) ? (List)tablePackage.get("UsedByPackages") : lTablePackages;
            }
            if (lLibraries != null && !lLibraries.isEmpty()) {
                for (int i = 0; i < lLibraries.size(); ++i) {
                    BrowseMetadataInterface library = (BrowseMetadataInterface)lLibraries.get(i);
                    lSimpleParents.add(new SimpleBrowseObjectImpl(library));
                }
            }
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return lSimpleParents.toArray(new SimpleBrowseObject[lSimpleParents.size()]);
    }
}

