/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.models.tree.inventory;

import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleBrowseObjectImpl;
import com.sas.workspace.models.tree.inventory.AbstractElement;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class OLAPSchemaElement
extends AbstractElement {
    @Override
    public boolean areChildrenAllowed(SimpleObject simpleObject) {
        return true;
    }

    @Override
    public SimpleBrowseObject[] getChildrenOf(SimpleObject simpleObject) {
        ArrayList<SimpleBrowseObjectImpl> lSimpleCubes = new ArrayList<SimpleBrowseObjectImpl>();
        try {
            List lDimensions;
            Filter filter = new Filter();
            filter.setOMRTemplate("<Templates><OLAPSchema><Cubes/><Dimensions/></OLAPSchema></Templates>");
            String sKey = simpleObject.getID() + "/" + simpleObject.getMetadataType();
            BrowseMetadataInterface schema = this.m_server.browseFetch(sKey, (FilterInterface)filter);
            List lCubes = (List)schema.get("Cubes");
            if (lCubes != null && !lCubes.isEmpty()) {
                for (int i = 0; i < lCubes.size(); ++i) {
                    BrowseMetadataInterface cube = (BrowseMetadataInterface)lCubes.get(i);
                    lSimpleCubes.add(new SimpleBrowseObjectImpl(cube));
                }
            }
            if ((lDimensions = (List)schema.get("Dimensions")) != null && !lDimensions.isEmpty()) {
                for (int i = 0; i < lDimensions.size(); ++i) {
                    BrowseMetadataInterface cube = (BrowseMetadataInterface)lDimensions.get(i);
                    lSimpleCubes.add(new SimpleBrowseObjectImpl(cube));
                }
            }
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return lSimpleCubes.toArray(new SimpleBrowseObject[lSimpleCubes.size()]);
    }

    @Override
    public SimpleBrowseObject[] getParentsOf(SimpleObject simpleObject) {
        return new SimpleBrowseObject[0];
    }
}

