/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.models.tree.inventory;

import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.util.UsageVersion;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractVersionedObjectManager;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleBrowseObjectImpl;
import com.sas.workspace.models.tree.inventory.AbstractElement;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class CubeElement
extends AbstractElement {
    WsAbstractVersionedObjectManager manager = WsAbstractVersionedObjectManager.getInstance();

    private boolean isVersionSupported(String publicType, UsageVersion instanceVersion) {
        boolean returnValue = true;
        if (this.manager != null && !this.manager.isVersionSupported(publicType, instanceVersion)) {
            returnValue = false;
        } else {
            UsageVersion max = this.manager.getCurrentVersion(publicType);
            if (instanceVersion.compareMajorMinor(max) > 0) {
                returnValue = false;
            }
        }
        return returnValue;
    }

    private boolean isVersionSupported(SimpleObject simpleObject) {
        boolean ret_val = true;
        try {
            Filter filter = new Filter();
            filter.setOMRTemplate("<Templates><Cube><UsageVersion/></Cube></Templates>");
            String sKey = simpleObject.getID() + "/" + simpleObject.getMetadataType();
            BrowseMetadataInterface cube = this.m_server.browseFetch(sKey, (FilterInterface)filter);
            if (cube != null) {
                String versionAsString = (String)cube.get("UsageVersion");
                if (versionAsString != null && versionAsString.length() > 0) {
                    Double versionAsDouble = new Double(versionAsString);
                    UsageVersion cubeVersion = UsageVersion.decode((double)versionAsDouble);
                    ret_val = this.isVersionSupported(simpleObject.getPublicType(), cubeVersion);
                }
            } else {
                ret_val = false;
            }
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
            ret_val = false;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            ret_val = false;
        }
        return ret_val;
    }

    @Override
    public boolean areChildrenAllowed(SimpleObject simpleObject) {
        return this.isVersionSupported(simpleObject);
    }

    @Override
    public SimpleBrowseObject[] getChildrenOf(SimpleObject simpleObject) {
        ArrayList<SimpleBrowseObjectImpl> lSimpleDimensions = new ArrayList<SimpleBrowseObjectImpl>();
        try {
            Filter filter = new Filter();
            filter.setOMRTemplate("<Templates><Cube><Dimensions/></Cube></Templates>");
            String sKey = simpleObject.getID() + "/" + simpleObject.getMetadataType();
            BrowseMetadataInterface cube = this.m_server.browseFetch(sKey, (FilterInterface)filter);
            List lDimensions = (List)cube.get("Dimensions");
            if (lDimensions != null && !lDimensions.isEmpty()) {
                for (int i = 0; i < lDimensions.size(); ++i) {
                    BrowseMetadataInterface dimension = (BrowseMetadataInterface)lDimensions.get(i);
                    lSimpleDimensions.add(new SimpleBrowseObjectImpl(dimension));
                }
            }
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return lSimpleDimensions.toArray(new SimpleBrowseObject[lSimpleDimensions.size()]);
    }

    @Override
    public SimpleBrowseObject[] getParentsOf(SimpleObject simpleObject) {
        ArrayList<SimpleBrowseObjectImpl> lSimpleParents = new ArrayList<SimpleBrowseObjectImpl>();
        try {
            Filter filter = new Filter();
            filter.setOMRTemplate("<Templates><Cube><AssociatedOLAPSchema/></Cube></Templates>");
            String sKey = simpleObject.getID() + "/" + simpleObject.getMetadataType();
            BrowseMetadataInterface cube = this.m_server.browseFetch(sKey, (FilterInterface)filter);
            List lSchemas = (List)cube.get("AssociatedOLAPSchema");
            if (lSchemas != null && !lSchemas.isEmpty()) {
                for (int i = 0; i < lSchemas.size(); ++i) {
                    BrowseMetadataInterface olapSchema = (BrowseMetadataInterface)lSchemas.get(i);
                    lSimpleParents.add(new SimpleBrowseObjectImpl(olapSchema));
                }
            }
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return lSimpleParents.toArray(new SimpleBrowseObject[lSimpleParents.size()]);
    }
}

