/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.models.tree;

import com.sas.nls.collator.SASCollatorFactory;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.tree.IDataTreeNode;
import com.sas.workspace.models.tree.ITreeNode;
import java.util.Comparator;

public class TreeNodeComparator
implements Comparator {
    public static final int BY_NAME = 0;
    public static final int BY_TYPE = 1;
    private int m_iCompareBy;
    private boolean m_bIsolateFolders;
    private Comparator m_comparator;

    public TreeNodeComparator() {
        this(0);
    }

    public TreeNodeComparator(int iCompareBy) {
        this(iCompareBy, false);
    }

    public TreeNodeComparator(int iCompareBy, boolean bCaseSensitive) {
        this(iCompareBy, bCaseSensitive, true);
    }

    public TreeNodeComparator(int iCompareBy, boolean bCaseSensitive, boolean bIsolateFolders) {
        if (iCompareBy != 0 && iCompareBy != 1) {
            throw new IllegalArgumentException();
        }
        this.m_iCompareBy = iCompareBy;
        this.m_bIsolateFolders = bIsolateFolders;
        if (bCaseSensitive) {
            Workspace.getLogger(TreeNodeComparator.class.getName()).warn("case sensitive is not supported");
        }
        this.m_comparator = SASCollatorFactory.createCollator();
    }

    public int compare(Object first, Object second) {
        if (!(first instanceof ITreeNode) || !(second instanceof ITreeNode)) {
            throw new IllegalArgumentException("Nodes must implement the ITreeNode interface.");
        }
        ITreeNode node1 = (ITreeNode)first;
        ITreeNode node2 = (ITreeNode)second;
        if (this.m_bIsolateFolders) {
            if (node1.isFolder() && !node2.isFolder()) {
                return -1;
            }
            if (!node1.isFolder() && node2.isFolder()) {
                return 1;
            }
        }
        switch (this.m_iCompareBy) {
            default: {
                int iNameCompare = this.compareByName(node1, node2);
                if (iNameCompare != 0) {
                    return iNameCompare;
                }
                return this.compareByType(node1, node2);
            }
            case 1: 
        }
        int iTypeCompare = this.compareByType(node1, node2);
        if (iTypeCompare != 0) {
            return iTypeCompare;
        }
        return this.compareByName(node1, node2);
    }

    private int compareByName(ITreeNode node1, ITreeNode node2) {
        return this.m_comparator.compare(node1.getName(), node2.getName());
    }

    private int compareByType(ITreeNode node1, ITreeNode node2) {
        String sType;
        if (node1 instanceof IDataTreeNode && node2 instanceof IDataTreeNode && (sType = ((IDataTreeNode)node1).getType()) != null) {
            return this.m_comparator.compare(sType, ((IDataTreeNode)node2).getType());
        }
        return 0;
    }
}

