/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.models.tree;

import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.IPublicTypeFilter;
import com.sas.workspace.models.ISimpleObjectHierarchyModel;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleBrowseObjectImpl;
import com.sas.workspace.models.impl.SimpleObjectHierarchyModel;
import com.sas.workspace.models.tree.AbstractTreeModel;
import com.sas.workspace.models.tree.AbstractTreeNode;
import com.sas.workspace.models.tree.CategoryTreeNode;
import com.sas.workspace.models.tree.IDataTreeNode;
import com.sas.workspace.models.tree.ITreeNode;
import com.sas.workspace.models.tree.inventory.CalculatedMeasureElement;
import com.sas.workspace.models.tree.inventory.CubeElement;
import com.sas.workspace.models.tree.inventory.DimensionElement;
import com.sas.workspace.models.tree.inventory.HierarchyElement;
import com.sas.workspace.models.tree.inventory.LevelElement;
import com.sas.workspace.models.tree.inventory.LibraryElement;
import com.sas.workspace.models.tree.inventory.MeasureElement;
import com.sas.workspace.models.tree.inventory.OLAPSchemaElement;
import com.sas.workspace.models.tree.inventory.SharedDimensionElement;
import com.sas.workspace.models.tree.inventory.TableElement;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;

public class InventoryTreeModel
extends AbstractTreeModel {
    private Map m_categoryMap = new HashMap();
    private IPublicTypeFilter m_categoryFilter = this.createDefaultCategoryFilter();
    private ISimpleObjectHierarchyModel m_hierarchyModel = this.createDefaultHierarchyModel();

    public InventoryTreeModel(UserContextInterface userContext) {
        super(userContext, null);
        cInventoryRootNode inventoryRoot = new cInventoryRootNode();
        inventoryRoot.setTreeModel(this);
        this.setRoot(inventoryRoot);
    }

    protected IPublicTypeFilter createDefaultCategoryFilter() {
        return new cDefaultCategoryFilter();
    }

    public void setCategoryFilter(IPublicTypeFilter categoryFilter) {
        this.m_categoryFilter = categoryFilter;
    }

    protected ISimpleObjectHierarchyModel createDefaultHierarchyModel() {
        return new cDefaultInventoryHierarchyModel(this.m_server);
    }

    public void setHierarchyModel(ISimpleObjectHierarchyModel hierarchyModel) {
        this.m_hierarchyModel = hierarchyModel;
    }

    @Override
    public boolean isValidParent(ITreeNode nodeParent, ITreeNode nodeChild) {
        if (nodeChild instanceof CategoryTreeNode) {
            return nodeParent.equals(this.getRoot());
        }
        if (nodeChild instanceof IDataTreeNode && nodeParent instanceof CategoryTreeNode) {
            try {
                TypeDescriptorInterface tdi = (TypeDescriptorInterface)((CategoryTreeNode)nodeParent).getCategoryObject();
                SimpleObject simpleObj = (SimpleObject)((IDataTreeNode)nodeChild).getData();
                if (tdi.getTypeName().equals(simpleObj.getPublicType())) {
                    return true;
                }
            }
            catch (ServiceException ex) {
                MessageUtil.displayServiceExceptionMessage(ex);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
        }
        if (this.m_hierarchyModel != null && nodeChild instanceof IDataTreeNode && nodeParent instanceof IDataTreeNode) {
            SimpleObject parent = (SimpleObject)((IDataTreeNode)nodeParent).getData();
            SimpleObject child = (SimpleObject)((IDataTreeNode)nodeChild).getData();
            SimpleBrowseObject[] aParents = this.m_hierarchyModel.getParentsOf(child);
            for (int i = 0; i < aParents.length; ++i) {
                if (!aParents[i].getID().equals(parent.getID())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addChildren(ITreeNode parentNode) {
        if (parentNode.equals(this.getRoot())) {
            this.addInventoryCategories();
        } else if (parentNode instanceof CategoryTreeNode) {
            TypeDescriptorInterface tdi = (TypeDescriptorInterface)((CategoryTreeNode)parentNode).getCategoryObject();
            try {
                Filter filter = new Filter("PublicType", 0, tdi.getTypeName());
                filter.setType(tdi.getMetadataType());
                filter.setOMRTemplate(m_browseFilter.getOMRTemplate());
                filter.setOMRFlags(m_browseFilter.getOMRFlags() | 0x80 | 0x100 | 0x2000);
                List lObjects = this.m_server.browseSearch((FilterInterface)filter);
                for (BrowseMetadataInterface browseObj : lObjects) {
                    SimpleBrowseObjectImpl simpleObj = new SimpleBrowseObjectImpl(browseObj);
                    if (!this.isValidObject(simpleObj)) continue;
                    ITreeNode childNode = this.createNode(simpleObj);
                    this.addChild(childNode, parentNode);
                }
            }
            catch (ServiceException ex) {
                MessageUtil.displayServiceExceptionMessage(ex);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
        } else if (parentNode instanceof IDataTreeNode && this.m_hierarchyModel != null) {
            SimpleObject simpleObj = (SimpleObject)((IDataTreeNode)parentNode).getData();
            SimpleBrowseObject[] aChildren = this.m_hierarchyModel.getChildrenOf(simpleObj);
            for (int i = 0; i < aChildren.length; ++i) {
                if (!this.isValidObject(aChildren[i])) continue;
                ITreeNode childNode = this.createNode(aChildren[i]);
                this.addChild(childNode, parentNode);
            }
        }
    }

    @Override
    public void addChild(IDataTreeNode nodeNew) {
        List lParentNodes = this.findParentNodes((SimpleBrowseObject)nodeNew.getData());
        if (lParentNodes.size() > 0) {
            this.addChild(nodeNew, (ITreeNode)lParentNodes.get(0));
        }
    }

    @Override
    public ITreeNode createNode(Object userObject) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)((Object)super.createNode(userObject));
        boolean bAllowsChildren = false;
        if (userObject instanceof SimpleObject && this.m_hierarchyModel != null) {
            bAllowsChildren = this.m_hierarchyModel.areChildrenAllowed((SimpleObject)userObject);
        }
        node.setAllowsChildren(bAllowsChildren);
        return (ITreeNode)((Object)node);
    }

    @Override
    public List findParentNodes(SimpleBrowseObject object) {
        ArrayList<ITreeNode> lParentNodes = new ArrayList<ITreeNode>();
        ITreeNode parentNode = (ITreeNode)this.m_categoryMap.get(object.getPublicType());
        if (parentNode != null) {
            lParentNodes.add(parentNode);
        }
        if (this.m_hierarchyModel != null) {
            SimpleBrowseObject[] aParents = this.m_hierarchyModel.getParentsOf(object);
            for (int i = 0; i < aParents.length; ++i) {
                lParentNodes.addAll(this.findNodes(aParents[i].getID()));
            }
        }
        return lParentNodes;
    }

    protected void addInventoryCategories() {
        this.m_categoryMap.clear();
        try {
            Map typesMap = ((MetadataServerInterface)this.m_server).getTypeDictionaryMap();
            if (typesMap == null) {
                return;
            }
            for (TypeDescriptorInterface tdi : typesMap.values()) {
                String sPublicType = tdi.getTypeName();
                if (!this.m_categoryFilter.accept(sPublicType)) continue;
                CategoryTreeNode inventoryNode = new CategoryTreeNode(tdi.getType());
                inventoryNode.setCategoryObject(tdi);
                this.addChild(inventoryNode, (ITreeNode)this.getRoot());
                this.m_categoryMap.put(sPublicType, inventoryNode);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
    }

    @Override
    protected boolean doesNodeAllowChildren(IDataTreeNode node) {
        Object dataObject = node.getData();
        if (dataObject instanceof SimpleObject && this.m_hierarchyModel != null) {
            return this.m_hierarchyModel.areChildrenAllowed((SimpleObject)dataObject);
        }
        return super.doesNodeAllowChildren(node);
    }

    @Override
    protected void updateModifiedObjects(Map objectsMap) {
        super.updateModifiedObjects(objectsMap);
        this.addCreatedObjects(objectsMap);
    }

    private class cDefaultInventoryHierarchyModel
    extends SimpleObjectHierarchyModel {
        public cDefaultInventoryHierarchyModel(ServerInterface server) {
            super(server);
            this.addElement(new LibraryElement(), "Library");
            this.addElement(new TableElement(false), "Table");
            this.addElement(new OLAPSchemaElement(), "OLAPSchema");
            this.addElement(new CubeElement(), "Cube");
            this.addElement(new DimensionElement(), "Dimension");
            this.addElement(new SharedDimensionElement(), "SharedDimension");
            this.addElement(new MeasureElement(), "Measure");
            this.addElement(new LevelElement(), "Level");
            this.addElement(new HierarchyElement(), "Hierarchy");
            this.addElement(new CalculatedMeasureElement(), "CalculatedMeasure");
        }
    }

    private class cDefaultCategoryFilter
    implements IPublicTypeFilter {
        private cDefaultCategoryFilter() {
        }

        @Override
        public boolean accept(String sPublicType) {
            return true;
        }
    }

    private class cInventoryRootNode
    extends AbstractTreeNode {
        public cInventoryRootNode() {
            super("InventoryRoot");
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public boolean isFolder() {
            return true;
        }
    }
}

