/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.models.tree;

import com.sas.metadata.remote.CMetadata;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.changemanagement.CMEvent;
import com.sas.workspace.changemanagement.CMEventListener;
import com.sas.workspace.models.IPublicTypeFilter;
import com.sas.workspace.models.ISimpleObjectHierarchyModel;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleBrowseObjectImpl;
import com.sas.workspace.models.tree.AbstractTreeModel;
import com.sas.workspace.models.tree.CategoryTreeNode;
import com.sas.workspace.models.tree.IDataTreeNode;
import com.sas.workspace.models.tree.ITreeNode;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;

public class CheckoutsTreeModel
extends AbstractTreeModel {
    private RepositoryInterface m_project;
    private IPublicTypeFilter m_topLevelTypeFilter;
    private ISimpleObjectHierarchyModel m_hierarchyModel;

    public CheckoutsTreeModel(UserContextInterface userContext) {
        super(userContext, null);
        try {
            CMetadata mdRepos = Workspace.getWorkspace().getProjectRepository();
            if (mdRepos != null) {
                String reposName = mdRepos.getName();
                this.m_project = this.m_server.getRepository(reposName);
                if (this.m_project != null) {
                    CategoryTreeNode checkoutsRoot = new CategoryTreeNode(reposName);
                    checkoutsRoot.setTreeModel(this);
                    this.setRoot(checkoutsRoot);
                }
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
    }

    public void setTopLevelTypeFilter(IPublicTypeFilter topLevelTypeFilter) {
        this.m_topLevelTypeFilter = topLevelTypeFilter;
    }

    public void setHierarchyModel(ISimpleObjectHierarchyModel hierarchyModel) {
        this.m_hierarchyModel = hierarchyModel;
    }

    protected boolean isValidTopLevelObject(SimpleBrowseObject simpleObj) {
        if (this.m_topLevelTypeFilter != null) {
            return this.m_topLevelTypeFilter.accept(simpleObj.getPublicType());
        }
        return this.isValidObject(simpleObj);
    }

    @Override
    public boolean isValidParent(ITreeNode nodeParent, ITreeNode nodeChild) {
        if (this.m_hierarchyModel != null && nodeChild instanceof IDataTreeNode && nodeParent instanceof IDataTreeNode) {
            SimpleObject parent = (SimpleObject)((IDataTreeNode)nodeParent).getData();
            SimpleObject child = (SimpleObject)((IDataTreeNode)nodeChild).getData();
            SimpleBrowseObject[] aParents = this.m_hierarchyModel.getParentsOf(child);
            for (int i = 0; i < aParents.length; ++i) {
                if (!aParents[i].getID().equals(parent.getID())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void addChildren(ITreeNode parentNode) {
        if (parentNode == this.getRoot()) {
            try {
                Filter filter = new Filter();
                filter.setType("PrimaryType");
                filter.setOMRTemplate(m_browseFilter.getOMRTemplate());
                filter.setOMRFlags(m_browseFilter.getOMRFlags() | 0x100);
                List lObjects = this.m_project.browseSearch((FilterInterface)filter);
                for (BrowseMetadataInterface browseObj : lObjects) {
                    SimpleBrowseObjectImpl simpleObj = new SimpleBrowseObjectImpl(browseObj);
                    if (!this.isValidTopLevelObject(simpleObj)) continue;
                    ITreeNode childNode = this.createNode(simpleObj);
                    this.addChild(childNode, parentNode);
                }
            }
            catch (ServiceException ex) {
                MessageUtil.displayServiceExceptionMessage(ex);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
        } else if (parentNode instanceof IDataTreeNode && this.m_hierarchyModel != null) {
            SimpleObject simpleObj = (SimpleObject)((IDataTreeNode)parentNode).getData();
            SimpleBrowseObject[] aChildren = this.m_hierarchyModel.getChildrenOf(simpleObj);
            for (int i = 0; i < aChildren.length; ++i) {
                if (!this.isValidObject(aChildren[i])) continue;
                ITreeNode childNode = this.createNode(aChildren[i]);
                this.addChild(childNode, parentNode);
            }
        }
    }

    @Override
    public void addChild(IDataTreeNode nodeNew) {
        this.addChild(nodeNew, (ITreeNode)this.getRoot());
    }

    @Override
    public ITreeNode createNode(Object userObject) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)((Object)super.createNode(userObject));
        boolean bAllowsChildren = false;
        if (userObject instanceof SimpleObject && this.m_hierarchyModel != null) {
            bAllowsChildren = this.m_hierarchyModel.areChildrenAllowed((SimpleObject)userObject);
        }
        node.setAllowsChildren(bAllowsChildren);
        return (ITreeNode)((Object)node);
    }

    @Override
    public List findParentNodes(SimpleBrowseObject object) {
        ArrayList<Object> lParentNodes = new ArrayList<Object>();
        lParentNodes.add(this.getRoot());
        if (this.m_hierarchyModel != null) {
            SimpleBrowseObject[] aParents = this.m_hierarchyModel.getParentsOf(object);
            for (int i = 0; i < aParents.length; ++i) {
                lParentNodes.addAll(this.findNodes(aParents[i].getID()));
            }
        }
        return lParentNodes;
    }

    @Override
    protected SimpleBrowseObject getSimpleBrowseObject(String sFQID, String sType) {
        try {
            Filter filter = new Filter("Id", 0, sFQID);
            filter.setType(sType);
            filter.setOMRTemplate(m_browseFilter.getOMRTemplate());
            filter.setOMRFlags(m_browseFilter.getOMRFlags() | 0x80 | 0x100 | 0x2000);
            List lBrowseObjects = this.m_project.browseSearch((FilterInterface)filter);
            if (!lBrowseObjects.isEmpty()) {
                return new SimpleBrowseObjectImpl((BrowseMetadataInterface)lBrowseObjects.get(0));
            }
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage(ex);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return null;
    }

    @Override
    protected boolean doesNodeAllowChildren(IDataTreeNode node) {
        Object dataObject = node.getData();
        if (dataObject instanceof SimpleObject && this.m_hierarchyModel != null) {
            return this.m_hierarchyModel.areChildrenAllowed((SimpleObject)dataObject);
        }
        return super.doesNodeAllowChildren(node);
    }

    @Override
    protected CMEventListener createCMEventListener() {
        return new cCMEventListener();
    }

    @Override
    public boolean isValidObject(SimpleBrowseObject simpleObj) {
        try {
            if (!Workspace.getWorkspace().getProjectRepositoryId().equals(simpleObj.getID().substring(0, 8))) {
                return false;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return super.isValidObject(simpleObj);
    }

    private class cCMEventListener
    implements CMEventListener {
        private cCMEventListener() {
        }

        @Override
        public void CMObjectsUpdated(CMEvent ev) {
            Map mapObjects = ev.getObjectMapForProjectRepository();
            if (mapObjects != null) {
                CheckoutsTreeModel.this.updateModifiedObjects(mapObjects);
            }
        }

        @Override
        public void CMObjectsDeleted(CMEvent ev) {
            String[] aFQIDs = ev.getArrayOfProjectIds();
            if (aFQIDs != null) {
                CheckoutsTreeModel.this.removeDeletedObjects(aFQIDs);
            }
        }

        @Override
        public void CMObjectsCreated(CMEvent ev) {
            Map mapObjects = ev.getObjectMapForProjectRepository();
            if (mapObjects != null) {
                CheckoutsTreeModel.this.addCreatedObjects(mapObjects);
            }
        }
    }
}

