/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.metadata;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRServerRootFolder;
import com.sas.services.util.Names;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Random;

public class WsMetadataNameUtil {
    private static WAdminResource bundle = WAdminResource.getBundle(WsMetadataNameUtil.class);
    private static Random rand = new Random();
    private static final int MAX_SUFFIX = 99999;
    private static final int MAX_ATTEMPTS = 10;
    private static final int MAX_NAME_LENGTH = 60;
    private static final char UNDERSCORE = '_';
    private static final char BACKSLASH = '\\';
    private static final char FORWARD_SLASH = '/';

    private WsMetadataNameUtil() {
    }

    public static String getUniqueNameForType(String metadataType) {
        if (metadataType == null) {
            return null;
        }
        String preferredNameForType = metadataType.equals("Document") ? bundle.getString("WsMetadataNameUtil.DefaultName.Document.txt") : (metadataType.equals("Job") ? bundle.getString("WsMetadataNameUtil.DefaultName.Job.txt") : (metadataType.equals("TextStore") ? bundle.getString("WsMetadataNameUtil.DefaultName.TextStore.txt") : bundle.getString("WsMetadataNameUtil.DefaultName.txt")));
        return WsMetadataNameUtil.getUniqueNameForType(metadataType, preferredNameForType);
    }

    public static String getUniqueNameForType(String metadataType, String preferredName) {
        StringBuffer newName;
        if (metadataType == null || preferredName == null) {
            return null;
        }
        int attempts = 0;
        do {
            newName = new StringBuffer();
            ++attempts;
            int suffix = rand.nextInt(99999) + 1;
            newName.append(preferredName);
            newName.append(" ");
            newName.append(suffix);
        } while (!WsMetadataNameUtil.isNameUnique(metadataType, newName.toString()) && attempts < 10);
        return newName.toString();
    }

    public static String getUniqueNameForTypeInFolder(String sProposedName, String sPublicType, Root folder) {
        if (!WsMetadataNameUtil.isNameValid(sProposedName)) {
            throw new IllegalArgumentException("Proposed name is invalid.");
        }
        if (!(folder instanceof Tree) && !(folder instanceof SoftwareComponent)) {
            throw new IllegalArgumentException("The folder parameter must be a Tree or SoftwareComponent.");
        }
        String sUniqueName = sProposedName;
        int iCounter = 2;
        while (folder instanceof Tree ? !WsMetadataNameUtil.isNameUniqueInFolder(sUniqueName, (Tree)folder, sPublicType) : !WsMetadataNameUtil.isNameUniqueInFolder(sUniqueName, (SoftwareComponent)folder, sPublicType)) {
            sUniqueName = sProposedName + iCounter;
            if (sUniqueName.length() > 60) {
                int iEndIndex = sProposedName.length() - (sUniqueName.length() - 60);
                sUniqueName = sProposedName.substring(0, iEndIndex) + iCounter;
            }
            ++iCounter;
        }
        return sUniqueName;
    }

    public static boolean isNameUnique(Root object, String proposedName) {
        if (object == null || proposedName == null) {
            return false;
        }
        try {
            List duplicateList = WsMetadataNameUtil.getObjectsOfTypeWithName(object.getCMetadataType(), proposedName);
            if (duplicateList == null || duplicateList.size() == 0) {
                return true;
            }
            for (int i = 0; i < duplicateList.size(); ++i) {
                if (((Root)duplicateList.get(i)).getFQID().equals(object.getFQID())) continue;
                return false;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return true;
    }

    public static boolean isNameUnique(String metadataType, String proposedName) {
        if (metadataType == null || proposedName == null) {
            return false;
        }
        List duplicateList = WsMetadataNameUtil.getObjectsOfTypeWithName(metadataType, proposedName);
        return duplicateList == null || duplicateList.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNameUniqueInFolder(String sObjectName, Tree oTree, String sPublicType) {
        ChildServerInterface transaction = null;
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            transaction = server.newChild(true);
            String key = oTree.getFQID() + "/" + oTree.getCMetadataType();
            MetadataInterface mi = transaction.fetch(key, true);
            if (mi instanceof FolderInterface) {
                boolean bl = !((FolderInterface)mi).hasDuplicate(sObjectName, sPublicType);
                return bl;
            }
        }
        catch (ServiceException se) {
            MessageUtil.displayServiceExceptionMessage(se);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.destroy();
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException(e);
                }
                catch (ServiceException e) {
                    MessageUtil.displayServiceExceptionMessage(e);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNameUniqueInFolder(String sObjectName, SoftwareComponent oSC, String sPublicType) {
        ChildServerInterface transaction = null;
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            transaction = server.newChild(true);
            String key = oSC.getFQID() + "/" + oSC.getCMetadataType();
            MetadataInterface mi = transaction.fetch(key, true);
            if (mi instanceof OMRServerRootFolder) {
                boolean bl = !((OMRServerRootFolder)mi).hasDuplicate(sObjectName, sPublicType);
                return bl;
            }
            if (mi instanceof FolderInterface) {
                boolean bl = !((FolderInterface)mi).hasDuplicate(sObjectName, sPublicType);
                return bl;
            }
        }
        catch (ServiceException se) {
            MessageUtil.displayServiceExceptionMessage(se);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.destroy();
                }
                catch (ServiceException e) {
                    MessageUtil.displayServiceExceptionMessage(e);
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException(e);
                }
            }
        }
        return false;
    }

    public static boolean isNameUniqueInFolder(String sObjectName, MetadataInterface folder, String sPublicType) {
        try {
            if (folder instanceof FolderInterface) {
                return !((FolderInterface)folder).hasDuplicate(sObjectName, sPublicType);
            }
        }
        catch (ServiceException se) {
            MessageUtil.displayServiceExceptionMessage(se);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        return false;
    }

    public static boolean isNameValid(String objectName) {
        try {
            return Names.validateOMRObjectName((String)objectName, (boolean)true);
        }
        catch (IllegalArgumentException iae) {
            MessageUtil.displayMessage(iae.getLocalizedMessage(), 0);
            return false;
        }
    }

    private static List getObjectsOfTypeWithName(String metadataType, String proposedName) {
        if (metadataType == null || proposedName == null) {
            return null;
        }
        CMetadata projectRepos = Workspace.getWorkspace().getProjectRepository();
        CMetadata checkinRepos = Workspace.getWorkspace().getCheckinRepository();
        List projectDuplicateList = null;
        List checkinDuplicateList = null;
        StringBuffer options = new StringBuffer();
        options.append("<XMLSELECT Search=\"@NAME EQ '");
        options.append(proposedName);
        options.append("'\"/><Templates><");
        options.append(metadataType);
        options.append(" Name=\"\"></");
        options.append(metadataType);
        options.append("></Templates>");
        try {
            if (projectRepos != null) {
                projectDuplicateList = Workspace.getMdFactory().getOMIUtil().getMetadataObjects(projectRepos.getFQID(), metadataType, 132, options.toString());
            }
            if (checkinRepos != null) {
                checkinDuplicateList = Workspace.getMdFactory().getOMIUtil().getMetadataObjects(checkinRepos.getFQID(), metadataType, 132, options.toString());
            }
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage(me, "Accessing");
            return null;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        if (checkinDuplicateList == null) {
            return projectDuplicateList;
        }
        if (projectDuplicateList == null) {
            return checkinDuplicateList;
        }
        checkinDuplicateList.addAll(projectDuplicateList);
        return checkinDuplicateList;
    }

    public static int getRandomInt() {
        return rand.nextInt(99999) + 1;
    }

    public static String getValidName(String proposedName) {
        if (proposedName == null || proposedName.length() == 0) {
            return null;
        }
        String newName = proposedName;
        if (!Names.validateOMRObjectName((String)newName, (boolean)false)) {
            newName = Names.trimName((String)proposedName);
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < newName.length() && i < 60; ++i) {
                char c = newName.charAt(i);
                if (c == '\\' || c == '/' || Character.isISOControl(c)) {
                    buf.append('_');
                    continue;
                }
                buf.append(c);
            }
            newName = buf.toString();
            newName = Names.trimName((String)newName);
        }
        return newName;
    }

    public static String getValidName(String proposedName, Tree oTree, String sPublicType) {
        String validName;
        if (proposedName == null || proposedName.length() == 0) {
            return null;
        }
        String newName = validName = WsMetadataNameUtil.getValidName(proposedName);
        for (int renameCount = 1; !WsMetadataNameUtil.isNameUniqueInFolder(newName, oTree, sPublicType) && renameCount < 99999 && newName != null; ++renameCount) {
            newName = bundle.formatString("WsMetadataNameUtil.NewName.N.txt", validName, String.valueOf(renameCount));
            if (newName.length() <= 60) continue;
            newName = null;
        }
        return newName;
    }
}

