/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.imsmc.visuals;

import com.sas.swing.visuals.util.Util;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.imsmc.ApplicationResource;
import com.sas.workspace.imsmc.visuals.ImageHandler;
import com.sas.workspace.imsmc.visuals.MinimumResizeListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class WindowUtil {
    static boolean referenceCountEnabled = false;
    protected static ApplicationResource bundle = new ApplicationResource(WindowUtil.class);
    protected static HashMap usageCountHashMap = new HashMap();
    private static final Logger LOGGER = LogManager.getLogger(WindowUtil.class);

    public static void addKeyListenersToAll(Container container, KeyAdapter keyHandler) {
        Component[] components = container.getComponents();
        for (int index = 0; index < components.length; ++index) {
            components[index].addKeyListener(keyHandler);
            if (!(components[index] instanceof Container)) continue;
            WindowUtil.addKeyListenersToAll((Container)components[index], keyHandler);
        }
    }

    public static void removeKeyListenersToAll(Container container, KeyAdapter keyHandler) {
        Component[] components = container.getComponents();
        for (int index = 0; index < components.length; ++index) {
            components[index].removeKeyListener(keyHandler);
            if (!(components[index] instanceof Container)) continue;
            WindowUtil.removeKeyListenersToAll((Container)components[index], keyHandler);
        }
    }

    public static void smartPopMenuShow(JPopupMenu popmenu, JComponent source, int xLoc, int yLoc) {
        popmenu.pack();
        if (popmenu != null && popmenu.getSubElements().length != 0) {
            source.add(popmenu);
            popmenu.setLocation(xLoc, yLoc);
            popmenu.show(source, xLoc, yLoc);
            Rectangle popmenuBox = popmenu.getBounds();
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension screenSize = toolkit.getScreenSize();
            Point parentLoc = source.getLocationOnScreen();
            boolean moveMenuSoItDoesnotGoOffEdge = false;
            if (parentLoc.x + popmenuBox.width + xLoc > screenSize.width) {
                xLoc -= popmenuBox.width;
                moveMenuSoItDoesnotGoOffEdge = true;
            }
            if (parentLoc.y + popmenuBox.height + yLoc > screenSize.height) {
                yLoc -= popmenuBox.height;
                moveMenuSoItDoesnotGoOffEdge = true;
            }
            if (moveMenuSoItDoesnotGoOffEdge) {
                popmenu.show(source, xLoc, yLoc);
            }
            popmenu.requestFocus();
        }
    }

    public static void fixupDialogIcons() {
        ImageIcon qIcon = ImageHandler.getImageIcon(bundle, "iq.image");
        JDialog parentLess = new JDialog();
        Frame sharedHiddenParentFrame = (Frame)parentLess.getParent();
        sharedHiddenParentFrame.setIconImage(qIcon.getImage());
    }

    public static void fixupJScrollPane(JScrollPane p) {
        p.setBorder(BorderFactory.createBevelBorder(1, SystemColor.controlLtHighlight, SystemColor.controlHighlight, SystemColor.controlDkShadow, SystemColor.controlShadow));
    }

    public static void fixupJPanel(JPanel p) {
        p.setBorder(BorderFactory.createBevelBorder(1, SystemColor.controlLtHighlight, SystemColor.controlHighlight, SystemColor.controlDkShadow, SystemColor.controlShadow));
    }

    public static final void busyOn(Component awtComponent) {
        if (WindowUtil.getParentFrame(awtComponent) != null) {
            WindowUtil.busyOn(WindowUtil.getParentFrame(awtComponent));
        }
    }

    public static final void busyOff(Component awtComponent) {
        if (WindowUtil.getParentFrame(awtComponent) != null) {
            WindowUtil.busyOff(WindowUtil.getParentFrame(awtComponent));
        }
    }

    public static final void busyOn(JComponent c) {
        Container topLevelAncestor = c.getTopLevelAncestor();
        if (topLevelAncestor != null) {
            int currentUC = 0;
            if (usageCountHashMap.containsKey(topLevelAncestor)) {
                Integer mapValue = (Integer)usageCountHashMap.get(topLevelAncestor);
                currentUC = mapValue;
            }
            usageCountHashMap.put(topLevelAncestor, new Integer(++currentUC));
            if (currentUC == 1 || !referenceCountEnabled) {
                topLevelAncestor.setCursor(Cursor.getPredefinedCursor(3));
            }
        }
    }

    public static final void busyOff(JComponent c) {
        Container topLevelAncestor = c.getTopLevelAncestor();
        if (topLevelAncestor != null) {
            Integer curValue = new Integer(0);
            if (usageCountHashMap.containsKey(topLevelAncestor)) {
                curValue = (Integer)usageCountHashMap.get(topLevelAncestor);
            }
            int currentUC = curValue;
            usageCountHashMap.put(topLevelAncestor, new Integer(--currentUC));
            if (currentUC == 0 || !referenceCountEnabled) {
                topLevelAncestor.setCursor(Cursor.getPredefinedCursor(0));
                if (currentUC == 0) {
                    usageCountHashMap.remove(topLevelAncestor);
                }
            }
        }
    }

    public static final void busyOn(JDialog c) {
        int currentUC = 0;
        if (usageCountHashMap.containsKey(c)) {
            Integer mapValue = (Integer)usageCountHashMap.get(c);
            currentUC = mapValue;
        }
        usageCountHashMap.put(c, new Integer(++currentUC));
        if (currentUC == 1 || !referenceCountEnabled) {
            c.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public static final void busyOff(JDialog c) {
        if (c != null) {
            Integer curValue = new Integer(0);
            if (usageCountHashMap.containsKey(c)) {
                curValue = (Integer)usageCountHashMap.get(c);
            }
            int currentUC = curValue;
            usageCountHashMap.put(c, new Integer(--currentUC));
            if (currentUC == 0 || !referenceCountEnabled) {
                if (currentUC == 0) {
                    usageCountHashMap.remove(c);
                }
                c.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public static final void busyOn(Frame c) {
        int currentUC = 0;
        if (usageCountHashMap.containsKey(c)) {
            Integer mapValue = (Integer)usageCountHashMap.get(c);
            currentUC = mapValue;
        }
        usageCountHashMap.put(c, new Integer(++currentUC));
        if (currentUC == 1 || !referenceCountEnabled) {
            c.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public static final void busyOff(Frame c) {
        if (c != null) {
            Integer curValue = new Integer(0);
            if (usageCountHashMap.containsKey(c)) {
                curValue = (Integer)usageCountHashMap.get(c);
            }
            int currentUC = curValue;
            usageCountHashMap.put(c, new Integer(--currentUC));
            if (currentUC == 0 || !referenceCountEnabled) {
                if (currentUC == 0) {
                    usageCountHashMap.remove(c);
                }
                c.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public static final void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public static void center(Window window) {
        Dimension size = window.getSize();
        Dimension screenSize = window.getToolkit().getScreenSize();
        window.setLocation(screenSize.width / 2 - size.width / 2, screenSize.height / 2 - size.height / 2);
    }

    public static void centerOver(Window window, Component component) {
        Point location = new Point(0, 0);
        Dimension componentSize = window.getToolkit().getScreenSize();
        if (component == null) {
            System.err.println("CenterOver: Component is null while trying to center= " + window);
        } else if (!component.isShowing()) {
            System.err.println("CenterOver: Component not showing= " + component);
            System.err.println("CenterOver: Cannot center= " + window);
        } else {
            location = component.getLocationOnScreen();
            componentSize = component.getSize();
        }
        location.x += componentSize.width / 2;
        location.y += componentSize.height / 2;
        Dimension size = window.getSize();
        int x = location.x - size.width / 2;
        int y = location.y - size.height / 2;
        Rectangle virtualScreen = WsUIUtilities.getVirtualScreenExtent();
        x = Math.max(virtualScreen.x, Math.min(x, virtualScreen.x + virtualScreen.width - size.width));
        y = Math.max(virtualScreen.y, Math.min(y, virtualScreen.y + virtualScreen.height - size.height));
        window.setLocation(x, y);
    }

    public static void centerOverWindow(Window window, Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        if (component != null && component.isShowing()) {
            WindowUtil.centerOver(window, component);
        } else {
            if (component != null && !component.isShowing()) {
                LOGGER.debug("attempt to center over component that is not showing:" + component, WindowUtil.class);
            }
            WindowUtil.center(window);
        }
    }

    public static Frame getParentFrame(Component comp) {
        Frame parentFrame = null;
        Component parent = comp;
        while (parent != null) {
            if (parent instanceof Frame) {
                parentFrame = (Frame)parent;
                parent = null;
                continue;
            }
            if (parent.getParent() == null) {
                if (parent instanceof JComponent) {
                    JComponent jc = (JComponent)parent;
                    parent = jc.getRootPane();
                    continue;
                }
                parent = parent.getParent();
                continue;
            }
            parent = parent.getParent();
        }
        return parentFrame;
    }

    public static Window getParentWindow(Component comp) {
        Window parentWindow = null;
        Component parent = comp;
        while (parent != null) {
            if (parent instanceof Window) {
                parentWindow = (Window)parent;
                parent = null;
                continue;
            }
            parent = parent.getParent();
        }
        return parentWindow;
    }

    public static Dialog getParentDialog(Component comp) {
        Dialog parentDialog = null;
        Component parent = comp;
        while (parent != null) {
            if (parent instanceof Dialog) {
                parentDialog = (Dialog)parent;
                parent = null;
                continue;
            }
            parent = parent.getParent();
        }
        return parentDialog;
    }

    public static Dimension getBestWindowSize(Dimension x) {
        Toolkit tkt = Toolkit.getDefaultToolkit();
        Dimension realSize = tkt.getScreenSize();
        Dimension retDim = new Dimension(x);
        if (x.height > realSize.height || x.width > realSize.width) {
            retDim.height = realSize.height;
            retDim.width = realSize.width;
        }
        return retDim;
    }

    public static void makeButtonsUniform(JButton[] buttonArray) {
        int i;
        Dimension buttonSize = new Dimension(0, 0);
        for (i = 0; i < buttonArray.length; ++i) {
            buttonArray[i].setPreferredSize(null);
            Dimension preferredSize = buttonArray[i].getPreferredSize();
            buttonSize.width = Math.max(buttonSize.width, preferredSize.width);
            buttonSize.height = Math.max(buttonSize.height, preferredSize.height);
        }
        for (i = 0; i < buttonArray.length; ++i) {
            buttonArray[i].setPreferredSize(buttonSize);
        }
    }

    public static MinimumResizeListener newMinimumResizeListener(Window window, Dimension minimumSize) {
        return new MinimumResizeListener(window, minimumSize);
    }

    public static MinimumResizeListener newMinimumResizeListener(Window window) {
        return new MinimumResizeListener(window);
    }

    public static void setButtonLabelandMnem(JButton button, String string) {
        String noMnem = Util.getLabelWithoutMnemonic((String)string);
        button.setText(noMnem);
        button.getAccessibleContext().setAccessibleName(noMnem);
        int index = Util.getDisplayedMnemonicIndex((String)string);
        if (index > -1) {
            int mnemonic = Util.getDisplayedMnemonic((String)string);
            button.setMnemonic(mnemonic);
            button.setDisplayedMnemonicIndex(index);
        }
    }

    public static void setDeepEnabled(Component comp, boolean state) {
        comp.setEnabled(state);
        if (comp instanceof Container) {
            Container container = (Container)comp;
            Component[] compArray = container.getComponents();
            for (int index = 0; index < compArray.length; ++index) {
                WindowUtil.setDeepEnabled(compArray[index], state);
            }
        }
    }
}

