/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.imsmc.visuals;

import com.sas.services.ServiceException;
import com.sas.services.connection.HostPortPair;
import com.sas.services.connection.HostPortSet;
import com.sas.services.user.UserServiceInterface;
import com.sas.swing.util.SASJavaHelp;
import com.sas.util.ChainedException;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.imsmc.visuals.BaseDialog;
import com.sas.workspace.imsmc.visuals.InternalLoginPasswordChangePanel;
import java.awt.Dialog;
import java.awt.Frame;
import java.rmi.RemoteException;
import org.omg.CORBA.COMM_FAILURE;

public class InternalLoginPasswordChangeDialog
extends BaseDialog {
    private static final long serialVersionUID = 1L;
    InternalLoginPasswordChangePanel m_ilpcp = null;
    private static final WAdminResource bundle = new WAdminResource(InternalLoginPasswordChangeDialog.class);
    private String m_userName;
    private String m_host;
    private String m_port;
    private UserServiceInterface m_userService;
    private String m_productName;
    public boolean m_success = false;

    public InternalLoginPasswordChangeDialog(Frame parent, String name, String productName) {
        super(parent, true);
        this.m_productName = productName;
        this.m_userName = name;
        this.setTitle(bundle.getString("InternalLoginPasswordChangeDialog.Title.txt"));
        this.setHelpID(new SASJavaHelp("newworkspace"), "reset_password");
        this.initialize();
    }

    public InternalLoginPasswordChangeDialog(Dialog parent, String name, String productName) {
        super(parent, true);
        this.m_productName = productName;
        this.m_userName = name;
        this.setTitle(bundle.getString("InternalLoginPasswordChangeDialog.Title.txt"));
        this.setHelpID(new SASJavaHelp("newworkspace"), "reset_password");
        this.initialize();
    }

    public void setPort(String port) {
        this.m_port = port;
    }

    public void setUserService(UserServiceInterface userService) {
        this.m_userService = userService;
    }

    public void setHost(String host) {
        this.m_host = host;
    }

    public void initialize() {
        this.m_ilpcp = new InternalLoginPasswordChangePanel(this.m_userName, false, true, this.m_productName);
        this.setDialogPanel(this.m_ilpcp);
    }

    @Override
    public void onOK() {
        boolean success = false;
        if (this.m_ilpcp.validateData()) {
            try {
                String newone;
                String oldone = this.m_ilpcp.getOldPassword();
                if (!SasPasswordString.isEncoded((String)oldone)) {
                    oldone = SasPasswordString.encode((String)oldone);
                }
                if (!SasPasswordString.isEncoded((String)(newone = this.m_ilpcp.getNewPassword()))) {
                    newone = SasPasswordString.encode((String)newone);
                }
                HostPortSet set = HostPortSet.newInstance((String)this.m_host, (String)this.m_port);
                for (HostPortPair pair : set) {
                    try {
                        this.m_userService.resetInternalPassword(pair.getHost(), String.valueOf(pair.getPort()), this.m_userName, oldone, newone);
                        success = true;
                    }
                    catch (ServiceException exc) {
                        if (ChainedException.chainContains((Throwable)exc, COMM_FAILURE.class)) continue;
                        MessageUtil.displayMessage(exc.getLocalizedMessage(), this.m_productName, 0);
                    }
                    catch (RemoteException exc) {
                        MessageUtil.displayMessage(exc.getLocalizedMessage(), this.m_productName, 0);
                    }
                    break;
                }
            }
            catch (SasPasswordEncodingException exc) {
                MessageUtil.displayMessage(exc.getLocalizedMessage(), this.m_productName, 0);
            }
            if (success) {
                this.setVisible(false);
            }
            this.m_success = success;
        }
    }
}

