/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.imsmc.visuals;

import com.sas.workspace.imsmc.visuals.BaseComboBox;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class BaseTextArea
extends JTextArea {
    private static final long serialVersionUID = 714680712275925455L;
    private static BaseComboBox m_baseCombo = new BaseComboBox();

    public BaseTextArea(boolean edit, boolean canSelect) {
        this.setStyle(edit, canSelect);
    }

    public BaseTextArea(String text, boolean edit, boolean canSelect) {
        super(text);
        this.setStyle(edit, canSelect);
    }

    public void setStyle(boolean edit, boolean canSelect) {
        this.setEditable(edit);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setOpaque(edit);
        this.setFocusable(canSelect);
        this.setFont(m_baseCombo.getFont());
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        if (!edit && canSelect) {
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    BaseTextArea.this.getCaret().setVisible(true);
                }

                @Override
                public void focusLost(FocusEvent e) {
                    BaseTextArea.this.getCaret().setVisible(false);
                }
            });
        }
    }

    public JScrollPane createScrollPane(int rows, boolean border) {
        JScrollPane retValue = new JScrollPane(this);
        this.setRows(rows);
        retValue.setFocusable(false);
        retValue.getHorizontalScrollBar().setFocusable(false);
        retValue.getVerticalScrollBar().setFocusable(false);
        if (border) {
            if (this.isEditable()) {
                retValue.setBorder(BorderFactory.createLoweredBevelBorder());
            } else {
                retValue.setBorder(BorderFactory.createEtchedBorder());
            }
        } else {
            retValue.setBorder(BorderFactory.createEmptyBorder());
        }
        return retValue;
    }

    @Override
    public void processComponentKeyEvent(KeyEvent event) {
        if (event.getKeyCode() == 9 || event.getKeyChar() == '\t') {
            if (event.getID() == 400) {
                if ((event.getModifiersEx() & 0x40) > 0) {
                    super.transferFocusBackward();
                } else {
                    super.transferFocus();
                }
            }
            event.consume();
            return;
        }
        super.processComponentKeyEvent(event);
    }
}

