/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.imsmc.model;

import com.sas.swing.util.SASJavaHelp;
import com.sas.util.ChainedException;
import com.sas.workspace.imsmc.ApplicationProperty;
import com.sas.workspace.imsmc.ApplicationResource;
import com.sas.workspace.imsmc.model.DisplayLater;
import com.sas.workspace.imsmc.model.HelpButtonListener;
import com.sas.workspace.imsmc.model.MessageHandler;
import com.sas.workspace.imsmc.visuals.BaseTextArea;
import com.sas.workspace.imsmc.visuals.FlatSplitPane;
import com.sas.workspace.imsmc.visuals.MinimumResizeListener;
import com.sas.workspace.imsmc.visuals.WindowUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class MessageUtil {
    protected static ApplicationResource bundle = new ApplicationResource(MessageUtil.class);
    protected static JButton m_okBut = null;
    static final String _showFullExceptionButtonLabel = bundle.getString("ShowFullExceptionText.txt");
    static final String _hideFullExceptionButtonLabel = bundle.getString("HideFullExceptionText.txt");
    static final String _exceptionAtStackTracePrefix = bundle.getString("ExceptionAtStackTracePrefix.txt");
    static final String _showEachChainedStackTraceButtonLabel = bundle.getString("ShowEachChainedStackTrace.txt");
    static final String _hideEachChainedStackTraceButtonLabel = bundle.getString("HideEachChainedStackTrace.txt");
    static final String _showReasonsInStackTraceButtonLabel = bundle.getString("ShowReasonsInStackTrace.txt");
    static final String _hideReasonsInStackTraceButtonLabel = bundle.getString("HideReasonsInStackTrace.txt");

    public static boolean displayMessagesAndCheckForErrors(Component parent, MessageHandler messageHandler) {
        boolean bError = messageHandler.failureHasOccurred();
        MessageUtil.displayMessages(parent, messageHandler);
        return bError;
    }

    public static void displayMessages(Component parent, MessageHandler messageHandler) {
        MessageUtil.displayMessages(parent, messageHandler, null);
    }

    public static void displayMessages(Component parent, MessageHandler messageHandler, String title) {
        MessageUtil.displayMessages(parent, messageHandler, title, null, null);
    }

    public static void displayMessages(Component parent, MessageHandler messageHandler, String title, SASJavaHelp javahelp, String helpid) {
        String[] messages;
        if (title == null) {
            title = bundle.getString("ApplicationName.txt");
        }
        if ((messages = messageHandler.getMessages()).length == 0) {
            return;
        }
        BaseTextArea text = MessageUtil.newWrappedTextArea(messageHandler.getOneBigMessage(), 2, 60, 6, 80, true);
        JScrollPane scrollPane = new JScrollPane(text);
        final JPanel allContent = new JPanel(new BorderLayout());
        final JPanel topContent = new JPanel(new GridBagLayout());
        int widthT = text.getPreferredSize().width + 60;
        int heightT = text.getPreferredSize().height + 5;
        topContent.setMinimumSize(new Dimension(widthT, heightT));
        topContent.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 18, 1, new Insets(0, 0, 3, 0), 0, 0));
        allContent.add((Component)topContent, "Center");
        if (messageHandler.hasThrowable()) {
            boolean useExceptionTextbutton;
            JScrollPane scrollCollapsed;
            Throwable t = messageHandler.getThrowable();
            Throwable rootCause = null;
            if (t instanceof ChainedException) {
                rootCause = ((ChainedException)t).getRootException();
            }
            if (rootCause == null) {
                rootCause = t.getCause();
            }
            if (rootCause != null && rootCause != t) {
                BaseTextArea textRoot = MessageUtil.newWrappedTextArea(MessageUtil.throwableMessage(rootCause), 2, 80, 8, 80, true);
                heightT += textRoot.getPreferredSize().height + 5;
                scrollCollapsed = new JScrollPane(textRoot);
            } else {
                scrollCollapsed = null;
            }
            StringBuffer buffer = new StringBuffer();
            List list = MessageUtil.throwableToStringList(t, false, false);
            for (int i = 0; i < list.size(); ++i) {
                buffer.append(list.get(i) + (i + 1 < list.size() ? "\n" : ""));
            }
            String throwableTextPlain = buffer.toString().trim();
            buffer.setLength(0);
            list = MessageUtil.throwableToStringList(t, true, false);
            for (int i = 0; i < list.size(); ++i) {
                buffer.append(list.get(i) + (i + 1 < list.size() ? "\n" : ""));
            }
            String throwableTextWithChained = buffer.toString().trim();
            buffer.setLength(0);
            list = MessageUtil.throwableToStringList(t, false, true);
            for (int i = 0; i < list.size(); ++i) {
                buffer.append(list.get(i) + (i + 1 < list.size() ? "\n" : ""));
            }
            String throwableTextWithReasons = buffer.toString().trim();
            buffer.setLength(0);
            list = MessageUtil.throwableToStringList(t, true, true);
            for (int i = 0; i < list.size(); ++i) {
                buffer.append(list.get(i) + (i + 1 < list.size() ? "\n" : ""));
            }
            String throwableTextWithReasonsAndChained = buffer.toString().trim();
            buffer.setLength(0);
            boolean bl = useExceptionTextbutton = throwableTextPlain.length() > 0 || throwableTextWithChained.length() > 0 || throwableTextWithReasons.length() > 0 || throwableTextWithReasonsAndChained.length() > 0;
            if (useExceptionTextbutton) {
                FlatSplitPane flatSplitPane = new FlatSplitPane(2, 20, 20);
                final JSplitPane splitPane = flatSplitPane.getSplitter();
                splitPane.setBorder(null);
                JPanel botContent = new JPanel(new GridBagLayout());
                boolean showEachChainedStackTrace = ApplicationProperty.getBooleanProperty("ShowEachChainedStackTrace", false);
                boolean showReasonsInStackTrace = ApplicationProperty.getBooleanProperty("ShowReasonsInStackTrace", false);
                final boolean useChainedButton = showEachChainedStackTrace && useExceptionTextbutton && (0 != throwableTextWithReasons.compareTo(throwableTextWithReasonsAndChained) || 0 != throwableTextPlain.compareTo(throwableTextWithChained));
                final boolean useReasonsButton = showReasonsInStackTrace && useExceptionTextbutton && (0 != throwableTextWithChained.compareTo(throwableTextWithReasonsAndChained) || 0 != throwableTextPlain.compareTo(throwableTextWithReasons));
                final BaseTextArea textAreaPlain = MessageUtil.newWrappedTextArea(throwableTextPlain, 5, 80, 15, 80, false);
                final BaseTextArea textAreaChained = useChainedButton ? MessageUtil.newWrappedTextArea(throwableTextWithChained, 5, 80, 15, 80, false) : textAreaPlain;
                final BaseTextArea textAreaReasons = useReasonsButton ? MessageUtil.newWrappedTextArea(throwableTextWithReasons, 5, 80, 15, 80, false) : textAreaPlain;
                final BaseTextArea textAreaReasonsAndChained = useChainedButton && useReasonsButton ? MessageUtil.newWrappedTextArea(throwableTextWithReasonsAndChained, 5, 80, 15, 80, false) : textAreaPlain;
                BaseTextArea startingTextArea = null;
                startingTextArea = useChainedButton ? (useReasonsButton ? textAreaReasonsAndChained : textAreaChained) : (useReasonsButton ? textAreaReasons : textAreaPlain);
                final JScrollPane scrollExpanded = new JScrollPane(startingTextArea);
                scrollExpanded.setVisible(false);
                final JButton fullExceptionButton = new JButton(_showFullExceptionButtonLabel);
                final JButton buttonChained = useChainedButton ? new JButton(_hideEachChainedStackTraceButtonLabel) : null;
                final JButton buttonReasons = useReasonsButton ? new JButton(_hideReasonsInStackTraceButtonLabel) : null;
                ActionListener al = new ActionListener(){
                    boolean showChainedTottle;
                    boolean showReasonsToggle;
                    boolean showExceptionText;
                    {
                        this.showChainedTottle = useChainedButton;
                        this.showReasonsToggle = useReasonsButton;
                        this.showExceptionText = false;
                    }

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        JButton source = (JButton)event.getSource();
                        if (source == fullExceptionButton) {
                            boolean bl = this.showExceptionText = !this.showExceptionText;
                            if (this.showExceptionText) {
                                fullExceptionButton.setText(_hideFullExceptionButtonLabel);
                                splitPane.setTopComponent(topContent);
                                allContent.removeAll();
                                allContent.add((Component)splitPane, "Center");
                            } else {
                                fullExceptionButton.setText(_showFullExceptionButtonLabel);
                                if (scrollCollapsed == null) {
                                    allContent.removeAll();
                                    allContent.add((Component)topContent, "Center");
                                }
                            }
                            scrollExpanded.setVisible(this.showExceptionText);
                            if (scrollCollapsed != null) {
                                scrollCollapsed.setVisible(!this.showExceptionText);
                            }
                            if (buttonChained != null) {
                                buttonChained.setVisible(this.showExceptionText);
                            }
                            if (buttonReasons != null) {
                                buttonReasons.setVisible(this.showExceptionText);
                            }
                            WindowUtil.getParentWindow(source).pack();
                        } else {
                            if (source == buttonReasons) {
                                this.showReasonsToggle = !this.showReasonsToggle;
                                buttonReasons.setText(this.showReasonsToggle ? _hideReasonsInStackTraceButtonLabel : _showReasonsInStackTraceButtonLabel);
                            } else {
                                this.showChainedTottle = !this.showChainedTottle;
                                buttonChained.setText(this.showChainedTottle ? _hideEachChainedStackTraceButtonLabel : _showEachChainedStackTraceButtonLabel);
                            }
                            BaseTextArea textArea = null;
                            textArea = this.showChainedTottle ? (this.showReasonsToggle ? textAreaReasonsAndChained : textAreaChained) : (this.showReasonsToggle ? textAreaReasons : textAreaPlain);
                            if (textArea != scrollExpanded.getViewport().getView()) {
                                scrollExpanded.setViewportView(textArea);
                            }
                        }
                    }
                };
                fullExceptionButton.addActionListener(al);
                topContent.add((Component)fullExceptionButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 4, 0, 4), 0, 0));
                if (buttonReasons != null) {
                    buttonReasons.addActionListener(al);
                    botContent.add((Component)buttonReasons, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(10, 4, 0, 4), 0, 0));
                    buttonReasons.setVisible(scrollExpanded.isVisible());
                }
                if (buttonChained != null) {
                    buttonChained.addActionListener(al);
                    botContent.add((Component)buttonChained, new GridBagConstraints(1, 2, 1, 0, 0.0, 0.0, 11, 2, new Insets(10, 4, 0, 4), 0, 0));
                    buttonChained.setVisible(scrollExpanded.isVisible());
                }
                int expandedConstraintsWidth = useChainedButton || useReasonsButton ? 1 : 2;
                GridBagConstraints expandedConstraints = new GridBagConstraints(0, 1, expandedConstraintsWidth, 3, 1.0, 1.0, 15, 1, new Insets(5, 0, 0, 0), 0, 0);
                botContent.add((Component)scrollExpanded, expandedConstraints);
                splitPane.setBottomComponent(botContent);
                if (scrollCollapsed != null) {
                    botContent.add((Component)scrollCollapsed, new GridBagConstraints(0, 1, 2, 3, 1.0, 1.0, 15, 1, new Insets(5, 0, 0, 0), 0, 0));
                    splitPane.setTopComponent(topContent);
                    allContent.add((Component)splitPane, "Center");
                }
                if (scrollCollapsed != null || useChainedButton || useReasonsButton) {
                    heightT += 14;
                }
            }
        }
        int icon = 2;
        if (messageHandler.failureHasOccurred()) {
            icon = 0;
        }
        JButton okbutton = new JButton(bundle.getString("Common.OK.txt"));
        JButton helpbutton = new JButton(bundle.getString("Standard.ButtonLabel.Help.txt"));
        Object[] options = new Object[]{okbutton, helpbutton};
        Object[] optionsNoHelp = new Object[]{okbutton};
        JOptionPane pane = null;
        pane = javahelp != null && helpid != null ? new JOptionPane(allContent, icon, -1, null, options, options[0]) : new JOptionPane(allContent, icon, -1, null, optionsNoHelp, optionsNoHelp[0]);
        final JDialog dialog = pane.createDialog(parent, title);
        dialog.setResizable(true);
        int widthT2 = Math.max(Math.min(widthT + 20, 600), 150);
        int heightT2 = Math.max(Math.min(heightT + 80, 400), 50);
        MinimumResizeListener mrl = WindowUtil.newMinimumResizeListener(dialog, new Dimension(widthT2, heightT2));
        okbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        helpbutton.addActionListener(new HelpButtonListener(helpid, javahelp));
        if (javahelp != null && helpid != null) {
            javahelp.setActivationWindow((Window)dialog);
            javahelp.enableHelpKey((Component)pane, javahelp.getDocProduct(), helpid);
        }
        dialog.setVisible(true);
        messageHandler.removeAllMessages();
        mrl.dispose();
    }

    public static String throwableToString(Throwable t) {
        StringWriter strWriter = new StringWriter();
        PrintWriter pwrtr = new PrintWriter(strWriter);
        String firstmsg = MessageUtil.throwableMessage(t);
        String lastmsg = "";
        Throwable ch = t;
        while (ch != null) {
            String msg = MessageUtil.throwableMessage(ch);
            if (msg != null) {
                if (msg.compareTo(lastmsg) != 0) {
                    pwrtr.println(msg);
                    lastmsg = msg;
                }
            } else {
                pwrtr.println("message is null for " + ch.getClass());
            }
            if (ch instanceof ChainedException) {
                if (((ChainedException)ch).getTargetException() != null) {
                    ch = ((ChainedException)ch).getTargetException();
                    continue;
                }
                ch = ch.getCause();
                continue;
            }
            if (ch instanceof Exception) {
                ch = ((Exception)ch).getCause();
                continue;
            }
            ch = null;
        }
        pwrtr.println();
        t.printStackTrace(pwrtr);
        Throwable rootCause = null;
        if (t instanceof ChainedException) {
            rootCause = ((ChainedException)t).getRootException();
        }
        if (rootCause == null) {
            rootCause = t.getCause();
        }
        if (rootCause != null && rootCause != t && rootCause != ch) {
            String msg = MessageUtil.throwableMessage(rootCause);
            if (msg != null && msg.compareTo(firstmsg) != 0) {
                pwrtr.println();
                pwrtr.println(msg);
            }
            pwrtr.println();
            rootCause.printStackTrace(pwrtr);
        }
        String string = strWriter.toString();
        return string;
    }

    public static List throwableToStringList(Throwable t) {
        boolean showEachChained = ApplicationProperty.getBooleanProperty("ShowEachChainedStackTrace", false);
        boolean showReasons = ApplicationProperty.getBooleanProperty("ShowReasonsInStackTrace", false);
        return MessageUtil.throwableToStringList(t, showEachChained, showReasons);
    }

    public static List throwableToStringList(Throwable t, boolean showEachChained, boolean showReasons) {
        ArrayList<Object> combinedStacks = new ArrayList<Object>();
        String firstmsg = MessageUtil.throwableMessage(t);
        String lastmsg = "";
        Throwable ch = t;
        while (ch != null) {
            String msg;
            StackTraceElement[] stack = ch.getStackTrace();
            int stackMergeAt = stack.length - 1;
            for (int i = 0; i < stack.length; ++i) {
                if (!combinedStacks.contains(stack[i])) continue;
                stackMergeAt = i;
                break;
            }
            for (int k = stackMergeAt; k >= 0; --k) {
                combinedStacks.add(stack[k]);
            }
            String chMsg = ch.toString();
            if (chMsg.compareTo(lastmsg) != 0) {
                lastmsg = chMsg;
                combinedStacks.add(chMsg);
                if (!showEachChained) {
                    combinedStacks.add(" ");
                }
            }
            if ((msg = MessageUtil.throwableMessage(ch)) != null && msg.compareTo(lastmsg) != 0) {
                lastmsg = msg;
                if (showEachChained) {
                    combinedStacks.add(" ");
                }
                combinedStacks.add(msg);
            }
            if (!showEachChained) break;
            ch = ch instanceof ChainedException ? (((ChainedException)ch).getTargetException() != null ? ((ChainedException)ch).getTargetException() : ch.getCause()) : (ch instanceof Exception ? ((Exception)ch).getCause() : null);
            if (ch == null) continue;
            combinedStacks.add(" ");
        }
        Throwable rootCause = null;
        if (t instanceof ChainedException) {
            rootCause = ((ChainedException)t).getRootException();
        }
        if (rootCause == null) {
            rootCause = t.getCause();
        }
        if (rootCause != null && rootCause != t && rootCause != ch) {
            String msg;
            combinedStacks.add(" ");
            StackTraceElement[] stack = rootCause.getStackTrace();
            int stackMergeAt = stack.length - 1;
            for (int i = 0; i < stack.length; ++i) {
                if (!combinedStacks.contains(stack[i])) continue;
                stackMergeAt = i;
                break;
            }
            for (int k = stackMergeAt; k >= 0; --k) {
                combinedStacks.add(stack[k]);
            }
            String chMsg = rootCause.toString();
            if (chMsg.compareTo(firstmsg) != 0 && chMsg.compareTo(lastmsg) != 0) {
                lastmsg = chMsg;
                combinedStacks.add(chMsg);
            }
            if ((msg = MessageUtil.throwableMessage(rootCause)) != null && msg.compareTo(firstmsg) != 0 && msg.compareTo(lastmsg) != 0) {
                combinedStacks.add(" ");
                combinedStacks.add(msg);
            }
        }
        ArrayList<String> result = new ArrayList<String>(combinedStacks.size());
        for (int j = combinedStacks.size() - 1; j >= 0; --j) {
            Object obj = combinedStacks.get(j);
            if (obj instanceof StackTraceElement) {
                result.add(_exceptionAtStackTracePrefix + obj);
                continue;
            }
            result.add((String)obj);
        }
        return result;
    }

    public static BaseTextArea newWrappedTextArea(String text, int minLines, int minColumns, int maxLines, int maxColumns, boolean wrapText) {
        int lines = 1;
        int columns = 0;
        int largestColumn = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '\n') {
                if (columns > largestColumn) {
                    largestColumn = columns;
                }
                columns = 0;
                ++lines;
                continue;
            }
            if (!wrapText || maxColumns == -1 || ++columns <= maxColumns) continue;
            columns = 0;
            ++lines;
        }
        if (columns > largestColumn) {
            largestColumn = columns;
        }
        if (maxLines != -1) {
            if (lines > maxLines && maxColumns != -1) {
                ++maxColumns;
            }
            lines = Math.min(maxLines, lines);
        }
        lines = Math.max(minLines, lines);
        if (maxColumns != -1) {
            if (largestColumn > maxColumns) {
                lines -= 2;
            }
            largestColumn = Math.min(maxColumns, largestColumn + 1);
        }
        largestColumn = Math.max(minColumns, largestColumn);
        BaseTextArea textArea = new BaseTextArea(false, true);
        textArea.setRows(lines);
        textArea.setColumns(largestColumn);
        textArea.setText(text);
        textArea.setLineWrap(wrapText);
        textArea.setCaretPosition(0);
        return textArea;
    }

    public static String throwableMessage(Throwable t) {
        if (t == null) {
            return null;
        }
        String msg = t.getLocalizedMessage();
        if (msg == null) {
            msg = t.getMessage();
        }
        if (msg == null) {
            msg = t.toString();
        }
        return msg;
    }

    public static void displayMessagesLater(Component parent, MessageHandler messageHandler) {
        new DisplayLater(parent, messageHandler);
    }

    public static void displayMessagesLater(MessageHandler messageHandler) {
        MessageUtil.displayMessagesLater(null, messageHandler);
    }

    public static boolean displayMessageForOkCancel(Component parent, String message) {
        return MessageUtil.displayMessageForOkCancel(parent, message, null);
    }

    public static boolean displayMessageForOkCancel(Component parent, String message, String title) {
        JScrollPane scrollArea;
        int result;
        if (title == null) {
            title = bundle.getString("ApplicationName.txt");
        }
        boolean ok = (result = JOptionPane.showConfirmDialog(parent, scrollArea = new JScrollPane(MessageUtil.newWrappedTextArea(message, 5, 60, 15, 80, true)), title, 2, 2)) == 0;
        return ok;
    }

    public static void displayException(Exception e) {
        MessageHandler messages = new MessageHandler();
        e.printStackTrace();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        messages.addError(e.toString());
        messages.addError(stringWriter.getBuffer().toString());
        MessageUtil.displayMessages(null, messages);
    }
}

