/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.changemanagement;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class CMMetadataUtil {
    private CMMetadataUtil() {
    }

    public static String getLockedByName(Root mdo) throws MdException, RemoteException {
        return CMMetadataUtil.getLockedByName(mdo.getCMetadataType(), mdo.getFQID());
    }

    public static String getLockedByName(String sType, String sFQID) throws MdException, RemoteException {
        String sLockedByFQID = CMMetadataUtil.getLockedByFQID(sType, sFQID);
        return sLockedByFQID == null ? null : CMMetadataUtil.getNameForFQID(sLockedByFQID);
    }

    public static String getLockedByName(SimpleObject simpleObject) throws MdException, RemoteException {
        String sLockedByFQID = CMMetadataUtil.getLockedByFQID(simpleObject.getMetadataType(), simpleObject.getID());
        return sLockedByFQID == null ? null : CMMetadataUtil.getNameForFQID(sLockedByFQID);
    }

    public static String getLockedByName(SimpleBrowseObject simpleBrowseObject) throws MdException, RemoteException {
        String sLockedByFQID = simpleBrowseObject.getLockedBy();
        return sLockedByFQID == null || sLockedByFQID.length() == 0 ? null : CMMetadataUtil.getNameForFQID(sLockedByFQID);
    }

    public static String getLockedByFQID(Root mdo) throws MdException, RemoteException {
        return CMMetadataUtil.getLockedByFQID(mdo.getCMetadataType(), mdo.getFQID());
    }

    public static String getLockedByFQID(String sType, String sFQID) throws MdException, RemoteException {
        String sLockedByFQID = CMMetadataUtil.getAttributeValue(sType, sFQID, "LockedBy");
        return sLockedByFQID.length() == 0 ? null : sLockedByFQID;
    }

    private static String getNameForFQID(String sFQID) throws MdException, RemoteException {
        try {
            return CMMetadataUtil.getAttributeValue("Person", sFQID, "Name");
        }
        catch (MdException ex) {
            return CMMetadataUtil.getAttributeValue("Identity", sFQID, "Name");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
            return CMMetadataUtil.getAttributeValue("Identity", sFQID, "Name");
        }
    }

    private static String getAttributeValue(String sType, String sFQID, String sAttr) throws MdException, RemoteException {
        ArrayList<String> lAttrs = new ArrayList<String>();
        lAttrs.add(sAttr);
        List lValues = Workspace.getMdFactory().getOMIUtil().getMetadataSimple(sType, sFQID, lAttrs);
        return (String)lValues.get(0);
    }
}

