/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.Workspace;
import java.util.ArrayList;
import java.util.List;

public class WsWorkManager {
    private static WsWorkManager s_instance;
    private List m_lstWork;
    private Object m_lock = new Object();

    private WsWorkManager() {
        this.m_lstWork = new ArrayList();
        for (int iThread = 0; iThread < 1; ++iThread) {
            new WorkerThread(iThread).start();
        }
    }

    public static WsWorkManager getInstance() {
        if (s_instance == null) {
            s_instance = new WsWorkManager();
        }
        return s_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWork(Runnable work) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_lstWork.add(work);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnable getWork() {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_lstWork.isEmpty()) {
                return null;
            }
            return (Runnable)this.m_lstWork.remove(0);
        }
    }

    private class WorkerThread
    extends Thread {
        public WorkerThread(int iThread) {
            super("WorkerThread " + iThread);
        }

        @Override
        public void run() {
            while (true) {
                Runnable work;
                if ((work = WsWorkManager.this.getWork()) == null) {
                    try {
                        WorkerThread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    work.run();
                    continue;
                }
                catch (Exception ex) {
                    Workspace.getDefaultLogger().error((Object)"", ex);
                    continue;
                }
                break;
            }
        }
    }
}

