/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.swing.visuals.util.Util;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsDropMenuAction;
import com.sas.workspace.WsFlatButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.JTableHeader;

public class WsUIUtilities {
    private static final int AUTOSCROLL_MOUSE_DISTANCE = 10;
    private static final WAdminResource bundle = WAdminResource.getBundle(WsUIUtilities.class);
    public static final FocusListener BUTTON_FOCUS_LISTENER = new ButtonFocusListener();
    private static Font SYSTEM_DEFAULT_FONT;
    private static double X_DIALOG_UNIT;
    private static double Y_DIALOG_UNIT;
    public static final int HAS_TEXT = 1;
    public static final int HAS_ICON = 2;
    public static final int HAS_TIP = 4;

    private WsUIUtilities() {
    }

    public static Font getSystemDefaultFont() {
        if (SYSTEM_DEFAULT_FONT == null) {
            WsUIUtilities.initializeSystemDefaultFont();
        }
        return SYSTEM_DEFAULT_FONT;
    }

    public static double getXDialogUnit() {
        if (SYSTEM_DEFAULT_FONT == null) {
            WsUIUtilities.initializeSystemDefaultFont();
        }
        return X_DIALOG_UNIT;
    }

    public static double getYDialogUnit() {
        if (SYSTEM_DEFAULT_FONT == null) {
            WsUIUtilities.initializeSystemDefaultFont();
        }
        return Y_DIALOG_UNIT;
    }

    private static void initializeSystemDefaultFont() {
        JLabel lbl = new JLabel();
        SYSTEM_DEFAULT_FONT = lbl.getFont();
        FontMetrics fm = lbl.getFontMetrics(SYSTEM_DEFAULT_FONT);
        X_DIALOG_UNIT = (double)fm.stringWidth("x") * 0.25;
        Y_DIALOG_UNIT = (double)fm.getHeight() * 0.125;
    }

    public static Rectangle getVirtualScreenExtent() {
        Rectangle rBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] aDevices = ge.getScreenDevices();
        for (int iDevice = 0; iDevice < aDevices.length; ++iDevice) {
            GraphicsConfiguration[] aConfigurations = aDevices[iDevice].getConfigurations();
            for (int iConfiguration = 0; iConfiguration < aConfigurations.length; ++iConfiguration) {
                rBounds = rBounds.union(aConfigurations[iConfiguration].getBounds());
            }
        }
        return rBounds;
    }

    public static void center(Dialog dlg) {
        Dimension szDialog = dlg.getPreferredSize();
        Dimension szParent = dlg.getParent().getSize();
        Point ptParent = dlg.getParent().getLocation();
        int x = ptParent.x + (szParent.width - szDialog.width) / 2;
        int y = ptParent.y + (szParent.height - szDialog.height) / 2;
        Rectangle rVirtualScreen = WsUIUtilities.getVirtualScreenExtent();
        x = Math.max(rVirtualScreen.x, Math.min(x, rVirtualScreen.width - szDialog.width));
        y = Math.max(rVirtualScreen.y, Math.min(y, rVirtualScreen.height - szDialog.height));
        dlg.setLocation(x, y);
    }

    public static boolean isXPThemeActive() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Boolean themeActive = (Boolean)toolkit.getDesktopProperty("win.xpstyle.themeActive");
        return themeActive != null && themeActive != false;
    }

    public static void autoscrollForDragEvent(DropTargetDragEvent e) {
        Container cntGrandParent;
        Component cmp = e.getDropTargetContext().getComponent();
        Container cntParent = cmp.getParent();
        if (cntParent instanceof JViewport && (cntGrandParent = cntParent.getParent()) instanceof JScrollPane) {
            Point pt = e.getLocation();
            JScrollPane scr = (JScrollPane)cntGrandParent;
            JScrollBar sbrHorizontal = scr.getHorizontalScrollBar();
            JScrollBar sbrVertical = scr.getVerticalScrollBar();
            if (sbrVertical != null) {
                int y = sbrVertical.getValue();
                if (pt.y < y + 10) {
                    sbrVertical.setValue(y - sbrVertical.getUnitIncrement(-1));
                }
                if (pt.y > y + cntParent.getBounds().height - 10) {
                    sbrVertical.setValue(y + sbrVertical.getUnitIncrement(1));
                }
            }
            if (sbrHorizontal != null) {
                int x = sbrHorizontal.getValue();
                if (pt.x < x + 10) {
                    sbrHorizontal.setValue(x - sbrHorizontal.getUnitIncrement(-1));
                }
                if (pt.x > x + cntParent.getBounds().width - 10) {
                    sbrHorizontal.setValue(x + sbrHorizontal.getUnitIncrement(1));
                }
            }
        }
    }

    public static void adjustScrollPanePreferredSize(JScrollPane scr) {
        Dimension dim = scr.getPreferredSize();
        if (scr.getVerticalScrollBarPolicy() != 21) {
            dim.width += scr.getVerticalScrollBar().getPreferredSize().width;
        }
        if (scr.getHorizontalScrollBarPolicy() != 31) {
            dim.height += scr.getHorizontalScrollBar().getPreferredSize().height;
        }
        scr.setPreferredSize(dim);
    }

    public static void adjustPreferredScrollableViewportSize(JTable tbl, int nRows) {
        int cy = nRows * tbl.getRowHeight();
        JTableHeader hdr = tbl.getTableHeader();
        if (hdr != null) {
            cy += hdr.getPreferredSize().height;
        }
        int cx = 0;
        for (int iColumn = 0; iColumn < tbl.getColumnCount(); ++iColumn) {
            cx += tbl.getColumnModel().getColumn(iColumn).getPreferredWidth();
        }
        tbl.setPreferredScrollableViewportSize(new Dimension(cx, cy));
    }

    public static JButton createTextButton(WsAbstractAction act) {
        JButton btn = new JButton(act);
        btn.setIcon(null);
        Integer iMnem = (Integer)act.getValue("MnemonicIndex");
        if (iMnem != null && iMnem != -1) {
            btn.setDisplayedMnemonicIndex(iMnem);
        }
        return btn;
    }

    public static JButton createToolButton(WsAbstractAction act) {
        JButton btn = new JButton(act);
        btn.setText(null);
        btn.setMnemonic(0);
        Insets ins = btn.getMargin();
        ins.left = ins.top;
        ins.right = ins.bottom;
        btn.setMargin(ins);
        return btn;
    }

    public static JButton createFlatTextButton(WsAbstractAction act) {
        JButton btn = WsUIUtilities.isXPThemeActive() ? new JButton(act) : new WsFlatButton(act);
        btn.setIcon(null);
        Integer iMnem = (Integer)act.getValue("MnemonicIndex");
        if (iMnem != null && iMnem != -1) {
            btn.setDisplayedMnemonicIndex(iMnem);
        }
        btn.addFocusListener(BUTTON_FOCUS_LISTENER);
        return btn;
    }

    public static JButton createFlatToolButton(WsAbstractAction act) {
        JButton btn = WsUIUtilities.isXPThemeActive() ? new JButton(act) : new WsFlatButton(act);
        btn.setText(null);
        btn.setMnemonic(0);
        Insets ins = btn.getMargin();
        ins.left = ins.top;
        ins.right = ins.bottom;
        btn.setMargin(ins);
        btn.addFocusListener(BUTTON_FOCUS_LISTENER);
        return btn;
    }

    public static JButton createFlatTextIconButton(WsAbstractAction act) {
        JButton btn = WsUIUtilities.isXPThemeActive() ? new JButton(act) : new WsFlatButton(act);
        Integer iMnem = (Integer)act.getValue("MnemonicIndex");
        if (iMnem != null && iMnem != -1) {
            btn.setDisplayedMnemonicIndex(iMnem);
        }
        btn.addFocusListener(BUTTON_FOCUS_LISTENER);
        return btn;
    }

    public static JButton createFlatToggleTextButton(WsAbstractToggleAction act) {
        JButton btn = WsUIUtilities.createFlatTextButton(act);
        if (btn instanceof WsFlatButton) {
            ((WsFlatButton)btn).setToggleStyle(true);
        } else {
            WsUIUtilities.changeButtonToToggleStyle(btn);
        }
        act.addButton(btn);
        return btn;
    }

    public static JButton createFlatToggleToolButton(WsAbstractToggleAction act) {
        JButton btn = WsUIUtilities.createFlatToolButton(act);
        if (btn instanceof WsFlatButton) {
            ((WsFlatButton)btn).setToggleStyle(true);
        } else {
            WsUIUtilities.changeButtonToToggleStyle(btn);
        }
        act.addButton(btn);
        return btn;
    }

    public static JButton createFlatToggleTextIconButton(WsAbstractToggleAction act) {
        JButton btn = WsUIUtilities.createFlatTextIconButton(act);
        if (btn instanceof WsFlatButton) {
            ((WsFlatButton)btn).setToggleStyle(true);
        } else {
            WsUIUtilities.changeButtonToToggleStyle(btn);
        }
        act.addButton(btn);
        return btn;
    }

    private static void changeButtonToToggleStyle(JButton btn) {
        JToggleButton.ToggleButtonModel mdl = new JToggleButton.ToggleButtonModel();
        mdl.setSelected(btn.isSelected());
        mdl.setEnabled(btn.isEnabled());
        mdl.setMnemonic(btn.getMnemonic());
        btn.setModel(mdl);
    }

    public static JButton createBrowseButton() {
        JButton btn = new JButton(bundle.getString("WsUIUtilities.Browse.txt"));
        btn.setMargin(new Insets(2, 2, 8, 2));
        Dimension dimButton = btn.getPreferredSize();
        dimButton.height = new JTextField().getPreferredSize().height;
        btn.setPreferredSize(dimButton);
        return btn;
    }

    public static JButton createDropMenuButton() {
        JButton btn = new JButton(bundle.getImageIcon("WsUIUtilities.DropMenu.image"));
        btn.setMargin(new Insets(2, 2, 2, 2));
        btn.setPreferredSize(new Dimension(15, 15));
        return btn;
    }

    public static JButton createDropMenuButton(WsDropMenuAction act) {
        JButton btn = WsUIUtilities.createFlatTextIconButton(act);
        btn.setHorizontalTextPosition(2);
        return btn;
    }

    public static JButton createOptionsDropMenuButton(JPopupMenu menuPopup, boolean bFlat) {
        OptionsAction actOptions = new OptionsAction(menuPopup);
        JButton btn = WsUIUtilities.createFlatTextButton(actOptions);
        btn.setIcon(actOptions.getIcon());
        btn.setHorizontalTextPosition(2);
        return btn;
    }

    public static JLabel createLabelForComponent(JComponent cmp, WAdminResource aBundle, String sKey) {
        JLabel lbl = new JLabel(aBundle.getString(sKey + ".txt"));
        lbl.setDisplayedMnemonic(aBundle.getString(sKey + ".mnem").charAt(0));
        lbl.setLabelFor(cmp);
        return lbl;
    }

    public static JLabel createLabelForComponent(JComponent cmp, String sLabel) {
        int cMnem = Util.getDisplayedMnemonic((String)sLabel);
        int iMnem = Util.getDisplayedMnemonicIndex((String)sLabel);
        sLabel = Util.getLabelWithoutMnemonic((String)sLabel);
        JLabel lbl = new JLabel(sLabel);
        lbl.setDisplayedMnemonic(cMnem);
        lbl.setDisplayedMnemonicIndex(iMnem);
        lbl.setLabelFor(cmp);
        return lbl;
    }

    public static JLabel createLabelAndToolTipForComponent(JComponent cmp, WAdminResource aBundle, String sKey) {
        cmp.setToolTipText(aBundle.getString(sKey + ".ToolTip.txt"));
        return WsUIUtilities.createLabelForComponent(cmp, aBundle, sKey);
    }

    public static JMenu createMenu(WsAbstractAction act) {
        JMenu mnu = new JMenu(act);
        mnu.setToolTipText(null);
        Integer iMnem = (Integer)act.getValue("MnemonicIndex");
        if (iMnem != null && iMnem != -1) {
            mnu.setDisplayedMnemonicIndex(iMnem);
        }
        return mnu;
    }

    public static JMenuItem createMenuItem(WsAbstractAction act) {
        JMenuItem mi = new JMenuItem(act);
        mi.setToolTipText(null);
        Integer iMnem = (Integer)act.getValue("MnemonicIndex");
        if (iMnem != null && iMnem != -1) {
            mi.setDisplayedMnemonicIndex(iMnem);
        }
        return mi;
    }

    public static JCheckBoxMenuItem createCheckBoxMenuItem(WsAbstractToggleAction act) {
        JCheckBoxMenuItem ckb = new JCheckBoxMenuItem(act);
        ckb.setToolTipText(null);
        Integer iMnem = (Integer)act.getValue("MnemonicIndex");
        if (iMnem != null && iMnem != -1) {
            ckb.setDisplayedMnemonicIndex(iMnem);
        }
        act.addButton(ckb);
        return ckb;
    }

    public static JRadioButtonMenuItem createRadioButtonMenuItem(WsAbstractToggleAction act) {
        JRadioButtonMenuItem rbn = new JRadioButtonMenuItem(act);
        rbn.setToolTipText(null);
        Integer iMnem = (Integer)act.getValue("MnemonicIndex");
        if (iMnem != null && iMnem != -1) {
            rbn.setDisplayedMnemonicIndex(iMnem);
        }
        act.addButton(rbn);
        return rbn;
    }

    public static void updateMenuItemText(JMenuItem mi, String sText) {
        int cMnem = Util.getDisplayedMnemonic((String)sText);
        int iMnem = Util.getDisplayedMnemonicIndex((String)sText);
        sText = Util.getLabelWithoutMnemonic((String)sText);
        mi.setText(sText);
        mi.setMnemonic(cMnem);
        mi.setDisplayedMnemonicIndex(iMnem);
    }

    public static JCheckBox createCheckBox(WAdminResource aBundle, String sKey) {
        JCheckBox ckb = new JCheckBox(aBundle.getString(sKey + ".txt"));
        ckb.setMnemonic(aBundle.getString(sKey + ".mnem").charAt(0));
        ckb.setToolTipText(aBundle.getString(sKey + ".tip"));
        return ckb;
    }

    public static JCheckBox createCheckBox(WAdminResource aBundle, String sKey, int fFlags) {
        JCheckBox ckb = new JCheckBox();
        if ((fFlags & 1) != 0) {
            String sText = aBundle.getString(sKey + ".txt");
            int cMnem = Util.getDisplayedMnemonic((String)sText);
            int iMnem = Util.getDisplayedMnemonicIndex((String)sText);
            sText = Util.getLabelWithoutMnemonic((String)sText);
            ckb.setText(sText);
            ckb.setMnemonic(cMnem);
            ckb.setDisplayedMnemonicIndex(iMnem);
        }
        if ((fFlags & 2) != 0) {
            ckb.setIcon(aBundle.getIcon(sKey + ".image"));
        }
        if ((fFlags & 4) != 0) {
            ckb.setToolTipText(aBundle.getString(sKey + ".tip"));
        }
        return ckb;
    }

    public static JCheckBox createCheckBox(WsAbstractToggleAction act) {
        JCheckBox ckb = new JCheckBox(act);
        act.addButton(ckb);
        int iMnemonic = act.getMnemonicIndex();
        if (iMnemonic != -1) {
            ckb.setDisplayedMnemonicIndex(iMnemonic);
        }
        return ckb;
    }

    public static JRadioButton createRadioButton(WAdminResource aBundle, String sKey) {
        JRadioButton rbn = new JRadioButton(aBundle.getString(sKey + ".txt"));
        rbn.setMnemonic(aBundle.getString(sKey + ".mnem").charAt(0));
        rbn.setToolTipText(aBundle.getString(sKey + ".tip"));
        return rbn;
    }

    public static JRadioButton createRadioButton(WAdminResource aBundle, String sKey, int fFlags) {
        JRadioButton rbn = new JRadioButton();
        if ((fFlags & 1) != 0) {
            String sText = aBundle.getString(sKey + ".txt");
            int cMnem = Util.getDisplayedMnemonic((String)sText);
            int iMnem = Util.getDisplayedMnemonicIndex((String)sText);
            sText = Util.getLabelWithoutMnemonic((String)sText);
            rbn.setText(sText);
            rbn.setMnemonic(cMnem);
            rbn.setDisplayedMnemonicIndex(iMnem);
        }
        if ((fFlags & 2) != 0) {
            rbn.setIcon(aBundle.getIcon(sKey + ".image"));
        }
        if ((fFlags & 4) != 0) {
            rbn.setToolTipText(aBundle.getString(sKey + ".tip"));
        }
        return rbn;
    }

    public static JRadioButton createRadioButton(WsAbstractToggleAction act) {
        JRadioButton rbn = new JRadioButton(act);
        act.addButton(rbn);
        int iMnemonic = act.getMnemonicIndex();
        if (iMnemonic != -1) {
            rbn.setDisplayedMnemonicIndex(iMnemonic);
        }
        return rbn;
    }

    public static TitledBorder createTitledBorder(String sTitle) {
        StringBuffer sbTitle = new StringBuffer(sTitle.length() + 4);
        sbTitle.append("  ");
        sbTitle.append(sTitle);
        sbTitle.append("  ");
        return BorderFactory.createTitledBorder(sbTitle.toString());
    }

    public static JToolBar createToolBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setRollover(true);
        return bar;
    }

    public static void addSpaceIconToPopupMenu(JPopupMenu mnuPopup) {
        ImageIcon iconSpace = bundle.getImageIcon("Common.EmptyIcon.image");
        int nItems = mnuPopup.getComponentCount();
        for (int iItem = 0; iItem < nItems; ++iItem) {
            Component cmp = mnuPopup.getComponent(iItem);
            if (!(cmp instanceof JMenuItem)) continue;
            JMenuItem mi = (JMenuItem)cmp;
            if (mi.getIcon() == null && !(mi instanceof JCheckBoxMenuItem) && !(mi instanceof JRadioButtonMenuItem)) {
                mi.setIcon(iconSpace);
            }
            if (!(mi instanceof JMenu)) continue;
            WsUIUtilities.addSpaceIconToPopupMenu(((JMenu)mi).getPopupMenu());
        }
    }

    public static void preparePopupMenuForCleanUp(JPopupMenu mnuPopup) {
        mnuPopup.addPopupMenuListener(new cPopupMenuListener());
    }

    public static void removeActionsFromPopupMenu(JPopupMenu mnuPopup) {
        int nItems = mnuPopup.getComponentCount();
        for (int iItem = 0; iItem < nItems; ++iItem) {
            Component cmp = mnuPopup.getComponent(iItem);
            if (!(cmp instanceof JMenuItem)) continue;
            JMenuItem mi = (JMenuItem)cmp;
            Action act = mi.getAction();
            if (act instanceof WsAbstractToggleAction) {
                ((WsAbstractToggleAction)act).removeButton(mi);
            }
            mi.setAction(null);
            if (!(mi instanceof JMenu)) continue;
            WsUIUtilities.removeActionsFromPopupMenu(((JMenu)mi).getPopupMenu());
        }
    }

    private static class ButtonFocusListener
    implements FocusListener {
        private ButtonFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent ev) {
            ((AbstractButton)ev.getComponent()).getModel().setRollover(true);
        }

        @Override
        public void focusLost(FocusEvent ev) {
            ((AbstractButton)ev.getComponent()).getModel().setRollover(false);
        }
    }

    protected static class cCleanPopupRunnable
    implements Runnable {
        protected JPopupMenu m_menuPopup;

        public cCleanPopupRunnable(JPopupMenu menuPopup) {
            this.m_menuPopup = menuPopup;
        }

        @Override
        public void run() {
            WsUIUtilities.removeActionsFromPopupMenu(this.m_menuPopup);
        }
    }

    protected static class cPopupMenuListener
    implements PopupMenuListener {
        protected cPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            SwingUtilities.invokeLater(new cCleanPopupRunnable((JPopupMenu)e.getSource()));
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    private static class OptionsAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;
        private JPopupMenu m_menuPopup;

        public OptionsAction(JPopupMenu menuPopup) {
            super(bundle, "WsUIUtilities.Action.Options", 258);
            this.m_menuPopup = menuPopup;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Component cmp = (Component)ev.getSource();
            this.m_menuPopup.show(cmp, 0, cmp.getHeight());
        }
    }
}

