/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.WsComponentPrinter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.print.PageFormat;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class WsTreePrinter
extends WsComponentPrinter {
    private JTree m_tree;
    private boolean m_bReset;
    private Color m_clrBackground;
    private Color m_clrBackgroundSelection;
    private Color m_clrBackgroundNonSelection;
    private Color m_clrTextSelection;
    private Color m_clrTextNonSelection;
    private Color m_clrBorderSelection;

    public WsTreePrinter(JTree tree, PageFormat page) {
        this(tree, page, false);
    }

    public WsTreePrinter(JTree tree, PageFormat page, boolean bAsIs) {
        super(tree, page);
        TreeCellRenderer rdr;
        this.m_tree = tree;
        if (!bAsIs && (rdr = tree.getCellRenderer()) instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer rdrDefault = (DefaultTreeCellRenderer)rdr;
            this.m_clrBackground = tree.getBackground();
            this.m_clrBackgroundSelection = rdrDefault.getBackgroundSelectionColor();
            this.m_clrBackgroundNonSelection = rdrDefault.getBackgroundNonSelectionColor();
            this.m_clrTextSelection = rdrDefault.getTextSelectionColor();
            this.m_clrTextNonSelection = rdrDefault.getTextNonSelectionColor();
            this.m_clrBorderSelection = rdrDefault.getBorderSelectionColor();
            this.m_bReset = true;
            tree.setBackground(Color.white);
            rdrDefault.setBackgroundSelectionColor(Color.white);
            rdrDefault.setBackgroundNonSelectionColor(Color.white);
            rdrDefault.setTextSelectionColor(Color.black);
            rdrDefault.setTextNonSelectionColor(Color.black);
            rdrDefault.setBorderSelectionColor(Color.white);
        }
    }

    @Override
    public void dispose() {
        if (this.m_bReset) {
            this.m_tree.setBackground(this.m_clrBackground);
            DefaultTreeCellRenderer rdr = (DefaultTreeCellRenderer)this.m_tree.getCellRenderer();
            rdr.setBackgroundSelectionColor(this.m_clrBackgroundSelection);
            rdr.setBackgroundNonSelectionColor(this.m_clrBackgroundNonSelection);
            rdr.setTextSelectionColor(this.m_clrTextSelection);
            rdr.setTextNonSelectionColor(this.m_clrTextNonSelection);
            rdr.setBorderSelectionColor(this.m_clrBorderSelection);
        }
    }

    @Override
    protected Dimension getPrintableDimensions() {
        Dimension dimPrint = this.m_tree.getSize();
        if (dimPrint.width == 0 && dimPrint.height == 0) {
            dimPrint = this.m_tree.getPreferredSize();
            this.m_tree.setSize(dimPrint);
        }
        return dimPrint;
    }
}

