/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.workspace.SplittableTabbedPaneEvent;
import com.sas.workspace.SplittableTabbedPaneListener;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractIconFactory;
import com.sas.workspace.WsDropMenuAction;
import com.sas.workspace.WsFocusListenerPropagator;
import com.sas.workspace.WsOverlayableTabbedPane;
import com.sas.workspace.WsTabbedInterface;
import com.sas.workspace.WsTabbedPaneOverlayLayout;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

public class WsSplittableTabbedPane2
extends JPanel
implements WsTabbedInterface {
    private static WAdminResource bundle = WAdminResource.getBundle(WsSplittableTabbedPane2.class);
    public static final int SPLIT_NONE = 0;
    public static final int SPLIT_HORIZONTAL = 1;
    public static final int SPLIT_VERTICAL = 2;
    public static final int SPLIT_BOTH = 3;
    protected Component m_cmpMain = null;
    protected JTabbedPane m_pnlTabs;
    protected cTabbedPane m_pnlTabsParent;
    protected Vector m_vPages = new Vector();
    protected Vector m_vSplitPanes = new Vector();
    protected boolean m_bClosable;
    protected boolean m_bSplitDown;
    protected boolean m_bSplitRight;
    protected Component m_cmpSelectedTab = null;

    public WsSplittableTabbedPane2() {
        this(3, true);
    }

    public WsSplittableTabbedPane2(int fStyle) {
        this(fStyle, true);
    }

    public WsSplittableTabbedPane2(int fStyle, boolean bCloseable) {
        this(fStyle, bCloseable, 3);
    }

    public WsSplittableTabbedPane2(int fStyle, boolean bClosable, int tabLocation) {
        this.m_pnlTabsParent = new cMainTabbedPane(tabLocation);
        this.m_bClosable = bClosable;
        this.m_pnlTabs = this.m_pnlTabsParent.getTabbedPane();
        this.m_pnlTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component cmpPage = WsSplittableTabbedPane2.this.m_pnlTabs.getSelectedComponent();
                WsSplittableTabbedPane2.this.setSelectedTabInternal(cmpPage);
            }
        });
        this.m_bSplitDown = (fStyle & 2) == 2;
        this.m_bSplitRight = (fStyle & 1) == 1;
        this.m_cmpMain = this.m_pnlTabsParent;
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_pnlTabsParent, "Center");
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public void setTitle(String sTitle) {
    }

    public void addTab(String sTitle, Component cmp) {
        this.addTab(sTitle, cmp, null, null);
    }

    @Override
    public void addTab(String sTitle, Icon icon, Component cmpTab, String sToolTip) {
        this.addTab(sTitle, cmpTab, icon, sToolTip);
    }

    public void addTab(String sTitle, Component cmp, Icon icon, String sToolTip) {
        cTabLabel cmpLabel = new cTabLabel(cmp, sTitle, this.m_bSplitDown, this.m_bSplitRight, this.m_bClosable);
        cPageObject page = new cPageObject(sTitle, cmp, cmpLabel, this.m_pnlTabs, 0, sToolTip);
        page.getLabel().setIcon(icon);
        this.m_vPages.add(page);
        this.m_pnlTabsParent.addTab(page);
    }

    public void insertTab(String sTitle, Component cmp, int iTab) {
        this.insertTab(sTitle, cmp, iTab, true);
    }

    public void insertTab(String sTitle, Component cmp, int iTab, boolean bAllowSplit) {
        this.insertTab(sTitle, cmp, null, null, iTab, bAllowSplit);
    }

    public void insertTab(String sTitle, Component cmp, Icon icon, String sToolTip, int iTab) {
        this.insertTab(sTitle, cmp, icon, sToolTip, iTab, true);
    }

    public void insertTab(String sTitle, Component cmp, Icon icon, String sToolTip, int iTab, boolean bAllowSplit) {
        cTabLabel cmpLabel = new cTabLabel(cmp, icon, sTitle, bAllowSplit && this.m_bSplitDown, bAllowSplit && this.m_bSplitRight, this.m_bClosable);
        cPageObject page = new cPageObject(sTitle, cmp, cmpLabel, this.m_pnlTabs, 0, sToolTip);
        this.m_vPages.insertElementAt(page, iTab);
        this.m_pnlTabsParent.insertTab(page, this.findInsertIndex(page));
    }

    @Override
    public void removeTabAt(int iTab) {
        this.close(this.getTabAt(iTab));
    }

    @Override
    public void removeTab(Component cmp) {
        this.close(cmp);
    }

    @Override
    public int getTabCount() {
        return this.getTabbedTabCount() + this.getSplitTabCount();
    }

    public int getTabbedTabCount() {
        return this.m_pnlTabs.getTabCount();
    }

    public int getSplitTabCount() {
        return this.m_vSplitPanes.size();
    }

    public int getTotalTabCount() {
        return this.m_pnlTabs.getTabCount() + this.getSplitTabCount();
    }

    @Override
    public Component getSelectedTab() {
        return this.m_cmpSelectedTab;
    }

    @Override
    public Component getTabAt(int iTab) {
        return ((cPageObject)this.m_vPages.get(iTab)).getPage();
    }

    @Override
    public void setSelectedTab(Component cmpTab) {
        cPageObject page = this.findPage(cmpTab);
        if (page.getState() == 0) {
            this.m_pnlTabs.setSelectedComponent(cmpTab);
        } else {
            this.setSelectedTabInternal(cmpTab);
        }
    }

    protected void setSelectedTabInternal(Component cmpTab) {
        if (this.m_cmpSelectedTab != cmpTab) {
            cPageObject page;
            if (this.m_cmpSelectedTab != null && (page = this.findPage(this.m_cmpSelectedTab)) != null) {
                page.getLabel().setActive(false);
            }
            this.m_cmpSelectedTab = cmpTab;
            if (this.m_cmpSelectedTab != null && (page = this.findPage(this.m_cmpSelectedTab)) != null) {
                page.getLabel().setActive(true);
            }
            this.fireChangeEvent(new ChangeEvent(this));
        }
    }

    public void setTitle(Component cmpTab, String sTitle) {
        cPageObject page = this.findPage(cmpTab);
        page.getLabel().setLabel(sTitle);
    }

    public String getTitle(Component cmpTab) {
        cPageObject page = this.findPage(cmpTab);
        return page.getLabel().getLabel();
    }

    public int getTabState(Component cmpTab) {
        cPageObject page = this.findPage(cmpTab);
        if (page == null) {
            throw new UnsupportedOperationException();
        }
        return page.getState();
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected WsAbstractAction createSplitDownAction(Component cmpTab) {
        return new cSplitDownAction(cmpTab);
    }

    protected WsAbstractAction createSplitRightAction(Component cmpTab) {
        return new cSplitRightAction(cmpTab);
    }

    protected WsAbstractAction createRejoinUpAction(Component cmpTab) {
        return new cRejoinUpAction(cmpTab);
    }

    protected WsAbstractAction createRejoinLeftAction(Component cmpTab) {
        return new cRejoinLeftAction(cmpTab);
    }

    protected void fireChangeEvent(ChangeEvent e) {
        Object[] oaListeners = this.listenerList.getListenerList();
        for (int iListener = oaListeners.length - 2; iListener >= 0; iListener -= 2) {
            if (oaListeners[iListener] != ChangeListener.class) continue;
            ((ChangeListener)oaListeners[iListener + 1]).stateChanged(e);
        }
    }

    public void addSplittableTabbedPaneListener(SplittableTabbedPaneListener l) {
        this.listenerList.add(SplittableTabbedPaneListener.class, l);
    }

    public void removeSplittableTabbedPaneListener(SplittableTabbedPaneListener l) {
        this.listenerList.remove(SplittableTabbedPaneListener.class, l);
    }

    protected void fireSplittableTabbedPaneEvent(SplittableTabbedPaneEvent e) {
        Object[] oaListeners = this.listenerList.getListenerList();
        block6: for (int iListener = oaListeners.length - 2; iListener >= 0; iListener -= 2) {
            if (oaListeners[iListener] != SplittableTabbedPaneListener.class) continue;
            SplittableTabbedPaneListener listener = (SplittableTabbedPaneListener)oaListeners[iListener + 1];
            switch (e.getID()) {
                case 300: {
                    listener.tabSplit(e);
                    continue block6;
                }
                case 301: {
                    listener.tabClosed(e);
                    continue block6;
                }
                case 302: {
                    listener.tabRejoined(e);
                    continue block6;
                }
                case 303: {
                    listener.splitTabClosed(e);
                }
            }
        }
    }

    public void close(Component cmpTab) {
        cPageObject page = this.findPage(cmpTab);
        if (page == null) {
            throw new UnsupportedOperationException();
        }
        if (this.m_cmpSelectedTab == cmpTab) {
            this.setSelectedTabInternal(null);
        }
        if (page.getState() != 0) {
            this.removeSplitPane(page.getSplitPane());
        } else {
            this.m_pnlTabsParent.removeTab(page);
        }
        this.m_vPages.remove(page);
        this.fireSplittableTabbedPaneEvent(new SplittableTabbedPaneEvent(this, 301, cmpTab));
    }

    public void split(Component cmpTab, int eSplitDir) {
        cPageObject page = this.findPage(cmpTab);
        if (page == null || page.getState() != 0) {
            throw new UnsupportedOperationException();
        }
        this.m_pnlTabsParent.removeTab(page);
        cTabbedPane pnlTabs = new cTabbedPane(this.m_pnlTabsParent.getTabbedPane().getTabPlacement());
        page.getLabel().setSplit(eSplitDir);
        pnlTabs.addTab(page);
        int eSplitPaneType = eSplitDir == 1 ? 1 : 0;
        JSplitPane pnlSplit = new JSplitPane(eSplitPaneType);
        pnlSplit.setLeftComponent(this.m_cmpMain);
        pnlSplit.setRightComponent(pnlTabs);
        this.add((Component)pnlSplit, "Center");
        this.m_cmpMain = pnlSplit;
        page.setSplit(eSplitDir, pnlTabs.getTabbedPane(), pnlSplit);
        this.m_vSplitPanes.add(pnlSplit);
        this.validate();
        cmpTab.setVisible(true);
        cmpTab.requestFocus();
        this.repaint();
        int nSplits = this.m_vSplitPanes.size();
        double loc = (double)nSplits / ((double)nSplits + 1.0);
        pnlSplit.setDividerLocation(loc);
        pnlSplit.setResizeWeight(0.5);
        this.fireSplittableTabbedPaneEvent(new SplittableTabbedPaneEvent(this, 300, cmpTab));
    }

    public void rejoin(Component cmpTab) {
        cPageObject page = this.findPage(cmpTab);
        if (page == null || page.getState() == 0) {
            throw new UnsupportedOperationException();
        }
        cTabLabel cmpLabel = page.getLabel();
        JSplitPane cmpSplitPane = page.getSplitPane();
        cTabbedPane pnlTabs = (cTabbedPane)cmpSplitPane.getRightComponent();
        cmpLabel.setSplit(3);
        pnlTabs.removeTab(page);
        this.m_pnlTabsParent.insertTab(page, this.findInsertIndex(page));
        page.setSplit(0, this.m_pnlTabs, null);
        this.removeSplitPane(cmpSplitPane);
        this.m_pnlTabs.requestFocus();
        this.fireSplittableTabbedPaneEvent(new SplittableTabbedPaneEvent(this, 302, cmpTab));
    }

    public void saveState(String sStatePrefix) {
        WorkspaceFile fileAppDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        int nSplitPanes = this.m_vSplitPanes.size();
        for (int iSplitPane = 0; iSplitPane < nSplitPanes; ++iSplitPane) {
            JSplitPane pnlSplit = (JSplitPane)this.m_vSplitPanes.get(iSplitPane);
            cTabbedPane pnlTabs = (cTabbedPane)pnlSplit.getRightComponent();
            Component cmpPage = pnlTabs.getTabbedPane().getComponentAt(0);
            int iPage = this.findPageAt(cmpPage);
            if (iPage == -1) {
                return;
            }
            cPageObject page = (cPageObject)this.m_vPages.get(iPage);
            String sPrefix = sStatePrefix + ".Split" + iSplitPane + ".";
            fileAppDefaults.setPropertyInt(sPrefix + "TabIndex", iPage);
            fileAppDefaults.setPropertyInt(sPrefix + "SplitDirection", page.getState());
            fileAppDefaults.setPropertyInt(sPrefix + "DividerLocation", pnlSplit.getDividerLocation());
        }
        fileAppDefaults.setPropertyInt(sStatePrefix + ".SplitCount", nSplitPanes);
        fileAppDefaults.setPropertyInt(sStatePrefix + ".SelectedTab", this.findPageAt(this.m_pnlTabs.getSelectedComponent()));
    }

    public void restoreState(String sStatePrefix) {
        this.restoreState(sStatePrefix, true);
    }

    public void restoreState(String sStatePrefix, boolean bSelectTab) {
        WorkspaceFile fileAppDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        int nSplitPanes = fileAppDefaults.getPropertyInt(sStatePrefix + ".SplitCount", 0);
        for (int iSplitPane = 0; iSplitPane < nSplitPanes; ++iSplitPane) {
            String sPrefix = sStatePrefix + ".Split" + iSplitPane + ".";
            int iPage = fileAppDefaults.getPropertyInt(sPrefix + "TabIndex", -1);
            int eDir = fileAppDefaults.getPropertyInt(sPrefix + "SplitDirection", -1);
            int loc = fileAppDefaults.getPropertyInt(sPrefix + "DividerLocation", -1);
            if (iPage == -1 || iPage >= this.m_vPages.size() || eDir == -1 || loc == -1) {
                return;
            }
            cPageObject page = (cPageObject)this.m_vPages.get(iPage);
            this.split(page.getPage(), eDir);
            page.getSplitPane().setDividerLocation(loc);
        }
        int iPage = fileAppDefaults.getPropertyInt(sStatePrefix + ".SelectedTab", 0);
        if (iPage < 0 || iPage >= this.m_vPages.size() || !bSelectTab) {
            iPage = 0;
        }
        if (this.m_vPages.size() != 0) {
            this.setSelectedTab(((cPageObject)this.m_vPages.get(iPage)).getPage());
        }
    }

    protected int findPageAt(Component cmpPage) {
        int nPages = this.m_vPages.size();
        for (int iPage = 0; iPage < nPages; ++iPage) {
            cPageObject page = (cPageObject)this.m_vPages.get(iPage);
            if (page.getPage() != cmpPage) continue;
            return iPage;
        }
        return -1;
    }

    protected int findInsertIndex(cPageObject page) {
        cPageObject pageLoop;
        int nPrevPages = 0;
        int nPages = this.m_vPages.size();
        for (int iPage = 0; iPage < nPages && page != (pageLoop = (cPageObject)this.m_vPages.get(iPage)); ++iPage) {
            if (pageLoop.getState() != 0) continue;
            ++nPrevPages;
        }
        return nPrevPages;
    }

    protected void removeSplitPane(JSplitPane cmpSplitPane) {
        int iSplitPane = this.m_vSplitPanes.indexOf(cmpSplitPane);
        if (iSplitPane == this.m_vSplitPanes.size() - 1) {
            this.remove(cmpSplitPane);
            this.m_cmpMain = cmpSplitPane.getLeftComponent();
            this.add(this.m_cmpMain, "Center");
        } else {
            JSplitPane cmpSplitPaneNext = (JSplitPane)this.m_vSplitPanes.get(iSplitPane + 1);
            cmpSplitPaneNext.setLeftComponent(cmpSplitPane.getLeftComponent());
        }
        this.remove(cmpSplitPane);
        this.m_vSplitPanes.remove(cmpSplitPane);
        this.validate();
        this.repaint();
    }

    protected cPageObject findPage(Component cmpPage) {
        int nPages = this.m_vPages.size();
        for (int iPage = 0; iPage < nPages; ++iPage) {
            cPageObject page = (cPageObject)this.m_vPages.get(iPage);
            if (page.getPage() != cmpPage) continue;
            return page;
        }
        return null;
    }

    protected class cRejoinLeftAction
    extends WsAbstractAction {
        private Component m_cmpPage;

        public cRejoinLeftAction(Component cmpPage) {
            super(bundle, "SplitTab.LeftArrow", 0);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:MoveTabLeft"));
            this.m_cmpPage = cmpPage;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsSplittableTabbedPane2.this.rejoin(this.m_cmpPage);
        }
    }

    protected class cRejoinUpAction
    extends WsAbstractAction {
        private Component m_cmpPage;

        public cRejoinUpAction(Component cmpPage) {
            super(bundle, "SplitTab.UpArrow", 0);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:MoveTabUp"));
            this.m_cmpPage = cmpPage;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsSplittableTabbedPane2.this.rejoin(this.m_cmpPage);
        }
    }

    protected class cSplitRightAction
    extends WsAbstractAction {
        private Component m_cmpPage;

        public cSplitRightAction(Component cmpPage) {
            super(bundle, "SplitTab.RightArrow", 0);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:MoveTabRight"));
            this.m_cmpPage = cmpPage;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsSplittableTabbedPane2.this.split(this.m_cmpPage, 1);
        }
    }

    protected class cSplitDownAction
    extends WsAbstractAction {
        private Component m_cmpPage;

        public cSplitDownAction(Component cmpPage) {
            super(bundle, "SplitTab.DownArrow", 0);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:MoveTabDown"));
            this.m_cmpPage = cmpPage;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsSplittableTabbedPane2.this.split(this.m_cmpPage, 2);
        }
    }

    protected class cPageObject {
        protected String m_sTitle;
        protected Component m_cmpPage;
        protected cTabLabel m_cmpLabel;
        protected JTabbedPane m_pnlTabs2;
        protected int m_eState;
        protected String m_sToolTip;
        protected JSplitPane m_cmpSplitPane;

        public cPageObject(String sTitle, Component cmpPage, cTabLabel cmpLabel, JTabbedPane pnlTabs, int eState, String sToolTip) {
            this.m_sTitle = sTitle;
            this.m_cmpPage = cmpPage;
            this.m_cmpLabel = cmpLabel;
            this.m_pnlTabs2 = pnlTabs;
            this.m_eState = eState;
            this.m_sToolTip = sToolTip;
            this.m_cmpSplitPane = null;
        }

        public String getTitle() {
            return this.m_sTitle;
        }

        public Component getPage() {
            return this.m_cmpPage;
        }

        public cTabLabel getLabel() {
            return this.m_cmpLabel;
        }

        public JTabbedPane getTabbedPanel() {
            return this.m_pnlTabs2;
        }

        public int getState() {
            return this.m_eState;
        }

        public String getToolTip() {
            return this.m_sToolTip;
        }

        public JSplitPane getSplitPane() {
            return this.m_cmpSplitPane;
        }

        public void setSplit(int eState, JTabbedPane pnlTabs, JSplitPane cmpSplitPane) {
            this.m_eState = eState;
            this.m_pnlTabs2 = pnlTabs;
            this.m_cmpSplitPane = cmpSplitPane;
        }
    }

    protected class cTabLabel
    extends JPanel {
        protected Component m_cmpPage;
        protected JLabel m_lblLabel;
        protected Font m_fntNormal;
        protected Font m_fntActive;
        protected int m_eSplitDir;
        protected boolean m_bActive;
        protected boolean m_bAllowSplitDown;
        protected boolean m_bAllowSplitRight;
        protected JToolBar m_tbrSplit;
        protected JPopupMenu m_mnuSplit;
        protected JMenuItem m_itemSplitDown;
        protected JMenuItem m_itemSplitRight;
        protected JMenuItem m_itemRejoinUp;
        protected JMenuItem m_itemRejoinLeft;

        public cTabLabel(Component cmpPage, String sLabel, boolean bDown, boolean bRight, boolean bClose) {
            this(cmpPage, null, sLabel, bDown, bRight, bClose);
        }

        public cTabLabel(Component cmpPage, Icon icon, String sLabel, boolean bDown, boolean bRight, boolean bClose) {
            this.initialize(cmpPage, icon, sLabel, bDown, bRight, bClose);
            this.layoutWidgets();
        }

        public void setSplit(int eSplitDir) {
            this.m_mnuSplit.removeAll();
            switch (eSplitDir) {
                case 2: {
                    this.m_mnuSplit.add(this.m_itemRejoinUp);
                    break;
                }
                case 1: {
                    this.m_mnuSplit.add(this.m_itemRejoinLeft);
                    break;
                }
                case 3: {
                    this.m_mnuSplit.add(this.m_itemSplitDown);
                    this.m_mnuSplit.add(this.m_itemSplitRight);
                }
            }
            this.m_eSplitDir = eSplitDir;
        }

        public void setLabel(String sLabel) {
            this.m_lblLabel.setText(sLabel);
            Font font = this.m_lblLabel.getFont().deriveFont(1);
            Rectangle2D rect = this.m_lblLabel.getFontMetrics(font).getStringBounds(sLabel, this.m_lblLabel.getGraphics());
            Dimension dim = new Dimension();
            dim.width = new Double(rect.getWidth()).intValue();
            dim.height = new Double(rect.getHeight()).intValue();
            this.m_lblLabel.setPreferredSize(dim);
            WsSplittableTabbedPane2.this.revalidate();
            WsSplittableTabbedPane2.this.repaint();
        }

        public String getLabel() {
            return this.m_lblLabel.getText();
        }

        public void setIcon(Icon icon) {
            this.m_lblLabel.setIcon(icon);
            WsSplittableTabbedPane2.this.revalidate();
            WsSplittableTabbedPane2.this.repaint();
        }

        public Icon getIcon() {
            return this.m_lblLabel.getIcon();
        }

        public void setActive(boolean bActive) {
            if (this.m_bActive != bActive) {
                this.m_bActive = bActive;
                this.m_lblLabel.setFont(bActive ? this.m_fntActive : this.m_fntNormal);
                Container cntParent = this.getParent();
                if (cntParent != null && cntParent instanceof cTabbedPane) {
                    cTabbedPane tabParent = (cTabbedPane)cntParent;
                    tabParent.getTabbedPane().invalidate();
                }
                WsSplittableTabbedPane2.this.revalidate();
                WsSplittableTabbedPane2.this.repaint();
            }
        }

        public boolean isActive() {
            return this.m_bActive;
        }

        protected void initialize(Component cmpPage, Icon icon, String sLabel, boolean bDown, boolean bRight, boolean bClose) {
            this.m_cmpPage = cmpPage;
            this.m_bAllowSplitDown = bDown;
            this.m_bAllowSplitRight = bRight;
            this.setOpaque(false);
            this.m_lblLabel = new JLabel(sLabel, icon, 0);
            this.setLabel(sLabel);
            this.m_mnuSplit = new JPopupMenu();
            this.m_itemSplitDown = WsUIUtilities.createMenuItem(WsSplittableTabbedPane2.this.createSplitDownAction(this.m_cmpPage));
            this.m_itemSplitRight = WsUIUtilities.createMenuItem(WsSplittableTabbedPane2.this.createSplitRightAction(this.m_cmpPage));
            this.m_itemRejoinUp = WsUIUtilities.createMenuItem(WsSplittableTabbedPane2.this.createRejoinUpAction(this.m_cmpPage));
            this.m_itemRejoinLeft = WsUIUtilities.createMenuItem(WsSplittableTabbedPane2.this.createRejoinLeftAction(this.m_cmpPage));
            WsDropMenuAction actDropMenu = new WsDropMenuAction();
            actDropMenu.setDropMenu(this.m_mnuSplit);
            JButton btnSplit = WsUIUtilities.createFlatToolButton(actDropMenu);
            this.m_tbrSplit = WsUIUtilities.createToolBar();
            this.m_tbrSplit.add(btnSplit);
            this.m_tbrSplit.setOpaque(false);
            btnSplit.setOpaque(false);
            Icon icnSplit = btnSplit.getIcon();
            btnSplit.setPreferredSize(new Dimension(icnSplit.getIconWidth() + 4, icnSplit.getIconHeight() + 4));
            this.m_fntNormal = this.m_lblLabel.getFont();
            if ((this.m_fntNormal.getStyle() & 1) != 0) {
                Workspace.getDefaultLogger().debug("Label font is already bold!");
            }
            this.m_fntActive = this.m_fntNormal.deriveFont(1);
            cTabLabelMouseListener lsnrMouse = new cTabLabelMouseListener();
            this.m_lblLabel.addMouseListener(lsnrMouse);
            this.m_lblLabel.addMouseMotionListener(lsnrMouse);
            this.setSplit(3);
        }

        protected void layoutWidgets() {
            this.setLayout(new GridBagLayout());
            this.add((Component)this.m_lblLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 0, 10), 0, 0));
            if (this.m_bAllowSplitDown || this.m_bAllowSplitRight) {
                JSeparator separator = new JSeparator(1);
                this.add((Component)separator, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0));
                this.add((Component)this.m_tbrSplit, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
        }

        protected class cTabLabelMouseListener
        extends MouseInputAdapter {
            protected cTabLabelMouseListener() {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                if (cTabLabel.this.m_eSplitDir == 1 || cTabLabel.this.m_eSplitDir == 2) {
                    JTabbedPane pnlTabs = WsSplittableTabbedPane2.this.findPage(cTabLabel.this.m_cmpPage).getTabbedPanel();
                    pnlTabs.requestFocus();
                    pnlTabs.repaint();
                } else if (WsSplittableTabbedPane2.this.getSelectedTab() == cTabLabel.this.m_cmpPage) {
                    WsSplittableTabbedPane2.this.m_pnlTabs.requestFocus();
                    WsSplittableTabbedPane2.this.m_pnlTabs.repaint();
                } else {
                    WsSplittableTabbedPane2.this.setSelectedTab(cTabLabel.this.m_cmpPage);
                    WsSplittableTabbedPane2.this.m_pnlTabs.requestFocus();
                    WsSplittableTabbedPane2.this.m_pnlTabs.repaint();
                }
            }

            @Override
            public void mouseEntered(MouseEvent ev) {
                this.forwardMouseEventToTabsPanel(ev);
            }

            @Override
            public void mouseExited(MouseEvent ev) {
                this.forwardMouseEventToTabsPanel(ev);
            }

            @Override
            public void mouseMoved(MouseEvent ev) {
                this.forwardMouseEventToTabsPanel(ev);
            }

            @Override
            public void mouseDragged(MouseEvent ev) {
                this.forwardMouseEventToTabsPanel(ev);
            }

            private void forwardMouseEventToTabsPanel(MouseEvent ev) {
                JTabbedPane pnlTabs = WsSplittableTabbedPane2.this.findPage(cTabLabel.this.m_cmpPage).getTabbedPanel();
                MouseEvent evForward = SwingUtilities.convertMouseEvent(ev.getComponent(), ev, pnlTabs);
                pnlTabs.dispatchEvent(evForward);
            }
        }
    }

    protected class cTabbedPane
    extends JPanel
    implements FocusListener {
        protected JTabbedPane m_pnlTabs1;

        public cTabbedPane() {
            this(3);
        }

        public cTabbedPane(int tabLocation) {
            this.m_pnlTabs1 = new WsOverlayableTabbedPane(tabLocation);
            this.setLayout(new WsTabbedPaneOverlayLayout(this.m_pnlTabs1));
            this.add(this.m_pnlTabs1);
            WsFocusListenerPropagator flp = new WsFocusListenerPropagator(this);
            flp.startListeningTo(this);
        }

        public JTabbedPane getTabbedPane() {
            return this.m_pnlTabs1;
        }

        public void addTab(cPageObject page) {
            Component cmpPage = page.getPage();
            this.m_pnlTabs1.addTab("", null, cmpPage, page.getToolTip());
            WsTabbedPaneOverlayLayout.Constraints cons = new WsTabbedPaneOverlayLayout.Constraints(0, 3, cmpPage);
            this.add(page.getLabel(), cons, 0);
        }

        public void insertTab(cPageObject page, int iTab) {
            Component cmpPage = page.getPage();
            this.m_pnlTabs1.insertTab("", null, cmpPage, page.getToolTip(), iTab);
            if (iTab != this.m_pnlTabs1.getSelectedIndex()) {
                this.m_pnlTabs1.setSelectedIndex(iTab);
            } else {
                WsSplittableTabbedPane2.this.setSelectedTabInternal(cmpPage);
            }
            WsTabbedPaneOverlayLayout.Constraints cons = new WsTabbedPaneOverlayLayout.Constraints(0, 0, cmpPage);
            this.add(page.getLabel(), cons, 0);
        }

        public void removeTab(cPageObject page) {
            Component cmpSelected;
            Component cmpPage = page.getPage();
            int iComponent = this.m_pnlTabs1.indexOfComponent(cmpPage);
            int iSelected = this.m_pnlTabs1.getSelectedIndex();
            this.m_pnlTabs1.remove(cmpPage);
            if (iComponent < iSelected) {
                this.m_pnlTabs1.setSelectedIndex(--iSelected);
            }
            if ((cmpSelected = this.m_pnlTabs1.getSelectedComponent()) != null && cmpSelected != WsSplittableTabbedPane2.this.getSelectedTab()) {
                WsSplittableTabbedPane2.this.setSelectedTabInternal(cmpSelected);
            }
            this.remove(page.getLabel());
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (SwingUtilities.getWindowAncestor(WsSplittableTabbedPane2.this) == null) {
                return;
            }
            Component tabSelected = this.m_pnlTabs1.getSelectedComponent();
            if (WsSplittableTabbedPane2.this.getSelectedTab() != tabSelected) {
                WsSplittableTabbedPane2.this.setSelectedTabInternal(tabSelected);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    protected class cMainTabbedPane
    extends cTabbedPane {
        public cMainTabbedPane() {
            this(3);
        }

        public cMainTabbedPane(int tabLocation) {
            super(tabLocation);
        }

        @Override
        public void addTab(cPageObject page) {
            int nPages = this.m_pnlTabs1.getTabCount();
            if (nPages == 0) {
                page.getLabel().setSplit(0);
            } else if (nPages == 1) {
                Component cmpPage = this.m_pnlTabs1.getComponentAt(0);
                cPageObject page0 = WsSplittableTabbedPane2.this.findPage(cmpPage);
                page0.getLabel().setSplit(3);
            }
            super.addTab(page);
        }

        @Override
        public void insertTab(cPageObject page, int iTab) {
            int nPages = this.m_pnlTabs1.getTabCount();
            if (nPages == 0) {
                page.getLabel().setSplit(0);
            } else if (nPages == 1) {
                Component cmpPage = this.m_pnlTabs1.getComponentAt(0);
                cPageObject page0 = WsSplittableTabbedPane2.this.findPage(cmpPage);
                page0.getLabel().setSplit(3);
            }
            super.insertTab(page, iTab);
        }

        @Override
        public void removeTab(cPageObject page) {
            super.removeTab(page);
            int nPages = this.m_pnlTabs1.getTabCount();
            if (nPages == 1) {
                Component cmpPage = this.m_pnlTabs1.getComponentAt(0);
                cPageObject page0 = WsSplittableTabbedPane2.this.findPage(cmpPage);
                page0.getLabel().setSplit(0);
            }
        }
    }
}

