/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WsSliderPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected ArrayList m_alSlidingPanels = new ArrayList(5);
    protected cSlidingPanel m_pnlSelected;

    public WsSliderPane() {
        this.setLayout(new cSlidingPanelsLayoutManager());
        this.setBorder(this.createBorder());
    }

    public void addPanel(String sTitle, Component cmpPanel) {
        cSlidingPanel pnl = new cSlidingPanel(cmpPanel, sTitle);
        this.m_alSlidingPanels.add(pnl);
        if (this.m_pnlSelected == null) {
            this.setSelectedPanelImpl(pnl);
        } else {
            pnl.m_cmpPanel.setVisible(false);
        }
        this.add(pnl.getLabel());
        this.add(pnl.getPanel());
        this.invalidate();
    }

    public void insertPanel(String sTitle, Component cmpPanel, int iPanel) {
        cSlidingPanel pnl = new cSlidingPanel(cmpPanel, sTitle);
        this.m_alSlidingPanels.add(iPanel, pnl);
        if (this.m_pnlSelected == null) {
            this.setSelectedPanelImpl(pnl);
        } else {
            pnl.m_cmpPanel.setVisible(false);
        }
        this.add(pnl.getLabel());
        this.add(pnl.getPanel());
        this.invalidate();
    }

    public void removeAllPanels() {
        int nPanels = this.m_alSlidingPanels.size();
        for (int iPanel = 0; iPanel < nPanels; ++iPanel) {
            this.removePanelAt(iPanel);
        }
    }

    public void removePanel(Component cmpPanel) {
        this.removePanelAt(this.indexOfPanel(cmpPanel));
    }

    public void removePanelAt(int iPanel) {
        cSlidingPanel pnl = this.getSlidingPanel(iPanel);
        if (pnl == this.m_pnlSelected) {
            int nPanels = this.getPanelCount();
            if (iPanel + 1 < nPanels) {
                this.setSelectedIndex(iPanel + 1);
            } else if (nPanels > 0) {
                this.setSelectedIndex(0);
            } else {
                this.setSelectedPanelImpl(null);
            }
        }
        this.m_alSlidingPanels.remove(iPanel);
        this.remove(pnl.getLabel());
        this.remove(pnl.getPanel());
        this.invalidate();
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        ChangeEvent e = new ChangeEvent(this);
        Object[] aListeners = this.listenerList.getListenerList();
        int nListeners = aListeners.length;
        for (int iListener = nListeners - 2; iListener >= 0; iListener -= 2) {
            if (aListeners[iListener] != ChangeListener.class) continue;
            ((ChangeListener)aListeners[iListener + 1]).stateChanged(e);
        }
    }

    public Rectangle getLabelBoundsAt(int iPanel) {
        return this.getSlidingPanel(iPanel).getLabel().getBounds();
    }

    public Rectangle getPanelBoundsAt(int iPanel) {
        return this.getSlidingPanel(iPanel).getPanel().getBounds();
    }

    public Component getPanelAt(int iPanel) {
        return this.getSlidingPanel(iPanel).getPanel();
    }

    public Component getSelectedPanel() {
        return this.m_pnlSelected.getPanel();
    }

    public int getSelectedIndex() {
        return this.m_alSlidingPanels.indexOf(this.m_pnlSelected);
    }

    public int getPanelCount() {
        return this.m_alSlidingPanels.size();
    }

    public String getTitleAt(int iPanel) {
        return this.getSlidingPanel(iPanel).getTitle();
    }

    public int indexOfPanel(Component cmpPanel) {
        int nPanels = this.m_alSlidingPanels.size();
        for (int iPanel = 0; iPanel < nPanels; ++iPanel) {
            if (this.getPanelAt(iPanel) != cmpPanel) continue;
            return iPanel;
        }
        return -1;
    }

    public int indexOfTitle(String sTitle) {
        int nPanels = this.m_alSlidingPanels.size();
        for (int iPanel = 0; iPanel < nPanels; ++iPanel) {
            if (!this.getTitleAt(iPanel).equals(sTitle)) continue;
            return iPanel;
        }
        return -1;
    }

    public void setPanelAt(int iPanel, Component cmpPanel) {
        cSlidingPanel pnl = this.getSlidingPanel(iPanel);
        this.remove(pnl.getPanel());
        pnl.setPanel(cmpPanel);
        this.add(cmpPanel);
        if (pnl == this.m_pnlSelected) {
            this.invalidate();
        } else {
            cmpPanel.setVisible(false);
        }
    }

    public void setTitleAt(int iPanel, String sTitle) {
        this.getSlidingPanel(iPanel).setTitle(sTitle);
    }

    public void setSelectedIndex(int iPanel) {
        this.setSelectedPanelImpl(this.getSlidingPanel(iPanel));
    }

    public void setSelectedPanel(Component cmpPanel) {
        this.setSelectedIndex(this.indexOfPanel(cmpPanel));
    }

    protected cSlidingPanel getSlidingPanel(int iPanel) {
        return (cSlidingPanel)this.m_alSlidingPanels.get(iPanel);
    }

    protected void setSelectedPanelImpl(cSlidingPanel pnlSelected) {
        if (this.m_pnlSelected != null) {
            this.m_pnlSelected.getPanel().setVisible(false);
        }
        this.m_pnlSelected = pnlSelected;
        if (this.m_pnlSelected != null) {
            this.m_pnlSelected.getPanel().setVisible(true);
        }
        this.invalidate();
        this.revalidate();
        this.fireStateChanged();
    }

    protected Border createBorder() {
        Color clrControlHighlight = UIManager.getColor("controlHighlight");
        Color clrControlLtHighlight = UIManager.getColor("controlLtHighlight");
        Color clrControlDkShadow = UIManager.getColor("controlDkShadow");
        Color clrControlShadow = UIManager.getColor("controlShadow");
        Border brdr = BorderFactory.createBevelBorder(1, clrControlLtHighlight, clrControlHighlight, clrControlDkShadow, clrControlShadow);
        return brdr;
    }

    protected JButton createTitleButton(String sTitle) {
        return new cTitleButton(sTitle);
    }

    protected class cTitleButton
    extends JButton {
        private static final long serialVersionUID = 1L;

        public cTitleButton(String sTitle) {
            super(sTitle);
            this.setDefaultCapable(false);
        }
    }

    protected class cSlidingPanel {
        protected JButton m_btnTitle;
        protected Component m_cmpPanel;

        public cSlidingPanel(Component cmpPanel, String sTitle) {
            this.m_btnTitle = WsSliderPane.this.createTitleButton(sTitle);
            this.m_btnTitle.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (WsSliderPane.this.getSelectedPanel() != cSlidingPanel.this.m_cmpPanel) {
                        WsSliderPane.this.setSelectedPanelImpl(cSlidingPanel.this);
                    }
                }
            });
            this.m_cmpPanel = cmpPanel;
        }

        public String getTitle() {
            return this.m_btnTitle.getText();
        }

        public void setTitle(String sTitle) {
            this.m_btnTitle.setText(sTitle);
        }

        public Component getLabel() {
            return this.m_btnTitle;
        }

        public Component getPanel() {
            return this.m_cmpPanel;
        }

        public void setPanel(Component cmpPanel) {
            this.m_cmpPanel = cmpPanel;
        }
    }

    protected class cSlidingPanelsLayoutManager
    implements LayoutManager {
        protected int m_cyLabel;

        protected cSlidingPanelsLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String sName, Component cmp) {
        }

        @Override
        public void layoutContainer(Container cnt) {
            if (this.m_cyLabel == 0) {
                this.calculateLayoutSize(cnt, true);
            }
            Insets insContainer = cnt.getInsets();
            int x = insContainer.left;
            int y = insContainer.top;
            int cx = cnt.getWidth() - insContainer.left - insContainer.right;
            int cy = cnt.getHeight() - insContainer.top - insContainer.bottom;
            int nPanels = WsSliderPane.this.m_alSlidingPanels.size();
            for (int iPanel = 0; iPanel < nPanels; ++iPanel) {
                cSlidingPanel panel = (cSlidingPanel)WsSliderPane.this.m_alSlidingPanels.get(iPanel);
                panel.getLabel().setBounds(x, y, cx, this.m_cyLabel);
                y += this.m_cyLabel;
                if (panel != WsSliderPane.this.m_pnlSelected) continue;
                int cyPanel = cy - nPanels * this.m_cyLabel;
                panel.getPanel().setBounds(x, y, cx, cyPanel);
                y += cyPanel;
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container cnt) {
            return this.calculateLayoutSize(cnt, false);
        }

        @Override
        public Dimension preferredLayoutSize(Container cnt) {
            return this.calculateLayoutSize(cnt, true);
        }

        public Dimension calculateLayoutSize(Container cnt, boolean bUsePreferred) {
            int cx = 0;
            int cyLabel = 0;
            int cyPanel = 0;
            int nPanels = WsSliderPane.this.m_alSlidingPanels.size();
            for (int iPanel = 0; iPanel < nPanels; ++iPanel) {
                cSlidingPanel panel = (cSlidingPanel)WsSliderPane.this.m_alSlidingPanels.get(iPanel);
                Dimension dimLabel = bUsePreferred ? panel.getLabel().getPreferredSize() : panel.getLabel().getMinimumSize();
                cx = Math.max(cx, dimLabel.width);
                cyLabel = Math.max(cyLabel, dimLabel.height);
                Dimension dimPanel = bUsePreferred ? panel.getPanel().getPreferredSize() : panel.getPanel().getMinimumSize();
                cx = Math.max(cx, dimPanel.width);
                cyPanel = Math.max(cyPanel, dimPanel.height);
            }
            if (bUsePreferred) {
                this.m_cyLabel = cyLabel;
            }
            int cy = nPanels * cyLabel + cyPanel;
            Dimension dimLayout = new Dimension(cx, cy);
            Insets insContainer = cnt.getInsets();
            dimLayout.width += insContainer.left + insContainer.right;
            dimLayout.height += insContainer.top + insContainer.bottom;
            return dimLayout;
        }

        @Override
        public void removeLayoutComponent(Component cmp) {
        }
    }
}

