/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace;

import com.sas.swing.visuals.tableview.BasicRowHeaderUI;
import com.sas.workspace.WsTable;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;

public class WsRowHeaderUI
extends BasicRowHeaderUI {
    public static ComponentUI createUI(JComponent h) {
        return new WsRowHeaderUI();
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandlerExt();
    }

    protected class MouseInputHandlerExt
    extends BasicRowHeaderUI.MouseInputHandler {
        private int m_iAnchorRow;

        protected MouseInputHandlerExt() {
            super((BasicRowHeaderUI)WsRowHeaderUI.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mousePressed(MouseEvent ev) {
            int iMouseRow;
            if (!this.shouldIgnore(ev) && (iMouseRow = WsRowHeaderUI.this.getHeader().rowAtPoint(ev.getPoint())) != -1) {
                WsTable table = (WsTable)WsRowHeaderUI.this.getHeader().getTable();
                if (table.isEditing() && !table.stopCellEditing()) {
                    return;
                }
                if (!table.getRowSelectionAllowed() && table.getCellSelectionEnabled()) {
                    boolean bSelected = table.isEntireRowSelected(iMouseRow);
                    if (SwingUtilities.isLeftMouseButton(ev) || !bSelected) {
                        boolean bAutoScroll = table.getAutoscrolls();
                        table.setAutoscrolls(false);
                        try {
                            if (ev.isShiftDown() && table.isEntireRowSelected(this.m_iAnchorRow)) {
                                table.selectRows(this.m_iAnchorRow, iMouseRow);
                                table.changeCurrentCell(iMouseRow, -1);
                            } else if (ev.isControlDown()) {
                                if (bSelected) {
                                    table.removeRowFromSelection(iMouseRow);
                                } else {
                                    table.addRowToSelection(iMouseRow);
                                }
                                table.changeCurrentCell(iMouseRow, -1);
                                this.m_iAnchorRow = iMouseRow;
                            } else {
                                table.clearSelection();
                                table.selectRow(iMouseRow);
                                table.changeCurrentCell(iMouseRow, -1);
                                this.m_iAnchorRow = iMouseRow;
                            }
                        }
                        finally {
                            table.setAutoscrolls(bAutoScroll);
                        }
                    }
                }
            }
            super.mousePressed(ev);
        }
    }
}

